C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE PREDVRG(LB,B,LPR,LA,A,ASE,PREW, space, pef, live,
     1                   weight,spacave,absl)

#include <f77/lhdrsz.h>

      DIMENSION B(*),A(*)                                               
      DIMENSION SPACE(*), weight(*), spacave(*)

      real      temp(SZSMPM)
      logical   pef, absl

C                                                                       
C     THIS SUBROUTINE COMPUTES THE LA-LENGTH SINGLE CHANNEL WIENER      
C     PREDICTION FILTER FOR PREDICTION DISTANCE LPR I.E., IT SOLVES     
C     THE SYSTEM OF NORMAL EQUATIONS,                                   
C                                                                       
C                                                                       
C         R(1),R(2),...R(LA)   A(1)     R(1+LPR)                        
C         R(2)          .      A(2)     R(2+LPR),  (R=AUTOPRODUCT OF A) 
C          .            .       .    =   .                              
C          .            .       .        .                              
C          .            .       .        .                              
C         R(LA),...,   R(1)    A(LA)    R(LA+LPR)                       
C                                                                       
C     AUTHOR--S.TREITEL, 10/5/1965                                      
C                                                                       
C     INPUTS ARE                                                        
C        LB=LENGTH OF INPUT B                                           
C         B=INPUT B                                                     
C       LPR=PREDICTION DISTANCE (MUST BE .GE. 0)                        
C        LA=LENGTH OF PREDICTION FILTER A                               
C      PREW=PREWHITENING LEVEL OF AUTO-CORR MATRIX (B X B)              
C     OUTPUTS ARE                                                       
C        A=PREDICTION FILTER A                                          
C        ASE=AVERAGE SQUARE PREDICTION ERROR FOR PRED. DIST. LPR        
C        SPACE=4*LA CELLS OF WORKING SPACE                              
C           FIRST LA CELLS CONTAIN  R(1),...R(LA)                       
C           NEXT  LA CELLS CONTAIN  R(1+LPR),...R(LA+LPR)               
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT RETROSPECTION     
C             ERROR OPERATOR, STORED IN REVERSE ORDER                   
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT PREDICTION        
C             ERROR OPERATOR, STORED IN REVERSE ORDER                   
C                                                                       
C     IF LPR .GT. LB, A IS THE NULL FILTER A(1)=A(2)=...A(LA)=0         
C                                                                       
C                                                                       
c - this has no function and caused compiler warnings - j.m.wade 8/26/92
c     rooti = 1./root

      IF ( .not. pef) THEN

      IF (LB-LPR)1,1,2                                                  
    1 call vclr(a,1,la)
      GO TO 20                                                          
    2 call vclr(space,1,2*la)
      CALL CROSS(LB,B,LB,B,MIN0(LA,LB),SPACE)                           
      SPACE(1)=SPACE(1)+PREW*SPACE(1)                                   
      call vmul (space, 1, weight, 1, space, 1, MIN0(LA,LB))
      LP=LPR+1                                                          
      IF (LP-LA)3,3,6                                                   
    3 call vmov(space(lp),1,space(la+1),1,la-lpr)
      IF (LPR)20,9,4                                                    
    4 ISP=2*LA-LPR+1                                                    
      LST=LPR                                                           
      LAG=LA                                                            
      GO TO 7                                                           
    6 ISP=LA+1                                                          
      LST=LA                                                            
      LAG=LPR                                                           
    7 IF (LB-LAG)9,9,8                                                  
    8 CALL CROSS(LB-LAG,B(LAG+1),LB,B,LST,SPACE(ISP))                   

      if (.not. absl) then
         xmax = space(1)
         call vsdiv (space, 1, xmax, space, 1, 2*la)
      endif

9     continue

         call vadd  (spacave, 1, space,   1, spacave, 1, 2*la)

      ELSE

         if (live .ge. 1 .AND. spacave(1) .gt. 0.0) then

            call vsdiv (spacave, 1, float(live), space, 1, 2*la)

            CALL EUREKb(LA,SPACE,SPACE(LA+1),A,SPACE(2*LA+1))                 

            call dotpr(a,1,space(la+1),1,ag,la)
            ASE=(SPACE(1)-AG)/SPACE(1)                                        
            DO 10 I=1,LA                                                      
            K=LA-I+1                                                          
   10       temp (K+LPR)=-A(K)                                                
            call vclr(temp,1,lpr)
            temp(1)=1.                                                       
            lapr=LA+LPR                                                         
            call vmov (temp,1,a,1,lapr)

        else

            call vclr (a, 1, lapr)
            a(1) = 1.0
            call vclr (spacave, 1, 2*la)
            return

        endif
        call vclr (spacave, 1, 2*la)

      ENDIF

20    CONTINUE
      RETURN                                                            
      END 
