C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickCount ( lupick, NumPicks, mtype )

c routine to count number of segments and total number of picks
c in pick file.  Expects xsd or oper pick format

#include <f77/iounit.h>

      integer lupick, NumPicks, nrec, ntrc

      real rec_units, trc_units, samp_units, segs, value

      character junk*1, key*10, mtype*(*)

c initialize variables

      NumPicks = 0

c determine type of pickfile being read if the new headeroutput file 
c is being used do appropriate read

      IF ( mtype .ne. 'diston' .and. mtype .ne. 'distoff' ) then

c read file header

         read ( lupick, '(a1,4x,3f13.7,2x,2i7)', end=900 ) junk, 
     :        rec_units, trc_units, samp_units, nrec, ntrc

         if(junk.ne."U")then
            write(LERR,*)' '
            write(LERR,*)' FATAL ........................'
            write(LERR,*)' Something fishy with pick file'
            write(LERR,*)' first line does not start with Units'
            write(LERR,*)' Fix this and rerun'
            write(LERR,*)' '
            stop
         endif

c
c ----- check first segment for format -----
c

         read(lupick,'(a1)',end=900)junk

         if(junk.ne."S")then

            write(LERR,*)' '
            write(LERR,*)' FATAL ........................'
            write(LERR,*)' Something fishy with pick file'
            write(LERR,*)' second line does not start with Segment'
            write(LERR,*)' Fix this and rerun'
            write(LERR,*)' '
            stop

         endif

c
c ----- determine number of picks -----
c

 10      read(lupick,'(a1)',end=910)junk
      
         if(junk.ne."S")then

            NumPicks = NumPicks + 1

         endif

         goto 10

      ELSE

c
c ----- use new pickfile key,value format  -----
c

         do while (1.EQ.1)

            read(lupick,'(a10,1x,f17.6)',end=200)key,value
            if (key.EQ.'No_Seg') then
               segs = value
            endif

            if (key.EQ.'Max_Pick') then
               NumPicks = nint(segs * value)
            endif
            
            if(segs.gt.0.and.NumPicks.gt.0)goto 200

         enddo

 200     continue

         if(NumPicks.lt.1) then

            write(LERR,*)'FATAL: something fishy in control pickfile'
            write(LERR,*)'       The total number of picks could not'
            write(LERR,*)'       be calculated.  Check that format of'
            write(LERR,*)'       pickfile is consitent with -M option'
            write(LERR,*)'       used on command line or that correct'
            write(LERR,*)'       spelling was used or if the file'
            write(LERR,*)'       exists at all'
            write(LERR,*)'       '
            stop

         else

            goto 910

         endif

      ENDIF

 900     continue

         write(LERR,*)'FATAL .........'
         write(LERR,*)'No entries found in pick file'
         stop
         
 910     continue

         write(LERR,*)' '
         write(LERR,*)'EOF on pick file after ',NumPicks,' picks'
         write(LERR,*)' '
         rewind(lupick)

      return
      end
