C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- bdmute ----- ----- ----- ----- ----- ----- -----

c     Program Changes :

c     Nov 26, 2002 : P.Garossino

c     - increased I/O buffer sizes to allow for much longer traces

c     June 30, 2001 : P.Garossino

c     - add -A option to cause the absolute value of DstSgn to be used
c       in the case of -M diston or -M distoff.  Previously only signed
c       trace distance was allowed.  Requested by Jim Specht.

c     Sept/96 : P.Garossino

c     - add -nointerp option to allow muting of induvidual records from a
c       pickfile with no interpolation between

c     July/95 : P.Garossino

c     - fixed bug in PickSort subroutine where sorting buffers overflowed for
c       large pickfiles.  I added two more dynamically allocated arrays to
c       the startup overhead and passed them to the subroutine.

c     June/95 : P.Garossino

c     - added -md option allowing the user to specify a minimum distance within
c       which no mute will be applied.  The default is to apply the mute all the 
c       way to the near offset.
c
c     - changed the DstSgn and DstUsg read options to only look for DstSgn.  We
c       are dissuading the use of DstUsg.  Too many time has there been conflicting
c       information in the two header slots of a given dataset.

c     January/95 : P.Garossino

c     - changed micro-second handling to expect microsecond parameterization
c       if data is sampled in micro-seconds.  Prior to this microsecond data
c       parameterization was handled in milliseconds which was causing too 
c       much confusion in the user community [and here as well].  I renamed
c       the variable dtmsec to dtunits to prevent future confusion.
c     - with this change I made the ramp default in all cases 48.

c     November/94 : P.Garossino 

c     - made ramp default 5 micro-seconds if nsi is > 32

c     October/94 : P.Garossino 

c     - added no-extraplotation option for Steve Harris which enables the user
c       to mute only within the bounds of the pickfile.

c     July/94 : P.Garossino

c       - made all character file name variables 200 in length to pick up
c         longer UNIX filenames

c     July/94 : K. Marfurt

c      - added dtmsec everywhere to handle micro-second data

c     Dec/93 : P. Garossino 

c       - added sorting to obviate the need to pick in sequential record order
c       - removed  polygonal mute capability 
c       - changed pickfile reference to user defined trace header index, from 
c         sequential record. [default RecNum]
c       - added some policemen to diston option to detect zero trace distance

c     Dec/91 : P. Garossino 

c       - changed ramp so that pick defines 100 on/off point
c       - added sorting to obviate the need to pick from left to right
c       - added polygonal mute capability ( 1 polygon per line at present)
c       - added (t(0),velocity) mute using pick file to control t(0)

c           This will allow the digitization of a rugose water bottom
c           from a near trace stack.  The resulting pick file will supply
c           the t(0) from which the mute algorithm applies the velocity
c           given on the command line to control the mute.

c ----- ----- ----- ----- ------ ----- ----- ----- ----- ----- ----- ----- 

c     July/90 : P. Garossino

c 	- Mute parameters are input through an xsd pick file.
c	- An array of mute co-efficients is generated for each record.
c       -    mute options supported are simple on mute
c                                     simple off mute
c	- The seismic record is then multiplied by this array.
c	- Output is the muted record.

c ----- ----- ----- ----- ------ ----- ----- ----- ----- ----- ----- ----- 

c ----- declare variables -----

c ----- get machine dependent parameters -----

#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c ----- dimension standard USP variables -----

      integer     itr ( 2*SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne, argis

      real        tri ( 2*SZLNHD )

      character   ntap*255, otap*255, name*6

      logical     verbos

c dimension program specific variables

      integer     index(2*SZSMPM,2), count, nseg, NumPicks
      integer     RecNum, l_RecNum, ln_RecNum, ifmt_RecNum
      integer     l_ONword, ln_ONword, ifmt_ONword
      integer     l_OFFword, ln_OFFword, ifmt_OFFword
      integer     DstSgn, l_DstSgn, ln_DstSgn, ifmt_DstSgn
      integer     static, l_StaCor, ln_StaCor, ifmt_StaCor
      integer     mul, spinit, spincr, ramp, length, SeisSize, PickSize 
      integer     MinDistToMute
      integer     lupick, abort, errcd1, errcd2, errcd3, errcd4, errcd5
      integer     errcd6, errcd7

      real        dt_units, UnitSc
      real        mvel, dist
      real	  mute_output, mute_coefs, records, traces, times
      real        TraceBuffer, TimeBuffer

      pointer     (wkadr1, mute_output(200000))
      pointer     (wkadr2, mute_coefs(200000))
      pointer     (wkadr3, traces(200000))
      pointer     (wkadr4, times(200000))
      pointer     (wkadr5, records(200000))
      pointer     (wkadr6, TraceBuffer(200000))
      pointer     (wkadr7, TimeBuffer(200000))

      character   ONword*6, OFFword*6, pfile*255, mtype*7, mnemonic*6

      logical     NoExtrap, NoInterp, absolute

c Variable Definitions
c
c ----- Integer -----
c
c     static : static for this trace 
c     index() : contains segment information (seq.rec,npicks) 
c     count : counter for traces() and times() arrays
c     nseg : number of segments in the pick file
c     mul : pick file time units override
c     spinit : initial shot point override
c     spincr : shot point increment override
c     ramp : length of mute ramp in ms
c
c ----- Real -----
c
c     mute_output() : output muted time series
c     mute_coefs() : mute coefficients 
c     traces() : pick file entries
c     times() : pick file entries 
c     mvel : mute velocity 
c     dist : trace distance 
c
c ----- Character -----
c
c     pfile : pick file name
c     mtype : type of mute requested
c

c Initialize variables

      data lbytes/0/
      data nbytes/0/
      data name/'BDMUTE'/
      data abort/0/
      data ONword/'VPick1'/
      data OFFword/'VPick2'/
      data NoExtrap/.false./
      data NoInterp/.false./

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, pfile, ns, ne, irs, ire, mtype, ramp,
     :     mul, spinit, spincr, mvel, mnemonic, NoExtrap, NoInterp, 
     :     MinDistToMute, absolute, verbos )

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read line header of input save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LOT,*)'BDMUTE: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

      call savelu(ONword,ifmt_ONword,l_ONword,ln_ONword,TRACEHEADER)
      call savelu(OFFword,ifmt_OFFword,l_OFFword,ln_OFFword,TRACEHEADER)
      call savelu(mnemonic,ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', UnitSc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif


      call hlhprt (itr, lbytes, name, 6, LERR)

c assign floating point delta T variable used in mute application.  This will
c be in units of milliseconds for millisecond data and microseconds for 
c microsecond data.  It is assumed [and required] that the pick file conform
c to the same convention.  If muting microsecond data then the pick file must
c contain microsecond picks.

      dt_units = float(nsi)

c ensure that command line values are compatible with data set

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c modify line header to reflect actual number of traces output

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + nsamp * SZSMPD

c save out hlh and line header

      call savhlh(itr,lbytes,lbyout)
      call wrtape (luout, itr, lbyout)

c verbose output of all pertinent information before processing begins

      call verbal(nsamp, dt_units, ntrc, nrec, iform, ntap, otap, pfile, 
     :     mtype, ramp, mul, spinit, spincr, mvel, mnemonic, NoExtrap,
     :     NoInterp, MinDistToMute, absolute )

c open pick file

      lupick = 27
      length = lenth(pfile)
      if (length .eq. 0) go to 990
      open ( lupick, file=pfile(1:length), status='old', err=990 )

c Determine Size Requirements and allocate memory

      call PickCount ( lupick, NumPicks, mtype )

      SeisSize = nsamp * SZSMPD
      PickSize = NumPicks * SZSMPD

      call galloc (wkadr1, SeisSize, errcd1, abort)
      call galloc (wkadr2, SeisSize, errcd2, abort)
      call galloc (wkadr3, PickSize, errcd3, abort)
      call galloc (wkadr4, PickSize, errcd4, abort)
      call galloc (wkadr5, PickSize, errcd5, abort)
      call galloc (wkadr6, PickSize, errcd6, abort)
      call galloc (wkadr7, PickSize, errcd7, abort)

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or. 
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 1*SeisSize+5*PickSize,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 1*SeisSize+5*PickSize,'  bytes'
         write(LERR,*)' '
      endif
         
c read and qc pick file

      call ReadPick ( lupick, index, records, traces, times, count, 
     :     nseg, mul, spinit, spincr, mtype, mnemonic, nsi, verbos )

c sort the picks based on increasing record [or trace if appropriate] index

      call PickSort ( index, traces, times, TraceBuffer, TimeBuffer, 
     :     count, nseg, ntrc, mtype )

c BEGIN PROCESSING
c skip to start record

      call recskp(1,irs-1,luin,ntrc,itr)

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp(JJ,1,ns-1,luin,ntrc,itr)
         ic = 0

         DO 1001  KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call vmov(itr(ITHWP1),1,tri(1),1,nsamp)

c Get trace distance from header

            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )

            if(mtype.eq.'diston'.or.mtype.eq.'distoff')then
               if ( absolute ) then
                  dist = float(iabs(DstSgn))
               else
                  dist = float(DstSgn)
               endif
            else
               dist = float(iabs(DstSgn))
            endif

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           static, TRACEHEADER )

c kill trace if dead and skip processing

            if (static .eq. 30000) then

               if ( mtype .eq. 'off' .or. 
     :              mtype .eq. 'distoff' .or. 
     :              mtype .eq. 'nearoff' ) then
                  call savew2( itr, ifmt_OFFword, l_OFFword, ln_OFFword, 
     :                 0, TRACEHEADER )
               else
                  call savew2( itr, ifmt_ONword, l_ONword, ln_ONword, 
     :                 0, TRACEHEADER )
               endif

               call vclr (tri,1,nsamp)
               call vmov(tri,1,itr(ITHWP1),1,nsamp)
               call wrtape (luout, itr, obytes)
               goto 1001

            endif

c skip muting if trace distance is within the range specified by Minimum 
c Distance to Mute parameter

            if ( iabs(DstSgn) .gt. MinDistToMute ) then
               

c get RecNum for trace

               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )

c construct an array of mute coefficients for this record

               call mucoef ( RecNum, ntrc, nsamp,dt_units, KK,  
     :              mute_coefs, traces, itr, l_ONword, ln_ONword, 
     :              ifmt_ONword, l_OFFword, ln_OFFword, ifmt_OFFword, 
     :              times, index, nseg, count, mtype, ramp, mvel, dist, 
     :              NoExtrap, NoInterp, NumPicks,verbos ) 

c perform the mute

               do itt = 1,nsamp
                  mute_output(itt) = tri(itt) * mute_coefs(itt)
               enddo

c extract traces from output array and write output data

               call vmov (mute_output,1,itr(ITHWP1),1,nsamp)

            endif

            call wrtape (luout, itr, obytes)
 
 1001    continue
 
c skip to end of record

         call trcskp(JJ,ne+1,ntrc,luin,ntrc,itr)

      ENDDO

c Normal Termination - close data files and exit

      call lbclos ( luin )
      call lbclos ( luout )
      close(lupick)

      write(LERR,*)' '
      write(LERR,*)'end of bdmute, processed',nreco,' record(s)',
     :             ' with ',ntrco, ' traces'
      write(LERR,*)' Normal Termination'
      write(LER,*)'bdmute:  Normal Termination'
      stop
c
c -----	error messages -----
c

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      close(lupick)

      write(LERR,*)'end of prgm, processed',nreco,' record(s)',
     :             ' with ',ntrc, ' traces'
      write(LERR,*)' Abnormal Termination'
      write(LER,*)'bdmute:  Abnormal Termination'
      stop

 990  write(LERR,*) ' '
      write(LERR,*) 'BDMUTE: error opening pick file'
      write(LERR,*) '        check spelling/existence'
      write(LERR,*) 'FATAL'
      write(LER,*) ' '
      write(LER,*) 'BDMUTE: error opening pick file'
      write(LER,*) '        check spelling/existence'
      write(LER,*) 'FATAL'

      stop
      end
