C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine DistOn ( rec, index, nseg, dist, ntr, offsets, times, 
     :     count, NoExtrap, NoInterp, start)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer rec, index(2*SZSMPM,2), nseg, ntr, count, pointer
      integer trndx, trndx2

      real dist, offsets(*), times(*), start, start1, start2

      logical NoExtrap, NoInterp

c initialize variables

      start = 0.
      start1 = 0.
      start2 = 0.
      trndx = 0
      trndx2 = 0
      
      IF ( rec .le. index(1,2) .or. rec .ge. index(nseg,2) ) then 
 
c record is outside bounds of segments in pickfile, determine 
c which segment to use for extrapolation of mute start time unless
c either no extrapolation flag or no interpolation flag is set

         if (  ( rec .lt. index(1,2) .or. rec .gt. index(nseg,2) ) 
     :        .and. ( NoExtrap .or. NoInterp ) ) then
            start = 0.0
            return
         endif

         if ( rec .le. index(1,2) ) then
            nelem = index(1,1)
            trndx = 1
            pointer = nelem
         else
            nelem = index(nseg,1)
            trndx = count - nelem + 1
            pointer = count
         endif

c get mute start time

         call GetStart ( dist, offsets, times, trndx, pointer, start )
         return

      ENDIF

c record is within bounds of pick segments
c locate position within pick control and interpolate mute start time

      do i = 1, nseg - 1

c determine records that bracket input record that trace is from

         if ( rec .lt. index(i+1,2) ) then
            trndx = trndx + 1
            trndx2 = trndx + index(i,1) - 1
            pointer = trndx2 + index(i+1,1)
            goto 40
         else
            trndx = trndx + index(i,1)
         endif
      enddo

 40    continue

c if no interpolation flag is on and rec is not in pickfile then
c no muting to be done

       if ( NoInterp .and. rec .ne. index(i,2) ) then
          start = 0.0
          return
       endif

c retrieve start time from first segment 

       call GetStart ( dist, offsets, times, trndx, trndx2, start1 )

c retrieve start time from second segment 

      trndx2 = trndx2 + 1

      call GetStart ( dist, offsets, times, trndx2, pointer, start2 )

c interpolate start time for this record

      call CalcStart ( start1, start2, index, i, rec, start )

      return
      end
