C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine near ( rec, index, nseg, tr, ntr, recs, times, count, 
     :     mvel, dist, dt_units, nsamp, mtype, NoExtrap, NoInterp, 
     :     start )

#include <f77/lhdrsz.h>

c passed variables

      integer rec,index(2*SZSMPM,2),nseg,tr,ntr,count, nsamp

      real    recs(*),times(*),mvel,dist,start, dt_units

      character mtype*(*)

      logical NoExtrap, NoInterp

c local variables

      integer nelem,k

c initialize variables

      start = 0.0

c determine placement of record relative to pick file

      nelem = index(1,1)

      IF ( rec .le. ifix(recs(1)) ) then

c extrapolate from first pick unless either no extrapolation or 
c no interpolation flag is set

         if ( rec .lt. ifix(recs(1)) .and. ( NoExtrap .or. NoInterp ) ) 
     :        then
            if ( mtype .eq. 'nearon' ) start = dt_units
            if ( mtype .eq. 'nearoff' ) start = ( nsamp - 1 ) * dt_units
            return
         else
            start = times(1) + (dist/mvel)*1000.
            return
         endif

      ELSEIF (rec .ge. ifix(recs(nelem)) ) then

c extrapolate from last pick unless either no extrapolation or no
c interpolation flag is set

         if ( rec .gt. ifix(recs(nelem)) .and. 
     :        ( NoExtrap .or. NoInterp ) ) then
            if ( mtype .eq. 'nearon' ) start = dt_units
            if ( mtype .eq. 'nearoff' ) start = ( nsamp - 1 ) * dt_units
            return
         else
            start = times(nelem) + (dist/mvel)*1000.
            return
         endif

      ENDIF

      if(start.lt.1.e-29)then

c interpolate within function unless no interpolation flag is set       

         do k = 2,nelem
            if(rec.le.recs(k))then

               if ( NoInterp .and. rec .ne. recs(k) ) then
                  if ( mtype .eq. 'nearon' ) start = dt_units
                  if ( mtype .eq. 'nearoff' ) start = ( nsamp - 1 ) * 
     :                 dt_units
                  return
               endif

               start = times(k-1) + ( (times(k) - times(k-1) ) / 
     :              ( recs(k) - recs(k-1) ) * ( rec - recs(k-1) ) )

               start = start + (dist/mvel) * 1000.
               return

            endif

         enddo

      endif

      end
