C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine on ( rec, index, nseg, tr, ntr, traces, times, count, 
     :     NoExtrap, NoInterp, start )

#include <f77/lhdrsz.h>

      integer rec,index(2*SZSMPM,2),tr,ntr,count,i,j,rndx,nelem,trndx
      integer trndx2

      real times(*), traces(*), start,start1,start2

      logical NoExtrap, NoInterp

c initialize variables

      start = 0.
      start1 = 0.
      start2 = 0.
      rndx = 0
      trndx = 0
      trndx2 = 0

c scan index for existance of record in pic file range assumption in 
c this logic is that record number is sequential record number

c RECORD is BEFORE SEGMENT ONE

      IF ( rec .le. index(1,2) ) then 

c if the no extrapolation or no interpolation option is chosen then return 
c with a start time of zero so that no muting is done on this record

         if ( rec .lt. index(1,2) .and. ( NoExtrap .or. NoInterp) ) then
            start = 0.0
            return
         endif

c determine if trace is before 1st trace in pic file or after last trace
c in pic file

         rndx = 1
         nelem = index(1,1)

         if ( tr .le. traces(1) ) then
            start = times(1)
            return
         else
            if ( tr .ge. traces(nelem) ) then
               start = times(nelem)
               return
            endif
         endif

c trace must fall within segment, bracket trace and interpolate mute start time

         do i = 2,nelem
            if ( tr .le. traces(i) ) then
               start = times(i-1) + ((times(i) - times(i-1))/(traces(i) 
     :                 - traces(i-1))*(tr - traces(i-1)))
               return
            endif
         enddo

      ELSEIF ( rec .ge. index(nseg,2) ) then

c RECORD is AFTER LAST SEGMENT 
         

c if the no extrapolation or no interpolation option is chosen then return 
c with a start time of zero so that no muting is done on this record

         if ( rec .gt. index(nseg,2) .and. ( NoExtrap .or. NoInterp ) ) 
     :        then
            start = 0.0
            return
         endif

         rndx = nseg
         nelem = index(nseg,1)
         trndx = count - nelem + 1

c determine if trace is before 1st trace in segments or after last trace in segments

         if ( tr .le. traces(trndx) ) then
            start = times(trndx)
            return
         else
            if ( tr .ge. traces(count) ) then
               start = times(count)
               return
            endif
         endif

c trace must fall within pic file, bracket trace and interpolate mute start time

         do i = trndx+1, count
            if ( tr .le. traces(i) ) then
               start = times(i-1) + ((times(i)-times(i-1))/(traces(i)
     :              - traces(i-1))*(tr - traces(i-1))) 
               return
            endif
         enddo

      ENDIF

	
      IF ( start .lt. 1.e-5 ) then

c record must exist in pic file, locate pic records that bracket 
c and determine trace index in traces and times array for first
c element of first segment

         do i = 1, nseg - 1
            if ( rec .lt. index(i+1,2) ) then
               trndx = trndx + 1
               trndx2 = trndx+index(i,1)
               goto 40
            else
               trndx = trndx + index(i,1)
            endif
         enddo

c get time value for desired trace from each segment then interpolate between

 40      continue

c if NoInterp option is flagged then check to see if rec = index(trndx,2), if not
c then no mute to be applied.

         if ( NoInterp ) then
            if ( rec .ne. index(i,2)) then
               start = 0.0
               return
            endif
         endif

c first segment first

c determine if trace is before 1st trace in pic file or after last trace in first segment 

         if ( tr .le. traces(trndx) ) then
            start1 = times(trndx)
         else
            if ( tr .ge. traces(trndx2 - 1) ) then
               start1 = times(trndx2 - 1)
            endif
         endif

c if start1 is still zero then tr must be in segment bracket it and interpolate start1 time	

         if ( start1 .lt. 1.e-5 ) then
            do j = trndx+1,trndx2-1
               if ( tr .le. traces(j) ) then
                  start1 = times(j-1)+((times(j)- times(j-1))/(traces(j)
     :                     - traces(j-1))*(tr - traces(j-1))) 
                  goto 70
               endif
            enddo
         endif

c second segment 

c determine if trace is before 1st trace in pic file or after last trace in second segment 

 70      if ( tr .le. traces(trndx2) ) then
            start2 = times(trndx2)
         else
            if ( tr .ge. traces(trndx2+index(i+1,1)-1) ) then
               start2 = times(trndx2+index(i+1,1)-1)
            endif
         endif

c if start2 is still zero then tr must be in segment bracket it and interpolate start2 time	

         if ( start2 .lt. 1.e-5 ) then

            do j = trndx2+1, trndx2+index(i+1,1)-1
               if ( tr .le. traces(j) ) then
                  start2 = times(j-1)+((times(j)- times(j-1))/(traces(j)
     :                     - traces(j-1))*(tr - traces(j-1))) 
                  goto 80
               endif
            enddo
         endif

c interpolate start time for current record and trace 

 80      start = start1 + ((start2 - start1)/(index(i+1,2)-index(i,2))
     :           *(rec - index(i,2)))

      ENDIF

c start is now calculated, return to calling routine 

      return
      end
