C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  binstk:  stack n records vertically together
C
C**********************************************************************C
C
C binstk READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C vertically stacks N records sample-to-sample, trace-to-trace
C or into distance bins, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>


      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     SHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis, stacor
      integer     errcod, abort
      REAL        xtr( SZLNHD ), spread( SZLNHD )
      REAL        rept( SZLNHD )
      REAL        static( SZLNHD )

      integer     ITRH, LinInd, DphInd
      REAL        out
      pointer     (wkaddr,  out(1))
      pointer     (wkitrh, itrh(1))
      CHARACTER   NAME * 6,  ntap * 256, otap * 256
#include <f77/pid.h>
      logical     verbos,query,heap,split,threed,abslt
 
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'BINSTK'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      data verbos/.false./
      data abort/ 0 /

c-------------------------------------
c  get online help if necessary
c-------------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call  help ()
           stop
      endif

c----------------------------------
c  open printout file
c----------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln (ntap,otap,far,dx,verbos,split,threed,abslt)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'binstk: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c--------------------------
c  get key header values
#include <f77/saveh.h>

      call saver (itr, 'CDPFld', ncdp,  LINHED)
      call saver (itr, 'MnLnIn', nli1,  LINHED)
      call saver (itr, 'MxLnIn', nli2,  LINHED)
      call saver (itr, 'MnDpIn', ndi1,  LINHED)
      call saver (itr, 'MxDpIn', ndi2,  LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      if (threed) then
c        nli  = nli2 - nli1 + 1
c        ndi  = ndi2 - ndi1 + 1
c        nrec = nli * ndi
c        ntrc = ncdp
      endif

      CALL HLHprt ( ITR, LBYTES, NAME, 5, LERR        )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

        write(LERR,*) ' '
        write(LERR,*) ' '
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform

C**********************************************************************C
C     update historical line header; write out header
C**********************************************************************C
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      nsampo=nsamp
      obytes = SZTRHD + SZSMPD * nsampo
      call savhlh ( itr, lbytes, lbyout )

        write(LERR,*) ' '
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsampo
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' '
        write(LERR,*) 'Bin option selected:'
        write(LERR,*) ' Far offset for spread =  ', far
        write(LERR,*) ' Bin size              =  ', dx
        if (abslt) 
     1  write(LERR,*) ' Input trace distances forced to be positive'
        write(LERR,*) ' '

c-------
c compute spread model
c-------
         if (split) then

            x  = 0.
            dx = abs(dx)
            do  j = 1, SZSMPM
   
                if (x .gt. abs(far)) then
                    ngrp2 = j - 1
                    go to 20
                else
                    xtr (j) = x
                endif
                x = x + dx
   
            enddo
20          continue
            ngrp = 2 * ngrp2 - 1

            ic = 0
            do  j = 2, ngrp2
                ic = ic + 1
                spread (ngrp2-ic) = -xtr(j)
            enddo
            ic = 0
            do  j = 1, ngrp2
                ic = ic + 1
                spread (ngrp2+ic-1) = xtr(j)
            enddo
   
         else

            x = 0.
            do  j = 1, SZSMPM
   
                if (far .gt. 0.) then
   
                   if (x .gt. far) then
                       ngrp = j - 1
                       go to 21
                   else
                       spread (j) = x
                   endif
   
                elseif (far .lt. 0.) then
   
                   if (x .gt. 0.0) then
                       ngrp = j - 1
                       go to 21
                   else
                       spread (j) = x
                   endif
   
                endif
                x = x + dx
            enddo
 21      continue
   
         endif

         call maxmgv (spread, 1, xmax, loc, ngrp)

         write(LERR,*)' '
         write(LERR,*)'Spread model:'
         write(LERR,*)'Number of groups in spread   = ',ngrp
         write(LERR,*)(spread(i),i=1,ngrp)
         write(LERR,*)' '
         if (verbos) then
         write(LER ,*)' '
         write(LER ,*)'Spread model:'
         write(LER ,*)'Number of groups in spread   = ',ngrp
         write(LER ,*)(spread(i),i=1,ngrp)
         write(LER ,*)' '
         endif

c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      ntrcm = ngrp
      itemi = ntrcm * ITRWRD
      items = ntrcm *  nsamp
      call galloc (wkitrh, itemi*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkaddr, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else 
         write(LERR,*)' ' 
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
      call savew( itr, 'NumTrc', ntrcm, LINHED)
      CALL WRTAPE ( LUOUT, ITR, LBYOUT                 )

C**********************************************************************C
C
C     READ TRACE, DO binstk, WRITE TO OUTPUT FILE
C
C**********************************************************************C

      DO 100 JJ = 1, NREC

           call vclr ( out, 1, nsamp*ntrcm )

c-----------------------------
c  loop over all traces in input
c  record
          call vclr (rept, 1, ntrcm)
          call vclr (static, 1, ntrcm)

          live = 0

          DO 98 KK = 1, NTRC

              nbytes = 0
              CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,' trace ',kk
                  go to 999
               endif
               call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)

               if ( KK .eq. 1 ) then
                  call saver2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                     LinInd  , TRACEHEADER)
                  call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                     DphInd  , TRACEHEADER)
               endif
                  

               call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                     idist  , TRACEHEADER)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     stacor , TRACEHEADER)

               if (abslt) idist = iabs (idist)
               xdist = idist

               IF (stacor .ne. 30000) THEN
                   call vmov (lhed, 1, shed, 1, ITRWRD)
                   live = live + 1
                   call  binsum (ngrp, nsamp, xdist, xmax,
     1                           dx, spread, xtr, out, rept)
               ENDIF

   98     CONTINUE
c----------------

        DO 75 KK = 1, NTRCM

          istrc = (kk-1) * nsamp
          call vmov  ( out(istrc+1), 1, xtr, 1, nsamp )
          call dotpr ( xtr, 1, xtr, 1, xdot, nsamp)
c------------------------
c  reconstitute headers
          call vmov (shed, 1, lhed, 1, ITRWRD)
c         ishdr = (kk-1) * ITRWRD
c         call vmov (itrh(ishdr+1),1,lhed,1,ITRWRD)

             if (xdot .lt. 1.e-30) then
                call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                              30000  , TRACEHEADER)
                call vclr (xtr, 1, nsamp)
             else
                call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                              0      , TRACEHEADER)
             endif
             idist = spread (KK)
             call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           idist  , TRACEHEADER)

c added DstUsg for Hans Sugianto....pgag

             idist = iabs(idist)
             call savew2(lhed,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                           idist  , TRACEHEADER)

             xscl = rept(KK)
             if (xscl .ne. 0.) then
                 xscl = 1. / xscl
             else
                 xscl = 0.
             endif
             call vsmul (xtr, 1, xscl, lhed(ITHWP1), 1, nsamp)

             call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            JJ     , TRACEHEADER)
             call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            KK     , TRACEHEADER)
             call savew2(lhed,ifmt_LinInd,l_LinInd, ln_LinInd,
     1            LinInd  , TRACEHEADER)
             call savew2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1            DphInd  , TRACEHEADER)
c------------------------
          call wrtape(luout,itr,obytes)

   75   CONTINUE

        if(verbos) then
           write(LERR,*)'Output Record ',jj
           write(LER ,*)'Output Record ',jj
        endif

  100 CONTINUE

  999 continue

       call lbclos(luin)
       call lbclos(luout)
      END

c------------------------------------
c  online help section
c------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for binstk: stack traces'
        write(LER,*)'into bins defining CDP spread'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-S         -- split spread (-far,...,0,...,far)'
        write(LER,*)'-A         -- input trc distances forced positive'
        write(LER,*)'-3d        -- 3D CDP input data assumed'
        write(LER,*)'-xf[far]   -- bin option: far offset (ft,m)'
        write(LER,*)'-xd[dx]    -- bin option: bin size override (ft,m)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      binstk -N[] -O[] -xf[] -xd[] [-S -3d -A -V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    nstk   - I      number of groups of records to stack
c    igath  - I      force number traces in gather to stack
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,far,dx,verbos,split,threed,
     1                 abslt)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      real       far, dx
      integer    argis
      logical    verbos, split, threed, abslt

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           call argr4('-xf',far,0.,0.)
           call argr4('-xd',dx ,0.,0.)

           abslt  = ( argis( '-A' ) .gt. 0 )
           if (far .eq. 0.) then
              write(LERR,*)'FATAL error in binstk bin option:'
              write(LERR,*)'must enter far offset using'
              write(LERR,*)'-xf[] cmd line argument'
              stop
           endif

           split  = ( argis( '-S' ) .gt. 0 )
           if (split) abslt = .false.
           threed = ( argis( '-3d') .gt. 0 )
           if (threed) abslt = .true.
           verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
