/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/signal.h>
#ifdef sun
#include <sys/filio.h>
#else
#ifdef CRAY
#include <sys/ioctl.h>
#endif
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <localsys.h>
#include <cu_defs.h>

#define BUFSIZE 600000
#define PIPSIZ 16384

FILE *dbfile = NULL;
int alarm_knt;
void pipe_alarm();

main (argc, argv) 
int    argc;
char * argv[];
{
   char *dbfname;
   short data_to_be_read();
   int     bytes_read,total_bytes_read = 0;
   static unsigned long timer_interval = 1;
   char *buffer= (char *) malloc(BUFSIZE*sizeof(char));
   char tmpbuf[PIPSIZ];
   int fdin,fdout;
   char ntap[240];
   char otap[240];
   char title[128];
   char *xcat_title,*title_char;
   char geometry[32];
   int x,y;
   char xcat_cmd[256];
   char rows[8],columns[8];
   void help();
   int C_ARGIS();

   if ((C_ARGIS("-?",&argc,argv) != 0) ||
       (C_ARGIS("-h",&argc,argv) != 0)) help();

	C_ARGSTR("-N",ntap,"","",&argc,argv);
	if (strlen(ntap) != 0)
	  fdin = open(ntap,(int) O_RDONLY );
	else {
	  fdin = 0;
	  if (setvbuf(stdin,&tmpbuf[0],_IOFBF,PIPSIZ) != 0) {
	    perror("BYTKNT");
	    exit(errno);
	    }
	  }
	  
	C_ARGSTR("-O",otap,"","",&argc,argv);
	if (strlen(otap) != 0)
	  fdout = open(otap, (int) O_WRONLY | O_CREAT | O_TRUNC, 0666);
	else {
	  fdout = 1;
	  }

	C_ARGI4("-alarm",&alarm_knt,1,0,&argc,argv);
	if (alarm_knt != 0) signal(SIGPIPE,pipe_alarm);

	C_ARGSTR("-title",title,"","",&argc,argv);
	if (strlen(title) != 0) {
	  xcat_title = strdup(title);
	  while ((title_char = strchr(xcat_title,'_')) != NULL) {
	 	*title_char = ' ';
		}
	  sprintf(xcat_cmd,"xcat -automap -buffer 10 -title \"%s\"",xcat_title);
	  }
	else
	  sprintf(xcat_cmd,"xcat -automap -buffer 10");

	C_ARGSTR("-rows",rows,"","",&argc,argv);
	if (strlen(rows) != 0) {
	  strcat(xcat_cmd," -rows ");
	  strcat(xcat_cmd,rows);
	  }
	C_ARGSTR("-columns",columns,"","",&argc,argv);
	if (strlen(columns) != 0) {
	  strcat(xcat_cmd," -columns ");
	  strcat(xcat_cmd,columns);
	  }

	C_ARGI4("-X",&x,9999,9999,&argc,argv);
	C_ARGI4("-Y",&y,9999,9999,&argc,argv);
        if ((x != 9999) && (y != 9999)) {
	  sprintf(geometry,"+%d+%d",x,y);
	  }

	C_ARGSTR("-geo",geometry,geometry,geometry,&argc,argv);
	C_ARGSTR("-geometry",geometry,geometry,geometry,&argc,argv);
	if (strlen(geometry) != 0) {
	  strcat(xcat_cmd," -geo ");
	  strcat(xcat_cmd,geometry);
	  }

	if (C_ARGIS("-x",&argc,argv) != 0) {
	    dbfile = popen(xcat_cmd,"w");
	    if (dbfile == NULL) 
	      fprintf(stderr,"Unable to open pipe to xcat process\n");
	    else
	      fclose(stderr);
	    }

	if (C_ARGIS("-f",&argc,argv) != 0) {
	    if (strlen(title) == 0)
	      sprintf(title,"BYTKNT.%06d",getpid());
	    dbfile = fopen(title,"w");

	    if (dbfile == NULL) {
		perror("BYTKNT");
	      fprintf(stderr,"Unable to open file %s for bytknt output\n",title);
	      exit(1);
	      }
	    }

	if (dbfile == NULL) dbfile = stderr;

	setbuf(dbfile,NULL);

	if (strlen(ntap) != 0)
	  fprintf(dbfile,"ntap = %s\n",ntap);
	else
	  fprintf(dbfile,"ntap = stdin\n");
	if (strlen(otap) != 0)
	  fprintf(dbfile,"otap = %s\n",otap);
	else
	  fprintf(dbfile,"otap = stdout\n");
       
	while (1) {
  	  if (data_to_be_read(fdin)) {
  	    bytes_read = read(fdin,buffer,BUFSIZE);
  	    total_bytes_read += bytes_read;
	    fprintf(dbfile,"%d (%d)\n",total_bytes_read,bytes_read);
  	  
  	    switch (bytes_read) {
  	     case (-1):
  	       perror("BYTKNT");
	       close(fdin);
	       close(fdout);
	       fclose(dbfile);
	       pipe_alarm();
  	       exit(1);
  	     case 0:
	       close(fdin);
	       close(fdout);
	       fclose(dbfile);
	       pipe_alarm();
  	       exit(0);
  	       break;
  	     default:
  	        write (fdout, buffer, bytes_read);
  	        timer_interval = 1;
  	      }
  	    } 
  	  }
}

/*
 *   data_to_be_read() - Check to see if a read of the specified file 
 *	would block.
 *
 *   Returns:
 *        FALSE, if read would block
 *        TRUE, if read would not block
 */
static short
data_to_be_read(fd)
   int fd;                       /* File descriptor */
{
	int nfound;              /* Number of ready descriptors */
	fd_set readfds;               /* Read file descriptors bit mask */
	struct timeval timeout;

	FD_ZERO(&readfds);
	FD_SET(fd, &readfds);

	timeout.tv_sec = 0;      /* Cause select to return immediately */
	timeout.tv_usec = 0;

	while ((nfound = select(FD_SETSIZE, &readfds, 0, 0, &timeout)) == -1) {
		if (errno == EINTR)
			continue; /* Ignore interrupts */

		fprintf(dbfile, "select() failed, errno = %d\n", errno);
		exit(1);
	}
	return((short) nfound);
}
void help()
{
fprintf(stderr,"\n Command Line Arguments for BYTKNT: ");
fprintf(stderr,"debug utility for data stream monitoring\n\n");

fprintf(stderr," Input........................................");
fprintf(stderr,"(defaults)\n\n");

fprintf(stderr," -N[ntap]    -- input data set name            (stdin)\n");
fprintf(stderr," -O[otap]    -- output data set name          (stdout)\n");
fprintf(stderr," -f          -- redirect stderr to file        (false)\n");
fprintf(stderr," -x          -- redirect stderr to xcat window (false)\n");
fprintf(stderr," -title      -- output file name or xcat title        \n");
fprintf(stderr," -alarm[knt] -- ring bell on stdin EOF   ");
fprintf(stderr,"(0 if not specified)\n");
fprintf(stderr,"                                    ");
fprintf(stderr,"(1 if no count specified)\n");

fprintf(stderr," -X          -- x location for xcat window  ");
fprintf(stderr,"(xcat default)\n");
fprintf(stderr," -Y          -- y location for xcat window  ");
fprintf(stderr,"(xcat default)\n");

fprintf(stderr," -rows       -- no. of rows in xcat window  ");
fprintf(stderr,"(xcat default)\n");
fprintf(stderr," -columns    -- no. of cols in xcat window  ");
fprintf(stderr,"(xcat default)\n");
fprintf(stderr," -? | -h     -- this help diagnostic\n");
exit(0);
}
void pipe_alarm()
{
	int i;
	fprintf(dbfile,"end of data\n");
	for (i=0; i<alarm_knt; i++) {
	  system("beep");
	  sleep(5);
	  }
	exit(0);
}
