/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
   this is a quick-and-dirty example of how a USP written in C may 
   be written using the arg handlers and USP I/O package.
*/
#include <stdio.h>
#include <save_defs.h>
#include <cu_defs.h>
#include <ut_defs.h>
#include <io_defs.h>
#include <size_defs.h>

void main(argc,argv)
int argc;
char **argv;
{
	int seqrec,seqtrc,rec_start,rec_end,trc_start,trc_end;
	char ntap[256],otap[256];
	char *buffer,*date;
	int help;
	int luin,luout;
	int nbytes,nbytes2,nrecs,ntrcs,nsmps;
	short recnum,trcnum;
	int recnum_fmt,recnum_indx,recnum_lng;
	int trcnum_fmt,trcnum_indx,trcnum_lng;

	help = C_ARGIS("-h",&argc,argv);
	help += C_ARGIS("-?",&argc,argv);
	if (help != 0) {
		fprintf(stderr,"c_prgm is an example code to demonstrate");
		fprintf(stderr,"how to code a USP program in C\n\n");
		fprintf(stderr,"Usage: c_prgm -N [ntap] -O [otap]");
		fprintf(stderr," -rs [starting_record] -re [ending_record]\n");
		fprintf(stderr,"\t-ns [starting_trace] -ne [ending_trace]\n");
		exit(0);
		}

	save_cmd_args(argc,argv);
/*
   Fetch the name of the input/output files from the command line. If not 
   specified, stdin and/or stdout are used.
*/
	C_ARGSTR("-N",ntap," "," ",&argc,argv);
	if (strcmp(ntap," ") != 0) 
	  C_LBOPEN(&luin,ntap,"r");
	else
	  luin = 0;

	C_ARGSTR("-O",otap," "," ",&argc,argv);
	if (strcmp(otap," ") != 0) 
	  C_LBOPEN(&luout,otap,"w");
	else
	  luout = 1;
/*
   Grab a buffer for the line header and then reallocate it down to 
   the size of a trace after we get the info from the line header.
*/
	buffer = (char *)malloc(12000*sizeof(char));
	nbytes = 0;
	C_RTAPE(luin,buffer,&nbytes);
	get_hw_val(buffer,"NumRec",LINEHEADER,&nrecs);
	get_hw_val(buffer,"NumTrc",LINEHEADER,&ntrcs);
	get_hw_val(buffer,"NumSmp",LINEHEADER,&nsmps);
	fprintf(stderr,"recs = %d, trcs = %d, smps = %d\n",nrecs,ntrcs,nsmps);
/*
   Read in the value for the starting and ending record and trace values.
*/
	C_ARGI4("-rs",&rec_start,1,1,&argc,argv);
	C_ARGI4("-re",&rec_end,nrecs,nrecs,&argc,argv);
	fprintf(stderr,"starting record = %d\nending record = %d\n",
		rec_start,rec_end);

	C_ARGI4("-ns",&trc_start,1,1,&argc,argv);
	C_ARGI4("-ne",&trc_end,ntrcs,ntrcs,&argc,argv);
	fprintf(stderr,"starting trace = %d\nending trace = %d\n",
		trc_start,trc_end);

	date = (char *) cgdate();
	fprintf(stderr,"date = %s\n",date);
	put_hw_val(buffer,"PrcDat",LINEHEADER,date);
	save_hlh(buffer,nbytes,&nbytes2);
	C_WRTAPE(luout,buffer,nbytes2);

	fprintf(stderr,"size of trace buffer = %d\n",SZTRHD+(nsmps*SZSMPD));
	buffer = (char *)realloc(buffer,SZTRHD+(nsmps*SZSMPD));
	C_SAVELU("RecNum",&recnum_fmt,&recnum_indx,&recnum_lng,TRACEHEADER);
	C_SAVELU("TrcNum",&trcnum_fmt,&trcnum_indx,&trcnum_lng,TRACEHEADER);
/*
   loop over the selected input traces ( or until we hit nbytes = 0 )
*/
	seqrec = rec_start-1;
	skipt(luin,seqrec*ntrcs);
	do {
	  seqtrc = trc_start-1;
	  skipt(luin,seqtrc);
	  do {
	    nbytes = 0;
	    C_RTAPE(luin,buffer,&nbytes);
	    if (nbytes == 0) break;
	    get_indexed_hw_val(buffer,recnum_fmt,recnum_indx,recnum_lng,
		TRACEHEADER,&recnum);
	    get_indexed_hw_val(buffer,trcnum_fmt,trcnum_indx,trcnum_lng,
		TRACEHEADER,&trcnum);
	    seqtrc++;
	    fprintf(stderr,"rec  = %d, trc = %d\n",recnum,trcnum);
	    C_WRTAPE(luout,buffer,nbytes);
	    } while ((seqtrc < trc_end) && (nbytes != 0));
	    skipt(luin,ntrcs-trc_end);
	    seqrec++;
	  } while ((seqrec < rec_end) && (nbytes != 0));

	C_LBCLOS(luin);
	C_LBCLOS(luout);

	exit(0);
}
