C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs some arcane geophysical process
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     itr ( SZLNHD ), source(SZLNHD), receiver(SZLNHD)
      integer     cdpvalue ( SZLNHD ), surface(SZLNHD)
      integer * 2 itr2( SZLNHD )
      real        head( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
 
c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c     real        bigar2(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
      integer     itrhdr
      real        bigar1, bigar2
      pointer     (wkadri, itrhdr(1))
      pointer     (wkadr1, bigar1(1))
      pointer     (wkadr2, bigar2(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     recnum, trcnum
      integer     srcloc, recind, dphind, dstsgn, stacor
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real        tri ( SZLNHD )
      character   ntap * 256, otap * 256, name*7
      character   src_stat*6, rec_stat*6,cdp_stat*6,surf_stat*6
      logical     verbos, query, heap1, heap2, heapi
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      equivalence ( itr2( 1), itr (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'CDPSTAT'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,src_stat,rec_stat,
     *			cdp_stat,surf_stat,verbos)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'PRGM: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header

      call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
      call savelu('SrcLoc',ifmt,l_SrcLoc,length,TRACEHEADER)
      call savelu('RecInd',ifmt,l_RecInd,length,TRACEHEADER)
      call savelu('DphInd',ifmt,l_DphInd,length,TRACEHEADER)
      call savelu('DstSgn',ifmt,l_DstSgn,length,TRACEHEADER)
      call savelu(cdp_stat,ifmt,l_cdp_stat,length,TRACEHEADER)
      call savelu(src_stat,ifmt,l_src_stat,length,TRACEHEADER)
      call savelu(rec_stat,ifmt,l_rec_stat,length,TRACEHEADER)
      call savelu(surf_stat,ifmt,l_surf_stat,length,TRACEHEADER)

      write(LERR,*)'TrcNum,ifmt,l_TrcNum,length= ',
     1             ifmt,l_TrcNum,length
      write(LERR,*)'RecNum,ifmt,l_RecNum,length= ',
     1             ifmt,l_RecNum,length
      write(LERR,*)'SrcLoc,ifmt,l_SrcLoc,length= ',
     1             ifmt,l_SrcLoc,length
      write(LERR,*)'RecInd,ifmt,l_RecInd,length= ',
     1             ifmt,l_RecInd,length
      write(LERR,*)'DphInd,ifmt,l_DphInd,length= ',
     1             ifmt,l_DphInd,length
      write(LERR,*)'DstSgn,ifmt,l_DstSgn,length= ',
     1             ifmt,l_DstSgn,length
      write(LERR,*)'cdp_stat,ifmt,l_cdp_stat,length= ',
     1             ifmt,l_cdp_stat,length
      write(LERR,*)'src_stat,ifmt,l_src_stat,length= ',
     1             ifmt,l_src_stat,length
      write(LERR,*)'rec_stat,ifmt,l_rec_stat,length= ',
     1             ifmt,l_rec_stat,length
      write(LERR,*)'surf_stat,ifmt,l_surf_stat,length= ',
     1             ifmt,l_surf_stat,length
 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 7, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
 
c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap1 = .true.
      heap2 = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      itemi = ntrc * ITRWRD * SZSMPD
      item1 = ntrc * nsamp  * SZSMPD
      item2 = ntrc * nsamp  * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 1  (allocation succeeded)
c     errcod = 0  (allocation failed)
c--------
 
      call galloc (wkadri, itemi, errcdi, aborti)
      call galloc (wkadr1, item1, errcd1, abort1)
      call galloc (wkadr2, item2, errcd2, abort2)
 
      if (errcdi .ne. 0.) heapi = .false.
      if (errcd1 .ne. 0.) heap1 = .false.
      if (errcd2 .ne. 0.) heap2 = .false.
 
      if (.not. heap1 .or. .not. heap2 .or. .not. heapi) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
 
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', jtr  , LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vel,ntap,otap)
      end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
         dt = real (nsi) * unitsc
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
 
c-----
c     process desired trace records
c-----
      do 1000 jj = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 		icount = jtr
            ic = 0
            do 1001  kk = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
 
c------
c     use previously derived pointers to trace header values
                  recnum = itr2(l_RecNum)
                  trcnum = itr2(l_TrcNum)
                  srcloc = itr2(l_SrcLoc)
                  recind = itr2(l_RecInd)
                  dphind = itr2(l_DphInd)
                  dstsgn = itr2(l_DstSgn)
                  stacor = itr2(l_StaCor)
                  source(kk) = itr2(l_src_stat)
                  receiver(kk) = itr2(l_rec_stat)
                  cdpvalue(kk) = itr2(l_cdp_stat)
                  surface(kk)= itr2(l_surf_stat)

       if (verbos)
     1 write(LERR,*)'recnum,trcnum,srcloc,recind,dphind,dstsgn,stacor,
     *source,receiver,cdpvalue,surface= '
     2,recnum,trcnum,srcloc,recind,dphind,dstsgn,stacor,source(kk),
     3 receiver(kk),cdpvalue(kk),surface(kk)

c------
                  if (stacor .eq. 30000) then
			icount = icount - 1
                     call vclr (tri,1,nsamp)
                  endif
 
c----------------------
c  pack data into array
                  ic = ic + 1
                  istrc = (ic-1) * nsamp
                  ishdr = (ic-1) * ITRWRD
                  call vmov (tri,1, bigar1(istrc+1),1, nsamp)
                  call vmov (itr,1, itrhdr(ishdr+1),1,ITRWRD)
 
1001        continue
 
c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
c-----------------------
c  here's the meat...
c  do something to data
 
	call distat(source,receiver,cdpvalue,surface,jtr)
 
c  (USER: insert your subroutine above)
c-----------------------
 
c---------------------
c  extract traces from
c  output array and
c  write output data
            do 1002 kk = 1, jtr
 
                  istrc = (kk-1) * nsamp
                  ishdr = (kk-1) * ITRWRD
                  call vmov (bigar1(istrc+1),1,itr(ITHWP1),1, nsamp)
                  call vmov (itrhdr(ishdr+1),1,itr,1,ITRWRD)
                  itr2(l_cdp_stat) = cdpvalue(kk)
                  itr2(l_surf_stat)= surface(kk)
                  call wrtape (luout, itr, obytes)
 
 
 1002             continue
 
 
 1000       continue
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
            write(LERR,*)'end of prgm, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*)
     :'The input MUST be in CDP format with source & receiver statics'
        write(LER,*)
     :'stored in the trace headers.'
        write(LER,*)
     :'CDPSTAT aportions these input statics into a SURFACE static'
        write(LER,*)
     :'that follows a floating datum and is applied BEFORE moveout'
        write(LER,*)
     :'AND a CDP static applied after stack'
        write(LER,*)
     :'execute CDPSTAT by typing CDPSTAT and the program parameters'
        write(LER,*)
     :' -N [ntap]    (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)         : output data file name'
        write(LER,*)
     :' -ns[ns]      (default = first)    : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)     : end trace number'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -ne[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -src[src] (default=InStAp(wd 9)):loc for INPUT source static'
        write(LER,*)
     :' -rec[rec] (default=RcStAp(wd 12)):loc for INPUT rec static'
        write(LER,*)
     :' -cdp[cdp] (default=StaCor(wd 125)):loc for OUTPUT cdp static'
        write(LER,*)
     :' -surf[surf](default=ToStAp(wd 13)):loc for OUTPUT surf static'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   cdpstat -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] '
        write(LER,*)
     :'      -re[ire] -src[src] -rec[rec] -cdp[cdp] -surf[surface]  -V'
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,src_stat,rec_stat,
     *			cdp_stat,surf_stat,verbos) 
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     src_statC*6      mnemonic for where src static is stored
c     rec_statC*6      mnemonic for where rec static is stored
c     cdp_statC*6      mnemonic for where cdp static is to be stored
c     surf_statC*6      mnemonic for where surface static is to be stored
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      character   src_stat*(*),rec_stat*(*),cdp_stat*(*),surf_stat*(*)
      integer     ns, ne, irs, ire
      logical     verbos
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program prgm might be invoked in the following way:
 
c     prgm  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into prgm and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argstr( '-src', src_stat,'InStAp', 'InStAp' )
            call argstr( '-rec', rec_stat,'RcStAp', 'RcStAp' )
            call argstr( '-cdp', cdp_stat,'StaCor', 'StaCor' )
            call argstr( '-surf', surf_stat,'ToStAp', 'ToStAp' )
            call argi4 ( '-re', ire ,   0  ,  0    )
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  vel,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' design window velocity =  ', vel
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

c-----
c    write out printout file in case program bombs later
c-----
            call flush (LERR)
 
      return
      end
 
	subroutine distat(src,rec,cdp,surf,jtr)
#include <f77/iounit.h>
	integer src(*),rec(*),cdp(*),surf(*)
	acount = 0.0
	test = 0.0
	totstat = 0.0
c
c	compute average cdp static
c
	do 10 i = 1, jtr
		if (cdp(i) .ne. 30000 )  then
			totstat = totstat + float(src(i))+float(rec(i))
			acount = acount + 1.0
		endif
10	continue
	avgcdp = (totstat/acount)
c
c	apply surface static and average cdp static
c
	do 20 i = 1, jtr
		if (cdp(i) .ne. 30000) then
			cdp(i) = nint(avgcdp)
			test = float(src(i))+ float(rec(i))- avgcdp
			surf(i)= nint(test)
		endif
20	continue
	return
	end
