c -----------------  Main Routine -----------------------
c
c     copyright 2002, Amoco Production Company 
c              All rights reserved
c        an affiliate of BP America Inc.
c
c -----------------  ------------ -----------------------

c     Program Changes:
c
c      - original written: October, 2002

c     Author(s):
c
c      - Mike D. Bush [Sunbury] - concept and original code
c      - Paul Garossino [Houston] USP implimentation

c     Program Description:

      implicit none

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer itr(SZLNHD)
      integer nsamp, nsi, ntrc, ntrco, nrec, nreco, iform, obytes
      integer luin , luout, lbytes, nbytes, lbyout
      integer irs, ire, ns, ne, argis, jerr


      real    tri(SZLNHD)
      real UnitSc

      character ntap*1048, otap*1048, name*5

      real*8 summeas,summeasp,tmeas
      real*8 dt,wedgeamp,wedgelen,ampl1
      real*8 fx
      real*8 ttopin,tbotin,tmid,ttopout,tbotout
      real*8 sumcalc,sumcalcp,tcalc
      real*8 fcorners(4)

      integer nvar,iflag1,nfreq,ismooth
      integer ierr,ibytes,ierrt
      integer i

      logical verbos

      real*8 filter,freq

      pointer (wkfreq    , freq  (1))
      pointer (wkfilter  , filter    (1))

c variables picked up by implicit none

      integer abort, length, lenth, nsampo
      integer ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum
      integer ifmt_TopHrz, l_TopHrz, ln_TopHrz, TopHrz
      integer ifmt_BotHrz, l_BotHrz, ln_BotHrz, BotHrz
      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer JJ, KK

      real TmMsFS, rTopHrz, rBotHrz

      character c_TopHrz*6, c_BotHrz*6

      logical hard

c common block assignment

      common /wedgedata/ 
     :     summeas, summeasp, tmeas, sumcalc, sumcalcp, ampl1,
     :     tcalc, dt, iflag1, nfreq

c Initialize variables

      data abort/0/
      data name/"CITHI"/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c---- Get command line arguments

      call cmdln ( ntap, otap, fcorners, nvar, ampl1,
     :     irs, ire, ns, ne, hard, c_TopHrz, c_BotHrz, verbos )

c set iflag, iflag is 1 if nvar = 2 and user has specified a 
c starting amplitude.  iflag = 0 if starting amplitude has to be estimated
c by program, in which case the user has not entered a starting point


      if ( ( nvar .eq. 2 ) .and. ( dabs(ampl1) .ge. 1.d-32 ) ) then
         iflag1 = 1
      elseif ( (nvar .eq. 2 ) .and. ( dabs(ampl1) .lt. 1.d-32 ) ) then
         iflag1 = 0
      endif

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         length = lenth(ntap)
         write(LERR,*)'CITHICKNESS: no line header on input dataset',
     :        ntap(1:length)
         write(LER,*)' '
         write(LER,*)'CITHICKNESS: '
         write(LER,*)' no line header on input dataset',ntap(1:length)
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', UnitSc, LINHED)
      call saver(itr, 'TmMsFS', TmMsFS, LINHED)

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 5, LERR)

      if ( UnitSc .eq. 0.0 ) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         UnitSc = 0.001
         call savew ( itr, 'UnitSc', UnitSc, LINHED)
      endif

c compute delta T in seconds

      dt = dble ( real (nsi) * UnitSc )

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( (ire .eq. 0) .or. (ire .gt. nrec) ) ire = nrec
      if ( ns .eq. 0 ) ns = 1
      if (( ne .eq. 0 ) .or. (ne .gt. ntrc) ) ne = ntrc

c this parameterization assumes input in units of the dataset

      nreco = ire - irs + 1
      ntrco = ne - ns + 1
      nsampo = 4

c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco, LINHED)
      call savew(itr, 'NumSmp', nsampo, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsampo 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )


c set up pointers to header mnemonic StaCor

      call savelu ( 'RecNum', ifmt_RecNum, l_RecNum, ln_RecNum, 
     :     TRACEHEADER )
      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     TRACEHEADER )
      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      call savelu ( c_TopHrz, ifmt_TopHrz, l_TopHrz, ln_TopHrz, 
     :     TRACEHEADER )
      call savelu ( c_BotHrz, ifmt_BotHrz, l_BotHrz, ln_BotHrz, 
     :     TRACEHEADER )

c---- Allocate space for the partial amplitude spectrum and filter

      ierrt = 0
      ibytes = 0

      nfreq = idint(fcorners(4) - fcorners(1)) + 3

      nbytes = nfreq * 2 * SZSMPD

      call galloc ( wkfreq, nbytes, ierr, abort )
      ierrt = ierrt + ierr
      ibytes = ibytes + nbytes

      call galloc ( wkfilter, nbytes, ierr, abort )
      ierrt = ierrt + ierr
      ibytes = ibytes + nbytes

      if (ierrt .ne. 0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) ibytes, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*)  ibytes, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)  ibytes, '  bytes'
         write(LERR,*)' '
      endif

c---- Fill frequency and filter arrays

      freq(1) = dmax1(0.0d0,(fcorners(1) - 1.0d0))

      do i = 2,nfreq
        freq(i) = freq(i - 1) + 1.0d0
      enddo

c---- Compute trapezoidal filter coefficients

      call dzero(nfreq, filter)         

      do i = 1,nfreq

         if(freq(i).ge.fcorners(2) .and. freq(i).le.fcorners(3)) then

c---- All pass

            filter(i) = 1.0d0

         else if( freq(i).gt.fcorners(1) .and.
     :           freq(i).lt.fcorners(2) ) then

c---- Ramp up

            filter(i) = (freq(i) - fcorners(1)) / 
     :           (fcorners(2) - fcorners(1))

         else if(freq(i).gt.fcorners(3) .and.
     :           freq(i).lt.fcorners(4)) then

c---- Ramp down

            filter(i) = (fcorners(4) - freq(i)) / 
     :           (fcorners(4) - fcorners(3))

         endif
      enddo

c----  ismooth = 1 for Hanning Smoothing

      ismooth = 1                         
      call dsmoth(nfreq,filter,ismooth)

      ampl1 = ampl1 * 1.0d-3

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER) 

            if ( ( ifmt_TopHrz .eq. SAVE_FKFLT_DEF ) .or. 
     :           ( ifmt_TopHrz .eq. SAVE_FLOAT_DEF  ) ) then
               call saver2( itr, ifmt_TopHrz, l_TopHrz, ln_TopHrz, 
     :              rTopHrz, TRACEHEADER )
            else
               call saver2( itr, ifmt_TopHrz, l_TopHrz, ln_TopHrz, 
     :              TopHrz, TRACEHEADER )
               rTopHrz = float(TopHrz)
            endif

            if ( ( ifmt_BotHrz .eq. SAVE_FKFLT_DEF  ) .or. 
     :           ( ifmt_BotHrz .eq. SAVE_FLOAT_DEF ) ) then
               call saver2( itr, ifmt_BotHrz, l_BotHrz, ln_BotHrz, 
     :              rBotHrz, TRACEHEADER )
            else
               call saver2( itr, ifmt_BotHrz, l_BotHrz, ln_BotHrz, 
     :              BotHrz, TRACEHEADER )
               rBotHrz = float(BotHrz)
            endif

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

            if ( ( StaCor .ne. 30000 ) .and. 
     :           ( rBotHrz .gt. 0 ) .and. 
     :           ( rTopHrz .gt. 0 ) ) then
               
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )

               ttopin = dble ( rTopHrz )
               tbotin = dble ( rBotHrz )

c---- Determine the middle of the picks and the measured thickness

               tmid = ttopin + (tbotin - ttopin) / 2.0d0
               tmeas = tbotin - ttopin

               call getamp ( tri, nsamp, TmMsFS, rTopHrz, rBotHrz, nsi, 
     :              hard, summeas, summeasp )

               summeas = summeas * 1.0d-3 !scale down for balancing
               summeasp = summeasp * 1.0d-3

               tmeas = tmeas * dble(UnitSc) !convert to secs

               call wedgest(freq,filter,wedgeamp,wedgelen,nvar,fx)

               sumcalc = sumcalc * 1.0d3 !remove scaling
               sumcalcp = sumcalcp * 1.0d3
               wedgeamp = wedgeamp * 1.0d3
               tcalc = tcalc / dble(UnitSc)
               wedgelen = wedgelen / dble(UnitSc)

               ttopout = tmid - wedgelen / 2.0d0
               tbotout = ttopout + wedgelen
 
c---- Output new horizon top, base and computed layer impedance

               tri(1) = sngl ( ttopout )
               tri(2) = sngl ( tbotout )
               tri(3) = sngl ( wedgelen )
               tri(4) = sngl ( wedgeamp )

            else
               
               do i = 1,4
                  tri(i) = 0.0
               enddo

            endif

            call vmov ( tri, 1, itr(ITHWP1), 1, nsampo )
            call wrtape ( luout, itr, obytes )

         ENDDO
      ENDDO

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'cithickness: Normal Termination'
      write(LER,*)'cithickness: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'cithickness: ABNORMAL Termination'
      write(LER,*)'cithickness: ABNORMAL Termination'
      stop
      end
