C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, fcorners, nvar, ampl1, 
     :     irs, ire, ns, ne, hard, c_TopHrz, c_BotHrz, verbos  )
c
c ampl1: initial wedge amplitude for nvar = 1
c fcorners[]: array of trapezoidal filter points
c nvar: number of variables [2]
c       note that nvar = 1 or 2 only.  If 1 then True Time Thickness. 
c       if 2 then True unfiltered amplitude of the layer.  If 1 then
c       use ampl1 as fixed layer amplitude to be used in modelling.  
c       If 2 then we can let the search start from a point determined 
c       by the input amplitude sums or we can let the search start 
c       from some user input value.
c ntap: input stream [stdin]
c otap: output stream [stdout]

      implicit NONE

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nvar, irs, ire, ns, ne

      real*8 fcorners(4), ampl1

      character ntap*(*), otap*(*)
      character c_TopHrz*6, c_BotHrz*6

      logical hard, verbos

c declare local variables
      
      integer argis

      real*8 rdef

c parse command line

c---- Initial wedge amplitude

      call argr8('-amp',ampl1,0.0d0,0.0d0)

c---- Filter corners

      rdef = -1.0d0
      call argr8('-f1',fcorners(1),rdef,rdef)
      call argr8('-f2',fcorners(2),rdef,rdef)
      call argr8('-f3',fcorners(3),rdef,rdef)
      call argr8('-f4',fcorners(4),rdef,rdef)

      hard = (argis('-hard') .gt. 0)
      call argstr('-hw1',c_TopHrz,' ',' ')
      call argstr('-hw2',c_BotHrz,' ',' ')

      call argi4('-irs', irs, 0, 0)
      call argi4('-ire', ire, 0, 0)

c---- Number of variables

      call argi4('-ne', ne, 0, 0)
      call argi4('-ns', ns, 0, 0)
      call argi4('-nv',nvar,2,2)

c---- Input

      call argstr('-N',ntap,' ',' ')

c---- Output

      call argstr('-O',otap,' ',' ')

c---- Printout verbosity flag

      verbos = (argis('-V') .gt. 0)

c---- Policemen

      if ( nvar.eq.1 .and. ampl1.eq.0.0d0 ) then

        write(LERR,*)'CITHICKNESS:'
        write(LERR,*)' Amplitude required for wedge thickness.'
        write(LERR,*)' Enter -amp[] on command line and try '
        write(LERR,*)' again.'
        write(LERR,*)'FATAL'

        write(LER,*)'CITHICKNESS:'
        write(LER,*)' Amplitude required for wedge thickness.'
        write(LER,*)' Enter -amp[] on command line and try '
        write(LER,*)' again.'
        write(LER,*)'FATAL'
        stop

      endif

      if ( nvar.lt.1 .or. nvar.gt.2 ) then

        write(LERR,*)'CITHICKNESS:'
        write(LERR,*)' Command line entry -nvar[] must be 1 or 2'
        write(LERR,*)'FATAL'
        write(LER,*)'CITHICKNESS:'
        write(LER,*)' Command line entry -nvar[] must be 1 or 2'
        write(LER,*)'FATAL'
        stop

      endif

      if ( ( fcorners(1) * fcorners(2) * fcorners(3) * fcorners(4) )
     :     .lt.0.0d0 ) then

        write(LERR,*)'CITHICKNESS:'
        write(LERR,*)' You must supply 4 filter corner frequencies'
        write(LERR,*)' -f1[], -f2[], -f3[], -f4[] on the command '
        write(LERR,*)' line and try again.'
        write(LERR,*)'FATAL'
        write(LER,*)'CITHICKNESS:'
        write(LER,*)' You must supply 4 filter corner frequencies'
        write(LER,*)' -f1[], -f2[], -f3[], -f4[] on the command '
        write(LER,*)' line and try again.'
        write(LER,*)'FATAL'
        stop

      endif

      return
      end
