C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dscald(x,lx,s)

c*******************************************************************************
c     This subroutine divides each element in an array, x by a divisor, s.
c     The length of array x is lx.
c
c     See Robinson, "Multichannel Time Series Analysis", page 19.
c
c**** Subroutine inputs.
c
c     x = The array of values of the dividend to be scaled.
c     n = The number of elements in array, x.
c     s = The divisor
c
c**** Subroutine outputs.
c
c     x = The array of values of the quotent after division.
c
c*******************************************************************************

      integer lx
      real*8 x(lx),s
      integer i

      do i = 1,lx

        x(i) = x(i) / s

      enddo

      return
      end
