C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dscalm(x,lx,s)

c*******************************************************************************
c     This subroutine multiplies each element in an array, x by a scale
c     factor s. The length of array x is lx.
c
c     See Robinson, "Multichannel Time Series Analysis", page 19.
c
c**** Subroutine inputs.
c
c     x = The array of values to be scaled.
c     n = The number of elements in array, x.
c     s = The scaling factor.
c
c**** Subroutine outputs.
c
c     x = The array of values of x after multiplication by s.
c
c***********************************************************************

      integer lx
      real*8 x(lx),s
      integer i

      do i = 1,lx

        x(i) = s * x(i)

      enddo

      return
      end
