C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dsmoth(ls,spect,itype)

c*******************************************************************************
c     This subroutine computes the spectral estimate by performing a
c     smoothing operation on the periodogram by the Hamming-Tukey formula.
c     the periodogram can be obtained from subroutine "dcostr".
c
c     see Robinson, "Multichannel Time Series Analysis", page 91.
c
c**** Subroutine inputs
c
c     ls = The length of the spectrum under investigation.
c     spect = The power spectrum under investigation.
c     itype = Type of smoothing
c             itype = 0 Hamming - Tukey Smoothing
c             itype = 1 Hanning Smoothing
c
c**** Subroutine outputs.
c
c     spect = The smoothed periodogram.
c
c*******************************************************************************

      integer ls,itype
      real*8 spect(ls),a,b,sj,sk,si
      integer mm,j

      real*8 coefs(2)

      if(itype.eq.0) then

        coefs(1) = 0.54d0
        coefs(2) = 0.46d0 / 2.0d0

      else

        coefs(1) = 0.5d0
        coefs(2) = 0.25d0

      endif

      mm = ls - 1
      a = coefs(1) * spect(1) + 2.0d0 * coefs(2) * spect(2)
      b = coefs(1) * spect(ls) + 2.0d0 * coefs(2) * spect(mm)
      sj = spect(1)
      sk = spect(2)

      do j = 2,mm

        si = sj
        sj = sk
        sk = spect(j + 1)
        spect(j) = coefs(1) * sj + coefs(2) * (si + sk)

      enddo

      spect(1) = a
      spect(ls) = b
      return
      end
