C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getamp ( tri, nsamp, TmMsFS, rTopHrz, rBotHrz, nsi, 
     :     hard, summeas, summeasp )

      implicit none

c declare variables passed from calling routine

      integer nsi, nsamp

      real tri(nsamp), rTopHrz, rBotHrz, TmMsFS

      real*8 summeas, summeasp

      logical hard

c declare local variables

      integer i, start_sample, end_sample

c initialize variables

      start_sample = nint ( ( rTopHrz - TmMsFS) / float(nsi) ) + 1
      end_sample = nint ( ( rBotHrz - TmMsFS) / float(nsi) ) + 1
      summeas = 0.0d0
      summeasp = 0.0d0

      IF ( .not. hard ) then
         
         do i = start_sample, end_sample
            
            summeas = summeas + dble ( tri(i) )

c sum negatives

            if ( tri(i) .lt. 0.0 ) 
     :           summeasp = summeasp + dble ( tri(i) )

         enddo


      ELSE

         do i = start_sample, end_sample
            
            summeas = summeas + dble ( tri(i) )

c sum positives

            if ( tri(i) .gt. 0.0 ) 
     :           summeasp = summeasp + dble ( tri(i) )

         enddo


      ENDIF

      return
      end
