C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getd(n,m,a,iact,nact,g,z,u,d,ztg,relacc,ddotg,meql,
     :mdeg,gm,space)

c-----
c     This subroutine calculates the components of the step length in the
c     search direction and during minimisation of a differentiable
c     function of several variables, subject to linear constraints on the
c     values of the variables.
c
c     See, Powell, M.J.D.,1989, "Tolmin: A Fortran Package for Linearly
c     Constrained Optimization Calculations" University of Cambridge,
c     Dept. of Applied Mathematics and Theoretical Physics report NA2.
c
c---- Subroutine inputs
c
c     n = The number of variables
c     m = The number of linear constraints (excluding simple bounds)
c     a = The n * m array of coefficients of equality constraints
c         such that  transpose[a] * [x] = [b]
c     relacc = The relative accuracy of the computation. It is determined
c              by the program to be close to the relative precision of
c              the computer arithmetic.
c
c---- Subroutine outputs
c
c     iact = The m + 2 * n vector of active constraints
c     nact = The final number of active constraints
c     g = The array of function gradients at X.
c     z = Working matrix such that z * z(transpose) = inverse of the
c         second derivatives of the active gradients.
c     u = The diagonal elements of the Goldfarb - Idnani upper triangular
c         factorization matrix.
c     d = The array of the components of the stepl length of the line
c         search in the directions with respect to X.
c     ztg = The vector obtained from z(transpose) * g
c     ddotg = Sum of residuals at constraint violations.
c     meql = The number of independent inequalities.
c     mdeg = The number of constraints with very small residuals that
c            are considered to be in the set of satisfied constraints.
c     gm = The array of residual gradient values after the active
c          constraints are adjusted with the Lagrange parameter.
c     space = working space of (4 * n) elements
c
c---- Subroutines Required
c
c     addcon
c     delcon
c     newcon
c     sdegen
c     sdirn
c     stepbd
c     ddot
c     dmmove
c     dzero
c
c-----

      integer n,m
      real*8 a(n * m),g(*),z(n * n),u(*),d(*),ztg(*),gm(n)
      real*8 space(4 * n)
      integer iact(*)
      real*8 relacc,ddotg
      integer nact,meql,mdeg,jm

      real*8 temp,ddotgm
      integer i,k,j,ik,ij,ipar

      ipar = n * 3

c-----
c    Initialise gm and cycle backwards through the active set.
c-----

   10 call dmmove(n,g,gm)
      k = nact

      do while (k.gt.0)

c-----
c     Set temp to be the next multiplier, but reduce the active set if
c     temp has an unacceptable sign
c-----

        ik = (k - 1) * n + 1
        call ddot(n,z(ik),gm,temp)
        temp = temp * u(k)

        if(k.gt.meql.and.temp.gt.0.0d0) then

          call delcon(n,m,a,iact,nact,z,u,relacc,k)
          goto 10

        endif

c-----
c     Update gm using the multiplier that has just been calculated
c-----

        j = iact(k)

        if(j.le.m) then

          ij = (j - 1) * n + 1

          do i = 1,n

            gm(i) = gm(i) - temp * a(ij)
            ij = ij + 1

          enddo

        else

          jm = j - m

          if(jm.le.n) then

            gm(jm) = gm(jm) + temp

            else

            gm(jm - n) = gm(jm - n) - temp

          endif

        endif

        space(ipar + k) = temp
        k = k - 1

      enddo

c-----
c     Calculate the search direction and ddotg
c-----

      ddotg = 0.0d0

      if(nact.lt.n) then

        call sdegen(n,m,a,iact,nact,space(ipar + 1),z,u,d,ztg,gm,relacc,
     :ddotgm,meql,mdeg,space)

        if(ddotgm.lt.0.0d0) call ddot(n,d,g,ddotg)

      endif

      return
      end
