C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine initzu(n,m,xl,xu,x,iact,meql,info,z,u,xbig,relacc)

c-----
c     This subroutine initialises the arrays z and u.  It determine the
c     parameter relacc, which is near to the relative precision of the
c     machine arithmetic and checks for inconsistency in the bounds.
c     It is used in the subroutine TOLMIN, which carries out minimisation
c     of a differentiable function of several variables, subject to linear
c     constraints on the values of the variables.
c
c     See, Powell, M.J.D.,1989, "Tolmin: A Fortran Package for Linearly
c     Constrained Optimization Calculations" University of Cambridge,
c     Dept. of Applied Mathematics and Theoretical Physics report NA2.
c
c---- Subroutine inputs
c
c     n = The number of variables
c     m = The number of linear constraints (excluding simple bounds)
c     xl = The vector of lower bounds on x
c     xu = The vector of upper bounds on x
c     x = The vector of variables to be minimised.
c
c---- Subroutine outputs
c
c     iact = The m + 2 * n vector of active constraints
c     meql = The number of independent inequalities.
c     info = Termination code.
c            info = 1  The final X is feasible and the solution satisfies
c                      the condition, acc.
c            info = 2  The final X is feasible and termination occurs
c                      because rounding errors seem to prevent higher
c                      accuracy.
c            info = 3  The final X is feasible and line search fails to
c                      find a better solution of the objective function,
c                      although it is predicted by the gradient vector.
c                      If the final rate of convergence is slow, the
c                      coding of the gradient should be suspected.
c            info = 4  The calculation cannot start because the bounds
c                      are inconsistent
c            info = 5  The error indicates that the equality constraints
c                      are inconsistent including freezing of variables
c                      by setting xl(i) = xu(i)
c            info = 6  The equality constraints and the bounds are
c                      incompatible.
c            info = 7  The bounds and equality constraints can be
c                      satisfied but the general inequality constraints
c                      cannot.
c            info = 8  The limit on the number of function calls has been
c                      reached.
c     space = workin space of (n * n + 14 * n + m) elements
c     z = Working matrix such that z * z(transpose) = inverse of the
c         second derivatives of the active gradients.
c     u = The diagonal elements of the Goldfarb - Idnani upper triangular
c         factorization matrix.
c     xbig = The array of largest absolute values of the variables.
c     relacc = The relative accuracy of the computation. It is determined
c              by the program to be close to the relative precision of
c              the computer arithmetic.
c
c---- Subroutines Required
c
c     dzero
c
c-----

      integer n
      real*8 xl(*),xu(*),x(*),z(n * n),u(*),xbig(*)
      real*8 relacc
      integer iact(*)
      integer m,meql,info

      real*8 ztpar,tempa,tempb
      integer i,jact,j,ij

c-----
c     Set relacc
c-----

      ztpar = 100.0d0
      relacc = 1.0d0
   10 relacc = 0.5d0 * relacc
      tempa = ztpar + 0.5d0 * relacc
      tempb = ztpar + relacc
      if(ztpar.lt.tempa.and.tempa.lt.tempb) goto 10

c-----
c     Seek bound inconsistencies and bound equality constraints
c-----

      meql = 0

      do i = 1,n

        if(xl(i).gt.xu(i)) return
        if(xl(i).eq.xu(i)) meql = meql + 1

      enddo

c-----
c     Initialise u, z, and xbig
c-----

      jact = 0

      do i = 1,n

        if(xl(i).eq.xu(i)) then

          x(i) = xu(i)
          jact = jact + 1
          u(jact) = 1.0d0
          iact(jact) = i + m + n
          j = jact

          else

          j = i + meql - jact

        endif

        ij = (j - 1) * n + 1
        call dzero(n,z(ij))
        ij = (j - 1) * n + i
        z(ij) = 1.0d0
        xbig(i) = dabs(x(i))

      enddo

      info = 1
      return
      end
