C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stepbd(n,m,a,iact,bres,d,stepcb,ddotg,mdeg,msat,mtot,
     :indxbd)

c-----
c     This subroutine calculates the step length of the line search and
c     the index of the constraint that determines the step size during
c     minimisation of a differentiable function of several variables,
c     subject to linear constraints on the values of the variables.
c
c     See, Powell, M.J.D.,1989, "Tolmin: A Fortran Package for Linearly
c     Constrained Optimization Calculations" University of Cambridge,
c     Dept. of Applied Mathematics and Theoretical Physics report NA2.
c
c---- Subroutine inputs
c
c     n = The number of variables
c     m = The number of linear constraints (excluding simple bounds)
c     a = The n * m array of coefficients of equality constraints
c         such that  transpose[a] * [x] = [b]
c
c---- Subroutine outputs
c
c     iact = The m + 2 * n vector of active constraints
c     bres = The array oc constraint residuals.
c     d = The array of the components of the stepl length of the line
c         search in the directions with respect to X.
c     stepcb = The step length of the line search
c     ddotg = Sum of residuals at constraint violations.
c     mdeg = The number of constraints with very small residuals that
c            are considered to be in the set of satisfied constraints.
c     msat = The number of satisfied constraints
c     mtot = The total number of constraints and bounds
c     indxbd = The index of the constraint that determines the search
c              step size.
c
c---- Subroutines Required
c
c     ddot
c
c-----

      integer n,m
      real*8 a(n * m),bres(*),d(*)
      real*8 stepcb,ddotg
      integer iact(*)
      integer mdeg,msat,mtot,indxbd

      real*8 sp,temp,xlogbres,xlogsp,big,bigex,small
      integer iflag,j,k,jm,kl,ij

      small = 1.0d-300
      big = 1.0d300
      bigex = dlog10(big)

c-----
c     Set steps to constraint boundaries and find the least positive one.
c-----
      
      iflag = 0
      stepcb = 0.0d0
      indxbd = 0
      k = mdeg
   10 k = k + 1

   20 if(k.le.mtot) then

c-----
c     Form the scalar product of D with the current constraint normal
c-----

        j = iact(k)

        if(j.le.m) then

          ij = (j - 1) * n + 1
          call ddot(n,d,a(ij),sp)

          else

          jm = j - m

          if(jm.le.n) then

            sp = -d(jm)

            else

            sp = d(jm - n)

          endif

        endif

c-----
c     The next branch is taken if label 20 was reached via label 40
c-----

        if(iflag.eq.1) goto 50

c-----
c     Set bres(j) to indicate the status of the j-th constraint

c-----

       temp = 0.0d0

       if(dabs(bres(j)).gt.small.and.dabs(sp).gt.small) then

          xlogbres = dlog10(dabs(bres(j)))
          xlogsp = dlog10(dabs(sp))
          temp = big
          temp = dsign(temp,bres(j))
          temp = dsign(temp,sp)

          if(bigex.gt.xlogbres + xlogsp) then

            temp = sp * bres(j)

          endif

        endif

        if(temp.le.0.0d0) then

          bres(j) = 0.0d0

          else
          
          if(bigex.le.xlogbres - xlogsp) then

            bres(j) = big
          
            else
            
            bres(j) = bres(j) / sp
            
          endif  

          if(stepcb.eq.0.0d0.or.bres(j).lt.stepcb) then

            stepcb = bres(j)
            indxbd = k

          endif

        endif

        goto 10

      endif

c-----
c     Try to pass through the boundary of a violated constraint.
c-----

   40 if(indxbd.gt.msat) then

        iflag = 1
        k = indxbd
        goto 20

        else

          return

        endif

   50 msat = msat + 1
      iact(indxbd) = iact(msat)
      iact(msat) = j
      bres(j) = 0.0d0
      indxbd = msat
      ddotg = ddotg - sp

      if(ddotg.lt.0.0d0.and.msat.lt.mtot) then

c-----
c     Seek the next constraint boundary along the search direction
c-----

        temp = 0.0d0
        kl = mdeg + 1

        do k = kl,mtot

          j = iact(k)

          if(bres(j).gt.0.0d0) then

            if(temp.eq.0.0d0.or.bres(j).lt.temp) then

              temp = bres(j)
              indxbd = k

            endif

          endif

        enddo

        if(temp.gt.0.0d0) then

          stepcb = temp
          goto 40

        endif

      endif

      return
      end
