C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      double precision function truewedge(wlen,freq,filter)

c-----
c     Function used to compute the objective function for
c     determining the width of a wedge
c
c     wlen = The true width of the of the wedge (secs)
c
c-----

      implicit none

      integer nfreq,iflag1
      real*8 summeas,summeasp,tmeas,ampl1
      real*8 sumcalc,sumcalcp,tcalc,dt

      common /wedgedata/summeas,summeasp,tmeas,sumcalc,sumcalcp,ampl1,
     :     tcalc,dt,iflag1,nfreq

      real*8 wlen,freq(nfreq),filter(nfreq)

      real*8 ampf0,sincs,dangle,fneg,zerol,zeroh,ampmax,wlenmin
      real*8 delta,polarity,aisign
      real*8 times,amps
      integer i,j,joffl,icountl,joffh,icounth,iabort,ioff,nsampmin

      integer jsz,ierr,ibytes,ierrt,nbytes,num_impulses 

      real*8 PI,PI2
      parameter (PI = 3.14159265358979323846d0, PI2 = 2.0d0 * PI)

      pointer (wktimes , times  (1))
      pointer (wkamps  , amps   (1))

      wlenmin = 1.0d-15   

      if(dabs(ampl1 * wlen).lt.wlenmin) then

        sumcalc = 0.0d0
        sumcalcp = 0.0d0
        tcalc = 0.0d0

      else

c---- Determine maximum number of impulses and allocate amplitude and times

        nsampmin = idint(1.0d0 / (freq(nfreq) * dt)) + 1
        num_impulses = idint(2.0d0 * dint(wlen / dt + 1.0d0) + 1)

        if((num_impulses - nsampmin).lt.4) 
     :     num_impulses = nsampmin * 4 + 1

c---- Allocate space for wavelets

        call sizefloat(jsz)
        jsz = 2 * jsz
        ierrt = 0
        ibytes = 0

        nbytes = num_impulses * jsz

        call galloc (wktimes, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes
        call galloc (wkamps, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes

c---- Fill times vector

        ioff = num_impulses / 2 + 1
        times(ioff) = 0.0d0

        do i = 1,num_impulses / 2

          times(ioff - i) = times(ioff - i + 1) - dt
          times(ioff + i) = times(ioff + i - 1) + dt

        enddo

c---- Filter the current wedge

        call dzero(num_impulses, amps)

        ampf0 = ampl1 * wlen ! Sinc amplitude at Freq = 0, Bracewell Page 136

        do i = 1,nfreq

          if(freq(i).gt.0.0d0) then   ! Account for negative frequencies

            fneg = 2.0d0

          else

            fneg = 1.0d0

          endif

          dangle = PI * wlen * freq(i)

          if(dangle.gt.0.0d0) then  ! Calculate sinc amplitude at freq(i)

            sincs = dsin(dangle) / dangle

          else

            sincs = 1.0d0

          endif 

          sincs = fneg * sincs * filter(i) * ampf0 ! filtered sinc at freq(i)     

c---- Reverse discrete Fourier Transform - sinc is zero phase, real only

          do j = 1,num_impulses

            dangle = PI2 * freq(i) * times(j)
            amps(j) = amps(j) + sincs * dcos(dangle)

          enddo
 
        enddo

c---- Find the zero crossings of the filtered wedge

        polarity = dsign(1.0d0,ampf0)

        icountl = 0                      ! lower side
        ampmax = 0.0d0

        do j = num_impulses / 2 + 1,1,-1

          aisign = amps(j) * polarity

          if(aisign.gt.ampmax) then

            ampmax = aisign
            icountl = j

          endif

        enddo

        joffl = -1

        do j = icountl,1,-1

          if(icountl.gt.0.and.(amps(j) * polarity).le.0.0d0
     :                   .and.joffl.lt.0) joffl = j + 1

        enddo

        zerol = amps(joffl) / (amps(joffl) - amps(joffl - 1))

        icounth = 0                      ! higher side
        ampmax = 0.0d0

        do j = num_impulses / 2 + 1,num_impulses

          aisign = amps(j) * polarity

          if(aisign.gt.ampmax) then

            ampmax = aisign
            icounth = j

          endif

        enddo

        joffh = -1

        do j = icounth,num_impulses

          if(icounth.gt.0.and.(amps(j) * polarity).le.0.0d0
     :                   .and.joffh.lt.0) joffh = j - 1

        enddo

        zeroh = amps(joffh) / (amps(joffh) - amps(joffh + 1))

        tcalc = (dble(joffh - joffl) + zerol + zeroh) * dt

c---- Calculate Area under the Curve

        sumcalc = 0.0d0
        sumcalcp = 0.0d0

        do j = joffl,joffh

          sumcalc = sumcalc + amps(j)
          if((amps(j) * polarity).gt.0.0d0) 
     :      sumcalcp = sumcalcp + amps(j)

        enddo

        call gfree(wktimes)
        call gfree(wkamps)

      endif

c---- Calculate the estimated meaured length and amplitude sums

      truewedge = 0.0d0

      delta = (sumcalc - summeas) / summeas
      truewedge = truewedge + delta

      delta = (sumcalcp - summeasp) / summeasp
      truewedge = truewedge + delta

      delta = 10.0d0 * (tcalc - tmeas) / tmeas
      truewedge = truewedge + delta

      return
      end
