C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wedgest(freq,filter,wedgeamp,wedgelen,nvar,fx)

c-----
c     Subroutine used to compute characteristics of a wedge from a
c     measured width and sum of amplitudes
c
c---- Subroutine Inputs
c
c     summeas        Sum of the measured ampliudes
c     summeasp       Sum of the positive amplitudes only
c     tmeas          Time (secs) of the measured wedge
c     dt             Sample interval (secs) of the trace
c
c---- Subroutine Outputs
c
c     wedgeamp         Amplitude of the wedge
c     wedgelen         Length of the wedge
c     sumcalcpout      Sum of the estimated wedge positive amplitudes only
c     tcalcout         Time (ms) of the estimated wedge
c
c     x(1) = The length (between zero crossing) of the wedge (secs)
c     x(2) = amplitude of the wedge
c
c-----

      implicit none

      integer nfreq,iflag1,nvar
      real*8 summeas,summeasp,tmeas,ampl1
      real*8 sumcalc,sumcalcp,tcalc,dt

      common /wedgedata/summeas,summeasp,tmeas,sumcalc,sumcalcp,ampl1,
     :     tcalc, dt,iflag1,nfreq

      real*8 freq(nfreq),filter(nfreq)
      real*8 wedgeamp,wedgelen

      real*8 x,g,h,a,b,par,space
      integer iact

      real*8 acc,fx,xin1,xin2
      real*8 wedgestfun,truewedge
      external wedgestfun,wedgestgrad,truewedge

      integer itype,info,nact,iprint,ilim,ierr,itrial

      integer jsz,iabort,ibytes,ierrt,nbytes

      pointer (wkx , x (1))
      pointer (wkg , g (1))
      pointer (wkh , h (1))
      pointer (wka , a (1))
      pointer (wkb , b (1))
      pointer (wkpar , par (1))
      pointer (wkspace , space (1))
      pointer (wkiact , iact (1))

      if(nvar.eq.1) then              ! Find zeros of objective function

        acc = 1.0d-9                  ! Solution tolerance
        ilim = 200                    ! Maximum Function calls
        xin1 = 0.0d0                  ! Initial low case
        xin2 = tmeas * 1.5d0          ! Initial High case
        wedgeamp = ampl1              ! Wedge amplitude

        call dilalg(xin1,xin2,truewedge,wedgelen,acc,ilim,itrial,ierr,
     :              freq,filter)

        fx = truewedge(wedgelen,freq,filter)

      else if(nvar.eq.2) then         ! Optimisation

c---- Allocate space for wavelets

        call sizefloat(jsz)
        jsz = 2 * jsz
        ierrt = 0
        ibytes = 0

        nbytes = nvar * jsz

        call galloc (wkx, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes
        call galloc (wkg, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes
        call galloc (wkh, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes
        call galloc (wkpar, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes

        nbytes = 1 * jsz
        call galloc (wka, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes
        call galloc (wkb, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes

        nbytes = (nvar * nvar + 16 * nvar) * jsz

        call galloc (wkspace, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes

        nbytes = (nvar * 2) * jsz / 2
        call galloc (wkiact, nbytes, ierr, iabort)
        ierrt = ierrt + ierr
        ibytes = ibytes + nbytes

        if(ierrt.eq.0) then

          info = 200                    ! Max calls in / return code out
          iprint = 0                    ! print flag
          acc = 1.0d-6                  ! Solution tolerance
          itype = -1                    ! Minimisatiom

          if(iflag1.ne.0) then          ! Initial amplitude defined

            ilim = 200
            xin1 = 0.0d0
            xin2 = tmeas * 1.5d0
            wedgeamp = ampl1              ! Wedge amplitude
            call dilalg(xin1,xin2,truewedge,wedgelen,acc,
     :                  ilim,itrial,ierr,freq,filter)

            x(1) = wedgelen 
            x(2) = ampl1

          else                          ! Initial amplitude estimated

            x(1) = tmeas                ! Initial length estimate
            x(2) = 2.0d0 * (2.0d0 * summeasp - summeas) / freq(nfreq) 

          endif

          g(1) = dt / 4.0d0             ! Lower limit of wedge length
          g(2) = -1.0d300               ! Lower limit of amplitude
          h(1) = tmeas * 1.5d0          ! Upper limit of wedge length
          h(2) = 1.0d300                ! Upper limit of amplitude

          call tolmin(nvar,0,0,a,b,g,h,x,wedgestfun,wedgestgrad,
     :                itype,acc,iact,nact,par,iprint,info,space,
     :                fx,freq,filter)

c---- Prepare for exit

          fx = wedgestfun(nvar,x,freq,filter)

          wedgelen = x(1)
          wedgeamp = x(2)

        endif

        call gfree(wkx)
        call gfree(wkg)
        call gfree(wkh)
        call gfree(wka)
        call gfree(wkb)
        call gfree(wkpar)
        call gfree(wkspace)
        call gfree(wkiact)

      endif

      return
      end
