C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wedgestgrad(nvar,x,grad,freq,filter)

c-----
c     Subroutine used to compute the gradient of the objective function for
c     determining the characteristics of a wedge
c
c     x(1) = amplitude of the wedge
c     x(2) = The length (between zero crossing) of the wedge (secs)
c-----

      implicit none

      integer nvar,nfreq,iflag1
      real*8 summeas,summeasp,tmeas,ampl1
      real*8 sumcalc,sumcalcp,tcalc,dt

      common /wedgedata/summeas,summeasp,tmeas,sumcalc,sumcalcp,ampl1,
     :     tcalc,dt,iflag1,nfreq

      real*8 x(nvar),grad(nvar),freq(nfreq),filter(nfreq)
      real*8 xtemp,funvals,xstep

      pointer (wkxtemp  , xtemp  (1))
      pointer (wkfunvals, funvals(1))
      pointer (wkxstep  , xstep  (1))

      real*8 h,wedgestfun
      integer i,j,ierr, nsteps
      integer jsz,iabort,ibytes,ierrt,nbytes

      nsteps = 2

c---- Allocate space for wavelets

      call sizefloat(jsz)
      jsz = 2 * jsz
      ierrt = 0
      ibytes = 0

      nbytes = nvar * jsz
      call galloc (wkxtemp, nbytes, ierr, iabort)
      ierrt = ierrt + ierr
      ibytes = ibytes + nbytes

      nbytes = nsteps * jsz
      call galloc (wkfunvals, nbytes, ierr, iabort)
      ierrt = ierrt + ierr
      ibytes = ibytes + nbytes

      call galloc (wkxstep, nbytes, ierr, iabort)
      ierrt = ierrt + ierr
      ibytes = ibytes + nbytes

      call dzero(nvar, grad) 

      h = 1.0d-6
      xstep(1) = -h
      xstep(2) = h
      h = 2.0d0 * h

      do i = 1,nvar

        do j = 1, nsteps

          call dmmove(nvar,x,xtemp)
          xtemp(i) = xtemp(i) + xstep(j) * x(i)
          funvals(j) = wedgestfun(nvar,xtemp,freq,filter)

        enddo

        grad(i) = (funvals(2) - funvals(1)) / (h * x(i))
      
      enddo

      call gfree(wkxtemp)
      call gfree(wkfunvals)
      call gfree(wkxstep)

      return
      end
