C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine clusdel(iclustasgloc, iclustasg, ncenters, centers,
     1                   nclust, nparm, mparm, nvect, vect, iflag,
     2                   range, sdelthresl, sdelthresu, 
     3                   sdelini, index, ler, lerr, verbos)

      implicit none

c-----------------------------------------------------------------------
c Bertram Kaufhold 	07/01/98	
c
c Suproutine which modifies clusters (removal of vectors within clusters,
c removal of clusters, repositioning of cluster centers and combinations
c of the above).
c
c iclustasgloc 	=>      iclustasgloc(i) is the location of the vector 
c                       that corresponds to the i-th cluster assignment
c                       given by iclustasg(i)
c iclustasg 	=>      iclustasg(i) is cluster assignment for i-th 
c			feature vector contained in vect
c ncenters	=>      ncenters(i) is number of members contained in
c                       i-th cluster
c centers	=>      cluster centers 
c nclust 	=> 	Desired number of clusters
c nparm         =>  	Number of complex parameters per feature vector
c mparm		=>      Array dimension size in calling program for 
c                       vect and centers...mparm >= nparm
c nvect		=>      Number of feature vectors to be clustered
c vect		=>      Array containing feature vectors to be clustered
c iflag		=>	integer parameter that indicates wether the 
c			algorithm has converged or not
c iflag = 0		no vectors/clusters were reassigned
c iflag = #	        vectors/clusters were reassigned
c range		=>	integer parameter that selects which clusters  
c                       are modified (if they fall within the modification
c                       threshold specified by sdelthresl and sdelthresu).
c range = 0		do not modify any clusters
c range = 1	        cluster centers with less than or equal to
c 			sdelthresl members are modified according to the 
c			method specified by sdelini 	
c range = 2	        cluster centers with more than sdelthresl and less
c                       than sdelthresu members are modified according to  
c			the method specified by sdelini 	
c range = 3	        cluster centers with more than or equal to
c 			sdelthresu members are modified according to the 
c			method specified by sdelini 	
c sdelthresl	=> 	integer parameter which selects lower 
c                       modification threshold. 
c sdelthresu	=> 	integer parameter which selects upper 
c                       modification threshold.  
c sdelini	=>	integer parameter which selects modification 
c			method used in subroutine clusdel
c sdelini=1		deletes all vectors in clusters which fall within 
c                       boundary specification made by range			
c sdelini=2		deletes all vectors in clusters and cluster centers 
c			themselfes which fall within boundary specification
c                       made by range
c sdelini=3		deletes cluster centers which  fall within boundary
c			specifation made by range, reduces # of cluster
c sdelini=4		relocate clusters which fall in boundary specification
c			made by range
c index         =>      dummy array
c ler		=>	standard error
c lerr		=>	usp log file
c verbos		flag which determines if additional printout
c                       is desired for standard error (ler) and usp
c                       log file (lerr)
c-----------------------------------------------------------------------


      integer nclust, nparm, mparm, nvect, iflag
      integer range, sdelthresl, sdelthresu, sdelini
      integer index(nclust), ler, lerr
      integer iclustasgloc(nvect), iclustasg(nvect), ncenters(nclust)
      complex vect(mparm, nvect), centers(mparm, nclust)
      logical verbos

      integer i, j, k, z, ndel, seeddel, rr
      integer maxnummem, maxnummemindex
      real    vr, vtotr, ranval, multiplier, dmin, d
      real*4  dist
            
      call timstr(vr,vtotr)
      iflag = 0 
      seeddel = vr 
      if (range .eq. 0) return

c-----------------------------------------------------------------------
c Check if there is at least one cluster that has an amount of members 
c which lies within the boundaries specified by range (in connection
c with sdelthresl and sdelthresu, respectively).
c Otherwise don't do anything! 

         do j=1, nclust
            if  (((range .eq. 1) .and. (ncenters(j) .gt. sdelthresl)) 
     1      .or. ((range .eq. 2) .and. ((ncenters(j) .le. sdelthresl)
     2                           .or.  (ncenters(j) .ge. sdelthresu)))
     3      .or. ((range .eq. 3) .and. (ncenters(j) .lt. sdelthresu)))
     4      iflag = iflag + 1 
         enddo
         if ((iflag .eq. 0) .and. (range .eq. 1)) then
            write(ler,'(a)')
     1     'CLUST3DM: Member # in all clusters is <= than -sdelthresl'
            write(lerr,'(a)')
     1     'CLUST3DM: Member # in all clusters is <= than -sdelthresl'
         elseif ((iflag .eq. 0) .and. (range .eq. 2)) then
            write(ler,'(a)')
     1      'CLUST3DM: Member # in all clusters is > than -sdelthresl an 
     2d < than -sdelthresu '
            write(lerr,'(a)')
     1      'CLUST3DM: Member # in all clusters is > than -sdelthresl an 
     2d < than -sdelthresu '
         elseif ((iflag .eq. 0) .and. (range .eq. 3)) then
            write(ler,'(a)')
     1     'CLUST3DM: Member # in all clusters is >= than -sdelthresu'
            write(lerr,'(a)')
     1     'CLUST3DM: Member # in all clusters is >= than -sdelthresu'
         endif
         if (iflag .eq. 0) then
            if (sdelini .eq. 1) then
               write(ler,'(a)')
     1         'CLUST3DM: No vectors will be deleted!!! '
               write(lerr,'(a)')
     1         'CLUST3DM: No vectors will be deleted!!! '
               return
            elseif (sdelini .eq. 2) then
               write(ler,'(a)')
     1         'CLUST3DM: No vectors nor clusters will be deleted!!!'
               write(lerr,'(a)')
     1         'CLUST3DM: No vectors nor clusters will be deleted!!!'
               return               
            elseif (sdelini .eq. 3) then
               write(ler,'(a)')
     1         'CLUST3DM: No clusters will be deleted!!! '
               write(lerr,'(a)')
     1         'CLUST3DM: No clusters will be deleted!!! '
               return
            elseif (sdelini .eq. 4) then
               write(ler,'(a)')
     1         'CLUST3DM: No cluster centers will be moved!!! '
               write(lerr,'(a)')
     1         'CLUST3DM: No cluster centers  will be moved!!! '
               return
            endif
         else 
            iflag = 0
         endif
         
c-----------------------------------------------------------------------
c Delete vectors in clusters whose amount of members lies within the 
c boundaries specified by range (in connection with sdelthresl and
c sdelthres u, respectively).  Note that this changes the array vect!

      if (sdelini .eq. 1) then

         do j=1, nclust

c Remove vectors

            if  (((range .eq. 1) .and. (ncenters(j) .le. sdelthresl)) 
     1      .or. ((range .eq. 2) .and. (ncenters(j) .gt. sdelthresl)
     2                           .and. (ncenters(j) .lt. sdelthresu))
     3      .or. ((range .eq. 3) .and. (ncenters(j) .ge. sdelthresu)))
     4      then

               write(ler,'(a,i3,a)')
     1         'CLUST3DM: Please wait...members from cluster ',j,
     2         ' are being deleted'
               i = 1
               ndel = 0
               rr = 1
               
c Look at i-th vector and check its cluster assignment

               do while (i .le. nvect) 

c Delete members of this cluster

                  if (iclustasg(i) .eq. j) then 
                     if (verbos) then
                        write(ler,'(a,i7,a,i3)')
     1                  'CLUST3DM: Deleting vector '
     2                  , rr,' belonging to cluster ', j
                        rr= rr + 1
                     endif
                     do z=i,nvect
                        do k=1, nparm
                           vect(k,z) = vect(k,z+1) 
                        end do
                        iclustasg(z) = iclustasg(z+1)
                        iclustasgloc(z) = iclustasgloc(z+1)
                     end do

c Decrease vector count

                     nvect = nvect - 1  
                     ndel = ndel + 1
                     i=i-1
                  endif
                  i = i + 1    
               end do 
               write(ler,'(a,i7,a,i3)') 'CLUST3DM: Deleted ', ndel,
     1         ' vectors belonging to cluster ', j
               write(lerr,'(a,i7,a,i3)') 'CLUST3DM: Deleted ', ndel,
     1         ' vectors belonging to cluster ', j
               iflag = iflag + 1   
            endif        
         enddo 

c Move cluster center that corresponds to the just deleted clusters
c to new cluster center location. Select as new cluster center that 
c center which corresponds to the cluster having currently the most 
c members and being not within the boundaries defined by range, 
c sdelthresl and sdelthresu, respectively. Make the new cluster
c center location random around the new selected cluster center,
c i.e. introduce a small perturbation. This prevents that for the
c case when more than one cluster exist that has to be deleted we do
c not assign them all to an identical new cluster center

         maxnummem=0  
         do j=1, nclust     
            if ((ncenters(j) .gt. maxnummem) .and. 
     1          (((range .eq. 1) .and. (ncenters(j) .gt. sdelthresl)) 
     2      .or. ((range .eq. 2) .and. ((ncenters(j) .le. sdelthresl)
     3                           .or.  (ncenters(j) .ge. sdelthresu)))
     4      .or. ((range .eq. 3) .and. (ncenters(j) .lt. sdelthresu))))
     5      then
               maxnummem = ncenters(j)
               maxnummemindex = j 
            endif
         enddo        

         do j=1, nclust

            if  (((range .eq. 1) .and. (ncenters(j) .le. sdelthresl)) 
     1      .or. ((range .eq. 2) .and. (ncenters(j) .gt. sdelthresl)
     2                           .and. (ncenters(j) .lt. sdelthresu))
     3      .or. ((range .eq. 3) .and. (ncenters(j) .ge. sdelthresu)))
     4      then

               call random(seeddel,ranval)
               multiplier = 0.95 + 0.1 * ranval 

               do i=1, nparm  
                  centers(i,j) = centers(i,maxnummemindex) * multiplier 
               end do
               write(ler,'(a,i3,a,i5,a)')
     1         'CLUST3DM: Relocating cluster center ', j,
     2         ' close to cluster center ', maxnummemindex,' location'
               write(lerr,'(a,i3,a,i5,a)')
     1         'CLUST3DM: Relocating cluster center ', j,
     2         ' close to cluster center ', maxnummemindex,' location'
            end if
         enddo

c-----------------------------------------------------------------------
c Delete vectors in clusters whose amount of members lies within the 
c boundaries specified by range (in connection with sdelthresl and
c sdelthres u, respectively). Also reduce the number of clusters used.
c Note that this changes the array vect!

      elseif (sdelini .eq. 2) then

         do j=1, nclust

c Delete vectors first

            if  (((range .eq. 1) .and. (ncenters(j) .le. sdelthresl)) 
     1      .or. ((range .eq. 2) .and. (ncenters(j) .gt. sdelthresl)
     2                           .and. (ncenters(j) .lt. sdelthresu))
     3      .or. ((range .eq. 3) .and. (ncenters(j) .ge. sdelthresu)))
     4      then

               write(ler,'(a,i3,a)')
     1         'CLUST3DM: Please wait...members from cluster ',j,
     2         ' are being deleted'
               i = 1
               ndel = 0
               rr = 1
               
c Look at i-th vector and check its cluster assignment

               do while (i .le. nvect) 

c Delete members of this cluster

                  if (iclustasg(i) .eq. j) then 
                     if (verbos) then
                        write(ler,'(a,i7,a,i3)')
     1                  'CLUST3DM: Deleting vector '
     2                  , rr,' belonging to cluster ', j
                        rr= rr + 1
                     endif
                     do z=i,nvect
                        do k=1, nparm
                           vect(k,z) = vect(k,z+1) 
                        end do
                        iclustasg(z) = iclustasg(z+1)
                        iclustasgloc(z) = iclustasgloc(z+1)
                     end do

c Decrease vector count

                     nvect = nvect - 1  
                     ndel = ndel + 1
                     i=i-1
                  endif
                  i = i + 1    
               end do 
               write(ler,'(a,i7,a,i3)') 'CLUST3DM: Deleted ', ndel,
     1         ' vectors belonging to cluster ', j
               write(lerr,'(a,i7,a,i3)') 'CLUST3DM: Deleted ', ndel,
     1         ' vectors belonging to cluster ', j  
            endif  
         enddo 

         j=1
         do while (j .le. nclust)        

c Delete this cluster

            if  (((range .eq. 1).and.(ncenters(j+iflag).le.sdelthresl)) 
     1      .or. ((range .eq. 2).and.(ncenters(j+iflag).gt.sdelthresl)
     2                          .and.(ncenters(j+iflag).lt.sdelthresu))
     3      .or. ((range .eq. 3).and.(ncenters(j+iflag).ge.sdelthresu)))
     4      then

               do z=j,nclust
                  do k=1, nparm
                     centers(k,z) = centers(k,z + 1)  
                  end do
               end do

c Adjust the cluster numbering. Deleted clusters will be assigned
c to zero.  

               do i=1, nvect
                  if (iclustasg(i) .gt. j) then 
                     iclustasg(i) = iclustasg(i) - 1
                  elseif (iclustasg(i) .eq. j)  then 
                     iclustasg(i) = 0
                  endif
               enddo 

c Decrease cluster count

               nclust = nclust - 1 
               write(ler,'(a,i3,a,i5)') 
     1         'CLUST3DM: Deleted cluster location',j+iflag,
     2         ' with population ',ncenters(j+iflag)
               write(lerr,'(a,i3,a,i5)')
     1         'CLUST3DM: Deleted cluster location',j+iflag,
     2         ' with population ',ncenters(j+iflag) 
               iflag = iflag + 1
               j = j - 1
            end if

c Look at the next cluster

            j = j + 1
            
         end do

c-----------------------------------------------------------------------
c Reduce the number of clusters but do not remove any vectors.
c nclust is reduced by one for each cluster with low population.
c Those cluster centers are deleted from the centers array.

      elseif (sdelini .eq. 3) then 

         j = 1
         do while (j .le. nclust)        

c Delete this cluster

            if  (((range .eq. 1).and.(ncenters(j+iflag).le.sdelthresl)) 
     1      .or. ((range .eq. 2).and.(ncenters(j+iflag).gt.sdelthresl)
     2                          .and.(ncenters(j+iflag).lt.sdelthresu))
     3      .or. ((range .eq. 3).and.(ncenters(j+iflag).ge.sdelthresu)))
     4      then

               do z=j,nclust
                  do k=1, nparm
                     centers(k,z) = centers(k,z + 1)  
                  end do
               end do

c Adjust the cluster numbering. Deleted clusters will be assigned
c to zero.  

               do i=1, nvect
                  if (iclustasg(i) .gt. j) then 
                     iclustasg(i) = iclustasg(i) - 1
                  elseif (iclustasg(i) .eq. j)  then 
                     iclustasg(i) = 0
                  endif
               enddo 

c Decrease cluster count

               nclust = nclust - 1 
               write(ler,'(a,i3,a,i5)') 
     1         'CLUST3DM: Deleted cluster location',j+iflag,
     2         ' with population ',ncenters(j+iflag)
               write(lerr,'(a,i3,a,i5)')
     1         'CLUST3DM: Deleted cluster location',j+iflag,
     2         ' with population ',ncenters(j+iflag) 
               iflag = iflag + 1
               j = j - 1
            end if

c Look at the next cluster

            j = j + 1
            
         end do

c-----------------------------------------------------------------------
c Do not remove vectors or clusters, but pick new location for clusters
c with low population. The ad-hoc algorithm is to move the cluster center
c to be "near" a vector in an adequately (outside boundaries specified by
c range, sdelthresl and sdelthresu, respectively) populated cluster.
c This results in temporarily splitting the bigger cluster. The cluster
c whose cluster center is closest to the cluster center we want to move
c is selected!

      else  

c Move cluster center to new cluster location, approximately not exactly
c though. Make the new cluster location random around the new selected
c cluster center, i.e. introduce a small perturbation. This prevents that
c for the case when more than one cluster exist that has to be relocated
c we do not assign them all to an identical new cluster center.

         do j=1, nclust

            index(j) = j

            if  (((range .eq. 1) .and. (ncenters(j) .le. sdelthresl)) 
     1      .or. ((range .eq. 2) .and. (ncenters(j) .gt. sdelthresl)
     2                           .and. (ncenters(j) .lt. sdelthresu))
     3      .or. ((range .eq. 3) .and. (ncenters(j) .ge. sdelthresu)))
     4      then

c For each cluster center that falls within the boundaries specified
c by range, sdelthresl and sdelthresu, respectively, determine which
c other cluster center is the closest in the Euclidean sense. Then
c check if this closest cluster center does not fall in the above 
c mentioned boundaries and if it does not write the result (index)
c into vector index

               dmin=1.0e25  
               do i=1, nclust
                  d=dist(centers(1,i),centers(1,j),nparm)     
              if ((d .lt. dmin) .and. (j .ne. i) .and. 
     1           (((range .eq. 1) .and. (ncenters(i) .gt. sdelthresl)) 
     2       .or. ((range .eq. 2) .and. ((ncenters(i) .le. sdelthresl)
     3                            .or.  (ncenters(i) .ge. sdelthresu)))
     4       .or. ((range .eq. 3) .and. (ncenters(i) .lt. sdelthresu))))
     5            then
                     dmin = d
                     index(j) = i
                  end if
               enddo           
            end if
         enddo

         do j= 1, nclust

            if  (((range .eq. 1) .and. (ncenters(j) .le. sdelthresl)) 
     1      .or. ((range .eq. 2) .and. (ncenters(j) .gt. sdelthresl)
     2                           .and. (ncenters(j) .lt. sdelthresu))
     3      .or. ((range .eq. 3) .and. (ncenters(j) .ge. sdelthresu)))
     4      then

               call random(seeddel,ranval)
               multiplier = 0.95 + 0.1 * ranval

               do i=1, nparm  
                  centers(i,j) = centers(i,index(j)) * multiplier 
               end do

               write(ler,'(a,i3,a,i5,a)')
     1         'CLUST3DM: Relocating cluster center ', j,
     2         ' close to cluster center ', index(j),' location'
               write(lerr,'(a,i3,a,i5,a)')
     1         'CLUST3DM: Relocating cluster center ', j,
     2         ' close to cluster center ', index(j),' location'
               iflag = iflag + 1

            endif
         enddo
      endif
      
      return
      end




