C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine clustinit(nvect, nparm, mparm, vect, centers, nclust, 
     1                     sclustini, iclustasg, seed, ler, lerr)

      implicit none

c-----------------------------------------------------------------------
c Bertram Kaufhold 	07/01/98	
c
c This routine initializes nclust cluster centers according to the method
c specified by the input parameter sclustini.
c
c sclustini=1	=> 	The first nclust vectors from array vect are used
c                       as the initial cluster centers
c sclustini=2 	=>     	nclust vectors are randomly selected from the 
c                       array vect and used as the initial cluster centers
c sclustini=3	=>      The one-pass "farthest neighbor" method is used
c                       to find initial cluster centers, as follows:
c                     * cluster 1 => the 1st column vector from array vect
c                     * cluster 2 => the column vector from array vect 
c                                    furthest from cluster 1
c                     * cluster 3 => the column vector which is furthest
c                                    from cluster 1 or cluster 2, i.e., 
c                                    it might be a vector which is close
c                                    to one of them!
c                     * procedure repeated until nclust centers found.
c sclustini=4	=>	The "maxmin" distance method is used 
c                       (see Tou & Gonzales; Pattern recognition Principles)
c nvect		=>      number of feature vectors 
c nparm         =>  	Number of complex parameters per feature vector
c vect		=>      Array containing feature vectors to be clustered
c centers	=>      cluster centers 
c nclust 	=> 	Desired number of clusters
c iclustasg     =>      used here as a scratch array
c seed		=>	positive integer seed for random generator
c                       used when sclustini=2 is selected
c ler		=>	standard error
c lerr		=>	usp log file
c-----------------------------------------------------------------------
      
      integer nclust, nparm, mparm, nvect, sclustini, seed, ler, lerr 
      integer iclustasg(nvect)        
      complex vect(mparm,nvect),
     1        centers(mparm,nclust)
      
      integer i, ic, iv, ii, itemp, j, k, kmaxd, kmind
      real ranval, d, dmaxd, dmind
      real*4 dist
      
c-----------------------------------------------------------------------
c initially assign the ith column vector (feature vector) to the ith 
c cluster center, independently of the desired number of clusters given
c by nclust

      do i=1, nvect 
         iclustasg(i) = i
      enddo
 
c-----------------------------------------------------------------------
c if sclustine = 2 pick randomly selected column vector from vect as
c initial cluster centers

      if (sclustini .eq. 2) then 
          ic = 0 
          do i=1, nclust
10           iv = 0
             do while (iv .lt. 1 .or. iv .gt. nvect)
                call random(seed,ranval)
                iv = int(ranval*nvect)+1
             enddo
             
c-----------------------------------------------------------------------
c check if the cluster center already has been used or not

             do ii=1, ic 
                if (iv .eq. iclustasg(ii)) goto 10
             enddo              
             ic = ic + 1 
             iclustasg(ic) = iv 
         enddo          

      else if (sclustini .eq. 3) then 

c-----------------------------------------------------------------------
c iteratively find vector farthest from current cluster centers and 
c make it the new center
      
c ic represents the number of centers found so far (first column vector
c of array vect is assigned as first cluster center)

          ic = 1 

c find ith cluster center

          do i=2, nclust 
              dmaxd = 0
              kmaxd = 0

c cycle through existing cluster centers

              do j=1, ic 
              
c cycle through unassigned vectors

                 do  k=ic+1, nvect 
                    d = dist(vect(1,iclustasg(k)),vect(1,iclustasg(j)),
     1                       nparm)

c find vector furthest from current cluster

                    if (d .gt. dmaxd) then 
                       dmaxd = d
                       kmaxd = k
                    end if
                 enddo
              enddo
              itemp = iclustasg(ic+1)
              iclustasg(ic+1) = iclustasg(kmaxd)
              iclustasg(kmaxd) = itemp
              ic = ic + 1                       
           enddo


      else if (sclustini .eq. 4) then 
      
c-----------------------------------------------------------------------
c maxmin-cluster method implements the maxmin-distance algorithm as 
c described in Tou & Gonzales (Pattern Recognition Principles, page92)       

c ic represents the number of centers found so far (first column vector
c of array vect is assigned as first cluster center)

          ic = 1

c find ith cluster center

          do i=2, nclust
             dmaxd = -1
             kmaxd = 0

c cycle through unassigned vectors

             do k=ic+1, nvect 
                dmind=1.0e29  
                kmind=0    

c cycle through existing cluster centers

                do j=1, ic
                   d = dist(vect(1,iclustasg(k)),vect(1,iclustasg(j)),
     1                nparm)

c for the second cluster center pick the one that has the largest 
c distance from the first cluster center

                   if (i.eq.2) then
                      if (d.gt.dmaxd) then
                         dmaxd = d
                         kmaxd = k
                      endif

c for the other cluster centers pick the one that has the maximum
c minimum distance from all existing cluster center

                   else 
                      if (d .lt. dmind) then 
                         dmind = d
                         kmind = k
                      end if
                   end if
                enddo
                if (dmind .gt. dmaxd .and. i .ne. 2) then    

c save maxmin distance and corresponding vector

                   dmaxd=dmind 
                   kmaxd=kmind 
                endif
             enddo
      write(ler,'(a60, i2, a3, E10.3)')
     1'CLUST3DM: Squared maximum-minimum distance to cluster center',i,
     2': ',dmaxd
      write(lerr,'(a60, i2, a3, E10.3)')
     1'CLUST3DM: Squared maximum-minimum distance to cluster center',i,
     2': ',dmaxd
             itemp = iclustasg(ic+1)
             iclustasg(ic+1) = iclustasg(kmaxd)
             iclustasg(kmaxd) = itemp
             ic = ic + 1                       
          enddo

      endif

c  now copy cluster center values into the centers array 
     
      do j=1, nclust
         do i=1, nparm
            centers(i,j) = vect(i,iclustasg(j))
         enddo
      enddo
 
      return
      end

