C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine clustwrm(u, uhdr, live, iclustasgloc, iclustasg, nvect,
     1                   nclust, isamp, NumSmpr, NumTrcr, NumRecr, 
     2                   lenhed, lbyoutc, luoutc, u_size,
     3                   cputim, waltim, ler, verbos) 
		
      implicit none
		
c-----------------------------------------------------------------------
c Bertram Kaufhold 	07/01/98	
c
c This subroutine writes out the cluster results
c-----------------------------------------------------------------------

      integer nvect
      integer iclustasgloc(nvect), nclust, isamp
      integer NumSmpr, NumTrcr, NumRecr
      integer lenhed, lbyoutc, luoutc, u_size, ler
      integer live(NumTrcr, NumRecr), iclustasg(nvect)
      real cputim(*), waltim(*)
      real u(-lenhed+1:NumSmpr), uhdr(lenhed, NumTrcr, NumRecr)
      logical verbos
      
      integer ivaltrcr, ivalloc, j, k
      real v3, vtot3, w3, wtot3
      real time_per_line, time_left
      integer nhour, nmin, nsec
      
      call timstr(v3, w3)

      ivaltrcr = 1
      ivalloc = 1
            
c-----------------------------------------------------------------------
c Write a record			=> START WRITE OUTER LOOP =>
  
      do k = 1, NumRecr			

c-----------------------------------------------------------------------
c Diagnostic message.  What line are we on and how much time until done?
 
         if (verbos) then
            if (k .ge. 2) then
               call timstr(vtot3,wtot3)                 
               time_per_line = (wtot3-w3)/(k-1)
               time_left = (NumRecr-k+1)*time_per_line  
               nhour=time_left/3600.
               nmin=(time_left-3600.*nhour)/60.
               nsec=time_left-3600.*nhour-60.*nmin
               write(ler,'(a,i5,a,i5,a,i5,a,i5,a,i5,a)')
     1         'CLUST3DM: Processing line ',k,' of ',NumRecr,
     2         ' time left: ',nhour, ' hr',
     3         nmin, ' min', nsec, ' sec'
            else
               write(ler,'(a,i5,a,i5)')
     1         'CLUST3DM: Processing line ',k,' of ',NumRecr
            endif
         endif

c-----------------------------------------------------------------------
c Write a trace			=> START WRITE INNER LOOP =>

         do j = 1, NumTrcr

c-----------------------------------------------------------------------
c Copy the trace header

            call vmov(uhdr(1,j,k), 1, u(-lenhed+1), 1, lenhed)

                       
            if (live(j,k) .ne. 0) then

c-----------------------------------------------------------------------
c Copy the trace data, i.e., the cluster assignments

               if (iclustasgloc(ivalloc) .eq. ivaltrcr) then
                  u(1) = iclustasg(ivalloc)
                  ivalloc = ivalloc + 1
                  ivaltrcr = ivaltrcr + 1
               else
                  u(1) = nclust + 1 
                  ivaltrcr = ivaltrcr + 1
               endif
            else
               u(1) = 0.0             
            endif

c-----------------------------------------------------------------------
c Write the trace

            call wrtape(luoutc, u(-lenhed+1), lbyoutc)

         enddo				
c				=> END WRITE INNER LOOP =>
c-----------------------------------------------------------------------

      enddo	
c					=> END WRITE OUTER LOOP =>
c-----------------------------------------------------------------------

      call timend(cputim(3), v3, vtot3, waltim(3), w3, wtot3)

      return
      end
