C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine featrdwrm(vect, u, uhdr, live, 
     1                    isamp, istart, iskip, iend, 
     2                    nclust, nvect, NumSmpr, NumTrcr, NumRecr, 
     3                    lenhed, lbyout, luinr, luini, luinm,
     4                    luoutr, luouti, ler, lerr, ntapi, u_size,
     5                    ifmt_StaCor, l_StaCor, ln_StaCor,
     6                    cputim,waltim,imagfile,maskfile,fout,verbos)	
		
      implicit none
		
c-----------------------------------------------------------------------
c Bertram Kaufhold 	07/01/98	
c
c This subroutine reads and writes input and output data, respectively
c-----------------------------------------------------------------------

#include <save_defs.h> 

      integer isamp, istart, iskip, iend, nclust
      integer nvect, NumSmpr, NumTrcr, NumRecr, lenhed, lbyout
      integer luinr, luini, luinm, luoutr, luouti, ler, lerr
      character ntapi*(*)
      integer u_size, ifmt_StaCor, l_StaCor, ln_StaCor
      integer imagfile, maskfile
      real cputim(*), waltim(*)
      logical fout, verbos

      integer errcds, initialize, ivaltrcr, ivaltrci, StaCor, maskval
      integer lbytesr, lbytesi, lbytesm, irec, itrc, i_dim, i
      real v1, vtot1, w1, wtot1
      real time_per_line, time_left
      integer nhour, nmin, nsec
      
      complex vect(NumSmpr, NumTrcr*NumRecr)
      real u(-lenhed+1:NumSmpr), uhdr(lenhed, NumTrcr, NumRecr)
      integer live(NumTrcr, NumRecr)
      data maskval/0/

      call timstr(v1,w1)

c----------------------------------------------------------------------- 
c Read the input data into the complex array vect.
c First read the input file that contains real part of the feature 
c vectors and then the one that contains the imaginary part. If the
c latter does not exist initialize imaginary part of vect to zero (has
c been done before during initialization of dynamic memory allocation)
c-----------------------------------------------------------------------

      errcds = 0
      ivaltrcr = 1
      ivaltrci = 1
            
c-----------------------------------------------------------------------
c Read/Write a record			=> START READ/WRITE OUTER LOOP =>
  
      do irec = 1, NumRecr			

c-----------------------------------------------------------------------
c Diagnostic message.  What line are we on and how much time until done?

         if (verbos) then 
            if (irec .ge. 2) then
               call timstr(vtot1,wtot1)                 
               time_per_line = (wtot1-w1)/(irec-1)
               time_left = (NumRecr-irec+1)*time_per_line  
               nhour=time_left/3600.
               nmin=(time_left-3600.*nhour)/60.
               nsec=time_left-3600.*nhour-60.*nmin
               write(ler,'(a,i5,a,i5,a,i5,a,i5,a,i5,a)')
     1         'CLUST3DM: Processing line ',irec,' of ',NumRecr,
     2         ' time left: ',nhour, ' hr',
     3         nmin, ' min', nsec, ' sec'
            else
               write(ler,'(a,i5,a,i5)')
     1         'CLUST3DM: Processing line ',irec,' of ',NumRecr
            endif
         endif

c-----------------------------------------------------------------------
c Read/Write a trace		=> START READ/WRITE INNER LOOP =>

         do itrc = 1, NumTrcr		

            do initialize = 1, 2      

               if ((maskfile .eq. 1) .and. (initialize .eq. 1)) then
                  call rtape(luinm, u(-lenhed+1), lbytesm)
                  maskval = u(1)
               endif

               if (initialize .eq. 1) then 

                  call rtape(luinr, u(-lenhed+1), lbytesr)

c-----------------------------------------------------------------------
c By convention a "Station Correction" of 30000 is used as a dead trace 
c flag. Traces marked by a maskval value of -1 are taken out of the set
c of active feature vectors, i.e., they are not considered for 
c classification. The "Station Correction" flag will be set to 30000!!!

                  if (maskval .eq. -1) then
                     StaCor=30000
                     call savew2(u(-lenhed+1), ifmt_StaCor, l_StaCor,
     1                           ln_StaCor, StaCor, TRACEHEADER)
                  endif

c-----------------------------------------------------------------------
c Save the header (use the header from the input data file that 
c corresponds to the real part of the feature vectors) for later use 
c and rearrange the data entries according to the specifications made
c in the command line 

                  call vmov(u(-lenhed+1), 1, 
     1                      uhdr(1,itrc,irec), 1, lenhed)
                  i_dim = 1
                  do i = istart, iend, iskip
                     u(i_dim)=u(i)
                     i_dim = i_dim + 1
                  enddo
                  if (fout) then
                     call wrtape(luoutr, u(-lenhed+1),lbyout)
                  endif

c-----------------------------------------------------------------------
c If it is a dead trace report in array live.

                  call saver2(u(-lenhed+1), ifmt_StaCor, l_StaCor,
     1                        ln_StaCor, StaCor, TRACEHEADER)

                  if (StaCor .ne. 30000) then                  
                      call cvreal(u(1), 1, vect(1,ivaltrcr),
     1                            2, isamp)
                     live(itrc, irec) = 1
                     ivaltrcr = ivaltrcr + 1
                  else
                     live(itrc, irec) = 0
                  endif

               elseif (initialize .eq. 2) then

                  if (imagfile .eq. 1) then

                     call rtape(luini, u(-lenhed+1), lbytesi) 
                     if (maskval .eq. -1) then
                        call savew2(u(-lenhed+1), ifmt_StaCor, l_StaCor,
     1                              ln_StaCor, StaCor, TRACEHEADER)
                     endif

                     i_dim = 1
                     do i = istart, iend, iskip
                        u(i_dim)=u(i)
                        i_dim = i_dim + 1
                     enddo                                
                     if (fout) then
                        call wrtape(luouti, u(-lenhed+1),lbyout)
                     endif

c-----------------------------------------------------------------------
c By convention a "Station Correction" of 30000 is used as a dead trace 
c flag. If it is a dead trace report in array live.

                     call saver2(u(-lenhed+1), ifmt_StaCor,
     1                        l_StaCor, ln_StaCor, StaCor, TRACEHEADER)

                     if (StaCor .ne. 30000) then                  

                        do i = 1,isamp
                           vect(i, ivaltrci) =
     1                          cmplx(real(vect(i,ivaltrci)),u(i))
                        enddo

                        if (live(itrc, irec) .ne. 1) then                    
                           write(LER,*)'CLUST3DM: Live traces in'
                           write(LER,*)'input files do not match'
                           write(LERR,*)'CLUST3DM: Live traces in'
                           write(LERR,*)'input files do not match'
                           errcds = 1                        
                        endif    
                           ivaltrci = ivaltrci + 1
                     else 
                        if (live(itrc, irec) .ne. 0) then
                           write(LER,*)'CLUST3DM: Dead traces in'
                           write(LER,*)'input files do not match'
                           write(LERR,*)'CLUST3DM: Dead traces in'
                           write(LERR,*)'input files do not match'
                           errcds = 1                        
                        endif   
                     endif                  
                  endif
               endif               
               if (errcds .ne. 0) call exitfu(-1)
            enddo				
c				=> END READ/WRITE INNER LOOP =>
c-----------------------------------------------------------------------

         enddo	
c					=> END READ/WRITE OUTER LOOP =>
c-----------------------------------------------------------------------

      enddo
      nvect = ivaltrcr-1

      call timend(cputim(1),v1,vtot1,waltim(1),w1,wtot1)
      return
      end
