/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* This routine started out with the "watch" program obtained from
 * Steve Farmer. I then put in several new features for changing commands,
 * timer interval, etc.
 * 				- Joe M. Wade 5/31/96
 */
/*
 * Modified to understand the erase character when entering a new command
 *				- Joe M. Wade 7/19/96
 */
/*
 * Modified to accept long commands that may result from wildcard expansion.
 * Bug fix to prevent flashing problems on SunOS machines. Added provisions
 * for handling of Ctrl-d entries. Added catch for commands which result
 * in error to prevent repeated occurrence.
 *						- Joe M. Wade 7/18/97
 */
/*
 * Bug fix on long command truncation. Do a screen reset on occasions
 * of commands which have err'ed to wipe stderr message from tty before
 * re-running the command.
 *						- Joe M. Wade 10/21/97
 */

#include <stdio.h>
#include <curses.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <errno.h>

#include <localsys.h>

#ifdef CONVEXSYSTEM
#define	cbreak() crmode()
#define	nocbreak() nocrmode()
#endif

#define XCENTER(x) (((LINES - x - 1) / 2) >= 0 ? (LINES - x - 1) / 2 : 0)
#define YCENTER(x) (((COLS - x - 1) / 2) >= 0 ? (COLS - x - 1) / 2 : 0)

#ifdef DEBUG
FILE *db;
#endif
WINDOW *tty,*popup,*debug_win;

int debug = 0;
int nsecs = 2;
int xloc,yloc;
char eraseflag = '';
char *cmd;

void	pipe_brk();
void	die();
void	chgcmd();
void	docmd();
void	interval();
void	help();
void	clr_error();
void	start_debug(),end_debug();
extern	FILE 		*popen();
extern	int 		pclose();
extern	long		time();
extern	char		*ctime();

main(argc, argv)
int argc;
char *argv[];
{
	long timer;
	char hexrep[9];
	int count = 1;
	int input = '\0';

	if (argc < 2) {
		fprintf(stderr, "Usage: %s command [args]\n", argv[0]);
		exit(1);
	} /* if */

	/* If -n is specified, convert the next argument to the numver
	 * for the number of seconds
	 */
	if (strcmp(argv[1], "-n") == 0) {
		nsecs = atoi(argv[2]);
		count = 3;
		if (nsecs == 0 || argc < 3) {
			fprintf(stderr, "Usage: %s command [args]\n", argv[0]);
			exit(1);
		} /* if */
	} /* if */

	/* Build command string to give to popen */
	cmd = (char *) malloc(strlen(argv[count])+2);
	if (cmd == NULL) {
	  fprintf(stderr,"cmdwatch: Unable to allocate space ");
	  fprintf(stderr,"for command storage; exiting\n");
	  exit(1);
	  }
	strcpy(cmd, argv[count]);
	while (++count < argc) {
		cmd = (char *) realloc(cmd,strlen(cmd)+strlen(argv[count])+1);
		if (cmd == NULL) {
		  fprintf(stderr,"cmdwatch: Unable to allocate space ");
		  fprintf(stderr,"for command storage; exiting\n");
		  exit(1);
		  }
		strcat(cmd, " ");
		strcat(cmd, argv[count]);
	} /* while */

	/* Catch keyboard interrupts so we can
	 * put tty back in a sane state 
	 */
	(void) signal(SIGINT, die);
	(void) signal(SIGTERM, die);
	(void) signal(SIGSEGV, die);
	(void) signal(SIGHUP, die);

	/* We close the pipe after we've read a screen; we need to ignore
	 * pipe errors
	 */
	(void) signal(SIGPIPE, SIG_IGN);
	 

#ifdef DEBUG
/*
	db = popen("/explprod/phase2/script/xcat -buffer 5 -display gpss89:0","w");
*/
	db = fopen("watch.db","w");
	if (db == (FILE *)NULL) {
	  db = stderr;
	  }
	setbuf(db,NULL);
#endif

	/* Set up tty for curses use */
	tty = initscr();
	savetty();
/*
	nonl();
*/
	cbreak();
	noecho();

/* the Convex doesn't have a routine in the curses library to
   retrieve the current erase character */

#ifndef CONVEXSYSTEM
	eraseflag = erasechar();
#endif

	signal(SIGALRM,docmd);
	docmd();

	if (fcntl(fileno(stdin),F_SETFL,O_SYNC) == -1) {
	  perror("cmdwatch");
	  exit(1);
	  }

	while(1) { /* loop forever */

		input = getch();
#ifdef DEBUG
	fprintf(db,"%c (%08x)\n",input,input); fflush(db);
#endif
		switch(input) {
/*
		  case((int) ERR):
		    die();
		    break;
*/
		  case 'd':
		  case 'D':
		    if (debug == 0) {
			debug = 1;
			start_debug();
			}
		    else {
			debug = 0;
			end_debug();
			}
		    break;
		  case 'c':
		  case 'C':
		    chgcmd();
		    break;
		  case 'q':
		  case 'Q':
		  case((int) 0x04):  /* Ctrl-D */
		    die();
		    break;
		  case 'h':
		  case 'H':
		    help();
		    break;
		  case 'i':
		  case 'I':
		    interval();
		    break;
		  case '0':
		    nsecs = 0;
		    break;
		  case '1':
		    nsecs = 1;
		    break;
		  case '2':
		    nsecs = 2;
		    break;
		  case '3':
		    nsecs = 3;
		    break;
		  case '4':
		    nsecs = 4;
		    break;
		  case '5':
		    nsecs = 5;
		    break;
		  case '6':
		    nsecs = 6;
		    break;
		  case '7':
		    nsecs = 7;
		    break;
		  case '8':
		    nsecs = 8;
		    break;
		  case '9':
		    nsecs = 9;
		    break;
		  case EOF:
		    break;
		  default:
		    mvaddch(2,0,input);
		    addstr(" - command (");
		    sprintf(&hexrep[0],"%08x",input);
		    hexrep[8] = '\0';
		    addstr(hexrep);
		    addstr(") unknown; enter 'h' for help ");
/*
	time(&timer);
	printw("    %s", ctime(&timer));
*/
		    move(2,0);
		    refresh();
		    alarm(5);		/* give them 5 secs to read the message */
		    break;
		  }

	} /* while */
} /* main */

void
pipe_brk()
{
fprintf(stderr,"We got a broken pipe signal\n");
}
void
die()
{
	/* Ignore interrupts while we clear the screen
	 * and reset the tty 
	 */
	alarm(0);
	(void) signal(SIGINT, SIG_IGN);
#ifdef DEBUG
	if (errno != 0) {
	  fprintf(db,"errno = %d\n",errno); 
	  fprintf(db,"die routine \n");
	  fflush(db);
	  }
#endif
	resetty();
	clear(); 
	refresh(); 
	endwin();
#ifdef DEBUG
	pclose(db);
#endif
	exit(0);
} /* die */

void rmpopup(status)
int status;
{
	delwin(popup);
#ifdef DEBUG
	  fprintf(db,"rmpopup\n");
	  fflush(db);
#endif
	signal(SIGALRM,docmd);
	alarm(1);
	return;
}
void
help(status)
int status;
{
#ifdef DEBUG
	  fprintf(db,"help\n");
	  fflush(db);
#endif
	xloc = XCENTER(8);
	yloc = YCENTER(40);
	popup = subwin(tty,8,40,xloc,yloc);
	alarm(0);
	signal(SIGALRM,SIG_IGN);
	wclear(popup);
	box(popup,'*','*');
	mvwaddstr(popup,2,3,"HELP:");
	mvwaddstr(popup,3,5,"i - change update interval");
	mvwaddstr(popup,4,5,"c - watch new command");
	mvwaddstr(popup,5,5,"q - quit");
	touchwin(tty);
	wrefresh(popup);
	signal(SIGALRM,rmpopup);
	alarm(5);
	move(2,0);
	refresh();
}
void
interval(status)
int status;
{
	char new_time[8];
#ifdef DEBUG
	  fprintf(db,"interval\n");
	  fflush(db);
#endif
	alarm(0);
	signal(SIGALRM,SIG_IGN);
	echo();
	xloc = XCENTER(5);
	yloc = YCENTER(35);
	popup = subwin(tty,5,35,xloc,yloc);
	wclear(popup);
	box(popup,'*','*');
	mvwaddstr(popup,2,3,"Enter New Interval: ");
	touchwin(tty);
	nocbreak();
	refresh();
	wrefresh(popup);
	errno = -1; 
	wgetstr(popup,&new_time[0]);
#ifdef DEBUG
	fprintf(db,"changing interval to %s secs\n",(char *)&new_time[0]);
	fflush(db);
#endif
	cbreak();
	nsecs = atoi(&new_time[0]);
#ifdef DEBUG
	  fprintf(db,"interval changed to %d secs\n",nsecs);
	  fflush(db);
#endif
	noecho();
	wrefresh(popup);
	refresh();
	signal(SIGALRM,rmpopup);
	alarm(1);
	return;
}
void 
docmd(status)
int status;
{
	char dspcmd[28];
	int hor = 1, ver = 0;
	FILE *piper;
	char buf[180];
	long timer;

		/* Put up time interval and current time */
#ifdef DEBUG
	  fprintf(db,"docmd\n");
	  fflush(db);
#endif
	if (debug != 0) {
		/* overwrite(debug_win,tty); */
		wprintw(debug_win,"docmd\n");
		touchwin(debug_win);
		wrefresh(debug_win);
		}
	alarm(0);
	move(0,0);
/* - this was causing flashing on the slower Suns
	clearok(tty,TRUE);
	refresh();
	clearok(tty,FALSE);
*/
	if (debug != 0) {
	  move(0,0);
	  printw("debugging....\t\t\t\tROWS %d COLUMNS %d\n", LINES, COLS);
	  refresh();
	  }
	else {
	  move(0,0);
	  clrtoeol();
	  }
	move(1,0);
	time(&timer);
	if (strlen(cmd) <= 27) {
	  memset(dspcmd,(int) ' ',27);
	  memcpy(dspcmd+((27-strlen(cmd))/2),cmd,strlen(cmd));
	  dspcmd[27] = '\0';
	  printw("Every %d seconds     %27s     %s\n",nsecs,dspcmd,
		ctime(&timer));
	  }
	else {
	  strncpy(dspcmd,cmd,27);
	  dspcmd[27] = '\0';
	  printw("Every %d seconds     %s...     %s\n",nsecs,dspcmd,
		ctime(&timer));
	  }
	getyx(tty,hor,ver);
	move(2,0);
	refresh();
	if (debug != 0) wrefresh(debug_win);

		/* Open pipe to command */
	if ((piper = popen(cmd, "r")) == (FILE *)NULL) {
		perror("popen");
		exit(2);
		} /* if */

		/* Read in output from the command and make sure 
	 	* that it will fit on 1 screen 
	 	*/
	while ((fgets(buf, sizeof(buf), piper) != NULL) && hor < LINES) {
		buf[COLS-1] = '\0';
		mvaddstr(hor, ver, buf);
		hor++;
		} /* while */
	clrtobot();
	refresh();
	if (debug != 0) mvprintw(LINES-1,0,"docmd\n");
	move(2,0);
	if (debug != 0) {touchwin(debug_win); /* overwrite(debug_win,tty); */}
	refresh();
	if (debug != 0) {touchwin(debug_win); wrefresh(debug_win);}
/*
   if the watched command returned a bad status, call clr_error to
   clear the screen before attempting to run the command again.
*/
	if (pclose(piper) != 0) {
#ifdef DEBUG
	  fprintf(db,"docmd: %s returned a bad status\n",(char *)cmd);
	  fflush(db);
#endif
	  signal(SIGALRM,clr_error);
	  alarm(nsecs);
	  }
	else {
	  signal(SIGALRM,docmd);
	  alarm(nsecs);
	  }
	return;
}
void
chgcmd(status)
int status;
{
	int x,y;
	int i=0;
	int input = '\0';
	char *prvcmd;

	prvcmd = strdup(cmd);

#ifdef DEBUG
	  fprintf(db,"chgcmd\n");
	  fflush(db);
#endif
	if (debug != 0) mvprintw(LINES-1,0,"chgcmd\n");
	alarm(0);
	signal(SIGALRM,SIG_IGN);
	xloc = XCENTER(5);
	yloc = YCENTER(80);
	popup = subwin(tty,5,80,xloc,yloc);
	wclear(popup);
	box(popup,'*','*');
	mvwaddstr(popup,2,3,"Enter New Command: ");
	wrefresh(popup);
	noecho();
	input = 0;
	cmd[127]='\0';
	do {
		input = getch();
		switch(input) {
		  case((int) '\n'):
		    cmd[i] = '\0';
		    break;
		  case((int) 0x04):    /* Ctrl-D was entered - exit */
		    strcpy(cmd,prvcmd);
		    input = '\n';
		    break;
		  default:
		    if (input != (int) eraseflag) {
		      waddch(popup,input);
		      wrefresh(popup);
		      cmd[i++] = (char)input;
		      cmd[i] = '\0';
		      }
		    else {
		      getyx(popup,y,x);
		      wmove(popup,y,x-1);
		      wdelch(popup);
		      winsch(popup,' ');
		      wrefresh(popup);
		      cmd[--i] = '\0';
		      }
		  }
		} while (input != (int)'\n'); /* loop until we get a new line */
#ifdef DEBUG
	  fprintf(db,"new command = \"%s\" len = %d\n",
			(char *)&cmd[0],strlen((char *)cmd));
	  fflush(db);
#endif
	if (debug != 0) mvprintw(LINES-1,0,"new command = \"%s\" len = %d\n",
			(char *)&cmd[0],strlen((char *)cmd));

	free(prvcmd);
	move(0,0);
	clear();
	clearok(tty,TRUE);
	refresh();
	clearok(tty,FALSE);
	cbreak();
	noecho();
	signal(SIGALRM,rmpopup);
	alarm(1);
	return;
}
void
start_debug()
{
	int x,y;
	int i=0;
	int input = '\0';
#ifdef DEBUG
	  fprintf(db,"start_debug\n");
	  fflush(db);
#endif
	alarm(0);
	signal(SIGALRM,SIG_IGN);
	xloc = XCENTER(5);
	yloc = YCENTER(40);
	debug_win = subwin(tty,5,40,xloc,yloc);
	wclear(debug_win);
	box(debug_win,'*','*');
	mvwaddstr(debug_win,2,2,"DEBUGGING: ");
	wrefresh(debug_win);
	signal(SIGALRM,docmd);
	alarm(1);
	return;
}
void
end_debug()
{
#ifdef DEBUG
	  fprintf(db,"end_debug\n");
	  fflush(db);
#endif
	delwin(popup);
	return;
}
void
clr_error()
{
	clear();
	refresh();
	docmd(NULL);
}
