C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c     program module comment
c
c**********************************************************************c
c
c comment reads text from command line arguments and adds to lineheader
c
c
c**********************************************************************c
c
c     declare variables
c
#include     <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes,  lbyte
      integer     irs,ire,ns,ne
#include <f77/pid.h>
      character   ntap * 256, otap * 256, c1*80 ,name*7,blank*50
      character   ctap * 256
      logical     query
      integer     argis

      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'COMMENT'/
	data nameblank/'       '/
      data blank /' '/
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
c-----
c     open printout files
c-----
#include <f77/open.h>
      call gcmdln(ntap,otap,ctap,ns,ne,irs,ire)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c-----
c     read line header of input
c     save certain parameters
c-----
	lbyte = 0
      call rtape  ( luin, itr, lbyte)
      if(lbyte .eq. 0) then
         write(LOT,*)'COMMENT'
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c	call hlhprt(itr, lbyte, name, 7, LERR)
 	call HLHLU(LERR)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c	name = '       '
      IF (ctap(1:1) .eq. ' ') THEN

          do    i = 1, 100
	    call argstr('-C',c1,' ',' ')
	    if (c1 .eq. ' ') then
		    go to 1010
	    else
		    call HLH(itr,lbyte,c1,80)
	    endif
          enddo
1010      continue

      ELSE
          open (unit=lun, file = ctap, status='old', iostat=ierr)
             if (ierr .ne. 0) then
                write(LERR,*)'Could not open comment file'
                write(LERR,*)'Check existence'
                stop
             endif

          do   i = 1, 100
               read (lun,'(a)', end=1011) c1
               call HLH(itr,lbyte,c1,80)
          enddo
1011      continue
          close (lun)
      ENDIF

      call wrtape ( luout, itr, lbyte       )
c-----
c     BEGIN PROCESSING
c     read trace,  write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      do 1000 jj = irs, ire

            call trcskp(jj,1,ns-1,luin,ntrc,itr)

            do 1001 kk=ns, ne

                  nbytes = 0
                  call rtape ( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call wrtape( luout, itr, nbytes)
 1001             continue

            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

 1000       continue
c-----
c     close data files
c-----
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
      end


      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'Execute by typing comment followed by program parameters.'
        write(LER,*)
     :'Users enter the following parameters, or use the default values'
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
        write(LER,*)' '
        write(LER,*)'Comment input either by flat file or cmd line:'
        write(LER,*)
     :' -D [ctap]    (def=" ")  : flat file containing comments, or'
        write(LER,*)
     :' -C [c1]      (def=" ")  : comment line (up to 100)'
        write(LER,*)' '
        write(LER,*)
     :' -rs[irs] (default = 1st record) : starting record number '
        write(LER,*)
     :' -re[ire] (default = last record) : final record number '
        write(LER,*)
     :' -ns[ns] (default = trace 1) : first trace in record '
        write(LER,*)
     :' -ne[ne] (default = last trace) : last trace in each record '
	write(LER,*)
	write(LER,*)
     :' EXAMPLE'
	write(LER,*)
     :' comment -N/data/ntap -O/data/otap [[-Cline of script  '
	write(LER,*)
     :'        -Cline of script -Cline of script ....] [-D[file] ]'
	write(LER,*)
     :'        NOTE: enclose -C{} cmd line comments in quotes '
	write(LER,*)
     :'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,ctap,ns,ne,irs,ire)
c-----
c     get command arguments
c
c     ntap  - c*120     input file name
c     otap  - c*120     output file name
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*), ctap*(*)
      integer *4 ns, ne, irs, ire
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-D', ctap, ' ', ' ' )
            call argi4 ( '-ns', ns ,    0  ,  0    )
            call argi4 ( '-ne', ne ,    0  ,  0    ) 
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0   , 0    )
      return
      end

