C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap1, ntap2, otap1, otap2, irs, ire, 
     :     var1_min, var1_max, var1_delta, 
     :     var2_min, var2_max, var2_delta, 
     :     ctap, reverse, logtr, logsa, luqci, luqco, verbos,
     :     luqce)

#include <f77/iounit.h>

      integer    argis, irs, ire
      integer    logtr, logsa, luqci, luqco, luqce

      real var1_min, var1_max, var1_delta
      real var2_min, var2_max, var2_delta

      character  ntap1*(*), ntap2*(*), otap1*(*), otap2*(*)
      character  ctap*(*)
      character  qctapi*512
      character  qctapo*512
      character  qctape*512

      logical    verbos, reverse

      call argr4('-delta1',var1_delta,-99999.,-99999.) 
      call argr4('-delta2',var2_delta,-99999.,-99999.)
 
      call argr4('-max1',var1_max,-99999.,-99999.) 
      call argr4('-max2',var2_max,-99999.,-99999.) 
      call argr4('-min1',var1_min,-99999.,-99999.) 
      call argr4('-min2',var2_min,-99999.,-99999.) 

      call argstr('-N1',ntap1,' ',' ')
      call argstr('-N2',ntap2,' ',' ')

      call argstr('-O1',otap1,' ',' ')
      call argstr('-O2',otap2,' ',' ')

      call argstr('-C',ctap,' ',' ')

      call argstr('-QCI', qctapi, ' ', ' ')
      call argstr('-QCO', qctapo, ' ', ' ')
      call argstr('-QCE', qctape, ' ', ' ')
      call argi4 ('-S', logsa, 10, 10)
      call argi4 ('-T', logtr, 10, 10)

      if (qctapi(1:1) .ne. ' ') then
          call alloclun (luqci)
          lc = lenth (qctapi)
          open (luqci, file=qctapi(1:lc), status='unknown', 
     1          iostat = ierr)
          if(ierr .ne. 0) then
             write(LER,*)'crossfilt: Could not open output QC file ',
     :              qctapi(1:lc)
             write(LER,*)'Check permissions/spelling and rerun '
             write(LER,*)'FATAL'
             stop
          endif
      endif

      if (qctapo(1:1) .ne. ' ') then
          call alloclun (luqco)
          lc = lenth (qctapo)
          open (luqco, file=qctapo(1:lc), status='unknown',
     1          iostat = ierr)
          if(ierr .ne. 0) then
             write(LER,*)'crossfilt: Could not open output QC file ',
     :              qctapo(1:lc)
             write(LER,*)'Check permissions/spelling and rerun '
             write(LER,*)'FATAL'
             stop
          endif
      endif

      if (qctape(1:1) .ne. ' ') then
          call alloclun (luqce)
          lc = lenth (qctape)
          open (luqce, file=qctape(1:lc), status='unknown',
     1          iostat = ierr)
          if(ierr .ne. 0) then
             write(LER,*)'crossfilt: Could not open output QC file ',
     :              qctape(1:lc)
             write(LER,*)'Check permissions/spelling and rerun '
             write(LER,*)'FATAL'
             stop
          endif
      endif

      if (ctap(1:1) .eq. ' ') then
         write(LERR,*)'FATAL ERROR in crossfilt:'
         write(LERR,*)'Must enter coefficients file -C[]'
         write(LERR,*)'(four coeffs to define 4 st lines)'
         write(LER ,*)'FATAL ERROR in crossfilt:'
         write(LER ,*)'Must enter coefficients file -C[]'
         write(LER ,*)'(four coeffs to define 4 st lines)'
         call ccexit (666)
      endif

      call argi4('-re',ire,0,0)
      call argi4('-rs',irs,1,1)

      reverse = ( argis( '-R' ) .gt. 0 )
      verbos = ( argis( '-V' ) .gt. 0 )

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

      return
      end
