C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     CROSSFILT:  crossfilt filters the crossplotted values from 2
c                 input data sets: if the XY values fall within a
c                 zone defined by 4 straight lines then the two
c                 data set values are passed, otherwise they are zeroed
c

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer nsamp, nsi, ntrc, nrec, ntrco, nsampo, nreco
      integer irs, ire
      integer luout1, luout2, nbytes, obytes, lbyout1, lbyout2
      integer argis, pipe1, pipe2, lucof, luqci, luqco, luqce

      integer  itr1( SZLNHD ), itr2( SZLNHD )

      character ntap1*256, ntap2*256, otap1*256, otap2*256, name*9
      character ctap*256, etap*256

      logical verbos, first, EOD, reverse, YX, XY(4)

c variables used with dynamic memory allocation

      integer abort, errcd0, errcd1, errcd2, errcd3
      integer xplot_size, var_size

      real cof(2,4)

      real var1, var2, xplot1, xplot2
      real xmin, xmax, ymin, ymax

      pointer ( mem_xplot1,xplot1(2) )
      pointer ( mem_xplot2,xplot2(2) )
      pointer ( mem_var1,var1(2) )
      pointer ( mem_var2,var2(2) )

c declare local variables

      integer luin1, luin2, lbytes1, lbytes2, length
      integer nsamp2, nsi2, ntrc2, nrec2
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer tr_index

      real var1_min, var1_max, var1_delta
      real var2_min, var2_max, var2_delta

      logical need_limits1, need_limits2

c initialize variables
 
      data name /'CROSSFILT'/
      data luin / 1 /
      data luout / 2 /
      data lbytes / 0 /
      data nbytes / 0 /
      data obytes / 0 /
      data pipe1/3/
      data pipe2/4/
      data first/.true./
      data need_limits1 /.false./
      data need_limits2 /.false./
      data YX/.true./
      data EOD/.false./

c  get online help if necessary

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help ()
         stop
      endif

c  open printout file

#include <f77/open.h>

c  get command line parameters

      call cmdln ( ntap1, ntap2, otap1, otap2, irs, ire, 
     :     var1_min, var1_max, var1_delta, 
     :     var2_min, var2_max, var2_delta, 
     :     ctap, reverse, logtr, logsa, luqci, luqco, verbos,
     :     luqce)

c open coefficient file

      call alloclun (lucof)
      length = lenth(ctap)
      open (lucof, file=ctap(1:length), status='old',err=711)
      go to 112
711   continue
      write(LERR,*)'FATAL ERROR in crossfilt:'
      write(LERR,*)'Unable to open coefficient file ',ctap
      write(LER ,*)'FATAL ERROR in crossfilt:'
      write(LER ,*)'Unable to open coefficient file ',ctap
      go to 999
112   continue

      rewind lucof
      call rdcoefs (lucof, YX, XY, cof)

c open input dataset one 

      call getln (luin1, ntap1, 'r', 0 )

c open input dataset two

      if ( ntap2 .eq. ' ') then
     
         write(LERR,*)' '
         write(LERR,*)'assumed to be running inside ikp'
         write(LERR,*)' '
         call sisfdfit (luin2, pipe1)
      else
         call getln (luin2, ntap2, 'r', 0 )
      endif
      
      if (luin2 .lt. 0) then
         length = lenth(ntap2)
	 if (length .gt. 0) then
           write(LERR,*)ntap2(1:length),' not accessible'
	 else
           write(LERR,*) '-N2 dataset not accessible'
	 endif
         write(LERR,*)'check existence and rerun'
         write(LERR,*)'FATAL'
         write(LER,*)'CROSSFILT:'
	 if (length .gt. 0) then
           write(LER,*) ntap2(1:length),' not accessible'
	 else
           write(LER,*) '-N2 dataset not accessible'
	 endif
         write(LER,*)' check existence and rerun'
         write(LER,*)'FATAL'
         stop
      endif

c open output dataset

      call getln (luout1, otap1,  'w', 1 )

c open output dataset two

      if ( otap2 .eq. ' ') then

         write(LERR,*)' '
         write(LERR,*)'assumed to be running inside ikp'
         write(LERR,*)' '
         call sisfdfit (luout2, pipe2)
      else
         call getln (luout2, otap2, 'w', -1 )
      endif


c read line header of dataset 1

      lbytes1 = 0
      length = lenth(ntap1)
      call rtape ( luin1, itr1, lbytes1 )
      if(lbytes1 .eq. 0) then
         write(LERR,*)'CROSSFILT:'
	 if (length .gt. 0) then
           write(LERR,*)' no line header read on ',ntap1(1:length)
	 else
           write(LERR,*)' no line header read on stdin'
         endif
         write(LERR,*)' Check file & rerun'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'CROSSFILT:'
	 if (length .gt. 0) then
           write(LER,*)' no line header read on ',ntap1(1:length)
	 else
           write(LER,*)' no line header read on stdin'
         endif
         write(LER,*)' Check file & rerun'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      write(LERR,*)' '
      write(LERR,*)' Historical Line Header from ',ntap1(1:length)
      write(LERR,*)' '
      call hlhprt ( itr1, lbytes1, name, 9, LERR )

c read line header of dataset 2

      lbytes2 = 0
      length = lenth(ntap2)
      call rtape ( luin2, itr2, lbytes2 )
      if(lbytes2 .eq. 0) then
         write(LERR,*)'CROSSFILT: '
	 if (length .gt. 0) then
           write(LERR,*)' no line header read on  ',ntap2(1:length)
	 else
           write(LERR,*)' no line header read on -N2 pipe'
         endif
         write(LERR,*)'Check file & rerun'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'CROSSFILT: '
	 if (length .gt. 0) then
           write(LER,*)' no line header read on  ',ntap2(1:length)
	 else
           write(LERR,*)' no line header read on -N2 pipe'
         endif
         write(LER,*)'Check file & rerun'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      write(LERR,*)' '
      write(LERR,*)' Historical Line Header from ',ntap2(1:length)
      write(LERR,*)' '
      call hlhprt ( itr2, lbytes2, name, 9, LERR )

c  save key header values

      call saver(itr1, 'NumSmp', nsamp , LINHED)
      call saver(itr1, 'SmpInt', nsi   , LINHED)
      call saver(itr1, 'NumTrc', ntrc  , LINHED)
      call saver(itr1, 'NumRec', nrec  , LINHED)

      call saver(itr2, 'NumSmp', nsamp2, LINHED)
      call saver(itr2, 'SmpInt', nsi2  , LINHED)
      call saver(itr2, 'NumTrc', ntrc2 , LINHED)
      call saver(itr2, 'NumRec', nrec2 , LINHED)

c build pointers to trace header data

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

c policemen to check data compatibility

      if ( nsamp .ne. nsamp2 ) then
        write(LERR,*)'Both data sets must have same trace length'
        write(LERR,*)'Found ',nsamp,' in DSN1 and ',nsamp2,' in DSN2' 
        write(LERR,*)'FATAL'
        write(LER,*)' '
        write(LER ,*)'CROSSFILT:'
        write(LER ,*)' Both data sets must have same trace length'
        write(LER,*)'Found ',nsamp,' in DSN1 and ',nsamp2,' in DSN2' 
        write(LER,*)'FATAL'
        write(LER,*)' '
        stop
      endif

      if ( nrec .ne. nrec2 ) then
         write(LERR,*)'number of records mismatch'
         write(LERR,*)'# recs DSN1 = ',nrec,' # recs DSN2= ',nrec2
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'CROSSFILT:'
         write(LER ,*)' number of records mismatch'
         write(LER,*)'# recs DSN1 = ',nrec,' # recs DSN2= ',nrec2
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      if( ntrc .ne. ntrc2 ) then
         write(LERR,*)'number of traces mismatch'
         write(LERR,*)'# trcs DSN1 = ',ntrc,' DSN2= ',ntrc2
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'CROSSFILT:'
         write(LER ,*)' number of traces mismatch'
         write(LER,*)'# trcs DSN1 = ',ntrc,' DSN2= ',ntrc2
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

c update number of output traces

      if ( var2_min .ne. -99999. .and.
     :     var2_max .ne. -99999. .and.
     :     var2_delta .ne. -99999. ) then
         ntrco = nint ( ( var2_max - var2_min ) / var2_delta )
      else
         need_limits2 = .true.
         ntrco = ntrc2
      endif

      call savew( itr1, 'NumTrc', ntrco, LINHED)
      call savew( itr2, 'NumTrc', ntrco, LINHED)

c update number of output samples 

      if ( var1_min .ne. -99999. .and.
     :     var1_max .ne. -99999. .and.
     :     var1_delta .ne. -99999. ) then
         nsampo = nint ( ( var1_max - var1_min ) / var1_delta )
      else
         nsampo = nsamp
         need_limits1 = .true.
      endif
         
      call savew( itr1, 'NumSmp', nsampo, LINHED)
      call savew( itr2, 'NumSmp', nsampo, LINHED)
      obytes = SZTRHD + SZSMPD * nsampo

c update number of output records

      if ( ire .eq. 0 ) ire = nrec
      nreco = ire - irs + 1
      call savew( itr1, 'NumRec', nreco, LINHED)
      call savew( itr2, 'NumRec', nreco, LINHED)

c  update historical line header

      call savhlh ( itr1, lbytes1, lbyout1 )
      call savhlh ( itr2, lbytes2, lbyout2 )

c write output line header 

      call wrtape ( luout1, itr1, lbyout1 )
      call wrtape ( luout2, itr2, lbyout2 )

c echo key parameters to printout file

c     call verbal ( ntap1, nrec, ntrc, nsamp, nsi, 
c    :     ntap2, nrec2, ntrc2, nsamp2, nsi2, 
c    :     otap, nreco, ntrco, nsampo, irs, ire,
c    :     var1_min, var1_max, var1_delta, 
c    :     var2_min, var2_max, var2_delta, verbos )

c dynamic memory allocation

      xplot_size = nsamp
      var_size = nsamp

      call galloc ( mem_xplot1, xplot_size * SZSMPD, errcd0, abort)
      call galloc ( mem_xplot2, xplot_size * SZSMPD, errcd1, abort)
      call galloc ( mem_var1, var_size * SZSMPD, errcd2, abort)
      call galloc ( mem_var2, var_size * SZSMPD, errcd3, abort)

      if ( errcd0 .ne. 0 .or. errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*var_size + 2*xplot_size * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*var_size + 2*xplot_size * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*var_size + 2*xplot_size * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( xplot1, 1, xplot_size )
      call vclr ( xplot2, 1, xplot_size )
      call vclr ( var1, 1, var_size )
      call vclr ( var2, 1, var_size )

c skip to start record

      call recskp ( 1, irs-1, luin1, ntrc, itr1 )
      call recskp ( 1, irs-1, luin2, ntrc, itr2 )

      first = .true.
      itrc = 0
      xmin = +1.e30
      ymax = -1.e30
      ymin = +1.e30
      xmax = -1.e30

      DO JJ = irs, ire

c load the data to be cross plotted

         tr_index = 1

         DO KK = 1, ntrc
            
            nbytes = 0
            call rtape  ( luin1 , itr1, nbytes )
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on ',ntap1
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               EOD = .true.
               go to 111
            endif
            if (JJ .eq. ire .AND. KK .eq. ntrc) EOD = .true.

            call vmov (itr1(ITHWP1), 1, var1(tr_index), 1, nsamp)

            nbytes = 0
            call rtape  ( luin2 , itr2, nbytes )
            if (nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on ',ntap2
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               EOD = .true.
               go to 111
            endif

            call vmov (itr2(ITHWP1), 1, var2(tr_index), 1, nsamp)

c build the cross plot histogram

            call vclr ( xplot1, 1, xplot_size )
            call vclr ( xplot2, 1, xplot_size )
            itrc = itrc + 1

111         continue

            call zone (nsamp, var1, var2, xplot1, xplot2, cof,
     1                 first, reverse, YX, XY, logtr, logsa,
     2                 itrc, luqci, luqco, xmin, xmax, ymin, ymax,
     3                 luqce, EOD, ntap1, ntap2)

            if (EOD .AND. nbytes .eq. 0) go to 999

c output cross plot record

            tr_index = 1

            call vmov ( xplot1(tr_index), 1, itr1(ITHWP1), 1, nsampo )
            call vmov ( xplot2(tr_index), 1, itr2(ITHWP1), 1, nsampo )
            call wrtape ( luout1, itr1, obytes )
            call wrtape ( luout2, itr2, obytes )

         ENDDO

      ENDDO

      call lbclos(luin1)
      call lbclos(luin2)
      call lbclos(luout1)
      call lbclos(luout2)
      if (luqci .gt. 0) close (luqci)
      if (luqco .gt. 0) close (luqco)
      if (luqce .gt. 0) close (luqce)
      
      write(LERR,*)' Normal Termination'
      write(LER,*)' crossfilt:  Normal Termination'
      stop

 999  continue

      call lbclos(luin1)
      call lbclos(luin2)
      call lbclos(luout1)
      call lbclos(luout2)
      if (luqci .gt. 0) close (luqci)
      if (luqco .gt. 0) close (luqco)
      
      write(LERR,*)' Abnormal Termination'
      write(LER,*)' crossfilt:  Abnormal Termination'
      stop

      end
