C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdcoefs (lucof, YX, XY, cof)

#include <f77/iounit.h>

      integer   lucof
      real      cof (2,4)
      real      tmp (2,4)
      character card * 80
      character tard * 80
      character blnk * 1
      character eqal * 1
      character plus * 1
      character mnus * 1
      character x * 1
      character y * 1
      logical   first, YX, XY(4)

      data blnk/' '/
      data eqal/'='/
      data plus/'+'/
      data mnus/'-'/
      data first/.true./

c---
c  As we read in the coefs the first two lines define the lower Y limits
c  and the upper Y limits respectively.
c  The next two lines will define the lower and upper X limits respectively.

c  The format of each line in this file will be
c  Y = a X + b
c  or
c  X = a Y + b
c  where X and/or Y may be upper of lower case

c  Each line is parsed to extract the numerical values "a" and "b". If the
c  first string entry is X or x then this line is flagged immediately
c  as being of the form X = a Y + b and the XY logical variable is set to
c  false.
c---

c---
c  set switches so that all str line coefs appear as Y = a*X + b
c---
      do  j = 1, 4
          XY (j) = .false.
      enddo

c---
c  go through all 4 lines of the file
c---
      DO  j = 1, 4

c---
c  initialize char arrays
c  read line out of file
c---
          do  i = 1, 80
              card (i:i) = blnk
              tard (i:i) = blnk
          enddo

          read (lucof, '(a80)') card
c---
c  strip off any leading blanks
c  determine length of character array
c---
          i  = 1
          ii = 0
          do while (card(i:i) .eq. blnk)
             i  = i  + 1
             ii = ii + 1
          enddo
          if (ii .eq. 80) then
             write(LERR,*)'********************************************'
             write(LERR,*)'FATAL ERROR in crossfilt:'
             write(LERR,*)'Line ',j,' of file is blank'
             write(LERR,*)'********************************************'
             write(LER ,*)'********************************************'
             write(LER ,*)'FATAL ERROR in crossfilt:'
             write(LER ,*)'Line ',j,' of file is blank'
             write(LER ,*)'********************************************'
             call ccexit (666)
          endif
          mc = lenth (card) 
          ic = 0
          do  i = ii+1, mc
              ic = ic + 1
              card (ic:ic) = card (i:i)
          enddo
          do  i = ic+1, mc
              card (i:i) = blnk
          enddo
          lc = lenth (card) 

c---
c  for the first entry on each line scan for y, Y, x, or X. If x or X set
c  XY switch to tell that it's of the form X = aY + b
c  If the first entry isn't one of these then bomb off
c  Lastly null out the X or Y string
c---
          ig = 0
          first = .true.
          do i = 1, lc

             if (first) then
                 if (card(i:i) .eq. 'y' .OR. 
     1               card(i:i) .eq. 'Y') then
                     XY (j) = .false.
                 elseif (card(i:i) .eq. 'x' .OR. 
     1                   card(i:i) .eq. 'X') then
                     XY (j) = .true.
                 else
                    go to 911
                 endif
                 if ( XY(j) ) YX = .false.
                 first = .false.
             endif

             if (card(i:i) .eq. 'y' .OR.
     1           card(i:i) .eq. 'Y') then
                 ig = ig + 1
                 card (i:i) = blnk
             elseif (card(i:i) .eq. 'x' .OR.
     1               card(i:i) .eq. 'X') then
                 ig = ig + 1
                 card (i:i) = blnk
             endif
c---
c  other entries on the line not a valid coef need to be nulled
c---
             if (card(i:i) .eq. 'x' .OR. card(i:i) .eq. 'X' .OR.
     1           card(i:i) .eq. 'y' .OR. card(i:i) .eq. 'Y' .OR.
     2           card(i:i) .eq. '=' .OR. card(i:i) .eq. '*' .OR.
     3           card(i:i) .eq. '+') then
                 card (i:i) = blnk
             endif
          enddo           ! end lc loop
c---
c  ig had better be 2 or we have a format problem in the file
c---
          if (ig .ne. 2) go to 911

c---
c  a minus sign needs to be dealt with: if a blank separates it from a
c  valid coef then strip that out
c---
          ib = 0
          ii = 0
          do  i = 1, lc
              ib = ib + 1
              ii = ii + 1
              tard (ib:ib) = card (ii:ii)
              if (card(ii:ii) .eq. '-') then
                  do while (card(ii+1:ii+1) .eq. blnk .AND.
     1                      ii+1 .le. lc)
                     ii = ii + 1
                  enddo
              endif
          enddo
c---
c  read the numerical values
c---
          call fsscnf (tard(1:ib), '%f %f', tmp(1,j), tmp(2,j))
      ENDDO

c---
c  The first 2 lines define the Y limits: these are always of the form
c  Y = a X + b; if not then solve for the proper form
c---
      DO  j = 1, 2
          if ( .not. XY(j) ) then
              cof (1,j) = tmp (1,j)
              cof (2,j) = tmp (2,j)
          else
              cof (1,j) = 1 / tmp (1,j)
              cof (2,j) = -tmp (2,j) / tmp (1,j)
          endif
      ENDDO



c---
c  The last 2 lines define the X limits: if these are not of the form
c  X = a Y + b, we need to solve the input equation Y = c X + d for
c  X, otherwise just grab the coefs
c---
      DO  j = 3, 4

c---
c  there is at least one X limit line of the form Y = c X + d
c---
         if ( .not. YX ) then
             if ( XY(j) ) then
                cof (1,j) = tmp (1,j)
                cof (2,j) = tmp (2,j)
             else
                cof (1,j) = 1 / tmp (1,j)
                cof (2,j) = -tmp (2,j) / tmp (1,j)
             endif
c---
c  both X limit lines aleady input in the file as X = a Y + b
c---
         else
             cof (1,j) = tmp (1,j)
             cof (2,j) = tmp (2,j)
         endif
c---
c  Now we've got the last 2 X-limit lines of the form X = a Y + b set the
c  switches
c---
         XY (j) = .true.

      ENDDO

      return

911   continue
      write(LERR,*)'********************************************'
      write(LERR,*)'FATAL ERROR in crossfilt:'
      write(LERR,*)'Bad format for coef file line ',j
      write(LERR,*)'Must be of form Y = a X + b or X = a Y + b,'
      write(LERR,*)'where a & b are the coefficients'
      write(LERR,*)'********************************************'
      write(LER ,*)'********************************************'
      write(LER ,*)'FATAL ERROR in crossfilt:'
      write(LER ,*)'Bad format for coef file line ',j
      write(LER ,*)'Must be of form Y = a X + b or X = a Y + b,'
      write(LER ,*)'where a & b are the coefficients'
      write(LER ,*)'********************************************'
      call ccexit (666)

      end
