C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FindLimits( nsamp, ntrc, nsampo, 
     :     var, var_min, var_max, var_delta )

c routine to find limits of input arrays to be cross plotted
c var1[] is associated with the sample axis and var2[] is associated
c with the trace axis

c variables passed from calling routine

      integer nsamp, ntrc, nsampo

      real var ( nsamp, ntrc)
      real var_min, var_max, var_delta

c local variables

      integer i, j

      real min, max

c initialize variables

      min = 1.0e32
      max = -1.0e32

c find var limits

      do i = 1, nsamp
         do j = 1, ntrc
            if ( var(i,j) .lt. min ) min = var(i,j)
            if ( var(i,j) .gt. max ) max = var(i,j) 
         enddo
      enddo

      var_delta = ( max - min ) / float(nsampo)
      var_min = min
      var_max = max

      return
      end
