C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine weight (ntrc, nsamp2, itaper, ep, ballast, wtarray)

c----
c   build weight array for amplitude spectrum (top 1/2 of input rec)
c----
      real    wtarray (nsamp2, ntrc)
      real    maxj, maxi, pi2

      pi2 = 3.14159265 / 2.

c----
c   find center of weight array (beware of odd # samples)
c----
      ic = nsamp2 / 2 + 1
      if (mod(nsamp2,2) .ne. 0) ic = ic + 1
      jc = ntrc / 2
c----
c   find squares of ellipse semi axes
c----
      maxj   = ntrc / 2
      maxi   = nsamp2 / 2
      a2     = maxj ** 2
      b2     = maxi ** 2
      a2b2   = a2 * b2
c----
c   get some tape params
c----
      taper  = itaper
      ltaper = itaper
      frac   = .01 * float(ltaper)

      do  j = 1, ntrc
          do  i = 1, nsamp2
              wtarray (i,j) = 0.0
          enddo
      enddo

      DO  J = 1, ntrc

          do  i = 1, nsamp2

c----
c   get offsets from center of ellipse. Compute angle radius makes
c   with y-axis (i-axis). Compute full radius and radius of x,y point
c   (actual radius of x,y is biased by "ballast" to possibly avoid a
c    zero weight at origin).
c   Then compute weight based on a powering of the fraction of full
c   radius.
c----
              x  = abs ( float (j - jc) )
              y  = abs ( float (i - ic) )
              r  = sqrt ( x * x + y * y )

              IF (r .ne. 0.) THEN
                 if (x .ne. 0.) then
                    theta = atan ( y / x )
                 else
                    theta = pi2
                 endif
                 sin2 = sin ( theta ) ** 2
                 cos2 = cos ( theta ) ** 2
                 fullr  = a2b2 / ( a2 * sin2 + b2 * cos2 )
                 fullr  = sqrt ( fullr )
                 rst    = frac * fullr
                 wt = ( (r + ballast) / fullr) ** ep

                 if (r .le. rst) then
                    wtarray (i,j) = wt
                 elseif (r .gt. rst .AND. r .lt. fullr) then
                    wt = wt * ( abs(fullr - r) / fullr )
                    wtarray (i,j) = wt
                 elseif (r .ge. fullr) then
                    wtarray (i,j) = 0.0
                 endif

              ELSE

                    wtarray (i,j) = ballast

              ENDIF

          enddo
      ENDDO

      return
      end
