C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       COVSRT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      COVSRT  (COVAR,NCVM,MA,LISTA,MFIT)                              *
C  ARGUMENTS:                                                          *
C      COVAR   REAL     ??IOU*  (NCVM,NCVM) -                          *
C      NCVM    INTEGER  ??IOU*              -                          *
C      MA      INTEGER  ??IOU*              -                          *
C      LISTA   INTEGER  ??IOU*  (*)         -                          *
C      MFIT    INTEGER  ??IOU*              -                          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/04/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/04/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine  covsrt (covar, ncvm, ma, lista, mfit)
 
c   given a covariance matrix COVAR of a fit for MFIT of MA parameters, and
c   their ordering LISTA(i), repack the covariance matrix to the true order
c   of the parameters.
c   Elements associated with  fixed parameters will be 0
 
      dimension covar(ncvm, ncvm), lista(*)
 
      do  12  j = 1, ma-1
          do  11  i = j+1, ma
              covar(i,j) = 0.
11        continue
12    continue
 
      do  14  i = 1, mfit-1
          do  13  j = i+1, mfit
              if (lista(j) .gt. lista(i)) then
                 covar(lista(j), lista(i)) = covar(i,j)
              else
                 covar(lista(i), lista(j)) = covar(i,j)
              endif
13        continue
14    continue
 
      swap = covar(1,1)
 
      do  15  j = 1, ma
          covar(1,j) = covar(j,j)
          covar(j,j) = 0.
15    continue
 
      covar(lista(1), lista(1)) = swap
 
      do  16  j = 2, mfit
          covar(lista(j), lista(j)) = covar(1,j)
16    continue
 
      do  18  j = 2, ma
          do  17  i = 1, j-1
              covar(i,j) = covar(j,i)
17        continue
18    continue
 
      return
      end
 
