C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DAGCM(LX,LW,AMP,X,G,idec)
C     A CONFIDENTIAL AMOCO SUBROUTINE
C                            FORTRAN BY KEN PEACOCK        7-19-74
C     DAGCM COMPUTES A MEDIAN GAIN TRACE FOR DIGITAL AUTOMATIC GAIN CONTROL.
C     INPUTS ARE...
C             LX, LENGTH OF X AND G.
C             LW, LENGTH OF ANALYSIS WINDOW, LW ODD.
C             AMP, AMPLITUDE THAT DAGC ACTION TRYS TO MAINTAIN
C             X, INPUT ARRAY.
C     OUTPUT IS...
C             G, GAIN TRACE.
C     PROGRAMMED FOR THE IBM 370/145 COMPUTER.
C     VERSION AS OF 9-24-75.
C
#include <f77/lhdrsz.h>

      real Tolerance

      DIMENSION X(1),G(1), work(SZLNHD), xx(SZLNHD)
      real tmp1(SZLNHD), tmp2(SZLNHD)
      integer key(SZLNHD), ley1(SZLNHD), ley2(SZLNHD)
      logical first

      parameter ( tolerance =  1.0e-30 )
 
      first = .true.
      xmed = 0.0
      LWD2 = LW/2
      ISTO = LWD2+1
      lwf = .1 * lw

      do  i = 1, LX
          g (i) = 1
      enddo

c---
c  find non zero start end samples of trace
c---
      is = 1
      do  i = 1, LX
          if (x(i) .ne. 0.0) then
              is = i
              go to 21
          endif
      enddo
21    continue

      ie = LX
      do  i = LX, is, -1
          if (x(i) .ne. 0.0) then
              ie = i
              go to 22
          endif
      enddo
22    continue

c---
c---
      ii = 0
      do  i = is, ie
          ii = ii + 1
          xx (ii) = abs(x(i))
      enddo
      lxx = ie - is + 1
 
c---
c  extract first half window of data
c---
      DO 1 I=1,ISTO
         work(i) = xx(i)
1     CONTINUE

c---
c  the first instance of medon will actually sort this first window
c  in its entirety
c---
      call medon (ISTO, wnew, first, xmed, key,
     1            work, tmp1, tmp2, ley1, ley2)
      if (xmed .gt. tolerance) then
          g(is) =  amp/xmed
      else
          g(is) = 0.
      endif
 
c---
c  roll down trace
c---
      DO 2 I=2,ISTO
         J = LWD2+I

         wnew = xx(J)
         call medon (J, wnew, first, xmed, key,
     1               work, tmp1, tmp2, ley1, ley2)
         if (xmed .gt. tolerance) then
             g(i+is-1) = amp/xmed
         else
             g(i+is-1) = 0.
         endif
 
    2 continue
 
c---
c  this is probably the bulk of the processing right here as we roll down
c  the trace adding a sample (wnew) and dropping a sample
c---
      ISTA = ISTO+1
      ISTO = LXX-LWD2
      LWD2P1=LWD2+1
 
      DO 3 I=ISTA,ISTO
         K = I+LWD2
         wnew = xx(K)
         call medroll (lw, wnew, first, xmed, key,
     1                 work, tmp1, tmp2, ley1, ley2)
         if (xmed .gt. tolerance) then
            g(i+is-1) = amp/xmed
         else
            g(i+is-1) = 0.
         endif
    3 continue
 
c---
c  now we're rolling off lw/2-1 samples
c---
      ISTA = ISTO+1
      ISTO = LXX

      jj = 0
      DO 4 I=ISTA, ISTO
          jj = jj + 1
          call medoff (jj, lw, xmed, key, work, tmp1)
          if (xmed .gt. tolerance) then
             g(i+is-1) = amp/xmed
          else
             g(i+is-1) = 0.
          endif
    4 continue

 
      RETURN
      END
