C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       MCTVF                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      MCTVF  (LX,X,ITYPE,TDEL,BAND,NFILT,DB,LFMAX,FREQ,F,BUF3,BUF4,   *
C              LF,Y,NTRACE,MXNT,IOTERM,CPUTIM,WALTIM,OPS)              *
C  ARGUMENTS:                                                          *
C      LX      INTEGER  ??IOU*      -                                  *
C      X       REAL     ??IOU*  (MXNT,NTRACE) -                        *
C      ITYPE   INTEGER  ??IOU*      -                                  *
C      TDEL    REAL     ??IOU*      -                                  *
C      BAND    REAL     ??IOU*      -                                  *
C      NFILT   INTEGER  ??IOU*      -                                  *
C      DB      REAL     ??IOU*      -                                  *
C      LFMAX   INTEGER  ??IOU*      -                                  *
C      FREQ    REAL     ??IOU*  (MXNT,4)      -                        *
C      F       REAL     ??IOU*  (*)           -                        *
C      BUF3    REAL     ??IOU*  (MXNT,NTRACE) -                        *
C      BUF4    REAL     ??IOU*  (MXNT,NTRACE) -                        *
C      LF      INTEGER  ??IOU*      -                                  *
C      Y       REAL     ??IOU*  (MXNT,NTRACE) -                        *
C      NTRACE  INTEGER  ??IOU*                -                        *
C      MXNT    INTEGER  ??IOU*                -                        *
C      IOTERM  INTEGER  ??IOU*                -                        *
C      CPUTIM  REAL     ??IOU*  (*)           -                        *
C      WALTIM  REAL     ??IOU*  (*)           -                        *
C      OPS     REAL*8   ??IOU*  (*)           -                        *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 87/03/11  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 87/03/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      INTD -                                                          *
C      HILC -                                                          *
C      TIMSTR -                                                        *
C      TIMEND -                                                        *
C      MFOLD  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      COS     GENERIC -                                               *
C      SIN     GENERIC -                                               *
C  FILES:                                                              *
C      IOTERM  ( OUTPUT SEQUENTIAL ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C***********************************************************************
      SUBROUTINE MCTVF(LX,X,ITYPE,TDEL,BAND,NFILT,DB,LFMAX,FREQ,F,      CTV01000
     1                 BUF3,BUF4,LF,Y,NTRACE,MXNT)
C     A CONFIDENTIAL AMOCO SUBROUTINE                                   CTV03000
C             FORTRAN BY KEN PEACOCK  8-24-83.                          CTV04000
C     CTVF APPLIES THE HILBERT TRANSFORM HIGHCUT FILTER TO THE INPUT    CTV05000
C     DATA.  INPUT PARAMETERS CONSIST OF THE FREQUENCY ARRAY AND ROLLOFFCTV06000
C     BAND.  THIS VERSION USES THE EMPIRICAL EQUATIONS OF REPORT F83-E- CTV07000
C     10.                                                               CTV08000
C     INPUTS ARE...                                                     CTV09000
C        LX, LENGTH OF X ARRAY.                                         CTV10000
C        X, THE INPUT ARRAY.                                            CTV11000
C        ITYPE, TYPE OF WEIGHTING, 1 = ROSS, 2 = BESSEL.                CTV12000
C        TDEL, SAMPLE INCREMENT, IN SECONDS, NOTE THAT THE HIGHEST      CTV13000
C             FREQUENCY PERMITTED IN THE INPUT IS 1/2 NYQUIST.  THAT IS CTV14000
C             THE DATA MUST NOT HAVE FREQUENCY CONTENT IN THE UPPER HALFCTV15000
C             RANGE.                                                    CTV16000
C        BAND, ROLLOFF INTERVAL, IN HERTZ.                              CTV17000
C        NFILT, NEW FILTER CODE, 1= NEW FILTER.                         CTV18000
C        DB, MINIMUM REJECTION FOR THE REJECT BAND.                     CTV19000
C        LFMAX, MAXIMUM LENGTH FOR HILBERT OPERATOR, IN SAMPLES.        CTV20000
C     INPUT/BUFFER IS...                                                CTV21000
C        FREQ, LX-LENGTH INSTANTANEOUS FREQUENCY ARRAY, SUBSEQUENTLY    CTV22000
C             USED AS BUFFER.                                           CTV23000
C     BUFFERS ARE...                                                    CTV24000
C        F, LFMAX-LENGTH BUFFER.                                        CTV25000
C        BUF2, LX-LENGTH BUFFER.                                        CTV26000
C        BUF3, LX+LFMAX-1 LENGTH BUFFER.                                CTV27000
C        BUF4, LX+LFMAX-1 LENGTH BUFFER.                                CTV28000
C     OUTPUTS ARE...                                                    CTV29000
C        LF, LENGTH OF HILBERT OPERATOR.                                CTV30000
C             IF LF = LFMAX, THE FILTER WILL NOT MEET CRITERIA.  IF THISCTV31000
C             IS NOT ACCEPTABLE, UP LFMAX, LOWER DB, OR INCREASE BAND.  CTV32000
C        Y, THE LX-LENGTH OUTPUT SIGNAL.                                CTV33000
C     PROGRAMMED FOR THE IBM 370/158 COMPUTER.                          CTV34000
C     VERSION AS OF 8-24-83.                                            CTV35000
C                                                                       CTV36000
      DIMENSION X(MXNT,NTRACE),Y(MXNT,NTRACE)                           CTV37000
      DIMENSION BUF3(MXNT,NTRACE),BUF4(MXNT,NTRACE)                     CTV37000
C
      DIMENSION F(*),FREQ(MXNT,4)                                       CTV37000
C_______________________________________________________________________
C     BUFFER A IS FOR INTD                                              CTV39000
C_______________________________________________________________________
      DIMENSION A(31)                                                   CTV38000
C
      IF(NFILT.EQ.1) THEN                                               CTV40000
C_______________________________________________________________________
C        INITIALIZE
C_______________________________________________________________________
         FACT = 2.*3.1415927                                            CTV41000
         CALL INTD(LX,FREQ(1,1),1,TDEL,3.,31,A,FREQ(1,2))               CTV42000
         DO 77 I=1,LX                                                   CTV43000
          FREQ(I,2) = FREQ(I,2)*FACT                                    CTV44000
77       CONTINUE
         EX = -1.1440+.0048880*DB**1.768                                CTV45000
         IF(ITYPE.EQ.2)EX = -8.4948+2.0913*DB**.470                     CTV46000
         IF(EX.LT.0.)EX = 0.                                            CTV47000
         LF = (-.22527+.010129*DB**1.552)/(BAND*TDEL)                   CTV48000
         IF(ITYPE.EQ.2) LF = (-.63196+.080371*DB**.973)/(BAND*TDEL)     CTV49000
         LF = LF/2*2+1                                                  CTV50000
         IF(LF.GT.LFMAX) LF= LFMAX                                      CTV51000
         CALL HILC(LF,ITYPE,TDEL,EX,F)                                  CTV52000
         DO 5 I=1,LX                                                    CTV53000
          FREQ(I,1) = COS(FREQ(I,2))                                    CTV54000
          FREQ(I,2) = SIN(FREQ(I,2))                                    CTV55000
5        CONTINUE
C_______________________________________________________________________
C        SCALE FREQ(I,1) AND FREQ(I,2) BY TDEL FOR POSTFILTERING.
C_______________________________________________________________________
         DO 50 I=1,LX                                                   CTV53000
          FREQ(I,3) = FREQ(I,1)*TDEL                                    CTV54000
50       CONTINUE
         DO 55 I=1,LX                                                   CTV53000
          FREQ(I,4) = FREQ(I,2)*TDEL                                    CTV55000
55       CONTINUE
      ENDIF
C
C_______________________________________________________________________
C     LOOP 4000 IS A MATRIX VECTOR MULTIPLY.
C_______________________________________________________________________
      DO 4000 ITRACE=1,NTRACE
       DO 3 I=1,LX                                                      CTV56000
        Y(I,ITRACE) = X(I,ITRACE)*FREQ(I,1)                             CTV57000
        X(I,ITRACE) = X(I,ITRACE)*FREQ(I,2)                             CTV58000
3      CONTINUE
4000  CONTINUE
C
      CALL MFOLDF(LX,Y,LF,F,LY,BUF3,MXNT,NTRACE)
      CALL MFOLDF(LX,X,LF,F,LY,BUF4,MXNT,NTRACE)
C_______________________________________________________________________
C     LOOP 5000 IS TWO MATRIX VECTOR MULTIPLIES.
C_______________________________________________________________________
      DO 5000 ITRACE=1,NTRACE
       JFACT = LF/2                                                     CTV61000
       DO 4 I=1,LX                                                      CTV62000
        J = I+JFACT                                                     CTV63000
        Y(I,ITRACE) =  -FREQ(I,4)*BUF3(J,ITRACE)                        CTV64000
     1                 +FREQ(I,3)*BUF4(J,ITRACE)
4      CONTINUE
5000  CONTINUE
C
      RETURN                                                            CTV65000
      END                                                               CTV66000
