C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c     Program to compute forward and inverse DFT
c
c
c     For Forward Transform:
c     Input = USP formated data set
c     Output = USP Formated Data Set with each sample 
c     representing a frequency band.  The first half
c     of the data file is amplitude the second half phase.
c
c
c     For Inverse Transform:
c     Just like the Forward except vice versa.      
c
c     James Gridley
c     USP Team
c     Tulsa OK
c     Winter 1997/98

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, argis

      character   ntap*255, otap*255, name*4

      logical     verbos, Inverse, Gaus, Forward

c Program Specific _ dynamic memory variables

      integer RecordSize1, HeaderSize, errcd1, errcd2, errcd3, abort
      integer Headers, RecordSize2, RecordSize3

      real    Record, Space, faze, amp
      real    Out_Data
      real    t(SZLNHD), stable(SZLNHD), inv_stable(SZLNHD)
      real    pie, radeg

      complex csum
      complex cdata(SZLNHD*2)

      pointer (memadr_Record, Record(200000))
      pointer (memadr_Space, Space(200000))
      pointer (memadr_Headers, Headers(200000))
      pointer (memadr_faze, faze(200000))
      pointer (memadr_amp, amp(200000))

      pointer (memadr_Out_Data, Out_Data(200000))


c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor

      integer hdr_index, tr_index, JJ, KK

      real    fmin, fmax, fint, unit_scale

c Initialize variables

      data abort/1/
      data name/"DFT"/

      pie = 4.0 * atan(1.0) 
      radeg = 180. / pie
      csum = (0., 0.)
      Forward = .false.
      Inverse = .false.
      
c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos, fmin, fmax, fint, Inverse, 
     :     Gaus, itw )
   
c get the logicals set  up

      if (Inverse) Forward=.false.
      if (.not. Inverse) Forward=.true.
      

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'DFT: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      if (Forward) then
         
         call saver(itr, 'NumSmp', nsamp, LINHED)
         call saver(itr, 'SmpInt', nsi  , LINHED)
         call saver(itr, 'NumTrc', ntrc , LINHED)
         call saver(itr, 'NumRec', nrec , LINHED)
         call saver(itr, 'Format', iform, LINHED)
         call saver(itr, 'UnitSc', unit_scale, LINHED)
         
c     Policeman for Unit Scale (will assume miliseconds)
         
         if (unit_scale .eq. 0.) unit_scale=0.001
         
      endif

      if (Inverse) then
         call saver(itr, 'SmpInt', nsi  , LINHED)
         call saver(itr, 'NumTrc', ntrc , LINHED)
         call saver(itr, 'NumRec', nrec , LINHED)
         call saver(itr, 'Format', iform, LINHED)
         call saver(itr, 'UnitSc', unit_scale, LINHED)
         call saver(itr, 'NumRec', nreco, LINHED)

         call saver(itr, 'NumSmp', Num_Freqs, LINHED)
         Num_Freqs=Num_Freqs/2
         call saver(itr, 'NumCmp', nsamp, LINHED)
         call saver(itr, 'NmSpMi', v1, LINHED)
c         fmin = int (v1)
         fmin =  (v1)
         call saver(itr, 'SmpFlt', v1, LINHED)
c         fmax = int (v1)
         fmax =  (v1)
         call saver(itr, 'HrzNul', v1, LINHED)
c         fint = int (v1)
         fint =  (v1)

c     Policeman for Unit Scale (will assume miliseconds)
               
         if (unit_scale .eq. 0.) unit_scale=0.001
         
      endif
      
c     print HLH to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)
      
c     check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1
c=======================================================================
c     Set the frequency interval to the correct number of
c     frequencies based on the length of the time series.
c     This is the automated aspect.

      if (Forward) then
         if (fmax .le. 0. ) then
            fmax=(1./nsi)*(1./unit_scale)*0.5
         endif
         
         if (fint .eq. 0. ) then
            fint =  (1./unit_scale)/(float(nsamp-1)*float(nsi))
         endif         
      endif
      
c     Policeman
      if (Forward) then
         if (fint .gt. (1./unit_scale)/(float(nsamp-1)*float(nsi))) then
            write(LERR,*)' '
            write(LERR,*)'DFT: WARNING, Frequency Sample is ALIASED!'
            write(LERR,*)'     User wants ',fint,' Should be', 
     :           (1./unit_scale)/(float(nsamp-1)*float(nsi))
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'DFT: WARNING, Frequency Sample is ALIASED!'
            write(LER,*)'     User wants ',fint,' Should be', 
     :           (1./unit_scale)/(float(nsamp-1)*float(nsi))
            write(LER,*)' '
         endif
      endif
c=======================================================================
c     
      if (Forward) then
         Num_Freqs = ((fmax-fmin)/fint)+1    
         write(LER,*)Num_Freqs,' Frequency Intervals at',fint
         write(LERR,*)Num_Freqs,' Frequency Intervals at',fint
      endif

c     modify line header to reflect actual record configuration output
c     NOTE: in this case the trace and sample limits are used to 
c     limit processing only.   All data within the selected record
c     range are actually passed.
      
      if (Forward) then
      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumSmp', Num_Freqs*2, LINHED)
      call savew(itr, 'NumCmp', nsamp, LINHED)
c     call savew(itr, 'NmSpMi', float(fmin), LINHED)
c     call savew(itr, 'SmpFlt', float(fmax), LINHED)
c     call savew(itr, 'HrzNul', float(fint), LINHED)
      call savew(itr, 'NmSpMi', fmin, LINHED)
      call savew(itr, 'SmpFlt', fmax, LINHED)
      call savew(itr, 'HrzNul', fint, LINHED)
      endif

      if (Inverse) then
         call savew(itr, 'NumSmp', nsamp, LINHED)
      endif

c number output bytes
      if (Forward) 
     :     obytes = SZTRHD + SZSMPD * Num_Freqs * 2
      if (Inverse)
     :     obytes = SZTRHD + SZSMPD * nsamp

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, verbos)

c dynamic memory allocation:  
      if (Forward) then
         RecordSize1 = ntrc * nsamp 
         RecordSize2 = ntrc * Num_Freqs 
         RecordSize3 = ntrc * Num_Freqs * 2
      endif
      if (Inverse) then
         RecordSize1 = ntrc * Num_Freqs * 2
         RecordSize2 = ntrc * Num_Freqs
         RecordSize3 = ntrc * nsamp
      endif
      HeaderSize = ntrc * ITRWRD 
c=======================================================================
      call galloc (memadr_Record, RecordSize1 * SZSMPD, errcd1, abort)
      call galloc (memadr_Space, RecordSize1 * SZSMPD, errcd2, abort)
      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcd3, abort)
      call galloc (memadr_amp, RecordSize2  * SZSMPD, errcd4, abort)
      call galloc (memadr_faze, RecordSize2  * SZSMPD, errcd5, abort)
      call galloc (memadr_Out_Data, RecordSize3 * SZSMPD, 
     :     errcd6, abort)

      
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
     
      call vclr ( Record, 1, RecordSize1 )
      call vclr ( Space, 1, RecordSize1 )
      call vclr ( Headers, 1, HeaderSize )
      call vclr ( amp, 1, RecordSize2 )
      call vclr ( faze, 1, RecordSize2 )
      call vclr ( Out_Data, 1, RecordSize3 )
  
    
c======================================================================
c     set up a table for the forward DFT this will
c     help reduce the number of calculations
      
      if (Forward) then
         do i = 1, nsamp
            stable(i) = 2. * pie * float(nsi) * unit_scale * (i-1)
c     set taper to 1.0 as a safety
            t(i)=1.
         enddo
      endif

      if (Inverse) then
         do i = 1, Num_Freqs
            inv_stable(i) = 2. * pie * ( float(i-1) * fint  + fmin)
         enddo
      endif
c======================================================================
c     taper

        if (Forward) then
           call taper( nsamp, ntrc, ist, iend, fmin, 
     :          fmax, fint, nsi, nsamp2, t, Gaus, itw)
        endif

c======================================================================


c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c load record to memory
         
         if (Forward) then
            tr_index = 1 - nsamp
         elseif (Inverse) then
            tr_index = 1 - Num_Freqs*2
         endif
         
         hdr_index = 1 - ITRWRD
         
         DO KK = 1, ntrc
             
             nbytes = 0
            call rtape( luin, itr, nbytes)
            
c     if end of data encountered (nbytes=0) then bail out
            
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
            
c     set array load points for this trace 
            if (Forward) then
               tr_index = tr_index + nsamp
            elseif (Inverse) then
               tr_index = tr_index + Num_Freqs*2
            endif
            hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

           call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :          TRACEHEADER )

           if ( StaCor .ne. 30000 ) then

c load trace to array Record[]
              if (Forward) then
              call vmov ( itr(ITHWP1), 1, Record(tr_index), 1, nsamp )
              elseif (Inverse) then
                 call vmov ( itr(ITHWP1), 1, Record(tr_index), 
     :                1, Num_Freqs*2 )
              endif
           else
              if (Forward) then
                 call vclr ( Record(tr_index), 1, nsamp )
              elseif (Inverse) then
                 call vclr ( Record(tr_index), 1, nsamp )
              endif
           endif

c load trace header to array Headers[]

            call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )

         ENDDO
c	write(6,*)  ntrc,ist,iend,fmin,fmax,fint,nsi,Num_Freqs
c======================================================================
c     The Transform Part
        
         if (Forward) then
            call forward_dft ( Record, Headers, Space, nsamp, 
     :           ntrc, ist, iend, fmin, fmax, fint, nsi, Num_Freqs,
     :           amp, faze, Out_Data, unit_scale, stable, t)
        
         endif
         
         if (Inverse) then
   
            call inverse_dft ( Record, Headers, Space,  nsamp, 
     :           ntrc, ist, iend, fmin, fmax, fint, nsi, Num_Freqs,
     :           amp, faze, cdata, unit_scale, inv_stable, Out_Data )
         endif
c======================================================================
c     reset array load points for this trace 
         
         
         if (Forward) then
            tr_index = 1 - Num_Freqs*2
         elseif (Inverse) then
            tr_index = 1 - nsamp
         endif
         
         
         hdr_index = 1 - ITRWRD
         
c     write output data
         
         DO KK = 1, ntrc
            if (Forward) then
               tr_index = tr_index + Num_Freqs*2
               elseif (Inverse) then
                  tr_index = tr_index + nsamp
            endif

            hdr_index = hdr_index + ITRWRD
            
            if (Forward) then
               call vmov ( Out_Data(tr_index), 1, itr(ITHWP1), 
     :              1,Num_Freqs*2 )
               elseif (Inverse) then
                  call vmov ( Out_Data(tr_index), 1, itr(ITHWP1), 
     :                 1,nsamp )
            endif
            
            call vmov ( Headers(hdr_index), 1, itr(1), 1, ITRWRD )
            call wrtape (luout, itr, obytes)
            
         ENDDO
      ENDDO

c     close data files 
      
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'dft: Normal Termination'
      write(LER,*)'dft: Normal Termination'
      stop
      
 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'dft: ABNORMAL Termination'
      write(LER,*)'dft: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for DFT: USP template'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-fmin[]  -- minimum frequency              (0 hz)'
      write(LER,*)'-fmax[]  -- maximum frequency  (0 yields Nyquist)'
      write(LER,*)'-fint[] -- frequency interval (ommit and module  '
      write(LER,*)'                will calcualte the optimum value)'
      write(LER,*)'-taper[]  -- percent taper (100=total taper,  0%)'
      write(LER,*)'-G  -- Apply a Gaussian Taper       (no % needed)'
      write(LER,*)'-R  -- Perform Inverse Transform'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       dft -N[] -O[] -s[] -e[] -rs[] -re[] '
      write(LER,*)'         -fmin[] -fmax[] -fint[] -taper -G -R -V'
      write(LER,*)' '
      write(LER,*)'================================================='

      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos,  fmin, fmax, fint, Inverse, Gaus,
     :     itw)

#include <f77/iounit.h>
      real       fmin, fmax, fint
      
      integer    ist, iend, irs, ire, argis, itw

      character  ntap*(*), otap*(*), name*(*)

      logical    verbos, Gaus, Inverse

           call argi4 ( '-e', iend, 0, 0 )
           
           call argr4( '-fint', fint,0.,0.)
           call argr4( '-fmax', fmax,0.,0.)
           call argr4( '-fmin', fmin,0.,0.)
           Gaus  = (argis('-G') .gt. 0)
          
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )
           Inverse = (argis('-R') .gt. 0)
           call argi4 ( '-s', ist, 1, 1 )
           call argi4 ( '-taper', itw, 0, 0)
           verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, verbos)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, nsi

      character  ntap*(*), otap*(*)

      logical    verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





