C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dginit (dt,dx,vel,zd,pct,epsilon,ntrc,nsamp,
     1                   nsmp4,ntrc4,nsmpe,ntrce,ntro,ift,ifx,d4,t4)

#include <f77/iounit.h>

      integer    ntrc,nsamp,ntrc4,nsmp4,ntrce,nsmpe,ntro,ift,ifx
      integer    ordfft
      real       dt,dx,zd,pct,epsilon,tgh,d4,t4


      nu = ordfft (ntrc)
      ntrc4 = 2 ** nu
      nu = ordfft (nsamp)
      nsmp4 = 2 ** nu
      left  = ntrc4 - ntrc
      ntro  = aint ( .5*float(left) )
      d4 = ntrc4 * dx
      t4 = nsmp4 * dt
      tgh = 2. * zd/vel
      r  = 1. - epsilon

      ift = 2**aint(4*tgh/(epsilon*t4))
      ifx = 2**aint(8*vel*tgh/(epsilon*d4))
      ift = 1
      ifx = 1
      ntrce = ifx * ntrc4
      nsmpe = ift * nsmp4

      write(LERR,*)' '
      write(LERR,*)'Initialization of dimensions'
      write(LERR,*)'ntrc:         = ',ntrc
      write(LERR,*)'ntrc4:        = ',ntrc4
      write(LERR,*)'ntrce:        = ',ntrce
      write(LERR,*)'nsamp:        = ',nsamp
      write(LERR,*)'nsmp4:        = ',nsmp4
      write(LERR,*)'nsmpe:        = ',nsmpe
      write(LERR,*)'ntro:         = ',ntro
      write(LERR,*)'d4:           = ',d4
      write(LERR,*)'t4:           = ',t4
      write(LERR,*)'ift:          = ',ift,'  time dimension scaler'
      write(LERR,*)'ifx:          = ',ifx,'  space dimension scaler'
      write(LERR,*)'Ghost time    = ',1000.*tgh,'  ms'

      return
      end
