C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - DIPFEB90 (VECTOR)                  ENTRY .MAIN      * C
C *                                                                  * C
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *                                                                  * C
C *     GENERATE AND APPLY A TWO-DIMENSIONAL FILTER IN X-T           * C
C *     SPACE.                                                       * C
C *     ALGORITHM DERIVED BY TIM SCHEUER AND RICHARD CRIDER          * C
C *     ALGORITHM BASED ON PAPER BY CASSANO AND ROCCA, GEOPH.        * C
C *     PROSPECTING, 22, 330-344, 1974 AFTER-STACK MULTICHANNEL      * C
C *     FILTERS WITHOUT MIXING EFFECTS.                              * C
C *                                                                  * C
C *   MODIFICATION HISTORY -                                         * C
C *     11/03/86 BY DAVID LEWIS                                      * C
C *       1) MODIFIED DIPF TO PROCESS IRREGULARLY SAMPLED(SPATIAL)   * C
C *          DATA.                                                   * C
C *       2) CONVOLUTIONS ARE DONE IN THE FREQUENCY DOMAIN RATHER    * C
C *          THAN THE TIME DOMAIN.                                   * C
C *       3) FORMAT CONVERSION IS DONE IN THE AP RATHER THAN CPU.    * C
C *       4) FIXED MISCELLANEOUS ERRORS.                             * C
C *                                                                  * C
C *     03/27/87 BY DAVID LEWIS                                      * C
C *       1) DELETED CODE FOR PROCESSING IRREGULARLY SAMPLED         * C
C *          (SPATIAL) DATA.                                         * C
C *       2) MODIFIED THE WATER BOTTOM TRACKING OPTION.              * C
C *          ALSO, MADE CORRECTIONS TO THE WATER BOTTOM CODE.        * C
C *       3) HANDLE DEAD TRACES CORRECTLY.                           * C
C *                                                                  * C
C *     06/88 BY RICHARD CRIDER                                      * C
C *          (1) IMPLEMENTED TIME VARIANT OPTION                     * C
C *          (2) IMPLEMENTED DIP ENHANCEMENT OPTION                  * C
C *          (3) IMPLEMENTED SPATIAL INTERPOLATION OF TIME WINDOWS   * C
C *     09/88 BY RICHARD CRIDER                                      * C
C *          MISCELLANEOUS CHANGES                                   * C
C *     11/88 BY RICHARD CRIDER                                      * C
C *          PICK UP SIGN OF TRACE DISTANCE FROM LIVE TRACES ONLY    * C
C *     12/88 BY RICHARD CRIDER                                      * C
C *          INCREASE # SAMPLES PER FILTER TRACE TO 513 TO BETTER    * C
C *          HANDLE STEEP DIPS.                                      * C
C *     01/89 BY RICHARD CRIDER                                      * C
C *          INSTITUTED LOGIC SPECIFIC TO SPLIT-SPREAD PROCESSING    * C
C *          TO CORRECT MANY PROBLEMS IN PREVIOUS CODE.              * C
C *     09/90 BY joe m. wade                                         * C
C *          Change logic to leave dead traces off of the output     * C
C *          tape. Change call to hlh to hlhprt. Delete ccexit       * C
C *          (use one in libut library.)                             * C
C *     12/90 BY joe m. wade                                         * C
C *          Change logic to compensate for taper-in and taper-out   * C
C *          effects. Richard Crider is the one ultimately, since    * C
C *          I just entered the changes verbatim from what he gave   * C
C *          me.                                                     * C
C *                                                                  * C
C *   UTILITY SUBROUTINES CALLED -                                   * C
C *     RTAPE     MOVE     GAMOCO     ITOFP        HLH               * C
C *     WRCARD   LBOPEN    CCEXIT                                    * C
C *     BLDRMP   RZEROS    RSTORE    LBOPEN       ALLOCS             * C
C *    QTC SUBROUTINES CALLED -                                      * C
C *     VCLR      VSMUL     VMOV      VADD         CVMUL             * C
C *     SCRFT     SRCFT     VRAMP     VRVRS         VMUL             * C
C *                                                                  * C
C ******************************************************************** C
C
#include <f77/localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
      integer argis
      integer ntrs, npts, frtp, lrtp, ialias, istak, iearly, iplf
      integer IALLWD, ltvar, inter,ipfl

      parameter (IALLWD = 8192 + ITRWRD )

      REAL      RDATA(IALLWD), TRIRMP(97)
      real      TRI(6000)
      REAL      SUM(6000),NRAMP(6000),WGHT(10)
      REAL      DDMX(20),DDMI(20),DDNS(20)
      REAL      UDMX(20),UDMI(20),UDNS(20)
      REAL      TENH(6000)
c
      character ntap*256, otap*256, cardin*256
      character name*4

      complex fin,fltt,xsum
      real wbsav,temp,tdata
      pointer(mfin, fin(1))
      pointer(mfltt, fltt(1))
      pointer(mxsum, xsum(1))
      pointer(mwbsav, wbsav(1))
      pointer(mtemp, temp(1))
      pointer(mtdata, tdata(1))
C
      INTEGER ERRKNT,JDATA(IALLWD),IWBSMP(47),WBBIAS,WBB2
      INTEGER FTYPE(40),STIME,ETIME
      INTEGER STIME1,ETIME1,STIME2,ETIME2
      INTEGER STRTT(20),ENDT(20)
      INTEGER AREC(10),BREC(10),BSTRTT(10),BENDT(10)

#ifndef CRAYSYSTEM
      INTEGER*2 I2NPUT(12128), IHDRS
#else
      INTEGER I2NPUT(6128), IHDRS
#endif

      integer LUCRD
C
      DIMENSION INPUT(IALLWD),F(513,94),HDRS(ITRWRD,47)
C
      character KARD*80,CARD1*80,CARD2*80,CRDID1*5
      CHARACTER FCTYP(2)*6,FC*6,MT(3)*22
      CHARACTER*5 ID1,CRDID2,ID,DUM1,DUM2,DUM3,DUM4,NA
      CHARACTER*50 MODH
      CHARACTER*4  TITLE,ABOV,BELO
      CHARACTER*1  ATITLE(13),BTITLE(66)
C
      COMMON/NMDFF/NS,IFLIP,ITLEN,NSR
      COMMON/FLDFF/NPTS,NTRS,IHDRS(128,47)
      COMMON/PERIPH/LUI,LUO,LUD1,LUD2,IPR,LBYTE,NS4
      COMMON/SPRED1/DDMX,DDMI,DDNS,UDMX,UDMI,UDNS,NPTNTR,LTVAR
      COMMON/SPRED2/DELSRC(2,10),LZEROS(47),
     *              WVEL,WBBIAS,WBB2,NRAMP
      COMMON/SPRED3/IOKNT,NIT,KNT,IC,IEND,JKNT,IO
C
      EQUIVALENCE (RDATA(1),INPUT(1),I2NPUT(1))
      equivalence (RDATA(ITHWP1),TRI(1))
      EQUIVALENCE (HDRS(1,1),IHDRS(1,1))
C
      integer errcod, abort

      logical verbos, query, cflag
      logical   heap
      LOGICAL   ALOKTD
      LOGICAL   NEW
      LOGICAL   RESET,EOC

      data abort / 0 /
      save abort

      DATA TITLE/'DIPF'/,ABOV/'ABOV'/,BELO/'    '/,
     &     ATITLE/'D','I','P',' ','F','I','L','T','E','R','I','N','G'/,
     &     BTITLE/66*' '/,CRDID1/'1DIPF'/,ERRKNT/0/,
     &     CHG/2.0/,NCRD/0/,IHCH/0/,CRDID2/'2DIPF'/
      DATA IGO/0/,FCTYP/'REJECT',' PASS '/
      DATA MT/'LINE SEQUENTIAL MODE  ','RECORD SEQUENTIAL MODE',
     *'SPLIT-SPREAD MODE     '/
      DATA NSETMX/10/,IWGHT/0/,NA/' N/A '/
      data aloktd /.FALSE./
      DATA NEW/.FALSE./,RESET/.TRUE./,EOC/.FALSE./
      data name/'DIPF'/
      data LUCRD/22/

cc       check for help flag
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
         call help()
         stop
      endif

cc       open printout file

#include <f77/open.h>

      ntap = ' '
      otap = ' '

      call gcmdln ( ntap, otap, cardin, cflag, verbos, LUCRD )

      icntap = 0
      KNT=0
      JKNT=0
      IO=0
      IC=0
      IOKNT=0
      IEND=0
      IPR = LERR
      LUI = 7
      LUO = 8
      LUD1=10
      LUD2=11
      luc=20

c open temporary scratch file

      open(unit=luc,access='direct',recl=80,status='SCRATCH')

      CALL MOVE (1,BTITLE(21),ATITLE,13)
      
      if(verbos) then
        CALL GAMOCO (BTITLE,1,IPR)
      endif

c open input datastream 

      call getln (LUI,ntap,'r',0)

c read input line header

      NIT = 0

      CALL RTAPE (LUI, INPUT, NIT)

      IF (NIT.NE.0) GO TO 1501
      WRITE(IPR,700)
      write(LER,700)
  700 FORMAT(/,18X,'** M0001 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'END OF FILE ENCOUNTERED ATTEMPTING TO READ LINE HEADER FROM',/,
     *14X,'INPUT DATA SET (NTAP).')
      IC = 100
      CALL CCEXIT (IC)

 1501 CONTINUE

c get global parameters from line header

      call saver (input, 'NumSmp', nsamp , LINHED )
      call saver (input, 'SmpInt', nsi   , LINHED )
      call saver (input, 'NumTrc', ntrc  , LINHED )
      call saver (input, 'NumRec', nrec  , LINHED )
      call saver (input, 'Format', iform , LINHED )
      call saver(input, 'UnitSc', unitsc, LINHED)

      if (unitsc .eq. 0.0) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         unitsc = .001
         call savew(input, 'UnitSc', unitsc, LINHED)
      endif

      J = 4
c  - new call specifies unit for hlh sysout - j.m.wade 10/01/90
      CALL HLHLU (IPR)
      CALL HLH (INPUT,NIT,TITLE,J)
      IACT = 1
      IFMT  = iform
      IOFMT = IFMT
C +-----------------------------+
C |  GET INPUT TAPE PARAMETERS  |
C +-----------------------------+
      NSR    = nsi
      SR     = FLOAT(NSR)
      NS     = nsamp

c POLICEMAN - at the moment arrays are hardwired to 6000 samples max
c             so watch out for datasets longer than that.
c
      IF(NS.GT.6000)THEN
         WRITE(IPR,775)NS
         WRITE(LER,775)NS
  775 FORMAT(/,18X,'** M0775 ** ERROR DETECTED IN MAIN PROGRAM.',
     */,14X,'THE NUMBER OF SAMPLES PER TRACE ( ',I5,' ) ON THE INPUT ',
     */,14X,'DATA SET EXCEEDS THE PROGRAM MAXIMUM OF 6000.',
     */,14X,'REDUCE THE NUMBER OF SAMPLES PER TRACE BEFORE',
     *' RESUBMITTING YOUR JOB.')
         ERRKNT=ERRKNT+1
         IC=100
      ENDIF

      NS4    = NS*ISZBYT
      NTPR   = ntrc
      IHLFSP = NTPR/2
      NRECDS = nrec
      call saver (input,'WatVel',iwatvel,LINHED)
      WVEL   = float(iwatvel) / 1000.0
      WBBIAS = 96 / NSR
      WBB2   = WBBIAS / 2
      CALL BLDRMP (NSR,IPR)
C
C ******************************************************************** C
C *    PARAMETER DESCRIPTION                                         * C
C *                                                                  * C
C *    1DIPF CARD:                                                   * C
C *       NTRS  -  NUMBER OF TRACES IN THE FILTER                    * C
C *       NPTS  -  NUMBER OF POINTS PER FILTER TRACE                 * C
C *       FRTP  -  FIRST RECORD TO PROCESS                           * C
C *       LRTP  -  LAST RECORD TO PROCESS                            * C
C *      IALIAS -  ALLOW FILTER TO ALIAS                             * C
C *                0 = NO  1 = YES                                   * C
C *       ISTAK -  STACKED DATA FLAG                                 * C
C *                0 = YES 1 = NO 2 = SPLIT-SPREAD                   * C
C *      IEARLY -  PRESERVE EARLY MUTE                               * C
C *                0 = YES   1 = NO                                  * C
C *      IPLF   -  PRESERVE LOW FREQUENCIES                          * C
C *                0 = YES   1 = NO                                  * C
C *      LTVAR  -  TIME VARIANCE FLAG                                * C
C *                0 = NONE                                          * C
C *                1 = GATED                                         * C
C *                2 = (PSEUDO) CONTINUOUS                           * C
C *      INTER  -  INTERPOLATE TIMES IN TIME VARIANT CASE            * C
C *                0 = NO    1 = YES                                 * C
C *      IPFL   -  PRINT FILTERS (UNDOCUMENTED  IN CC 80)            * C
C *                0 = NO    1 = YES                                 * C
C *                                                                  * C
C *    2DIPF CARD:                                                   * C
C *      STRTT  -  START TIME FOR FILTER APPLICATIO                  * C
C *       ENDT  -  END TIME FOR FILTER APPLICATION                   * C
C *                (IGNORED FOR CONTINUOUSLY VARIANT APPLICATION)    * C
C *       DDMX  -  DOWN DIP MAX. STEPOUT                             * C
C *       DDMI  -  DOWN DIP MIN. STEPOUT                             * C
C *       DDNS  -  NOISE TO SIGNAL RATIO (DOWN DIP)                  * C
C *       UDMX  -  UP   DIP MAX. STEPOUT                             * C
C *       UDMI  -  UP   DIP MIN. STEPOUT                             * C
C *       UDNS  -  NOISE TO SIGNAL RATIO (UP   DIP)                  * C
C *       IPASS -  PASS/REJECT FLAG                                  * C
C *                0 = REJECT 1 = PASS                               * C
C *        WGHT -  DIP ENHANCEMENT WEIGHT                            * C
C *       AREC  -  RECORD AT WHICH FIRST TIMES APPLY                 * C
C *     BSTRTT  -  START TIME FOR FILTER APPLICATION                 * C
C *                AT NEW LOCATION (FOR INTERPOLATION)               * C
C *      BENDT  -  END TIME FOR FILTER APPLICATION                   * C
C *                AT NEW LOCATION (FOR INTERPOLATION)               * C
C *       BREC  -  RECORD TO INTERPOLATE TO                          * C
C ******************************************************************** C
C +------------------------------------+
C | TOP OF CARD CHECK ERROR SCAN LOOP  |
C +------------------------------------+

      K1=1
      K2=0
      KTOT=0
      IP = 1
      NSETS=1

    1 CONTINUE

      IF (K1.GE.201) THEN
         WRITE (IPR,777)
         WRITE (LER,777)
  777 FORMAT(/,18X,'** M0021 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE NUMBER OF PARAMETER CARD SETS HAS EXCEEDED 200.',/,14X,
     *'SELECT PROPER PARAMETERS BEFORE RESUBMITTING YOUR JOB.')
         ERRKNT = ERRKNT+1
         IC = 100
      ENDIF

      IF(K1.GT.1)IP=3
      IF(NEW)GO TO 6
C +------------------+
C |  READ DATA CARD  |
C +------------------+

      if(verbos) write(LERR,*)' reading CARD1 from LUCRD'
      READ(LUCRD,399,END=300,ERR=303,iostat=ios) CARD1
 399  FORMAT(A80)

      if(verbos) write(LERR,*) ' CARD1 read'
      write(LERR,*) CARD1

    6 CONTINUE

      IF(EOC)GO TO 300

      if(verbos) write(LERR,*)' reading with format 400 '
      READ(CARD1,400,ERR=123)ID1,DM1,DM2,DM3,DM4,DM5,DM6,
     *  JTRS,JPTS,EXP,FRTP,LRTP,IWFLG,IALIAS,
     *  JSTAK,IPASS,JEARLY,IPLF,LTTVAR,INTER,IPFL
  400 FORMAT (  A5, 2(2F5.0,F3.0),
     *        I2, I4, F3.0, 2I5, 3X, 5I1,T63,I4,1X,2I1,T80,I1)

      go to 1123

  123 write(LERR,*)' error reading CARD1 with format 400'

      call ccexit (123)

 1123 continue

      if(verbos) then
        write(LERR,*)' id1,dm1,dm2,dm3,dm4,dm5,dm6'
        write(LERR,*)  id1,dm1,dm2,dm3,dm4,dm5,dm6
        write(LERR,*)' jtrs,jpts,exp,frtp,lrtp'
        write(LERR,*)  jtrs,jpts,exp,frtp,lrtp
        write(LERR,*)' iwflg,ialias,jstak,ipass,jearly'
        write(LERR,*)  iwflg,ialias,jstak,ipass,jearly
      endif

      IF(IALIAS.NE.1)IALIAS=0
      IF(K1.EQ.1)THEN
         LTVAR=LTTVAR
      ELSE
         LTTVAR=LTVAR
      ENDIF

      if(card1(67:67).ne.' '.and.card1(67:67).ne.'N')then
        write(ipr,10120)card1(67:67)
10120 format(/,14x,'** M0004 ** ERROR DETECTED IN MAIN PROGRAM.',
     */,14x,'THE CARD FORMAT FLAG ',A1,' IS NOT RECOGNIZED.',
     */,14x,'CHECK YOUR PARAMETER CARDS BEFORE RESUBMITTING YOUR JOB.')
         errknt=errknt+1
         ic = 100
      endif

      IF(CARD1(67:67).EQ.'N')THEN
         NEW=.TRUE.
      ELSE
         if(k1.eq.1)then
            call newcrd(card1,ns,nsr,ipr)
         endif

         DDMI(1)=DM1
         DDMX(1)=DM2
         DDNS(1)=DM3
         UDMI(1)=DM4
         UDMX(1)=DM5
         UDNS(1)=DM6
         NSETS=1
         FTYPE(1)=IPASS
         INTER=0

         IF (IPASS.NE.0.AND.IPASS.NE.1)THEN
            WRITE(IPR,641)IPASS
            WRITE(LER,641)IPASS
  641 FORMAT(/,18X,'** M0641 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE PASS/REJECT FLAG ENTRY (',I2,') IS INVALID',/,14X,
     *'VALID ENTRIES ARE BLANK, 0, OR 1 ONLY.',
     */,14X,' CORRECT THE ENTRY BEFORE RESUBMITTING THIS JOB.')
         ERRKNT = ERRKNT+1
         ENDIF

         WGHT(1)=0.
         LTVAR=0
      ENDIF

      IF (INTER.NE.0.AND.INTER.NE.1)THEN
         WRITE(IPR,642)INTER
         WRITE(LER,642)INTER
  642 FORMAT(/,18X,'** M0642 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE INTERPOLATION FLAG ENTRY (',I2,') IS INVALID',/,14X,
     *'VALID ENTRIES ARE BLANK, 0, OR 1 ONLY.',
     */,14X,' CORRECT THE ENTRY BEFORE RESUBMITTING THIS JOB.')
         ERRKNT = ERRKNT+1
      ENDIF

      IF (INTER.EQ.1.AND.FRTP.EQ.0)THEN
         WRITE(IPR,644)
         WRITE(LER,644)
  644 FORMAT(/,18X,'** M0644 ** WARNING FROM MAIN PROGRAM.',/,14X,
     *'SPATIAL INTERPOLATION OF WINDOWS REQUESTED AND THE FIRST ',
     *'RECORD TO FILTER IS NOT SPECIFIED.',
     */,14X,' INTERPOLATION MAY NOT BE SATISFACTORY IF THE INTERPOLA',
     *'TION PARAMETERS ARE DEFAULTED.')
      ENDIF

      IF (INTER.EQ.1.AND.LRTP.EQ.0)THEN
         WRITE(IPR,645)
         WRITE(LER,645)
  645 FORMAT(/,18X,'** M0645 ** WARNING FROM MAIN PROGRAM.',/,14X,
     *'SPATIAL INTERPOLATION OF WINDOWS REQUESTED AND THE LAST ',
     *'RECORD TO FILTER NOT SPECIFIED.',
     */,14X,' INTERPOLATION MAY NOT BE SATISFACTORY IF THE INTERPOLA',
     *'TION PARAMETERS ARE DEFAULTED.')
      ENDIF

      IF (LRTP.LT.FRTP.AND.LRTP.NE.0)THEN
         WRITE(IPR,646)LRTP,FRTP
         WRITE(LER,646)LRTP,FRTP
  646 FORMAT(/,18X,'** M0646 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'RECORD NUMBERS MUST BE IN INCREASING ORDER.  THE ENTRY FOR THE',
     */,14X,'LAST RECORD TO PROCESS (',I5,') IS LESS THAN THE ENTRY ',
     */,14X,'FOR THE FIRST RECORD TO PROCESS (',I5,').',
     */,14X,' CORRECT THESE ENTRIES BEFORE RESUBMITTING THIS JOB.')
         ERRKNT = ERRKNT+1
      ENDIF

      KTOT=K1+K2

      write(unit=luc,rec=ktot)card1

      IF(NEW)THEN
 201     READ(LUCRD,399,END=33)CARD2
         IF(CARD2(1:5).EQ.CRDID2)THEN
            K2=K2+1
            KTOT=K1+K2

            write(unit=luc,rec=ktot)card2
            write(LERR,*) CARD2

            IF(K1.EQ.1.AND.K2.EQ.1)READ(CARD2,502)DDMI(1),DDMX(1),
     :           DDNS(1), UDMI(1),UDMX(1),UDNS(1), FTYPE(1),WGHT(1)
 502        FORMAT(15X,2(2F5.0,F3.0),I1,1X,F4.0)

            IF (FTYPE(1).NE.0.AND.FTYPE(1).NE.1)THEN
               WRITE(IPR,641)FTYPE(1)
               WRITE(LER,641)FTYPE(1)
               ERRKNT = ERRKNT+1
            ENDIF
            GO TO 201
         ELSE
            IF(CARD2(1:5).NE.CRDID1)THEN
               WRITE (IPR,495)CARD2(1:5)
               WRITE (LER,495)CARD2(1:5)
  495       FORMAT (/,18X, '** M0495 ** ERROR IN DIPF.',
     &           /, 14X, 'EXPECTED A 1DIPF CARD BUT FOUND A ',A5,
     &                   ' CARD.',
     &           /, 14X, 'I DO NOT KNOW HOW TO CONTINUE, SO JOB ',
     &                   'ABORTED.')
               CALL CCEXIT(100)
            ELSE
               CALL MOVE(1,CARD1,CARD2,80)
            ENDIF
         ENDIF
      ENDIF

      GO TO 34

   33 EOC=.TRUE.
      IF(NEW.AND.K2.EQ.0)THEN
         WRITE(IPR,70)
         WRITE(LER,70)
   70 FORMAT(/,18X,'** M0070 ** ERROR DETECTED IN MAIN PROGRAM.',
     */,14X,'NEW CARD FORMAT FLAGGED AND NO 2DIPF CARD SUPPLIED.',
     */,14X,'CORRECT CARD DECK BEFORE RESUBMITTING THIS JOB.')
         ERRKNT=ERRKNT+1
         IC=100
      ENDIF

 34   IF (K1.NE.1) GO TO 3
      IF (LTVAR.NE.0.AND.LTVAR.NE.1.AND.LTVAR.NE.2) THEN
         WRITE(IPR,496)LTVAR
         WRITE(LER,496)LTVAR
  496 FORMAT(/,18X,'** M0496 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE TIME TIME VARIANCE FLAG ENTRY (',I3,') IS INVALID',/,14X,
     *'VALID ENTRIES ARE BLANK, 0, 1, OR 2.',
     */,14X,' CORRECT THE ENTRY BEFORE RESUBMITTING THIS JOB.')
         ERRKNT = ERRKNT+1
         IC = 100
      ENDIF

      IF (IWFLG.NE.0.AND.IWFLG.NE.1)THEN
         WRITE(IPR,643)IWFLG
         WRITE(LER,643)IWFLG
  643 FORMAT(/,18X,'** M0643 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE WATER BOTTOM FLAG ENTRY (',I2,') IS INVALID',/,14X,
     *'VALID ENTRIES ARE BLANK, 0, OR 1 ONLY.',
     */,14X,' CORRECT THE ENTRY BEFORE RESUBMITTING THIS JOB.')
         ERRKNT = ERRKNT+1
      ENDIF

      IPASS=FTYPE(1)

      IF (IPASS.NE.0.AND.IPASS.NE.1)THEN
         WRITE(IPR,641)IPASS
         WRITE(LER,641)IPASS
         ERRKNT = ERRKNT+1
      ENDIF

      NTRS   = JTRS
      IF (NTRS.EQ.0) NTRS=15
      NTRS = NTRS/2*2+1

      if(ntrs.gt.jtrs.and.jtrs.gt.0)then
         write(ipr,86)jtrs,ntrs
   86 format(/,14x,'** M0086 ** WARNING FROM MAIN PROGRAM.',/,14x,
     *'THE NUMBER OF FILTER CHANNELS REQUESTED (',I3,' ) is even and',
     */,14x,'HAS BEEN INCREASED BY 1 to ',I3,' CHANNELS.')
      endif

      IF(NTRS.LT.5)THEN
         WRITE(IPR,71)NTRS
         WRITE(LER,71)NTRS
   71 FORMAT(/,18X,'** M0071 ** WARNING FROM IN MAIN PROGRAM.',/,14X,
     *'THE NUMBER OF FILTER CHANNELS REQUESTED (',I3,') IS LESS THAN',
     */,14X,'THE MINIMUM (5) ALLOWED.',/,
     */,14X,'5 WILL BE USED.')
         NTRS=5
      ENDIF

      IF(NTRS.GT.47)THEN
         WRITE(IPR,72)NTRS
         WRITE(LER,72)NTRS
   72 FORMAT(/,18X,'** M0072 ** WARNING FROM IN MAIN PROGRAM.',/,14X,
     *'THE NUMBER OF FILTER CHANNELS REQUESTED (',I3,') IS GREATER',
     *' THAN',/,14X,'THE MAXIMUM (47) ALLOWED.',/,
     */,14X,'47 WILL BE USED.')
         NTRS=47
      ENDIF

      IF(JSTAK.LT.0.OR.JSTAK.GT.2)THEN
         WRITE(IPR,82)JSTAK
         WRITE(LER,82)JSTAK
   82 FORMAT(/,18X,'** M0082 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE PROCESSING MODE REQUESTED (',I2,' ) IS INVALID',
     */,14X,'VALID VALUES ARE BLANK, 0, 1, OR 2 ONLY.',
     */,14X,'CORRECT THIS PARAMETER BEFORE RESUBMITTING YOUR JOB.')
         ERRKNT=ERRKNT+1
      ENDIF

      IF(JSTAK.EQ.2 .AND. NTPR.GT.512)THEN
         WRITE(IPR,774)NTPR
         WRITE(LER,774)NTPR
  774 FORMAT(/,18X,'** M0774 ** ERROR DETECTED IN MAIN PROGRAM.',
     */,14X,'THE NUMBER OF TRACES PER RECORD ( ',I4,' ) ON THE INPUT ',
     */,14X,'DATA SET EXCEEDS THE PROGRAM MAXIMUM OF 512 FOR ',
     */,14X,'SPLIT-SPREAD PROCESSING MODE. ',
     */,14X,'REDUCE BEFORE RESUBMITTING YOUR JOB.')
         ERRKNT=ERRKNT+1
         IC=100
      ENDIF

      IF(JSTAK.EQ.2.AND.NTRS.GT.IHLFSP)THEN
         WRITE(IPR,84)NTRS,IHLFSP
         WRITE(LER,84)NTRS,IHLFSP
   84 FORMAT(/,18X,'** M0084 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'SPLIT-SPREAD APPLICATION REQUESTED AND THE NUMBER OF FILTER',
     *'CHANNELS ( ',I4,' )',
     */,14X,'IS GREATER THAN THE HALF SPREAD LENGTH ( ',I4,
     *'CHANNELS ).',
     */,14X,'CORRECT YOUR FILTER SPECIFICATION BEFORE RESUBMITTING',
     *'THIS JOB.')
         ERRKNT=ERRKNT+1
      ENDIF

      IF(JEARLY.LT.0.OR.JEARLY.GT.1)THEN
         WRITE(IPR,83)JEARLY
         WRITE(LER,83)JEARLY
   83 FORMAT(/,18X,'** M0083 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE EARLY MUTE PRESERVE FLAG (',I2,' ) IS INVALID',
     */,14X,'VALID VALUES ARE BLANK, 0, 1 ONLY.',
     */,14X,'CORRECT THIS PARAMETER BEFORE RESUBMITTING YOUR JOB.')
         ERRKNT=ERRKNT+1
      ENDIF

      IFFRTP=FRTP
      IFLRTP=LRTP
      NPTS   = JPTS
      IF (NPTS.EQ.0) NPTS = 101
      NPTS   = NPTS/2*2+1

      if(npts.gt.jpts.and.jpts.gt.0)then
        write(ipr,69)jpts,npts
        write(LER,69)jpts,npts
   69 format(/,14x,'** M0069 ** WARNING FROM MAIN PROGRAM.',/,14x,
     *'THE NUMBER OF FILTER POINTS REQUESTED (',I3,') IS AN EVEN',
     *' NUMBER.',/,14X,'IT HAS BEEN INCREASED BY 1 TO ',I3,'.')
      endif

      IF(NPTS.LT.33)THEN
         WRITE(IPR,73)NPTS
         WRITE(LER,73)NPTS
   73 FORMAT(/,18X,'** M0073 ** WARNING FROM IN MAIN PROGRAM.',/,14X,
     *'THE NUMBER OF FILTER POINTS REQUESTED (',I3,') IS LESS',
     *' THAN',/,14X,'THE MINIMUM (33) ALLOWED.',/,
     */,14X,'33 WILL BE USED.')
         NPTS=33
      ENDIF

      IF(NPTS.GT.513)THEN
         write(LER,74)npts
         WRITE(IPR,74)NPTS
   74 FORMAT(/,18X,'** M0074 ** WARNING FROM IN MAIN PROGRAM.',/,14X,
     *'THE NUMBER OF FILTER POINTS REQUESTED (',I3,') IS GREATER',
     *' THAN',/,14X,'THE MAXIMUM (513) ALLOWED.',/,
     */,14X,'513 WILL BE USED.')
         NPTS=513
      ENDIF

      IF ( IWFLG .NE. 1 ) IWFLG = 0
      ISTAK  = JSTAK
      IEARLY = JEARLY
      IF (ISTAK.GT.2) ISTAK=0

      IF (IEARLY.NE.1) IEARLY=0

      IF (IWFLG .EQ. 1) THEN
         LRMP2 = 48 / NSR
         TRIRMP(LRMP2+1) = 1.0
         LRMP = 96 / NSR + 1
         LAST = LRMP

         DO 4 I = 1, LRMP2
            TRIRMP(I) = (SR / 48.) * (FLOAT(I) - 1.)
            TRIRMP(LAST) = TRIRMP(I)
    4    LAST = LAST - 1
         IF (WVEL .EQ. 0.) THEN
            IC = 100
            WRITE (IPR, 5)
            WRITE (LER, 5)
    5       FORMAT (/,18X, '** M0005 ** ERROR IN DIPF.',
     &           /, 14X, 'WHEN YOU USE THE WATER BOTTOM FLAG, YOU ',
     &                   'MUST HAVE A NON-ZERO ',
     &           /, 14X, 'WATER VELOCITY IN THE LINE HEADER.  YOU ',
     &                   'CAN USE UTOP TO ',
     &           /, 14X, 'ENTER A WATER VELOCITY IN YOUR LINE ',
     &                   'HEADER BEFORE RESUBMITTING.')
            ERRKNT = ERRKNT + 1
         ENDIF
      ENDIF

      ITLEN  = NS + NPTS
      LENGTH = 32
 112  LENGTH = LENGTH + LENGTH
      IF ( LENGTH .LT. ITLEN ) GO TO 112
      ITLEN  = LENGTH
      N1     = ITLEN / 2 + 1
      N2=ITLEN+2
C +-----------------------------------------------------------+
C |  ALLOCATE MEMORY BELOW THE LINE FOR FLTT AND XSUM BUFFERS |
C |  ABOVE THE LINE FOR FIN, WB, TDATA, AND TEMP BUFFERS      |
C +-----------------------------------------------------------+
      IF (.NOT. ALOKTD) THEN
         IGET  = NTRS * N1 * (2 * SZSMPD)
         heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

         call galloc(mfin, iget, errcod, abort)
         if (errcod .ne. 0) heap = .false.
         IF ( .not. heap) THEN
            IC = 100
            WRITE (IPR, 11) IGET
            WRITE (LER, 11) IGET
   11       FORMAT (/,14X, '** M0011 ** ERROR IN DIPF.',
     &           /, 14X, 'CAN NOT ALLOCATE ENOUGH MEMORY FOR FIN. ',
     &                   'REQUESTED ', I10, ' BYTES.')
            ERRKNT = ERRKNT + 1
         ENDIF

         IGET  = N1 * (2 * SZSMPD)
         heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

         call galloc(mxsum, iget, errcod, abort)
         if (errcod .ne. 0) heap = .false.

         IF (.not. heap) THEN
            IC = 100
            WRITE (IPR, 12) IGET
            WRITE (LER, 12) IGET
   12       FORMAT (/,14X, '** M0012 ** ERROR IN DIPF.',
     &           /, 14X, 'CAN NOT ALLOCATE ENOUGH MEMORY FOR XSUM. ',
     &                   'REQUESTED ', I10, ' BYTES.')
            ERRKNT = ERRKNT + 1
         ENDIF

         IF (IWFLG .EQ. 1) THEN
            IGET  = NS * NTRS * SZSMPD
            heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

            call galloc(mwbsav, iget, errcod, abort)
            if (errcod .ne. 0) heap = .false.

            IF (.not. heap) THEN
               IC = 100
               WRITE (IPR, 13) IGET
               WRITE (LER, 13) IGET
 13            FORMAT (/,14X, '** M0013 ** ERROR IN DIPF.',
     &              /, 14X, 'CAN NOT ALLOCATE ENOUGH MEMORY FOR ',
     &                      'WBSAV.  REQUESTED ', I10, ' BYTES.')
               ERRKNT = ERRKNT + 1
            ENDIF
         ENDIF

         IGET  = NTRS * N1 * ( 2 *SZSMPD )
         heap = .true.
         IF(LTVAR.NE.0)THEN
            IGET  = NTRS * N1 * ( 2 *SZSMPD ) * NSETMX
         ENDIF
         IF (ISTAK.EQ.2) IGET = IGET * 2
         
c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

         call galloc(mfltt, iget, errcod, abort)
         if (errcod .ne. 0) heap = .false.
            
         IF (.not. heap) THEN
            IC = 100
            WRITE (IPR, 14) IGET
            WRITE (LER, 14) IGET
 14         FORMAT (/,14X, '** M0014 ** ERROR IN DIPF.',
     &           /, 14X, 'CAN NOT ALLOCATE ENOUGH MEMORY FOR FLTT. ',
     &                   'REQUESTED ', I10, ' BYTES.')
            ERRKNT = ERRKNT + 1
         ENDIF

         IGET  = NTRS * NS * SZSMPD
         heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

         call galloc(mtdata, iget, errcod, abort)
         if (errcod .ne. 0) heap = .false.

         IF (.not. heap) THEN
            WRITE (IPR, 15) IGET
            WRITE (LER, 15) IGET
 15         FORMAT (/,14X, '** M0015 ** ERROR IN DIPF.',
     &           /, 14X, 'CAN NOT ALLOCATE ENOUGH MEMORY FOR TDATA. ',
     &                   'REQUESTED ', I10, ' BYTES.')
            ERRKNT = ERRKNT + 1
            IC = 100
         END IF

         IF(LTVAR.NE.0)THEN
            IGET  = NSETMX * NS * SZSMPD
            heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

            call galloc(mtemp, iget, errcod, abort)
            if (errcod .ne. 0) heap = .false.

            IF (.not. heap) THEN
               IC = 100
               WRITE (LER, 19) IGET
               WRITE (IPR, 19) IGET
 19            FORMAT (/,14X, '** M0014 ** ERROR IN DIPF.',
     &           /, 14X, 'CAN NOT ALLOCATE ENOUGH MEMORY FOR TEMP. ',
     &                   'REQUESTED ', I10, ' BYTES.')
               ERRKNT = ERRKNT + 1
            ENDIF
         ENDIF

         ALOKTD = .TRUE.
      ENDIF

      IFIN = 0
      IXSUM = 0
      IWBSAV=0
      IFLTT = 0
      ITDAT = 0
      ISAVE=0
C +-------------------------+
C |  END MEMORY ALLOCATION  |
C +-------------------------+

c    Center trace position
      IZ  = NTRS/2+1
      IZ1 = IZ-1
      
 3    CONTINUE

      IF (ID1.NE.CRDID1)THEN
         WRITE (IPR,701)ID1
         WRITE (LER,701)ID1
  701 FORMAT(/,18X,'** M0002 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'EXPECTED A 1DIPF CARD AND FOUND A ',A5,' CARD.')
         ERRKNT = ERRKNT+1
         IC  = 100
      ENDIF

      IF (EXP.GT.50.0) THEN
         write(LER,712)exp
         WRITE (IPR,712) EXP
  712 FORMAT(/,18X,'** M0006 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE BESSEL WEIGHTING EXPONENT CANNOT BE GREATER THAN 50.',/,14X,
     *'SELECT PROPER VALUE BEFORE RESUBMITTING YOUR JOB.')
         ERRKNT=ERRKNT+1
         IC=100
      ENDIF

      XDMX=DDMX(1)
      XDMI=DDMI(1)
      XUMI=UDMI(1)
      XUMX=UDMX(1)
      XDNS=DDNS(1)
      XUNS=UDNS(1)
      TD = ABS(XDMX)+ABS(XDMI)+ABS(XUMX)+ABS(XUMI)+
     :     ABS(XDNS)+ABS(XUNS)
      IF (TD.EQ.0.0) THEN
         WRITE(IPR,702)
         WRITE(LER,702)
  702 FORMAT(/,18X,'** M0003 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE FILTER MOVEOUT PARAMETERS CANNOT ALL BE ZERO. SELECT ',
     *'PROPER PARAMETERS BEFORE',/,14X,'RESUBMITTING YOUR JOB.')
         ERRKNT = ERRKNT+1
         IC = 100
      ENDIF

      IF (ISTAK.EQ.0) GO TO 704
      IF (NTRS.LE.NTPR-1) GO TO 704
      WRITE(IPR,703)NTPR,NTRS
      WRITE(LER,703)NTPR,NTRS
  703 FORMAT(/,18X,'** M0007 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'NUMBER OF TRACES/RECORD ',I5,' SHOULD BE GREATER THAN ',
     *'THE NUMBER OF CHANNELS IN THE FILTER ',I5,/,14X,' SELECT ',
     *'PROPER PARAMETERS BEFORE',/,14X,'RESUBMITTING YOUR JOB.')
      ERRKNT = ERRKNT+1
      IC = 100
 704  CONTINUE
      K1 = K1 + 1
      
      IF (K1 .EQ. 2.AND.LTVAR.EQ.0) THEN
C +---------------------------------------+
C |  DO HLH STUFF FOR TIME INVARIANT MODE |
C +---------------------------------------+
         IPASS=FTYPE(1)
         SCAL=WGHT(1)
         IL=35
         CALL MOVE(2,MODH,0,35)
         WRITE(MODH,10001)NTRS,NPTS
         CALL HLH(INPUT,NIT,MODH,IL)
10001    FORMAT(' --------NC=',I2,
     *          '--FL=',I4,'PTS---------')
         IF ( IPASS .NE. 1 ) IPASS = 0
         IL = 35
         CALL MOVE (2,MODH,0,35)
         IFR = FRTP
         ILR = LRTP
         IF ( FRTP .EQ. 0 ) IFR = 1
         IF ( LRTP .EQ. 0 ) ILR = 32767
         FC=FCTYP(IPASS+1)
         WRITE(MODH,10002)IFR,ILR,FC
10002    FORMAT(' REC ',I5,' TO ',I5,'     TYPE=',A6)
         CALL HLH (INPUT,NIT,MODH,IL)
         WRITE(MODH,10011)MT(ISTAK+1)
10011    FORMAT(' ',A22)
         IL=23
         CALL HLH (INPUT,NIT,MODH,IL)

         IF(SCAL.NE.0)THEN
            WRITE(MODH,10012)SCAL
10012       FORMAT(' DIP ENHANCEMENT FACTOR ',F5.1)
            IL=30
            CALL HLH(INPUT,NIT,MODH,IL)
         ENDIF

         IW = 0
         IL = 35
         CALL MOVE (2,MODH,0,35)
         IF (DDMI(1).NE.0.0.OR.DDMX(1).NE.0.0) IW = 1
         IF ( IW .EQ. 1 .AND. DDNS(1) .EQ. 0.0 ) DDNS(1) = 2.0
         IF (IW.EQ.1) WRITE(MODH,10004)DDMI(1),DDMX(1),DDNS(1),EXP
10004    FORMAT (' D-DIP',F5.1,' TO ',F5.1,
     *           ' N/S=',F4.1,'BW=',F3.1)
         IF (IW.EQ.1) CALL HLH (INPUT,NIT,MODH,IL)
         IL = 35
         IW = 0
         CALL MOVE (2,MODH,0,35)
         IF (UDMI(1).NE.0.0.OR.UDMX(1).NE.0.0) IW = 1
         IF ( IW .EQ. 1 .AND. UDNS(1) .EQ. 0.0 ) UDNS(1) = 2.0
         IF (IW.EQ.1) WRITE(MODH,10005)UDMI(1),UDMX(1),UDNS(1),EXP
10005    FORMAT(' U-DIP',F5.1,' TO ',F5.1,
     *          ' N/S=',F4.1,'BW=',F3.1)
         IF (IW.EQ.1) CALL HLH (INPUT,NIT,MODH,IL)
      ENDIF
C +-------------------------------------------+
C |  END HLH STUFF TIME INVARIANT APPLICATION |
C +-------------------------------------------+
      GO TO 1
C +----------------------------------------+
C |  BOTTOM OF CARD CHECK ERROR SCAN LOOP  |
C +----------------------------------------+
 303  write(LERR,*)' ERR detected from reading LUCRD'
 300  CONTINUE
      K1=K1-1
      IF(K1.EQ.0)THEN
         WRITE(LER,640)
         WRITE(IPR,640)
  640 FORMAT(/,18X,'** M0640 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'NO 1DIPF CARDS HAVE BEEN READ.',/,14X,'ENSURE THAT YOUR',
     *' PARAMETER CARDS ARE CORRECTLY COMPLETED',/,14X,
     *'BEFORE RESUBMITTING YOUR JOB.')
         ERRKNT = ERRKNT+1
      ENDIF

      NCARDS = K1+K2
      IF (ERRKNT.EQ.0) GO TO 35
      WRITE (IPR,705) ERRKNT
      WRITE (LER,705) ERRKNT
  705 FORMAT(//,'******* PROGRAM DIPF TERMINATED DUE TO ',I3,' ERRORS',
     *          ' *******')
      ic = 0
      GO TO 999
 35   CONTINUE
C +-------------------------------------------+
C |  DO HLH STUFF TIME VARIANT APPLICATION    |
C |  NEED FIRST TO SEE HOW MANY 2DIPF CARDS   |
C |   ARE IN FIRST SET                        |
C +-------------------------------------------+
      IF(LTVAR.NE.0.AND.IGO.NE.1)THEN
         DO 41 I=2,NCARDS
            read(unit=luc,rec=i)kard
            if(kard(1:5).ne.crdid2)go to 42
            KKK=I
 41      CONTINUE
 42      CONTINUE

         DO 43 I=2,KKK
            read(unit=luc,rec=I)KARD
            call GTIME(KARD,DDMI,DDMX,DDNS,UDMI,UDMX,UDNS,
     &           STRTT,ENDT,FTYPE,NSETS,WGHT,RESET,LTVAR,
     &           AREC,BREC,BSTRTT,BENDT,IFFRTP,IFLRTP,INTER,IERROR)
            RESET=.FALSE.
 43      CONTINUE

 525     IF(IERROR.NE.0)THEN
            WRITE(IPR,530)IERROR
            WRITE(LER,530)IERROR
            IC=100
            GO TO 999
         ENDIF

 530   FORMAT(T19,'***************************************************',
     *'****',
     *     /,T15,I5,' ERRORS DETECTED IN TIME PARAMETER INPUT. JOB',
     *      ' ABORTED.',
     *     /,T19,'***************************************************',
     *'****')
         IF(NSETS.GT.NSETMX)THEN
            WRITE(IPR,10010)NSETS,NSETMX
            WRITE(LER,10010)NSETS,NSETMX
10010 FORMAT(/,18X,'** M0008 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'THE NUMBER OF FILTERS DEFINED (',I4,') IS INVALID',/,14X,
     *'A MAXIMUM OF ',I3,' IS ALLOWED.',
     */,14X,' CORRECT BEFORE RESUBMITTING THIS JOB.')
            ERRKNT = ERRKNT+1
            IC = 100
            GO TO 1020
         ENDIF

         if(nsets.eq.1.and.ltvar.eq.2)then
            write(ipr,10110)
10110 format(/,14x,'** M0009 ** ERROR DETECTED IN MAIN PROGRAM.',/,14x,
     *'THE CONTINUOUSLY TIME VARIANT MODE (CC 68 = 2) IS INVALID WHEN',
     */,14X,'ONLY 1 FILTER (1 2DIPF CARD) SUPPLIED.',
     */,14X,'SELECT MODE 1 AND RESUBMIT THE JOB.')
            errknt=errknt+1
            ic = 100
            go to 1020
         endif

         RESET=.TRUE.
         WRITE(MODH,10001)NTRS,NPTS
         IF ( IPASS .NE. 1 ) IPASS = 0
         IL = 35
         CALL HLH (INPUT,NIT,MODH,IL)
         IL = 35
         CALL MOVE (2,MODH,0,35)
         IFR = IFFRTP
         ILR = IFLRTP
         IF ( IFFRTP .EQ. 0 ) IFR = 1
         IF ( IFLRTP .EQ. 0 ) ILR = 32767
10006    FORMAT(' REC ',I5,' TO ',I5)
         IL = 19
         WRITE(MODH,10006)IFR,ILR
         CALL HLH (INPUT,NIT,MODH,IL)
         WRITE(MODH,10011)MT(ISTAK+1)
         IL=23
         CALL HLH (INPUT,NIT,MODH,IL)
         WRITE(MODH,37)
         IL=46
         CALL HLH (INPUT,NIT,MODH,IL)
         WRITE(MODH,38)
         IL=46
         CALL HLH (INPUT,NIT,MODH,IL)

         DO 36 I=1,NSETS
            IND=FTYPE(I)+1
            IF(IND.NE.2)IND=1
            FC=FCTYP(IND)
            STIME=(STRTT(I)-1)*NSR
            ETIME=(ENDT(I)-1)*NSR
            IF(ETIME.EQ.NS*NSR-NSR)ETIME=NS*NSR
            IF(STIME.EQ.NS*NSR-NSR)STIME=NS*NSR
            WRITE(DUM1,3640)STIME
            WRITE(DUM2,3640)ETIME
            IF(LTVAR.EQ.2)DUM2=NA
            WRITE(MODH,39)DUM1,DUM2,DDMI(I),DDMX(I),DDNS(I),
     &           UDMI(I),UDMX(I),UDNS(I),FC
            IF(WGHT(I).NE.0.0)IWGHT=1
            IL=48
            CALL HLH (INPUT,NIT,MODH,IL)
            IGO=1
 36      CONTINUE

 37      FORMAT(' START  END DOWN DOWN DOWN  UP   UP   UP FILTER')
 38      FORMAT(' TIME  TIME MIN  MAX  N/S  MIN  MAX  N/S  TYPE ')
 39      FORMAT(1X,2A5,6F5.1,1X,A6)
 46      FORMAT(' START  END  DIP ENHANCEMENT')
 47      FORMAT('  TIME TIME       FACTOR    ')

         IF(IWGHT.EQ.1)THEN
            IL=28
            WRITE(MODH,46)
            CALL HLH (INPUT,NIT,MODH,IL)
            WRITE(MODH,47)
            CALL HLH (INPUT,NIT,MODH,IL)

            DO 48 I=1,NSETS
               STIME=(STRTT(I)-1)*NSR
               ETIME=(ENDT(I)-1)*NSR
               IF(ETIME.EQ.NS*NSR-NSR)ETIME=NS*NSR
               IF(STIME.EQ.NS*NSR-NSR)STIME=NS*NSR
               WRITE(DUM1,3640)STIME
               WRITE(DUM2,3640)ETIME
               IF(LTVAR.EQ.2)DUM2=NA
               WRITE(MODH,49)DUM1,DUM2,WGHT(I)
               IL=23
               CALL HLH (INPUT,NIT,MODH,IL)
 48         CONTINUE

         ENDIF

 49      FORMAT(1X,2A5,7X,F5.1)
         IF(LTVAR.EQ.1)THEN
            WRITE(MODH,10008)
10008       FORMAT('  TIME VARIANT ')
            IL=15
            CALL HLH(INPUT,NIT,MODH,IL)
         ENDIF

         IF(LTVAR.EQ.2)THEN
            WRITE(MODH,10009)
10009       FORMAT('  CONTINUOUSLY TIME VARIANT ')
            IL=28
            CALL HLH(INPUT,NIT,MODH,IL)
         ENDIF

         IF(INTER.EQ.1)THEN
            WRITE(MODH,10013)
10013       FORMAT('  SPATIAL INTERPOLATION REQUESTED ')
            IL=34
            CALL HLH(INPUT,NIT,MODH,IL)
         ENDIF
      ENDIF

C +-----------------------------------------+
C |  END HLH STUFF TIME VARIANT APPLICATION |
C +-----------------------------------------+
C +-------------------------+
C |   COMPUTE OUTPUT LENGTH |
C +-------------------------+

      if(ISZBYT.eq.4) then
         LBYTE = 2*NS+SZTRHD
         IF (IOFMT.EQ.3) LBYTE=NS4+SZTRHD
      else
         LBYTE = ISZBYT*NS + SZTRHD
      endif

c open output dataset

      call getln (LUO,otap,'w',1)

c write output line header

      CALL WRTAPE (LUO,INPUT,NIT)

C +------------------------------------+
C |                                    |
C |      TOP OF PROCESSING LOOP        |
C |                                    |
C +------------------------------------+

      NSETS=1
      KK1=0
      KK = 0
350   CONTINUE
      IFRST=0
      RESET=.TRUE.
      KK = KK + 1
      KK1=KK1+1
C +------------------------+
C |  SEE IF ANY MORE CARDS |
C +------------------------+
      IF (KK1.GT.K1) GO TO 999
C +----------------+
C |  GET CARD DATA |
C +----------------+
      read(unit=luc,rec=kk)KARD
      READ (KARD     , 401) DM1,DM2,DM3,DM4,DM5,DM6,
     *     EXP,FRTP,LRTP,IALIAS,IPASS,INTER,IPFL
  401 FORMAT (5X,2(2F5.0, F3.0),6X,F3.0,2I5,4X,2(I1,1X),T69,I1,T80,I1)

      IF(IALIAS.NE.1)IALIAS=0

      IF(NEW)THEN
 220     KK=KK+1
         IF(KK.GT.NCARDS)GO TO 222
         read(unit=luc,rec=kk)KARD
         READ(KARD     ,402)ID
 402     FORMAT(A5)

         IF(ID.EQ.CRDID1)THEN
            KK=KK-1
            RESET=.TRUE.
            GO TO 222
         ELSE

            CALL GTIME(KARD     ,DDMI,DDMX,DDNS,UDMI,UDMX,UDNS,
     &           STRTT,ENDT,FTYPE,NSETS,WGHT,RESET,LTVAR,
     &           AREC,BREC,BSTRTT,BENDT,FRTP,LRTP,INTER,IERROR)
            RESET=.FALSE.
            GO TO 220
         ENDIF
      ELSE
         DDMI(1)=DM1
         DDMX(1)=DM2
         DDNS(1)=DM3
         UDNS(1)=DM6
         UDMX(1)=DM5
         UDMI(1)=DM4
         NSETS=1
         FTYPE(1)=IPASS
         INTER=0
         LTVAR=0
         WGHT(1)=0.
      ENDIF
 222  CONTINUE

      IF(IERROR.NE.0) THEN
         WRITE(LER,530)IERROR
         WRITE(LERR,530)IERROR
         IC=100
         GO TO 999
      ENDIF

      IF(NSETS.GT.NSETMX)THEN
         WRITE(IPR,10010)NSETS,NSETMX
         write(LER,10010)nsets,nsetmx
         ERRKNT = ERRKNT+1
         IC = 100
         GO TO 1020
      ENDIF

      IF (FRTP.EQ.0) FRTP = -32767
      IF (LRTP.EQ.0) LRTP =  32767
      DO 225 JF=1,NSETS
         DMX = DDMX(JF)/SR
         DMI = DDMI(JF)/SR
         UMX = UDMX(JF)/SR
         UMI = UDMI(JF)/SR
         IF (ABS(DMX)+ABS(DMI).NE.0 .AND. DDNS(JF).EQ.0) DDNS(JF) = 2.0
         IF (ABS(UMX)+ABS(UMI).NE.0 .AND. UDNS(JF).EQ.0) UDNS(JF) = 2.0
 225  CONTINUE

      IF(INTER.EQ.1)THEN
         DO 250 JF=1,NSETS
            DTS=BSTRTT(JF)-STRTT(JF)
            DTE=BENDT(JF)-ENDT(JF)
            DREC=BREC(JF)-AREC(JF)
            DELSRC(1,JF)=0.
            DELSRC(2,JF)=0.
            IF(DREC.NE.0.0)THEN
               DELSRC(1,JF)=DTS/DREC
               DELSRC(2,JF)=DTE/DREC
            ENDIF
 250     CONTINUE
      ENDIF
C +----------------+
C |  PROCESS DATA  |
C +----------------+

      IF(LTVAR.EQ.0)THEN

         if(verbos) then

            WRITE(IPR,403)DDMI(1),DDMX(1),DDNS(1),
     &           UDMI(1),UDMX(1),UDNS(1)
  403 FORMAT(/,' ','*** PROCESSING PARAMETERS AFTER DEFAULTS  ***',/,
     *   '    ---DOWN DIP PARAMETERS-------',/,
     *   '     MINIMUM MOVEOUT          = ',F10.4,/,
     *   '     MAXIMUM MOVEOUT          = ',F10.4,/,
     *   '     NOISE TO SIGNAL RATIO    = ',F10.4,/,
     *   '    ---UP DIP PARAMETERS---------',/,
     *   '     MINIMUM MOVEOUT          = ',F10.4,/,
     *   '     MAXIMUM MOVEOUT          = ',F10.4,/,
     *   '     NOISE TO SIGNAL RATIO    = ',F10.4,/,
     *   ' -----------------------------')
C
         endif

         IPFR = FRTP
         IF (FRTP.EQ.-32767) IPFR = 0

         if(verbos) then

            WRITE (IPR,406)NTRS,NPTS,EXP,IPFR,LRTP,IWFLG,IALIAS,ISTAK
  406 FORMAT('     NUMBER CHANNELS          = ',I3,/,
     *   '     NUMBER POINTS/FILTER     = ',I3,/,
     *   '     BESSEL WEIGHTING VALUE   = ',F6.2,/,
     *   '     FIRST RECORD TO PROCESS  = ',I5,/,
     *   '     LAST RECORD TO PROCESS   = ',I5,/,
     *   '     WATER BOTTOM FLAG          ',/,
     *   '        (0=NO 1=YES)          = ',I3,/,
     *   '     ALIAS FLAG                 ',/,
     *   '        (0=NO 1=YES)          = ',I3,/,
     *   '     PROCESSING MODE            ',/,
     *   '         0 = LINE SEQUENTIAL    ',/,
     *   '         1 = RECORD SEQUENTIAL  ',/,
     *   '         2 = SPLIT-SPREAD     = ',I1)
            IF(WGHT(1).NE.0.0)WRITE(IPR,407)WGHT(1)
 407        FORMAT('     DIP ENHANCEMENT FACTOR   = ',F5.1)

         endif

         IPASS=FTYPE(1)
         IF ( IPASS .NE. 1 ) IPASS = 0

         if(verbos) then
            
            IF (IPASS.EQ.0) WRITE(IPR,404)
            IF (IPASS.EQ.1) WRITE(IPR,405)
            WRITE (IPR,444) IEARLY
 404        FORMAT('     REJECT FILTER REQUESTED ')
 405        FORMAT('     PASS FILTER REQUESTED ')
 444        FORMAT('  EARLY MUTE FLAG          = ',I1)
         endif

      ELSE
      
         IWGHT=0
         DO 3594 I=1,NSETS
 3594    IF(WGHT(I).NE.0.0)IWGHT=1

 3599 FORMAT(/,' ',' *** PROCESSING PARAMETERS AFTER DEFAULTS  ***')
 3597 FORMAT('     ---- TIME INVARIANT FILTER PARAMETERS ----')
 3598 FORMAT('     ----- TIME VARIANT FILTER PARAMETERS -----')
 3596 FORMAT(' ')

         IPFR = FRTP
         IF (FRTP.EQ.-32767) IPFR = 0

         if(verbos) then
               
            WRITE(IPR,3599)
            WRITE (IPR,406)NTRS,NPTS,EXP,IPFR,LRTP,IWFLG,IALIAS,ISTAK
            IF(INTER.EQ.1)WRITE(IPR,3590)
 3590       FORMAT('     SPATIAL INTERPOLATION OF TIMES REQUESTED.')
            IF(LTVAR.EQ.0)WRITE(IPR,3597)
            IF(LTVAR.NE.0)WRITE(IPR,3598)
            
            IF(IWGHT.EQ.0)THEN
               IF(INTER.EQ.0)THEN
                  WRITE(IPR,3601)
                  WRITE(IPR,3602)
               ELSE
                  WRITE(IPR,3621)
                  WRITE(IPR,3622)
               ENDIF
            ELSE
               IF(INTER.EQ.0)THEN
                  WRITE(IPR,3611)
                  WRITE(IPR,3612)
               ELSE
                  WRITE(IPR,3631)
                  WRITE(IPR,3632)
               ENDIF
            ENDIF
            
         endif

         IF(INTER.EQ.0)THEN
            DO 3600 I=1,NSETS
               IND=FTYPE(I)+1
               IF(IND.NE.2)IND=1
               FC=FCTYP(IND)
               STIME=(STRTT(I)-1)*NSR
               ETIME=(ENDT(I)-1)*NSR
               IF(ETIME.EQ.NS*NSR-NSR)ETIME=NS*NSR
               IF(STIME.EQ.NS*NSR-NSR)STIME=NS*NSR
               
               if(verbos) then
                  
                  WRITE(DUM1,3640)STIME
                  WRITE(DUM2,3640)ETIME
                  
               endif
               
               IF(LTVAR.EQ.2)DUM2=NA
               
               if(verbos) then
                  
                  IF(WGHT(I).EQ.0)THEN
                     WRITE(IPR,3603)DUM1,DUM2,DDMI(I),DDMX(I),DDNS(I)
     :                    ,UDMI(I),UDMX(I),UDNS(I),FC
                  ELSE
                     WRITE(IPR,3613)DUM1,DUM2,DDMI(I),DDMX(I),DDNS(I)
     :                    ,UDMI(I),UDMX(I),UDNS(I),FC,WGHT(I)
                  ENDIF
                  
               endif
               
 3600       CONTINUE

         ELSE

            DO 3610 I=1,NSETS
               IND=FTYPE(I)+1
               IF(IND.NE.2)IND=1
               FC=FCTYP(IND)
               STIME1=(STRTT(I)-1)*NSR
               ETIME1=(ENDT(I)-1)*NSR
               IF(ETIME1.EQ.NS*NSR-NSR)ETIME1=NS*NSR
               IF(STIME1.EQ.NS*NSR-NSR)STIME1=NS*NSR
               STIME2=(BSTRTT(I)-1)*NSR
               ETIME2=(BENDT(I)-1)*NSR
               IF(ETIME2.EQ.NS*NSR-NSR)ETIME2=NS*NSR
               IF(STIME2.EQ.NS*NSR-NSR)STIME2=NS*NSR
               
               if(verbos) then
                  
                  WRITE(DUM1,3640)STIME1
                  WRITE(DUM2,3640)ETIME1
                  
               endif
               
               IF(LTVAR.EQ.2)DUM2=NA
               
               if(verbos) then
                  
                  WRITE(DUM3,3640)STIME2
                  WRITE(DUM4,3640)ETIME2
                  
               endif
               
               IF(LTVAR.EQ.2)DUM4=NA
               
               if(verbos) then
                  
                  IF(WGHT(I).EQ.0)THEN
                     WRITE(IPR,3623)DUM1,DUM2,AREC(I),DUM3,DUM4,
     :                    BREC(I),
     &                    DDMI(I),DDMX(I),DDNS(I),
     &                    UDMI(I),UDMX(I),UDNS(I),FC
                  ELSE
                     WRITE(IPR,3633)DUM1,DUM2,AREC(I),DUM3,DUM4,
     :                    BREC(I),
     &                    DDMI(I),DDMX(I),DDNS(I),
     &                    UDMI(I),UDMX(I),UDNS(I),FC,WGHT(I)
                  ENDIF
                  
               endif
               
 3610       CONTINUE

         ENDIF

         if(verbos) WRITE(IPR,3596)

      ENDIF

 3601 FORMAT('     START  END DOWN DOWN DOWN  UP   UP   UP  FILTER')
 3602 FORMAT('      (MS) TIME MIN  MAX  N/S  MIN  MAX  N/S   TYPE')
 3603 FORMAT(5X,2A5,6F5.1,1X,A6)
 3611 FORMAT('     START  END DOWN DOWN DOWN  UP   UP   UP  FILTER',
     *' DIP ENHANCEMENT')
 3612 FORMAT('      (MS) TIME MIN  MAX  N/S  MIN  MAX  N/S   TYPE ',
     *'     FACTOR')
 3613 FORMAT(5X,2A5,6F5.1,1X,A6,5X,F5.1)
 3621 FORMAT('     START  END       START  END       ',
     *' DOWN DOWN DOWN  UP   UP   UP  FILTER')
 3622 FORMAT('      (MS) TIME  RCRD  (MS)  TIME  RCRD',
     *'  MIN  MAX  N/S MIN  MAX   N/S   TYPE')
 3623 FORMAT(5X,2A5,1X,I5,2(1X,A5),1X,I5,6F5.1,2X,A6)
 3631 FORMAT('     START  END       START   END      ',
     *' DOWN DOWN DOWN  UP   UP   UP   FILTER  ENHANCEMENT')
 3632 FORMAT('      (MS) TIME  RCRD  (MS)  TIME  RCRD',
     *'  MIN  MAX  N/S MIN  MAX   N/S   TYPE     FACTOR')
 3633 FORMAT(5X,2A5,1X,I5,2(1X,A5),1X,I5,6F5.1,2X,A6,4X,F5.1)
 3640 FORMAT(I5)

C +--------------------------------------+
C |  GENERATE FILTER TRACES AND FFT THEM |
C |  STORE IN CORE AFTER FFT             |
C +--------------------------------------+

      IF(LTVAR.EQ.0)NSETS=1
      NPTNTR=N1*NTRS
      DO 2000 JF=1,NSETS
         IPASS=FTYPE(JF)
         JFNPT=(JF-1)*NPTNTR
         DMX=DDMX(JF)/SR
         DMI=DDMI(JF)/SR
         UMX=UDMX(JF)/SR
         UMI=UDMI(JF)/SR
C RLC 10/27/88 ADDED CODE TO ENSURE PROPER VALUES GO TO FILTER
C              BUILD ROUTINE WHEN NEGATIVE VALUES USED.
         AA=SIGN(1.0,DMI)
         BB=SIGN(1.0,DMX)

         IF(ABS(DMI).GT.ABS(DMX).AND.AA.EQ.BB)THEN
            HDMX=DMX
            DMX=DMI
            DMI=HDMX
         ENDIF

         AA=SIGN(1.0,UMI)
         BB=SIGN(1.0,UMX)

         IF(ABS(UMI).GT.ABS(UMX).AND.AA.EQ.BB)THEN
            HUMX=UMX
            UMX=UMI
            UMI=HUMX
         ENDIF

         ADDNS = DDNS(JF)*10.0
         AUDNS = UDNS(JF)*10.0

         IF (ISTAK.NE.2)THEN
            CALL DIPF (F,FIN(IFIN+1),NPTS,NTRS,DMX,DMI,UMX,UMI,
     *           ADDNS,AUDNS,IALIAS,EXP,IPASS,0)
            IPNT=IFLTT+1+JFNPT
            CALL FFTFLT (F, FLTT(IPNT))
            IF (verbos) THEN
               IF (IPFL.EQ.1) THEN
                  DO 680 JJ=1,NTRS
                     WRITE (IPR,681) JJ
 681                 FORMAT (1H0,'    FILTER NO.',I4)
                     WRITE (IPR,682) (F(LL,JJ),LL=1,NPTS)
 682                 FORMAT ((10E13.5))
 680              CONTINUE
               ENDIF
            ENDIF
         ELSE
C +--------------------------------------------------------------+
C |   GENERATE FILTERS FOR SPLIT SPREAD PROCESSING HERE          |
C +--------------------------------------------------------------+
C +--------------------------------------------------------------+
C |   BUILD FILTER  1ST HALF OF SPREAD                           |
C |                                                              |
C | ZERO OUT NOISE TO SIGNAL RATIO AS WELL AS MAX AND MIN        |
C | DIP PARAMETERS FOR UP DIP WHEN GENERATING THE DOWN DIP       |
C | FILTER AND FOR DOWN DIP WHEN GENERATING THE UP DIP FILTER.   |
C | OTHERWISE, DIPF WILL GENERATE A FILTER TO TAKE OUT FLAT DIP. |
C +--------------------------------------------------------------+
C
            DMXX  = DMX
            DMII  = DMI
            ADDNS = DDNS(JF)*10.0
            UMXX  = 0.0
            UMII  = 0.0
            AUDNS = 0.0
            NTT   = NTRS+1
            CALL DIPF (F(1,NTT),FIN(IFIN+1),NPTS,NTRS,DMXX,DMII,UMXX,
     :           UMII, ADDNS,AUDNS,IALIAS,EXP,IPASS,0)
            IFLTT2 = IFLTT + (N1 * NTRS)+JFNPT+JFNPT
            CALL FFTFLT (F(1,NTT), FLTT(IFLTT2+1))
C
C +---------------------------------------------------+
C |   BUILD FILTER  2ND HALF OF SPREAD INVERSE OF 1ST |
C +---------------------------------------------------+
            UMXX  = UMX
            UMII  = UMI
            AUDNS = UDNS(JF)*10.0
            DMXX  = 0.0
            DMII  = 0.0
            ADDNS = 0.0
            CALL DIPF (F,FIN(IFIN+1),NPTS,NTRS,DMXX,DMII,UMXX,UMII,
     *           ADDNS,AUDNS,IALIAS,EXP,IPASS,0)
            IPNT=IFLTT+1+JFNPT+JFNPT
            CALL FFTFLT (F, FLTT(IPNT))
            IF (verbos) THEN
               IF (IPFL.EQ.1) THEN
                  DO 685 JJ=1,NTRS
                     WRITE (IPR,681) JJ
                     WRITE (IPR,682) (F(LL,JJ),LL=1,NPTS)
                     MM = JJ + NTRS
                     WRITE (IPR,681) MM
                     WRITE (IPR,682) (F(LL,MM),LL=1,NPTS)
 685              CONTINUE
               ENDIF
            ENDIF
         ENDIF
         
 2000 CONTINUE
c - j.m.wade - 8/26/92 - added istak,inter, & lrmp to parm list

      IF(ISTAK.EQ.2)THEN
         CALL SPLIT(NTPR,IWFLG,N1,STRTT,ENDT,AREC,BREC,
     *        BSTRTT,BENDT,TEMP(ISAVE+1),TDATA(ITDAT+1),SUM,TENH,RAMP,
     *        tri,RDATA,input,I2NPUT,
     *        FRTP,LRTP,IFMT,IOFMT,FIN(IFIN+1),FLTT(IFLTT+1),NSETS,
     :        IWBSMP,
     *        WBSAV(IWBSAV+1),TRIRMP,WGHT,XSUM(IXSUM+1),iearly,
     *        ISTAK,INTER,LRMP,*999,*612)
      ENDIF
C +------------------------------------------------------------+
C |                          TAPER IN                          |
C +------------------------------------------------------------+
C +------------------------------------------------------------+
C | READ FIRST NTRS TRACES, OUTPUT CENTER TRACE AS FIRST TRACE |
C +------------------------------------------------------------+
      IF (KK1.GT.1) GO TO 802
 801  NIT = 0
      CALL RTAPE (LUI,INPUT,NIT)
      IF (NIT.NE.0) GO TO 802
      if(luo.ne.1)WRITE (LER,410)IRCD
 410  FORMAT (' ',' END OF FILE ON DATA SET AFTER RECORD ',I6,/)
      if(luo.ne.1)write(LER,309)FRTP
 309  FORMAT(/,14X,'** M0309 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'END OF FILE ENCOUNTERED ATTEMPTING TO FIND RECORD ',I5,/,14X,
     *'JOB ABORTED.')
c*     IC = 100

      IC = 0
c*           GO TO 999

      call lbclos(lui)
      call lbclos(luo)
      call daclos(lud1)
      call ccexit(IC)

 802  CONTINUE

C RLC 11/04/88
C   PICK UP SIGN OF TRACE DISTANCE ONLY FROM LIVE TRACE
      
      IF(I2NPUT(125).LT.30000)THEN
         LSAVE  = I2NPUT(119)
         LDSAVE = ISIGN(1,LSAVE)
      ENDIF

      IRCD   = I2NPUT(106)
      
      if(ircd.gt.lrtp)then
         write(LER,305)ircd,lrtp
  305 format(/,14x,'** M0305 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'FIRST RECORD FOUND (',I5,' ) IS GREATER THAN LAST RECORD',/,14X,
     *'TO PROCESS (',I5,' ).',/,14X,
     *'JOB ABORTED.')
         IC = 100
         GO TO 999
      endif

      if(ircd.gt.frtp.and.ifrst.eq.0.and.frtp.gt.-32767)then
         write(ipr,304)ircd,frtp
  304 format(/,14X,'** M0304 ** WARNING FROM DIPF.',/,14X,
     *'FIRST RECORD FOUND (',I5,' ) IS GREATER THAN REQUESTED',
     */,14X,'FIRST RECORD TO PROCESS (',I6,' ).',/,14X,
     *'DATA SET DOES NOT CONTAIN EXPECTED RECORDS.',/,14X,
     *'PROCESSING WILL CONTINUE.')
      endif

      IF (IRCD.LT.FRTP) THEN
         CALL WRTARI (LUO,INPUT,NIT,NTPR,IPR)
         JKNT   = JKNT + 1
         GO TO 801
      ENDIF

c - added this line to match houston code - 01/29/91 - j.m.wade
      ifrst = 1
      KNT = KNT+1
      IO  = IO + 1
 806  CONTINUE
      IFLIP = 0

      ISIDE = 1
 807  CONTINUE
      IFIN2 = IFIN + (N1 * (IO - 1))
      IPNT=ITDAT+(IO-1)*NS
      IF (I2NPUT(125) .LT. 30000) THEN
         IF (IWFLG .EQ. 1) THEN
            DEPTH = I2NPUT(97)
            DIST  = I2NPUT(119)
            WBTIME = SQRT((2. * DEPTH) **2. + (DIST **2)) / WVEL
            IWBSMP(IO) = WBTIME / NSR + WBBIAS
            IF (IWBSMP(IO) .GE. NS) IWBSMP(IO) = NS - 1
            NWBSAV = IWBSMP(IO) + WBB2 + 1
            IF (NWBSAV .GT. NS) NWBSAV = NS
            IWB = IWBSAV + (NS * (IO - 1))
            IF (IFMT .EQ. 3) THEN
               CALL VMOV ( TRI(1), 1, WBSAV(IWB+1), 1, NWBSAV )
            ELSE
               CALL ITOFP (I2NPUT(129), WBSAV(IWB+1), NWBSAV)
            ENDIF
         ELSE
            IWBSMP(IO) = 0
         ENDIF

         IF (IEARLY .EQ. 0) THEN
            IF (IFMT .EQ. 1) THEN
               CALL IZEROS (I2NPUT(129+IWBSMP(IO)), NS-IWBSMP(IO),
     &                      LZEROS(IO))
            ELSE
c*              CALL RZEROS ( RDATA(65+IWBSMP(IO)), NS-IWBSMP(IO),
               call rzeros(tri(1+iwbsmp(io)),ns-iwbsmp(io),
     &                       LZEROS(IO) )
            ENDIF
         ENDIF
C
         IF (LZEROS(IO) .LT. NS-IWBSMP(IO)) THEN
            IF (IFMT .NE. 3) CALL ITOFP (I2NPUT(129),  TRI (1) , NS)

            IF (IWFLG .EQ. 1) THEN
               LZERO = IWBSMP(IO) - WBB2
               IF(LZERO.GT.NS)LZERO=NS
               CALL VMOV ( 0.0, 0,  TRI (1) , 1, LZERO )
            ENDIF

            CALL VMOV ( TRI (1) ,1,TDATA(IPNT+1),1, NS )
            CALL IAPR5 ( TRI (1) , FIN(IFIN2+1))
         ELSE
            I2NPUT(125) = 30000
            CALL VMOV ( 0.0, 0, FIN(IFIN2+1), 1, ITLEN+2 )
            CALL VMOV(0.0,0,TDATA(IPNT+1),1, NS )
         ENDIF
      ELSE
         CALL VMOV ( TRI (1)  , 1, FIN(IFIN2+1), 1, NS )
         CALL VMOV(0.0,0,TDATA(IPNT+1),1, NS )
      ENDIF

      CALL VMOV ( RDATA, 1, HDRS(1,IO), 1, ITRWRD )
      III = IO+1

      DO 10 I=III,NTRS
         NIT = 0
         CALL RTAPE (LUI,INPUT,NIT)
         IF (NIT.NE.0) GO TO 820
         WRITE (LER,410)IRCD
         write(LER,307)
  307 format(/,14X,'** M0307 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'END OF FILE ENCOUNTERED ATTEMPTING TO COMPLETE TAPER IN.',/,14X,
     *'NUMBER OF FILTER CHANNELS TOO LARGE FOR THIS DATA SET.',/,14X,
     *'JOB ABORTED.')
         IC = 100
         GO TO 999
 820     CONTINUE
         KNT  = KNT+1
         IFIN2 = IFIN + (N1 * (I - 1))
         IPNT  = ITDAT+ (I-1)*NS
         IRCD = I2NPUT(106)
         IF (I2NPUT(125) .LT. 30000) THEN
            IF (IWFLG .EQ. 1) THEN
               DEPTH = I2NPUT(97)
               DIST  = I2NPUT(119)
               WBTIME = SQRT((2. * DEPTH) **2. + (DIST **2)) / WVEL
               IWBSMP(I) = WBTIME / NSR + WBBIAS
               IF (IWBSMP(I) .GE. NS) IWBSMP(I) = NS - 1
               NWBSAV = IWBSMP(I) + WBB2 + 1
               IF (NWBSAV .GT. NS) NWBSAV = NS
               IWB = IWBSAV + (NS * (I - 1))
               IF (IFMT .EQ. 3) THEN
                  CALL VMOV ( TRI (1)  , 1, WBSAV(IWB+1), 1, NWBSAV )
               ELSE
                  CALL ITOFP (I2NPUT(129), WBSAV(IWB+1), NWBSAV)
               END IF
            ELSE
               IWBSMP(I) = 0
            ENDIF

            IF ( IEARLY .EQ. 0 ) THEN
               IF (IFMT .EQ. 1) THEN
                  CALL IZEROS (I2NPUT(129+IWBSMP(I)), NS-IWBSMP(I),
     &                 LZEROS(I))
               ELSE
                  CALL RZEROS ( TRI (1 +IWBSMP(I)), NS-IWBSMP(I),
     &                 LZEROS(I))
             
               ENDIF
            ENDIF

            IF (LZEROS(I) .LT. NS-IWBSMP(I)) THEN
               IF (IFMT .NE. 3)CALL ITOFP (I2NPUT(129), TRI (1)  , NS)
               IF (IWFLG .EQ. 1) THEN
                  LZERO = IWBSMP(I) - WBB2
                  IF(LZERO.GT.NS)LZERO=NS
                  CALL VMOV ( 0.0, 0, TRI (1)  , 1, LZERO )
               ENDIF

               CALL VMOV( TRI (1) ,1,TDATA(IPNT+1),1, NS )
               CALL IAPR5 ( TRI (1) , FIN(IFIN2+1))
            ELSE
               I2NPUT(125) = 30000
               CALL VMOV ( 0.0, 0, FIN(IFIN2+1), 1, ITLEN+2 )
               CALL VMOV(0.0,0,TDATA(IPNT+1),1, NS )
            ENDIF
         ELSE
            CALL VMOV ( TRI (1)  , 1, FIN(IFIN2+1), 1, NS )
            CALL VMOV(0.0,0,TDATA(IPNT+1),1, NS )
         ENDIF
C
C --- SAVE THE TRACE HEADER
C
         CALL VMOV ( RDATA, 1, HDRS(1,I), 1, ITRWRD )
         KRCD  = I2NPUT(106)
C RLC 11/04/88
C  PICK UP SIGN OF TRACE DISTANCE FROM LIVE TRACE ONLY

         IF(I2NPUT(125).LT.30000)THEN
            L     = I2NPUT(119)
            LDD   = ISIGN(1,L)
         ENDIF
         NTRAC = I - 1
         IF ((LDD.NE.LDSAVE .AND. I.LE.NTRS) .AND.
     *        ISTAK.EQ.2)
     *        WRITE (IPR, 8) NTRS, NTRAC, KRCD
    8       FORMAT(18X,'*** M0650 *** WARNING FROM MAIN PROGRAM.',
     *             /,14X,'THE NUMBER OF FILTER CHANNELS, ',I5,', IS ',
     *             'GREATER THAN OR EQUAL TO',/,14X,
     *             'THE NUMBER OF TRACES, ',I5,', ON ',
     *             'ONE SIDE OF THE SPLIT-SPREAD FOR RECORD ', I5,'.')
         IF (LDD .NE. LDSAVE) LDSAVE = LDD
 10   CONTINUE

C XXX CONVOLVE EACH TRACE WITH ITS RESPECTIVE FILTER TRACE
C
C +--------------------------------------+
C |  OUTPUT THE FIRST HALF OF THE TRACES |
C +--------------------------------------+
c -- added next 2 lines per crider for taper compensation -j.m.wade 12/05/90
      isw = 1
      nst = 2
  
      DO 18 IX=1,IZ
         IO  = IX
         IF (IHDRS(125,IO) .GE. 30000) THEN
            IFIN2 = IFIN + (N1 * (IO - 1))
            CALL VMOV ( FIN(IFIN2+1), 1,  TRI (1) , 1, NS )
         ELSE
            CALL VCLR(SUM,1,NS)
            DO 2010 JF=1,NSETS
               CALL VMOV (0.0, 0, XSUM(IXSUM+1), 1, ITLEN+2 )
               ISF  = IZ-IX+ISIDE
               IEZ  = IZ+IX-1
C
               IPNT=IFLTT+1+(JF-1)*NPTNTR
               IF(ISTAK.EQ.2)IPNT=IFLTT+1+2*(JF-1)*NPTNTR
               CALL EXCHN (FIN(IFIN+1), 1, FLTT(IPNT), ISF, IEZ,
     &              XSUM(IXSUM+1),  TRI (1), NST, ISW )
C +---------------------------------------------------------------+
C |         PROCESS THE WEIGHTING FOR DIP ENHANCEMENT             |
C +---------------------------------------------------------------+
               IF(WGHT(JF).GT.0.0)THEN
                  SCAL=WGHT(JF)-1.
                  CALL VSMUL( TRI (1) ,1,SCAL, TRI (1) ,1,NS)
               ENDIF
               IF(LTVAR.NE.0)THEN
                  ISAV2 = ISAVE + (NS * (JF - 1))+1
                  CALL VMOV ( TRI (1)  , 1, TEMP(ISAV2), 1, NS )
               ENDIF
 2010       CONTINUE

            IF(LTVAR.NE.0)THEN
               IPNT=ITDAT+(IO-1)*NS
               CALL VMOV(TDATA(IPNT+1),1, TRI (1) ,1, NS )
               CALL VMOV( TRI (1) ,1,SUM,1,NS)
               CALL VMOV( TRI (1) ,1,TENH,1,NS)
               DO 2015 JF=1,NSETS
                  ISAV2 = ISAVE + (NS * (JF - 1))+1
                  CALL VMOV ( TEMP(ISAV2), 1,  TRI (1) , 1, NS )
                  IF(LTVAR.EQ.1)THEN
                     IS=STRTT(JF)
                     IE=ENDT(JF)
                  ELSE
                     IE=STRTT(JF)
                     IF(JF.GT.1)THEN
                        IS=STRTT(JF-1)
                     ELSE
                        IS=IE
                     ENDIF
                     IF(NSETS.EQ.1)IS=IE
                  ENDIF

                  IF(INTER.EQ.1)THEN
                     DELST=0.
                     DELET=0.
                     ICHK=IHDRS(106,IO)
                     DELRC=ICHK-AREC(JF)
                     DELST=DELRC*DELSRC(1,JF)
                     DELET=DELRC*DELSRC(2,JF)
                     IS=IS+DELST
                     IF(IS.GT.NS)IS=NS
                     IF(IS.LE.0)IS=1
                     IE=IE+DELET
                     IF(IE.GT.NS)IE=NS
                     IF(IE.LE.0)IE=1
                  ENDIF

                  IF((IE-IS+1).LE.12)GO TO 2015

                  IF(WGHT(JF).GT.0.0)THEN
                     CALL VADD( TRI (1) ,1,TENH,1, TRI (1) ,1,NS)
                  ENDIF

                  CALL GNTRC1(SUM, TRI (1) ,IS,IE,NRAMP,LTVAR)
 2015          CONTINUE

               CALL VMOV(SUM,1, TRI (1) ,1,NS)

            ELSE

               IF(WGHT(1).GT.0.0)THEN
                  IPNT=ITDAT+(IO-1)*NS
                  CALL VADD( TRI (1) ,1,TDATA(IPNT+1),1, TRI (1) ,1,NS)
               ENDIF
            ENDIF
C +--------------------------------------------------------------------+
C | RESTORE DATA ABOVE WATER BOTTOM IF WATER BOTTOM TRACKING REQUESTED |
C +--------------------------------------------------------------------+
            IF (IWFLG .EQ. 1) THEN
               IWBSTR = IWBSMP(IO) - WBB2
               IWB = IWBSAV + (NS * (IO - 1))
               CALL VMOV ( WBSAV(IWB+1), 1,  TRI (1) , 1, IWBSTR )

               ILAST = LRMP
               IF ( IWBSTR+LRMP .GT. NS ) ILAST = NS - IWBSTR
               
               DO 20 I = 1, ILAST
                  TRI (   IWBSTR+I) =
     &                 WBSAV(IWB+IWBSTR+I) * TRIRMP(I) +
     &                 TRI (   IWBSTR+I) * (1 - TRIRMP(I))
 20            CONTINUE

            ENDIF
C +----------------------------------+
C | RESTORE EARLY MUTE IF REQUESTED  |
C | FIX THE DATA IF NECESSARY        |
C +----------------------------------+
            IF (IEARLY.EQ.0 .AND. LZEROS(IO).GT.0)
     &           CALL RSTORE (TRI  ( 1+IWBSMP(IO)),IPR,LZEROS(IO))
            IF (IOFMT.EQ.1) CALL FPTOI (I2NPUT(129), TRI (1) ,NS,ITT)
         ENDIF
C +------------------------------+
C |   RESTORE THE TRACE HEADER   |
C +------------------------------+
         CALL VMOV ( HDRS(1,IO), 1, RDATA(1), 1, ITRWRD )
C +------------------------------+
C |   OUTPUT THE SUMMED TRACE    |
C +------------------------------+
         CALL WRTARI (LUO,INPUT,LBYTE,NTPR,IPR)
         JKNT   = JKNT + 1
c -- added next lines per crider for taper compensation -j.m.wade 12/05/90
         nst = nst + 2
 18   CONTINUE
C +------------------------------------------------------------+
C |                 FINISH THE PROCESSING                      |
C +------------------------------------------------------------+
C +-------------------------------------------------------+
C |   COMPUTE POINTER TO  NEXT TRACE,INCREMENT KNT AND IO |
C +-------------------------------------------------------+
C
c -- added next 2 lines per crider for taper compensation -j.m.wade 12/05/90
      isw = 0
      nst = 0
 40   CONTINUE
C
      NIT = 0
      CALL RTAPE (LUI,INPUT,NIT)
      IF (NIT.NE.0) GO TO 500
      write(ipr,410)IRCD
      if(ircd.lt.lrtp.and.lrtp.lt.32767)then
         write(ipr,306)lrtp
  306 format(/,14X,'** M0306 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'END OF FILE ENCOUNTERED BEFORE FINDING RECORD ',I5,/,14X,
     *'DATA SET DOES NOT CONTAIN EXPECTED RECORDS.',/,14X,
     *'JOB ABORTED.')
         ic = 100
      endif
      if(ircd.lt.frtp.and.frtp.gt.-32767)then
         write(ipr,306)frtp
         ic = 100
      endif
      IEND = 1
      GO TO 599
 500  CONTINUE
      KNT   = KNT+1
      IO    = IO+1
      IREPL = MOD(KNT,NTRS)
      IF (IREPL.EQ.0) IREPL=NTRS
      IOL   = MOD(IO,NTRS)
      IF (IOL.EQ.0) IOL=NTRS
      ircd = I2NPUT(106)
      IF (I2NPUT(106).LE.LRTP) GO TO 505
      NCRD  = 1
      IO    = IO - 1
      CALL VMOV ( INPUT, 1, JDATA, 1, NS+ITRWRD)
      GO TO 599
 505  CONTINUE
      IF (ISTAK.EQ.0) GO TO 510
C +---------------------------------------+
C |  CHECK FOR TAPER OUT IF SPLIT SPREAD  |
C +---------------------------------------+
      IF (ISTAK.NE.2) GO TO 5055
C RLC 11/04/88
C  PICK UP SIGN OF TRACE DISTANCE FROM LIVE TRACE ONLY
      IF(I2NPUT(125).LT.30000)THEN
         L  = I2NPUT(119)
         LD = ISIGN(1,L)
      ENDIF
      IF (LD .NE. LDSAVE) LDSAVE = LD
      IF (IHCH.EQ.0) GO TO 5054
      IF (LD.NE.LDD .AND. KNT.GT.IHCH) GO TO 5054
      WRITE(IPR,778)
 778  FORMAT(18X,'*** M0656 *** WARNING FROM MAIN PROGRAM.',/,14X
     *     ,'CENTER OF SPLIT SPREAD NOT DETECTED AT'
     *     ,' HALF SPLIT SPREAD NUMBER OF CHANNELS')
 5054 IF (LD.NE.LDD) GO TO 506
      IF (IHCH.GT.0 .AND. KNT.GT.IHCH) GO TO 506
 5055 IF (I2NPUT(106).EQ.KRCD) GO TO 510
 506  CONTINUE
      IO = IO -1
      CALL VMOV ( INPUT, 1, JDATA, 1, NS + ITRWRD)

      GO TO 599
 510  CONTINUE
      IFIN2 = IFIN + (N1 * (IREPL - 1))
      IPNT  = ITDAT+ (IREPL-1)*NS
      IF (I2NPUT(125) .LT. 30000) THEN
         IF (IWFLG .EQ. 1) THEN
            DEPTH = I2NPUT(97)
            DIST  = I2NPUT(119)
            WBTIME = SQRT((2. * DEPTH) **2. + (DIST **2)) / WVEL
            IWBSMP(IREPL) = WBTIME / NSR + WBBIAS
            IF (IWBSMP(IREPL) .GE. NS) IWBSMP(IREPL) = NS - 1
            NWBSAV = IWBSMP(IREPL) + WBB2 + 1
            IF (NWBSAV .GT. NS) NWBSAV = NS
            IWB = IWBSAV + (NS * (IREPL - 1))
            IF (IFMT .EQ. 3) THEN
               CALL VMOV (  TRI (1) , 1, WBSAV(IWB+1), 1, NWBSAV )
            ELSE
               CALL ITOFP (I2NPUT(129), WBSAV(IWB+1), NWBSAV)
            ENDIF
         ELSE
            IWBSMP(IREPL) = 0
         ENDIF
         IF ( IEARLY .EQ. 0 ) THEN
            IF ( IFMT .EQ. 1 ) THEN
               CALL IZEROS ( I2NPUT(129+IWBSMP(IREPL)),
     &              NS-IWBSMP(IREPL), LZEROS(IREPL) )
            ELSE
               CALL RZEROS (  TRI ( 1+IWBSMP(IREPL)),
     &              NS-IWBSMP(IREPL), LZEROS(IREPL) )
            ENDIF
         ENDIF
         
         IF (LZEROS(IREPL) .LT. NS-IWBSMP(IREPL)) THEN
            IF (IFMT .NE. 3) CALL ITOFP (I2NPUT(129),  TRI (1) , NS)
            IF (IWFLG .EQ. 1) THEN
               LZERO = IWBSMP(IREPL) - WBB2
               IF(LZERO.GT.NS)LZERO=NS
               CALL VMOV ( 0.0, 0,  TRI (1) , 1, LZERO )
            ENDIF

            CALL VMOV( TRI (1) ,1,TDATA(IPNT+1),1, NS )
            CALL IAPR5 ( TRI (1) , FIN(IFIN2+1))
         ELSE
            I2NPUT(125) = 30000
            CALL VMOV ( 0.0, 0, FIN(IFIN2+1), 1, ITLEN+2 )
            CALL VMOV(0.0,0,TDATA(IPNT+1),1, NS )
         ENDIF
      ELSE
         CALL VMOV (  TRI (1) , 1, FIN(IFIN2+1), 1, NS )
         CALL VMOV(0.0,0,TDATA(IPNT+1),1, NS )
      ENDIF
C +--------------------------+
C |   SAVE THE TRACE HEADER  |
C +--------------------------+
      CALL VMOV ( RDATA, 1, HDRS(1,IREPL), 1, ITRWRD)
C +--------------------------+
C |   DO THE CONVOLUTION     |
C +--------------------------+
      ISTRT = IREPL+1
      IF (ISTRT.GT.NTRS) ISTRT=1
      IFLT = ISIDE

      IF (IHDRS(125,IOL) .GE. 30000) THEN
         IFIN2 = IFIN + (N1 * (IOL - 1))
         CALL VMOV ( FIN(IFIN2+1), 1,  TRI (1) , 1, NS )
      ELSE
         CALL VCLR(SUM,1,NS)
         DO 2020 JF=1,NSETS
            CALL VMOV ( 0.0, 0, XSUM(IXSUM+1), 1, ITLEN+2 )
            IPNT=IFLTT+1+(JF-1)*NPTNTR
            IF(ISTAK.EQ.2)IPNT=IFLTT+1+2*(JF-1)*NPTNTR
            CALL EXCHN (FIN(IFIN+1), ISTRT, FLTT(IPNT), IFLT, NTRS,
     &           XSUM(IXSUM+1),  TRI (1), NST, ISW )
C +---------------------------------------------------------------+
C |         PROCESS THE WEIGHTING FOR DIP ENHANCEMENT             |
C +---------------------------------------------------------------+
            IF(WGHT(JF).GT.0.0)THEN
               SCAL=WGHT(JF)-1.
               CALL VSMUL( TRI (1) ,1,SCAL, TRI (1) ,1,NS)
            ENDIF

            IF(LTVAR.NE.0)THEN
               ISAV2 = ISAVE + (NS * (JF - 1))+1
               CALL VMOV (  TRI (1) , 1, TEMP(ISAV2), 1, NS )
            ENDIF

 2020    CONTINUE

         IF(LTVAR.NE.0)THEN
            IPNT=ITDAT+(IOL-1)*NS
            CALL VMOV(TDATA(IPNT+1),1, TRI (1) ,1, NS )
            CALL VMOV( TRI (1) ,1,SUM,1,NS)
            CALL VMOV( TRI (1) ,1,TENH,1,NS)
            DO 2025 JF=1,NSETS
               ISAV2 = ISAVE + (NS * (JF - 1))+1
               CALL VMOV ( TEMP(ISAV2), 1,  TRI (1) , 1, NS )
               IF(LTVAR.EQ.1)THEN
                  IS=STRTT(JF)
                  IE=ENDT(JF)
               ELSE
                  IE=STRTT(JF)
                  IF(JF.GT.1)THEN
                     IS=STRTT(JF-1)
                  ELSE
                     IS=IE
                  ENDIF
                  IF(NSETS.EQ.1)IS=IE
               ENDIF
               IF(INTER.EQ.1)THEN
                  DELST=0.
                  DELET=0.
                  ICHK=IHDRS(106,IOL)
                  DELRC=ICHK-AREC(JF)
                  DELST=DELRC*DELSRC(1,JF)
                  DELET=DELRC*DELSRC(2,JF)
                  IS=IS+DELST
                  IF(IS.GT.NS)IS=NS
                  IF(IS.LE.0)IS=1
                  IE=IE+DELET
                  IF(IE.GT.NS)IE=NS
                  IF(IE.LE.0)IE=1
               ENDIF
               IF((IE-IS+1).LE.12)GO TO 2025
               IF(WGHT(JF).GT.0.0)THEN
                  CALL VADD( TRI (1) ,1,TENH,1, TRI (1) ,1,NS)
               ENDIF
               CALL GNTRC1(SUM, TRI (1) ,IS,IE,NRAMP,LTVAR)
 2025       CONTINUE

            CALL VMOV(SUM,1, TRI (1) ,1,NS)
         ELSE

            IF(WGHT(1).GT.0.0)THEN
               IPNT=ITDAT+(IOL-1)*NS
               CALL VADD( TRI (1) ,1,TDATA(IPNT+1),1, TRI (1) ,1,NS)
            ENDIF
         ENDIF
C +--------------------------------------------------------------------+
C | RESTORE DATA ABOVE WATER BOTTOM IF WATER BOTTOM TRACKING REQUESTED |
C +--------------------------------------------------------------------+
         IF (IWFLG .EQ. 1) THEN
            IWBSTR = IWBSMP(IOL) - WBB2
            IWB = IWBSAV + (NS * (IOL - 1))
            CALL VMOV ( WBSAV(IWB+1), 1,  TRI (1) , 1, IWBSTR )
            ILAST = LRMP
            IF ( IWBSTR+LRMP .GT. NS ) ILAST = NS - IWBSTR
            DO 50 I = 1, ILAST
               TRI (   IWBSTR+I) =
     &              WBSAV(IWB+IWBSTR+I) * TRIRMP(I) +
     &              TRI (  IWBSTR+I) * (1 - TRIRMP(I))
 50         CONTINUE
         ENDIF
C +----------------------------------+
C | RESTORE EARLY MUTE IF REQUESTED  |
C | FIX THE DATA IF NECESSARY        |
C +----------------------------------+
         IF (IEARLY.EQ.0 .AND. LZEROS(IOL).GT.0)
     &        CALL RSTORE ( TRI ( 1+IWBSMP(IOL)),IPR,LZEROS(IOL))
         IF (IOFMT.EQ.1) CALL FPTOI (I2NPUT(129), TRI (1) ,NS,ITT)
      ENDIF

C +------------------------------+
C |   RESTORE THE TRACE HEADER   |
C +------------------------------+
      CALL VMOV ( HDRS(1,IOL), 1, RDATA(1), 1, ITRWRD )
C +--------------------+
C |  OUTPUT THE TRACE  |
C +--------------------+
      CALL WRTARI (LUO,INPUT,LBYTE,NTPR,IPR)
      JKNT   = JKNT + 1
      GO TO 40
C +------------------------------------------------------------+
C |                          TAPER OUT                         |
C +------------------------------------------------------------+
 599  CONTINUE
c -- added next 2 lines per crider for taper compensation -j.m.wade 12/05/90
      isw = -1
      nst = 1
      NDO = NTRS - 1
      DO 610 I=1,IZ1
         IO  = IO+1
         IOL = MOD(IO,NTRS)
         IF (IOL.EQ.0) IOL=NTRS
         IF (IHDRS(125,IOL) .GE. 30000) THEN
            IFIN2 = IFIN + (N1 * (IOL - 1))
            CALL VMOV ( FIN(IFIN2+1), 1,  TRI (1) , 1, NS )
            NDO = NDO - 1
         ELSE
            JTRC = IOL-IZ1
            IF (JTRC.LE.0) JTRC = IOL+IZ
            JTRC = MOD(JTRC,NTRS)
            IF (JTRC.EQ.0) JTRC=NTRS

            IFLT = ISIDE

            CALL VCLR(SUM,1,NS)
            DO 2030 JF=1,NSETS
               CALL VMOV ( 0.0, 0, XSUM(IXSUM+1), 1, ITLEN+2 )
               IPNT=IFLTT+1+(JF-1)*NPTNTR
               IF(ISTAK.EQ.2)IPNT=IFLTT+1+2*(JF-1)*NPTNTR
               CALL EXCHN (FIN(IFIN+1), JTRC, FLTT(IPNT), IFLT,
     &              NDO, XSUM(IXSUM+1),  TRI (1), NST, ISW )
C +---------------------------------------------------------------+
C |         PROCESS THE WEIGHTING FOR DIP ENHANCEMENT             |
C +---------------------------------------------------------------+
               IF(WGHT(JF).GT.0.0)THEN
                  SCAL=WGHT(JF)-1.
                  CALL VSMUL( TRI (1) ,1,SCAL, TRI (1) ,1,NS)
               ENDIF
               IF(LTVAR.NE.0)THEN
                  ISAV2 = ISAVE + (NS * (JF - 1))+1
                  CALL VMOV (  TRI (1) , 1, TEMP(ISAV2), 1, NS )
               ENDIF

 2030       CONTINUE

            IF(LTVAR.NE.0)THEN
               IPNT=ITDAT+(IOL-1)*NS
               CALL VMOV(TDATA(IPNT+1),1, TRI (1) ,1, NS )
               CALL VMOV( TRI (1) ,1,SUM,1,NS)
               CALL VMOV( TRI (1) ,1,TENH,1,NS)
               DO 2035 JF=1,NSETS
                  ISAV2 = ISAVE + (NS * (JF - 1))+1
                  CALL VMOV ( TEMP(ISAV2), 1,  TRI (1) , 1, NS )
                  IF(LTVAR.EQ.1)THEN
                     IS=STRTT(JF)
                     IE=ENDT(JF)
                  ELSE
                     IE=STRTT(JF)
                     IF(JF.GT.1)THEN
                        IS=STRTT(JF-1)
                     ELSE
                        IS=IE
                     ENDIF
                     IF(NSETS.EQ.1)IS=IE
                  ENDIF
                  IF(INTER.EQ.1)THEN
                     DELST=0.
                     DELET=0.
                     ICHK=IHDRS(106,IOL)
                     DELRC=ICHK-AREC(JF)
                     DELST=DELRC*DELSRC(1,JF)
                     DELET=DELRC*DELSRC(2,JF)
                     IS=IS+DELST
                     IF(IS.GT.NS)IS=NS
                     IF(IS.LE.0)IS=1
                     IE=IE+DELET
                     IF(IE.GT.NS)IE=NS
                     IF(IE.LE.0)IE=1
                  ENDIF
                  IF(WGHT(JF).GT.0.0)THEN
                     CALL VADD( TRI (1) ,1,TENH,1, TRI (1) ,1,NS)
                  ENDIF
                  CALL GNTRC1(SUM, TRI (1) ,IS,IE,NRAMP,LTVAR)
 2035          CONTINUE

               CALL VMOV(SUM,1, TRI (1) ,1,NS)
            ELSE
               IF(WGHT(1).GT.0.0)THEN
                  IPNT=ITDAT+(IOL-1)*NS
                  CALL VADD( TRI (1) ,1,TDATA(IPNT+1),1, TRI (1) ,1,NS)
               ENDIF
            ENDIF

            NDO = NDO-1
C +--------------------------------------------------------------------+
C | RESTORE DATA ABOVE WATER BOTTOM IF WATER BOTTOM TRACKING REQUESTED |
C +--------------------------------------------------------------------+
            IF (IWFLG .EQ. 1) THEN
               IWBSTR = IWBSMP(IOL) - WBB2
               IWB = IWBSAV + (NS * (IOL - 1))
               CALL VMOV ( WBSAV(IWB+1), 1,  TRI (1) , 1, IWBSTR )
               ILAST = LRMP
               IF ( IWBSTR+LRMP .GT. NS ) ILAST = NS - IWBSTR
               DO 60 J = 1, ILAST
                  TRI (   IWBSTR+J) =
     &                 WBSAV(IWB+IWBSTR+J) * TRIRMP(J) +
     &                 TRI (   IWBSTR+J) * (1 - TRIRMP(J))
 60            CONTINUE
            ENDIF
C +----------------------------------+
C | RESTORE EARLY MUTE IF REQUESTED  |
C | FIX THE DATA IF NECESSARY        |
C +----------------------------------+
            IF (IEARLY.EQ.0 .AND. LZEROS(IOL).GT.0)
     &           CALL RSTORE ( TRI (1+ IWBSMP(IOL)),IPR,LZEROS(IOL))
            IF (IOFMT.EQ.1) CALL FPTOI (I2NPUT(129), TRI (1) ,NS,ITT)
         ENDIF
C +------------------------------+
C |   RESTORE THE TRACE HEADER   |
C +------------------------------+
         CALL VMOV ( HDRS(1,IOL), 1, RDATA(1), 1, ITRWRD)
C +--------------------+
C |  OUTPUT THE TRACE  |
C +--------------------+
         CALL WRTARI (LUO,INPUT,LBYTE,NTPR,IPR)
         JKNT   = JKNT + 1
c -- added next line per crider for taper compensation -j.m.wade 12/05/90
         nst = nst + 1
C
C +-----------------------------------------------------+
C |   CHECK FOR EOJ,RECORD-BOUNDARY OR NEXT CARD        |
C +-----------------------------------------------------+
C
 610  CONTINUE

      CALL VMOV ( JDATA, 1, INPUT, 1, NS+ITRWRD)
      IF (IEND.EQ.1) GO TO 999
      IF (ISTAK.EQ.2 .AND. IFLIP.EQ.0) GO TO 612
 612  IOKNT = IOKNT+KNT
      KNT   = 1
      IO    = 1
      IF (ISTAK.EQ.2) GO TO 350
      IF (ISTAK.EQ.1 .AND. NCRD.EQ.0) GO TO 806
      NCRD = 0
      IO   = 0
      KNT  = 0
      GO TO 350
C-------------------------------------------------------C
 999  CONTINUE
      IF (NIT .EQ. 0 .OR. IC .EQ. 100) GO TO 1020
      GO TO 1010
 1000 NIT = 0
      CALL RTAPE (LUI,INPUT,NIT)
      IF (NIT .EQ. 0) GO TO 1020
 1010 JKNT = JKNT + 1
      CALL WRTARI (LUO,INPUT,NIT,NTPR,IPR)
      GO TO 1000
 1020 CONTINUE
      CALL LBCLOS (LUI)
      CALL LBCLOS(LUO)
      call daclos(lud1)
      call ccexit(0)
  
      STOP
      END

c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  Subroutines
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      SUBROUTINE EXCHN (FIN, IDNDX, FLTT, IFNDX, NCONVS, XSUM, OUT,
     1                      NST, ISW)
C
#include <f77/lhdrsz.h>
      COMPLEX       XSUM(*), FLTT(*), FIN(*)
C
      REAL OUT(*)
C
#ifndef CRAYSYSTEM
      INTEGER*2 IHDRS
#else
      INTEGER IHDRS
#endif
C
      DATA          IONCE/0/
C
      COMMON/NMDFF/NS,IFLIP,ITLEN,NSR
      COMMON/FLDFF/NPTS,NTRS,IHDRS(128,47)
C
      SAVE IONCE,N1
C
      IF ( IONCE .EQ. 0 ) THEN
         IONCE  = 1
         N1 = ITLEN / 2 + 1
      ENDIF
C
      IDNDXN = IDNDX
      IFNDXN = IFNDX
C
      DO 10 J = 1, NCONVS
         IF (IHDRS(125,IDNDXN) .NE. 30000) THEN
C
C**** COMPLEX MULTIPLY FFT OF THE TRACE AND FFT OF THE FILTER
C
            IFLTT = (IFNDXN - 1) * N1 +1
            IFIN  = (IDNDXN - 1) * N1 +1

c -- added another call to cvma as per crider for taper compensation
c -- on taper in or taper out				-j.m.wade 12/05/90

	    if (isw .gt. 0 .and. j .ge. nst) then
              CALL CVMA (FLTT(IFLTT), 2, FIN(IFIN), 2, xsum(1), 2,
     &                  xsum(1), 2, N1, 1)
	    endif
     	    if (isw .lt. 0 .and. j .le. nst) then
              CALL CVMA (FLTT(IFLTT), 2, FIN(IFIN), 2, xsum(1), 2,
     &                  xsum(1), 2, N1, 1)
	    endif

            CALL CVMA (FLTT(IFLTT), 2, FIN(IFIN), 2, xsum(1), 2,
     &                  xsum(1), 2, N1, 1)
          ENDIF
C
         IDNDXN = IDNDXN + 1
         IF (IDNDXN .GT. NTRS) IDNDXN = 1
         IFNDXN = IFNDXN + 1
 10   CONTINUE
C
C     INVERSE FFTS
C
cmam 04-20-89..........................................................c
c   SCRFT calls changed to qtc calls.  See IBM version for SCRFT.......c
      call rfftsc (xsum,itlen,-3,-1)
      call rffti (xsum, out, itlen)
cmam 04-20-89..........................................................c
C
C
      RETURN
      END
C
C
      SUBROUTINE BLDRMP ( ISI, PRINTR )

***********************************************************************
*                                                                     *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
*                                                                     *
***********************************************************************
************************************************************************
*
* @@@@@@@@@ @@@@@@@@@ @@@@@@@   @@@@@@@@@ @@@@@@@        @     @@@   @@@
* @       @ @       @ @      @  @       @ @      @     @   @   @ @   @ @
* @ @@@@@@@ @ @@@@@ @ @ @@@@@ @ @@@@ @@@@ @ @@@@@ @   @ @ @ @  @  @  @ @
* @ @@@@@   @ @   @ @ @ @@@@@ @    @ @    @ @@@@@ @  @ @@@@@ @ @ @ @ @ @
* @     @   @ @   @ @ @     @      @ @    @     @    @       @ @ @@ @@ @
* @ @@@@@   @ @   @ @ @ @@@@ @     @ @    @ @@@@ @   @ @@@@@ @ @ @ @ @ @
* @ @       @ @@@@@ @ @ @   @ @    @ @    @ @   @ @  @ @   @ @ @ @  @  @
* @ @       @       @ @ @   @ @    @ @    @ @   @ @  @ @   @ @ @ @   @ @
* @@@       @@@@@@@@@ @@@   @@@    @@@    @@@   @@@  @@@   @@@ @@@   @@@
*
*                         @@@@@@@@  @@@@@@@@
*                        @      @  @      @
*                       @@@@@@ @  @@@@@@ @
*                           @ @       @ @
*                          @ @       @ @
*                         @ @       @ @
*                        @ @       @ @
*                       @ @       @ @
*                      @@@       @@@
************************************************************************
***********************************************************************
*                                                                     *
*  NAME    : BUILD RAMP                       ENTRYS: RZEROS  IZEROS  *
*  AUTHOR  : DAVID LEWIS                              RSTORE          *
*  DATE    : 07/10/86                                                 *
*                                                                     *
*  PURPOSE : SUBROUTINE BLDRMP WILL BUILD A 48MS RAMP TO BE           *
*            USED FOR SMOOTHING THE FRONT OF A TRACE.                 *
*                                                                     *
*  INPUT   : ISI    - INTEGER * 4 SAMPLE INTERVAL GIVEN IN MS.        *
*            PRINTR - INTEGER * 4 PRINTER UNIT NUMBER.                *
*                                                                     *
*  PASSED  : RMPFLG - LOGICAL * 4 FLAG USED BY "RSTORE" ROUTINE.      *
*            RAMP   - REAL * 4 RAMP ARRAY USED BY "RSTORE" ROUTINE.   *
*            RMPLEN - INTEGER * 4 RAMP LENGTH USED BY "RSTORE" .      *
*                                                                     *
*  INTERNAL VARIABLES:                                                *
*           RAMP   - REAL * 4 RAMP ARRAY CONTAINING THE RAMP VALUES.  *
*           RMPLEN - INTEGER * 4 VALUE FOR RAMP LENGTH.               *
*           RMPDIM - INTEGER * 4 VALUE FOR RAMP DIMENSION OF 48.      *
*           RMPFLG - LOGICAL * 4 RAMP FLAG INDICATES "BLDRMP" INVOKED *
*                                                                     *
***********************************************************************
*
*                       ----------------------------
*                       |       DECLARATIONS       |
*                       ----------------------------
      REAL         RTRACE ( 1 )
     *            ,RAMP   ( 48 )
*
      INTEGER      RMPLEN
     *            ,RMPDIM
     *            ,PRINTR
     *            ,TRALEN
c
c  set up a local variable to hold TRALEN - j.m. wade
c
      integer ltrlen
*
      LOGICAL*4    RMPFLG
*
#ifndef CRAYSYSTEM
      INTEGER*2 ITRACE (1)
#else
      INTEGER ITRACE(1)
#endif
*
      DATA       RMPDIM / 48 /
     *          ,RMPFLG /.FALSE. /

      save rmpdim,rmpflg,ltrlen,rmplen,ramp
*
*                    -------------------------------
*                    | CHECK SAMPLE INTERVAL RANGE |
*                    -------------------------------
      IF ( ISI .EQ. 1  .OR.
     *     ISI .EQ. 2  .OR.
     *     ISI .EQ. 3  .OR.
     *     ISI .EQ. 4  .OR.
     *     ISI .EQ. 6  .OR.
     *     ISI .EQ. 8  .OR.
     *     ISI .EQ. 12 .OR.
     *     ISI .EQ. 16)         GO TO 10
*
*
*                     --------------------------------
*                     | PRINT ERROR MESSAGE AND EXIT |
*                     --------------------------------
*
*
      WRITE (PRINTR,1) ISI
    1 FORMAT('0','** M0001 **  ERROR DETECTED BY SUBROUTINE BLDRMP',/,
     *T14,' THE SAMPLE INTERVAL "',I4,'" IS INVALID.    THE SAMPLE IN',
     *    'TERVAL MUST BE 1,2,3,4,6,8,12, OR 16 .')
      CALL CCEXIT(100)
*
*
*                       ---------------------------
*                       |  CALCULATE RAMP LENGTH  |
*                       ---------------------------
*
   10 RMPLEN = RMPDIM / ISI
*
*
*                       ----------------------------
*                       | CALCULATE RAMP INCREMENT |
*                       ----------------------------
*
      XRAMP = 1.0 / FLOAT (RMPLEN)
*
*
*                       ----------------------------
*                       |   INITIALIZE RAMP ARRAY  |
*                       ----------------------------
*
      DO 20 I = 1, RMPLEN
         RAMP ( I ) = I * XRAMP
   20 CONTINUE
*
*
*             --------------------------------------------------
*             | INDICATE "BLDRMP" WAS INVOKED BY SETTING FLAG. |
*             --------------------------------------------------
*
      RMPFLG = .TRUE.
      RETURN
*
*
      ENTRY IZEROS ( ITRACE, TRALEN, LZEROS )
***********************************************************************
*                                                                     *
*  NAME    : INTEGER ZEROS                                            *
*                                                                     *
*  PURPOSE : IZEROS WILL COUNT THE NUMBER OF LEADING ZEROS IN         *
*            A I*2 TRACE FOR PRESERVING THE EARLY MUTE .              *
*                                                                     *
*  INPUT   : ITRACE - I*2 ARRAY HOLDING THE TRACE DATA.               *
*          : TRALEN - I*4 VALUE SPECIFYING THE TRACE LENGTH.          *
*                                                                     *
*  OUTPUT  : LZEROS - I*4 NUMBER OF LEADING ZEROES                    *
*                                                                     *
***********************************************************************
*         ---------------------------------------------------------
*         |  COUNT THE NUMBER OF ZEROS AT THE FRONT OF THE TRACE. |
*         ---------------------------------------------------------
      ltrlen = tralen
      LZEROS = 0
      DO 90 I = 1, TRALEN
         IF ( ITRACE ( I ) .NE. 0 ) RETURN
         LZEROS = LZEROS + 1
   90 CONTINUE
*          ------------------------
*          |  TRACE IS ALL ZEROS  |
*          ------------------------
      RETURN
*
*
*
      ENTRY RSTORE ( RTRACE, PRINTR, ICOUNT )
*
***********************************************************************
*                                                                     *
*    NAME   : RESTORE                                                 *
*                                                                     *
*    PURPOSE: THIS SUBROUTINE IS CALLED TO RESTORE AN EARLY MUTE OF   *
*             ZEROS FOR A SEISMIC TRACE AND THEN SMOOTH THE TRACE     *
*             WITH A RAMP FUNCTION.                                   *
*                                                                     *
*    INPUT  : RTRACE -  REAL ARRAY HOLDING THE TRACE DATA.            *
*             PRINTR -  INTEGER PRINTER UNIT NUMBER.                  *
*             ICOUNT -  INTEGER VALUE SPECIFYING THE COUNT            *
*                       OF ZEROS TO BE PLACED IN FRONT OF THE TRACE.  *
*             RAMP   -  REAL ARRAY HOLDING THE RAMP FUNCTION.         *
*                       SUPPLIED BY "BLDRMP" ROUTINE.                 *
*             RMPLEN -  INTEGER VALUE SPECIFYING THE RAMP             *
*                       LENGTH IN SAMPLES.  SUPPLIED BY "BLDRMP" PGM. *
*             RMPFLG -  LOG*4 FLAG USED TO VERIFY BLDRMP WAS INVOKED. *
*                       SUPPLIED BY "BLDRMP" ROUTINE.                 *
*                                                                     *
*    OUTPUT : RTRACE -  REAL ARRAY HOLDING RESORTED TRACE DATA.       *
*                                                                     *
***********************************************************************
*      ---------------------------------------------------------
*      |  VERIFY THAT THE "BLDRMP"  ROUTINE WAS INVOKED        |
*      |  PRIOR TO APPLYING THE RAMP FUNCTION.                 |
*      ---------------------------------------------------------
      IF ( .NOT. RMPFLG ) THEN
         WRITE (PRINTR,21)
   21    FORMAT(
     *   '0','** M0021 **  ERROR DETECTED BY SUBROUTINE RSTORE',/,T14
     *   ,' SUBROUTINE "BLDRMP" MUST BE CALLED AT LEAST ONCE BEFORE',
     *    ' INVOKING SUBROUTINE "RSTORE".')
         CALL CCEXIT (100)
      ENDIF
*      ---------------------------------------------------------
*      | RESTORE THE ZEROS AT THE FRONT OF THE TRACE IF ZEROS  |
*      | WERE FOUND.  IF NOT THEN DONT RESTORE OR APPLY RAMP.  |
*      ---------------------------------------------------------
*
      IF ( ICOUNT .NE. 0 )  THEN
*
         CALL VMOV ( 0.0, 0, RTRACE, 1, ICOUNT )
CCCCCCC  CALL SCOPY (ICOUNT, 0.0, 0, RTRACE, 1)
*                 -----------------------------------
*                 | MUTLIPLY THE RAMP BY THE TRACE. |
*                 -----------------------------------
*
* --- RESET THE RAMP LENGTH IF NECESSARY.
         LENGTH = RMPLEN
c        IF (ICOUNT + RMPLEN  .GT.  TRALEN)   LENGTH = TRALEN - ICOUNT
         IF (ICOUNT + RMPLEN  .GT.  ltrlen)   LENGTH = ltrlen - ICOUNT
*
         DO 50 I = 1, LENGTH
            J            = ICOUNT + I
            RTRACE ( J ) = RTRACE ( J ) * RAMP ( I )
   50    CONTINUE
*
      ENDIF
      RETURN
*
*
      ENTRY RZEROS ( RTRACE, TRALEN, LZEROS )
***********************************************************************
*                                                                     *
*  NAME    : REAL ZEROS                                               *
*                                                                     *
*  PURPOSE : RZEROS WILL COUNT THE NUMBER OF LEADING ZEROS IN         *
*            A R*4 TRACE FOR PRESERVING THE EARLY MUTE .              *
*                                                                     *
*  INPUT   : RTRACE - R*4 ARRAY HOLDING THE TRACE DATA.               *
*            TRALEN - I*4 VALUE SPECIFYING THE TRACE LENGTH.          *
*            LZEROS - I*4 NUMBER OF LEADING ZEROES                    *
*                                                                     *
***********************************************************************
*         ---------------------------------------------------------
*         |  COUNT THE NUMBER OF ZEROS AT THE FRONT OF THE TRACE. |
*         ---------------------------------------------------------
      LZEROS = 0
      ltrlen = tralen
      DO 70 I = 1, TRALEN
         IF ( RTRACE ( I ) .NE. 0.0 ) RETURN
         LZEROS = LZEROS + 1
   70 CONTINUE
*         ------------------------
*         |  TRACE IS ALL ZEROS  |
*         ------------------------
      RETURN
      END
C
C
C
C ----SUBROUTINE TO COMPUTE THE NF CHANNEL DIP FILTER
C
C     CODED BY T SCHEUER
C
C                 RF   = REAL FILTERS (RETURNED)
C               F(I,J) = THE COMPLEX MATRIX CONTAINING THE REAL
C                        FILTERS AFTER EXIT FROM DIPF ROUTINE
C                   LF = THE LENGTH OF EACH FILTER
C                   NF = THE NUMBER OF FILTERS
C               ALPHA1 = MAXIMUM DOWN DIP (SAMPLES PER TRACE)
C                 BETA = MIMIMUM DOWN DIP (SAMPLES PER TRACE)
C                SIGMA = MAXIMUM UP DIP (SAMPLES PER TRACE)
C                  RHO = MINIMUM UP DIP (SAMPLES PER TRACE)
C                   B  = DOWN DIP NOISE TO SIGNAL RATIO
C                   C  = UP DIP NOISE TO SIGNAL RATIO
C                  IAL = THE ALIAS FLAG (1=ALIAS, ELSE NO ALIAS)
C                  SN  = FACTOR TO VARY NOISE TO SIGNAL RATIO W/FREQ
C                 EXP  = ROSS WEIGHTING EXPONENT
C                  EX  = BESSEL WEIGHTING EXPONENT
C               IPASS  = 0 FOR REJECT FILTER
C                      = 1 FOR PASS FILTER
C
C
      SUBROUTINE DIPF(RF,F,LF,NF,ALPHA1,BETA,
     *                SIGMA,RHO,B,C,IAL,EX,IPASS,IPLF)
      COMPLEX   F(NF,*),XTC(1024),FILT(47),R(47),G(47),PEO(47)
      COMPLEX   Z
      REAL   BESS(47),RF(513,47)
C
C ----INITIALIZE SOME CONSTANTS
C
      PI=3.14159265
      NF2=NF/2
      NFM2 = NF*2
      NL=NF2+1
      BC1=1.+B+C
      IPARM=ABS(ALPHA1)+ABS(BETA)+ABS(SIGMA)+ABS(RHO)+ABS(B)+ABS(C)
C
C ----COMPUTE THE ALIASING FREQUENCIES, FAD=DOWN DIP, FAU=UP DIP.
C
      FAD1=0.5
      FAD=0.5
      FAU1=0.5
      FAU=0.5
      IF(ABS(ALPHA1).GT.0.) FAD1=.5/ABS(ALPHA1)
      IF(ABS(BETA).GT.0.) FAD=.5/ABS(BETA)
      IF(ABS(SIGMA).GT.0.) FAU1=.5/ABS(SIGMA)
      IF(ABS(RHO).GT.0.) FAU=.5/ABS(RHO)
      IF(B.EQ.0.0)FAD = 0.0
      IF(C.EQ.0.0)FAU = 0.0
C
C ----DETERMINE FFT LENGTH, NYQUIST AND FREQUENCY INCREMENT
C
      LFFT=8
      DO 1 I=1,10
      IF(LFFT.GE.LF) GO TO 2
    1 LFFT=LFFT*2
    2 L=LFFT/2+1
      DF=1./FLOAT(LFFT)
c     print *,'in DIPF, IPARM,LFFT,DF=',IPARM,LFFT,DF
C
C ----COMPUTE FILTER SOLUTION BY STEPPING THROUGH EACH FREQUENCY
C
      DO 100 I=1,L
      FR=DF*(I-1)
C
      FR2=FR
      IF(IPLF.NE.0)FR2=1.0
C
      APB=ALPHA1+BETA
      AMB=ALPHA1-BETA
      SPR=SIGMA+RHO
      SMR=SIGMA-RHO
C
C ----CHECK FOR ALIASING
C
      IF(IAL.EQ.1) GO TO 31
C
C ----MODIFY FAN TO HAVE VERTICAL CUT-OFF AT THE K NYQUIST TO
C     REDUCE ALIASING
C
      IF(FR.LE.FAD1) GO TO 80
      FRS=SIGN(FR,ALPHA1)
      ALPHA1=.5/FRS
      APB=ALPHA1+BETA
      AMB=ALPHA1-BETA
   80 CONTINUE
      IF(FR.LE.FAU1) GO TO 81
      FRS=SIGN(FR,SIGMA)
      SIGMA=.5/FRS
      SPR=SIGMA+RHO
      SMR=SIGMA-RHO
   81 CONTINUE
C
      IF(FR.LT.FAD .OR. FR.LT.FAU) GO TO 31
      call CVFILL (CMPLX(0.,0.),FILT,2,NF)
cmm   DO 40 IND=1,NF
cmm40 FILT(IND)=CMPLX(0.,0.)
      FILT(NL)=CMPLX(1.,0.)
      CD = ALPHA1*BETA
      CU = SIGMA*RHO
      IF(CD.LT.0.0.OR.CU.LT.0.0)FILT(NL)=CMPLX(0.,0.)
      GO TO 32
   31 CONTINUE
C
C ----INITIALIZE R AND G AND COMPUTE SOME CONSTANTS
C      R  =  THE MUTUAL CORRELATION VECTOR (FROM CORRELATION MATRIX)
C      G  =  THE CORRELATION OF INPUT WITH DESIRED OUTPUT
C
      call CVFILL (CMPLX(0.,0.),R,2,NF)
      call CVFILL (CMPLX(0.,0.),G,2,NF)
cmm   DO 41 IND=1,NF
cmm   R(IND)=CMPLX(0.,0.)
cmm41 G(IND)=CMPLX(0.,0.)
      DFAC1=APB*FR*PI
      DFAC2=AMB*FR*PI
      UFAC1=SPR*FR*PI
      UFAC2=SMR*FR*PI
C
C ----FILL IN THE DOWN DIP COMPONENTS
C
      IF(B.EQ.0.0)GO TO 200
      IF(IAL.EQ.1) GO TO 110
      IF(FR.GE.FAD) GO TO 200
C ***************************** FILL IN DOWN DIP PART OF R
  110 CONTINUE
      DO 10 J=1,NF
      FJ=FLOAT(J-1)
      DARG1=DFAC1*FJ
      DARG2=DFAC2*FJ
      T=B*BC1*SINC(DARG2)
      DR=T*COS(DARG1)
      DI=T*SIN(DARG1)
   10 R(J)=CMPLX(DR,DI) * FR2
C ***************************** FILL IN DOWN DIP PART OF G
      DO 11 J=1,NL
      FJ=FLOAT(J-1)
      DARG1=DFAC1*FJ
      DARG2=DFAC2*FJ
      T=B*SINC(DARG2)
      DR=T*COS(DARG1)
      DI=T*SIN(DARG1)
      K=NL-J+1
   11 G(K)=CMPLX(DR,DI) * FR2
C
  200 CONTINUE
C
C ----FILL IN THE UP DIP COMPONENTS
C
      IF(C.EQ.0.0)GO TO 300
      IF(IAL.EQ.1) GO TO 120
      IF(FR.GE.FAU) GO TO 300
C ***************************** FILL IN UP DIP PART OF R
  120 CONTINUE
      DO 12 J=1,NF
      FJ=FLOAT(J-1)
      UARG1=UFAC1*FJ
      UARG2=UFAC2*FJ
      T=C*BC1*SINC(UARG2)
      UR=T*COS(UARG1)
      UI=-T*SIN(UARG1)
      Z=CMPLX(UR,UI)
   12 R(J)= R(J)+Z*FR2
C ***************************** FILL IN UP DIP PART OF G
      DO 13 J=1,NL
      FJ=FLOAT(J-1)
      UARG1=UFAC1*FJ
      UARG2=UFAC2*FJ
      T=C*SINC(UARG2)
      UR=T*COS(UARG1)
      UI=-T*SIN(UARG1)
      Z=CMPLX(UR,UI)
      K=NL-J+1
   13 G(K)=G(K)+Z*FR2
C
  300 CONTINUE
      call CVCONJ (G,2,G(NF),-2,NF2)
cmm   DO 14 J=1,NF2
cmm14 G(NF-J+1)=CONJG(G(J))
C
C ----ADD ZERO LAG SIGNAL TERM AND PREWHITEN R IF NECESSARY
C
      Z=CMPLX(1.,0.)
      R(1)=R(1)+Z
      G(NL)=G(NL)+Z
C
C ----SOLVE THE COMPLEX SYSTEM USING COMPLEX WIENER LEVINSON
C
      CALL CWLEV(R,PEO,NF,FILT,G)
C
   32 CONTINUE
C
      call CVMOV (FILT,2,F(1,I),2,NF)
cmm   DO 5 K=1,NF
cmm 5 F(K,I)=FILT(K)
C
  100 CONTINUE
C
C ----INVERSE TRANSFORM TO OBTAIN THE FILTERS
C
      DO 20 I=1,NF
      call CVFILL (CMPLX(0.,0.),XTC,2,LFFT)
cmm   DO 42 IND=1,LFFT
cmm42 XTC(IND)=CMPLX(0.,0.)
C
      L1=L-1
      call CVMOV (F(I,2),NFM2,XTC(2),2,L1-1)
      call CVCONJ (XTC(2),2,XTC(LFFT),-2,L1-1)
cmm   DO 25 J=2,L1
cmm   XTC(J)=F(I,J)
cmm   KK=LFFT-J+2
cmm25 XTC(KK)=CONJG(XTC(J))
      XTC(1)=F(I,1)
      XTC(L)=F(I,L)
C
      CALL FORK(XTC,LFFT,1.)
C
      LF2=LF/2
      LOD=LF2+1
      F(I,LOD)=XTC(1)
      call CVMOV (XTC(2),2,F(I,LOD+1),NFM2,LF2)
      call CVMOV (XTC(LFFT),-2,F(I,LOD-1),-NFM2,LF2)
cmm   DO 6 J=1,LF2
cmm   K=LFFT-J+1
cmm   F(I,LOD+J)=XTC(J+1)
cmm 6 F(I,LOD-J)=XTC(K)
C
   20 CONTINUE
C
C ----ROSS WINDOW THE CENTER FILTER (EXPONENT OF 1.)
C
C
      FMAX=FLOAT(LFFT)
      FL2=FLOAT(LF2)
      DO 7 J=1,LF2
      FAC=FLOAT(LF2-J)/FL2
      FAC=(1.-FAC*FAC)
      K=LF-J+1
      RF(J,NL)=FAC*REAL(F(NL,J))/FMAX
    7 RF(K,NL)=FAC*REAL(F(NL,K))/FMAX
      RF(LOD,NL)=REAL(F(NL,LOD))/FMAX
C
C ----BESSEL WEIGHT THE FILTERS SPATIALLY
C
      CALL BESSL(BESS,EX,NF)
C
      DO 8 I=1,NF2
      K=NF-I+1
      call VREAL(F(I,1),NFM2,RF(1,I),1,LF)
      call VREAL(F(K,1),NFM2,RF(1,K),1,LF)
cmm   call VREAL(F(K,1),-NFM2,RF(1,K),1,LF)
      val = BESS(I)/FMAX
      call VSMUL(RF(1,I),1,val,RF(1,I),1,LF)
      call VSMUL(RF(1,K),1,val,RF(1,K),1,LF)
cmm   DO 9 J=1,LF
cmm   RF(J,I)=BESS(I)*F(I,J)/FMAX
cmm 9 RF(J,K)=BESS(I)*F(K,J)/FMAX
    8 CONTINUE
      IF(IPASS.EQ.0.OR.IPARM.EQ.0) RETURN
      FSAVE=RF(LOD,NL)
      DO 33 I=1,NF
      call VNEG (RF(1,I),1,RF(1,I),1,LF)
   33 continue
cmm   DO 33 J=1,LF
cmm33 RF(J,I) = -RF(J,I)
      RF(LOD,NL) = 1.0 - FSAVE
      RETURN
      END
C
C ----FUNCTION TO COMPUTE THE SINCS
C
      FUNCTION SINC(ARG)
      SINC=1.
      IF(ARG.EQ.0.) RETURN
      SINC=SIN(ARG)/ARG
      RETURN
      END
C
C ----ROUTINE TO DO COMPLEX WIENER LEVINSON RECURSION
C
C     CODED BY T SCHEUER
C
C                 R(N) = THE COMPLEX AUTOCORRELATION VECTOR
C                 A(N) = THE COMPLEX PREDICTION ERROR OPERATOR
C                 G(N) = THE COMPLEX RIGHT HAND SIDE VECTOR
C                 F(N) = THE COMPLEX SOLUTION (PREDICTION FILTER)
C                   N  = THE DIMENSION OF THE SYSTEM
C
C ----COMPLEX LEVINSON RECURSION ROUTINE
C
      SUBROUTINE CWLEV(R,A,N,F,G)
      COMPLEX   R(1),A(1),F(1),G(1),C0,C1,C2,STORE,C,V
      A(1)=CMPLX(1.,0.)
      C=CMPLX(-1.,0.)
      V=CMPLX(1.,0.)
C
C ----NORMALIZE BY DIVIDING BOTH SIDES BY R(1)
C
      IF(REAL(R(1)).EQ.0) RETURN
      call CVCONJ(G(1),2,G(1),2,N)
      call CVDIV (G(1),2,R(1),0,G(1),2,N)
      call CVDIV (R(N),-2,R(1),0,R(N),-2,N)
cmm   DO 10 I=1,N
cmm   G(I)=CONJG(G(I))/R(1)
cmm   R(N+1-I)=R(N+1-I)/R(1)
cmm10 CONTINUE
C
C ----START THE ITERATION OF LEVINSON RECURSION
C
      F(1)=G(1)
C
      DO 50 J=2,N
      A(J)=CMPLX(0.,0.)
      F(J)=CMPLX(0.,0.)
      C0=CMPLX(0.,0.)
      C1=CMPLX(0.,0.)
C
      J1 = J-1
c     call CDOTPR (R(2),2,A(J1),-2,C0,J1)
c     call CDOTPR (R(2),2,F(J1),-2,C1,J1)
      DO 20 I=2,J
      C0=C0+R(I)*A(J-I+1)
      C1=C1+R(I)*F(J-I+1)
   20 CONTINUE
C
      C=C0/V
      V=V-C0*CONJG(C)
      C2=(C1-G(J))/V
      JH=(J+1)/2
C
      DO 30 I=1,JH
      JI1 = J-I+1
      STORE=A(JI1)-C*CONJG(A(I))
      A(I)=A(I)-C*CONJG(A(JI1))
      A(JI1)=STORE
cmm   STORE=A(J-I+1)-C*CONJG(A(I))
cmm   A(I)=A(I)-C*CONJG(A(J-I+1))
cmm   A(J-I+1)=STORE
cmm30 CONTINUE
C
cmm   DO 40 I=1,JH
      STORE=F(JI1)-C2*CONJG(A(I))
      F(I)=F(I)-C2*CONJG(A(JI1))
      F(JI1)=STORE
cmm   STORE=F(J-I+1)-C2*CONJG(A(I))
cmm   F(I)=F(I)-C2*CONJG(A(J-I+1))
cmm   F(J-I+1)=STORE
   30 CONTINUE
cmm0 CONTINUE
C
   50 CONTINUE
      RETURN
      END
C
C ----ROUTINE TO DO THE FAST FOURIER TRANSFORM WITH COMPLEX INPUT
C     AND COMPLEX OUTPUT -- THE RESULT MUST BE NORMALIZED BY 1/LX
C     IF THE PROPER SCALING IS TO BE RETAINED
C          SIGN=-1. FOWARD TRANSFORM
C              =+1. INVERSE TRANSFORM
C
      SUBROUTINE FORK (CX,LX,SIGN)
      COMPLEX CX(1),CARG,CW,CTEMP
      J=1
      DO 30 I=1,LX
      IF(I.GT.J) GO TO 10
      CTEMP=CX(J)
      CX(J)=CX(I)
      CX(I)=CTEMP
   10 M=LX/2
   20 IF(J.LE.M) GO TO 30
      J=J-M
      M=M/2
      IF(M.GE.1) GO TO 20
   30 J=J+M
      L=1
   40 ISTEP=2*L
      DO 50 M=1,L
      CARG=(0.,1.)*(3.14152965*SIGN*(M-1))/L
      CW=CEXP(CARG)
      DO 50 I=M,LX,ISTEP
      CTEMP=CW*CX(I+L)
      CX(I+L)=CX(I)-CTEMP
   50 CX(I)=CX(I)+CTEMP
      L=ISTEP
      IF(L.LT.LX) GO TO 40
      RETURN
      END
C
C ----SUBROUTINE BESSL (FROM KEN PEACOCK) COMPUTES THE BESSEL
C     WINDOW
C
      SUBROUTINE BESSL(BESS,EX,LF)
      REAL      BESS(1)
      call VFILL (1.,BESS(1),1,LF)
cmm   DO 99 I=1,LF
cmm99 BESS(I)=1.
      N=LF/2
      ISTA=N+2
      KFACT=1-ISTA
C
      IF(EX.LE.0.) RETURN
      DEN=1.
      DS=1.
      D=0.
    3 D=D+2.
      DS=DS*EX*EX/(D*D)
      DEN=DEN+DS
      IF(DS.GT..2E-8*DEN) GO TO 3
      J=N+1
      DO 5 I=ISTA,LF
      J=J-1
      AK=I+KFACT
      EXX=EX*SQRT(1.-(AK/N)**2)
      ANUM=1.
      DS=1.
      D=0.
    4 D=D+2.
      DS=DS*EXX*EXX/(D*D)
      ANUM=ANUM+DS
      IF(DS.GT..2E-8*ANUM) GO TO 4
    5 BESS(J)=ANUM/DEN
      RETURN
      END
C
      SUBROUTINE WRTARI(LUO,IOUT,LBYTE,NTPR,IPR)
      INTEGER IOUT(*)
#include <f77/localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      integer static

c     DATA LRI/0/
c     save lri
      call saver(IOUT,'StaCor',static,1)
      idata = (SZTRHD/SZSMPD)+1
      if (static .eq. 30000)
     1   call move(0,IOUT(IDATA),0,LBYTE-SZTRHD)
c
      call saver(iout,'RecNum',irec,1)
      call saver(iout,'TrcNum',itrc,1)
      write(LERR,*)' write trace ',itrc,' record ',irec
      CALL WRTAPE(LUO,IOUT,LBYTE)
c.c.c      IR = IOUT(106)
c.c.c      IF(IR.EQ.LRI)RETURN
c.c.c      CALL RIPRNT(IR,IPR)
c.c.c      LRI = IR
      RETURN
      END
C
C**********************************************************************
C
      SUBROUTINE IAPR5 (RDATA, FIN)
C
      COMPLEX FIN(*)
C
      REAL    RDATA(*)
C
      COMMON/NMDFF/NS,IFLIP,ITLEN,NSR
C
C     FORWARD FFTS
C
      N1 = ITLEN / 2 + 1
C
      CALL VMOV ( 0.0, 0, RDATA(NS+1), 1, ITLEN-NS )
CCCCC CALL SCOPY (ITLEN-NS, 0.0, 0, RDATA(NS+1), 1)
C
C**** TRANSFORM ITLEN TIME DOMAIN TRACE ELEMENTS INTO ITLEN/2+1
C**** COMPLEX FREQUENCY DOMAIN ELEMENTS
C
cmam 04-20-89.........................................................c
c       changed to normal qtc calls ..................................c
      call rfftb (rdata, fin, itlen, 1)
      call rfftsc (fin, itlen, 3, 0)
cmam 04-20-89.........................................................c
C
      RETURN
      END
C*******************************************************************
C
      SUBROUTINE FFTFLT (F, FLTT)
C
#include <f77/lhdrsz.h>
      COMPLEX  FLTT(*)
C
      REAL     WORK(8192), F(513,94)
C
#ifndef CRAYSYSTEM
      INTEGER*2 IHDRS
#else
      INTEGER IHDRS
#endif
c
      COMMON/NMDFF/NS,IFLIP,ITLEN,NSR
      COMMON/FLDFF/NPTS,NTRS,IHDRS(128,47)
C
      N1 = ITLEN / 2 + 1
      N3 = NPTS / 2
      IFLTT = 1
C
C *** FFT ALL FILTERS
C
      DO 100 I = 1, NTRS
C
         CALL VMOV ( 0.0, 0, WORK(N3+2), 1, ITLEN-NPTS )
CCCCCCC  CALL SCOPY (ITLEN-NPTS, 0.0, 0, WORK(N3+2), 1)
C
C *** MOVE NPTS/2+1 FILTER ELEMENTS FROM IOPR STARTING AT LOCATION
C *** NPTS/2 AND STORE LEFT JUSTIFIED IN IWRK1
C
         CALL VMOV ( F(N3+1,I), 1, WORK, 1, N3+1 )
CCCCCCCC CALL SCOPY (N3+1, F(N3+1,I), 1, WORK, 1)
C
C**** MOVE NPTS/2 FILTER ELEMENTS FROM IOPR STARTING AT LOCATION 1
C**** AND STORE RIGHT JUSTIFIED IN IWRK1
C
         CALL VMOV ( F(1,I), 1, WORK(ITLEN-N3+1), 1, N3 )
CCCCCCCC CALL SCOPY (N3, F(1,I), 1, WORK(ITLEN-N3+1), 1)
C
C**** TRANSFORM ITLEN TIME DOMAIN FILTER ELEMENTS INTO ITLEN/2+1
C**** COMPLEX FREQUENCY DOMAIN ELEMENTS
C
         IFLTT = N1 * (I - 1) + 1
cmam 04-20-89 ........................................................c
c           change to normal qtc calls ...............................c
        call rfftb ( work, fltt(ifltt), itlen, 1)
        call rfftsc (fltt(ifltt), itlen, 3, 0)
cmam 04-20-89 ........................................................c
C
  100 CONTINUE
C
      RETURN
      END
      SUBROUTINE GTIME(CARD,DMI,DMX,DNS,UMI,UMX,UNS,TS,TE,FT,NSETS,
     *WGHT,MM,LTVAR,AREC,BREC,BTS,BTE,FRTP,LRTP,INTER,IERROR)
#include <f77/lhdrsz.h>
      DIMENSION DMI(*),DMX(*),DNS(*),UMI(*),UMX(*),UNS(*)
      DIMENSION WGHT(*)
      INTEGER*4 TS(*),TE(*),TS1,TE1
      INTEGER*4 FT(*),FT1,ERRKNT
      INTEGER*4 AREC(*),BREC(*),BTS(*),BTE(*),FRTP,LRTP
      INTEGER*4 RECA,RECB,BST,BET
#ifndef CRAYSYSTEM
      INTEGER*2 IHDRS
#else
      INTEGER IHDRS
#endif
      CHARACTER*80 CARD
      LOGICAL MM
      COMMON/NMDFF/NS,IFLIP,ITLEN,NSR
      COMMON/FLDFF/NPTS,NTRS,IHDRS(128,47)
      DATA KK/0/,IPR/6/,ERRKNT/0/
      SAVE kk,ipr,errknt
      LTRACE=NS*NSR
      IWERR=0
         READ(CARD,402,END=122)TS1,TE1,DWNMI1,DWNMX1,DWNNS1,
     &                UPMI1,UPMX1,UPNS1,FT1,WT1,RECA,RECB,BST,BET
  402 FORMAT(5X,2I5,2(2F5.0,F3.0),I1,1X,F4.0,1X,4I5)
      IF (FT1.NE.0.AND.FT1.NE.1)THEN
         WRITE(IPR,641)FT1
  641 FORMAT(/,18X,'** M0641 ** ERROR DETECTED IN SUBROUTINE GTIME.',
     */,14X,'THE PASS/REJECT FLAG ENTRY (',I2,') IS INVALID',/,14X,
     *'VALID ENTRIES ARE BLANK, 0, OR 1 ONLY.',
     */,14X,' CORRECT THE ENTRY BEFORE RESUBMITTING THIS JOB.')
         ERRKNT = ERRKNT+1
      ENDIF
      NPTS2=NPTS/2
      IF(MM)THEN
         KK=1
         KKK=KK
         NSETS=0
      ELSE
         KKK=KK+1
         KK=KK+1
      ENDIF
CRLC 09/88
         IF(KK.NE.1.AND.TS1.EQ.0)GO TO 122
            TS(KK)=TS1
             IF(TS1.GT.LTRACE)THEN
             WRITE(IPR,76)TS1,LTRACE
   76 FORMAT(/,18X,'** M0076 ** ERROR DETECTED IN SUBROUTINE GTIME.'/,
     *14X,'THE START TIME ',I5,' MS EXCEEDS THE TRACE LENGTH (',I5,
     *' MS).',
     */,14X,'CORRECT PARAMETERS BEFORE RESUBMITTING THIS JOB.')
              ERRKNT=ERRKNT+1
             ENDIF
            TE(KK)=TE1
            IF(TE(KK).EQ.0)TE(KK)=LTRACE
             IF(TE(KK).GT.LTRACE)THEN
             WRITE(IPR,81)TE1,LTRACE
   81 FORMAT(/,18X,'** M0081 ** ERROR DETECTED IN SUBROUTINE GTIME.'/,
     *14X,'THE END TIME ',I5,' MS EXCEEDS THE TRACE LENGTH (',I5,
     *' MS).',
     */,14X,'IT WILL BE RESET TO END OF TRACE.')
             TE(KK)=LTRACE
             ENDIF
            NSETS=NSETS+1
            DMI(KK)=DWNMI1
            DMX(KK)=DWNMX1
CRLC 09/88
             IF(DWNMI1.GT.DWNMX1)THEN
             WRITE(IPR,77)DWNMI1,DWNMX1
   77 FORMAT(/,18X,'** M0077 ** ERROR DETECTED IN SUBROUTINE GTIME.'/,
     *14X,'THE MINIMUM DOWN-DIP PARAMETER ',F5.1,' EXCEEDS THE MAXIMUM',
     *' DOWN-DIP PARAMETER ',F5.1,
     */,14X,'CORRECT PARAMETERS BEFORE RESUBMITTING THIS JOB.')
              ERRKNT=ERRKNT+1
             ENDIF
            DNS(KK)=DWNNS1
            UMI(KK)=UPMI1
            UMX(KK)=UPMX1
CRLC 09/88
             IF(UPMI1.GT.UPMX1)THEN
             WRITE(IPR,78)UPMI1,UPMX1
   78 FORMAT(/,18X,'** M0077 ** ERROR DETECTED IN SUBROUTINE GTIME.'/,
     *14X,'THE MINIMUM UP-DIP PARAMETER ',F5.1,' EXCEEDS THE MAXIMUM',
     *' UP-DIP PARAMETER ',F5.1,
     */,14X,'CORRECT PARAMETERS BEFORE RESUBMITTING THIS JOB.')
              ERRKNT=ERRKNT+1
             ENDIF
            UNS(KK)=UPNS1
            WGHT(KK)=WT1
               IF(WT1.EQ.1.)IWERR=1
               IF(FT1.NE.1)FT1=0
            FT(KK)=FT1
         IF(INTER.EQ.1)THEN
            AREC(KK)=RECA
            IF(AREC(KK).EQ.0)AREC(KK)=FRTP
            BREC(KK)=RECB
            IF(BREC(KK).EQ.0)BREC(KK)=LRTP
CRLC 09/88 IF BREC STILL 0, THEN LRTP=0, SO SET BREC TO 32767
             IF(BREC(KK).EQ.0)BREC(KK)=32767
            BTS(KK)=BST
             IF(BST.GT.LTRACE)THEN
             WRITE(IPR,79)BST,LTRACE
   79 FORMAT(/,18X,'** M0079 ** ERROR DETECTED IN SUBROUTINE GTIME.'/,
     *14X,'THE START TIME ',I5,' MS EXCEEDS THE TRACE LENGTH (',I5,
     *' MS).',
     */,14X,'CORRECT PARAMETERS BEFORE RESUBMITTING THIS JOB.')
              ERRKNT=ERRKNT+1
             ENDIF
            IF(BTS(KK).EQ.0)BTS(KK)=TS(KK)
            BTE(KK)=BET
            IF(BTE(KK).EQ.0)BTE(KK)=LTRACE
             IF(BTE(KK).GT.LTRACE)THEN
             WRITE(IPR,80)BET,LTRACE
   80 FORMAT(/,18X,'** M0080 ** ERROR DETECTED IN SUBROUTINE GTIME.'/,
     *14X,'THE END TIME ',I5,' MS EXCEEDS THE TRACE LENGTH (',I5,
     *' MS).',
     */,14X,'IT WILL BE RESET TO END OF TRACE.')
             BTE(KK)=LTRACE
             ENDIF
      ENDIF
  122 CONTINUE
C +------------------------------------------------------------+
C |  CONVERT TIMES TO SAMPLES, CHECKING FOR GREATER THAN TRACE |
C |     LENGTH                                                 |
C +------------------------------------------------------------+
      DO 220 I=KKK,KK
      TS(I)=TS(I)/NSR+1
      IF(TS(I).GT.NS)TS(I)=NS
      BTS(I)=BTS(I)/NSR+1
      IF(BTS(I).GT.NS)BTS(I)=NS
      TE(I)=TE(I)/NSR+1
      BTE(I)=BTE(I)/NSR+1
      IF(INTER.EQ.1)THEN
        IF(AREC(I).LT.FRTP)THEN
         WRITE(6,527)AREC(I),FRTP
         ERRKNT=ERRKNT+1
        ENDIF
        IF(BREC(I).GT.LRTP.AND.LRTP.NE.0)THEN
         WRITE(6,528)BREC(I),LRTP
         ERRKNT=ERRKNT+1
        ENDIF
        IF(BREC(KK).LT.AREC(KK))THEN
         WRITE(IPR,529)BREC(KK),AREC(KK)
         ERRKNT = ERRKNT+1
        ENDIF
         SLOTOP=FLOAT(BTS(I)-TS(I))/FLOAT(BREC(I)-AREC(I))
         SLOBOT=FLOAT(BTE(I)-TE(I))/FLOAT(BREC(I)-AREC(I))
         TEND1=(LRTP-BREC(I))*SLOTOP+BTS(I)
         TEND2=(LRTP-BREC(I))*SLOBOT+BTE(I)
         IF(TEND2.LT.(TEND1-1))THEN
           WRITE(6,538)I
           ERRKNT=ERRKNT+1
         ENDIF
         TEND1=(FRTP-AREC(I))*SLOTOP+TS(I)
         TEND2=(FRTP-AREC(I))*SLOBOT+TE(I)
         IF(TEND2.LT.(TEND1-1))THEN
           WRITE(6,539)I
           ERRKNT=ERRKNT+1
         ENDIF
      ENDIF
      IF(LTVAR.EQ.1)THEN
       IF(TE(I).GT.NS)TE(I)=NS
        IF(TS(I).GE.TE(I).AND.TS(I).NE.NS)THEN
         IPTS=(TS(I)-1)*NSR
         IF(TS(I).EQ.NS)IPTS=LTRACE
         IPTE=(TE(I)-1)*NSR
         IF(TE(I).EQ.NS)IPTE=LTRACE
         WRITE(6,520)IPTE,IPTS
         ERRKNT=ERRKNT+1
        ENDIF
       IF(I.GT.1.AND.TS(I).LT.TE(I-1))THEN
         IPTS=(TS(I)-1)*NSR
         IF(TS(I).EQ.NS)IPTS=LTRACE
         IPTE=(TE(I-1)-1)*NSR
         IF(TE(I-1).EQ.NS)IPTE=LTRACE
         WRITE(6,522)IPTS,IPTE
         ERRKNT=ERRKNT+1
       ENDIF
       IF(I.GT.1.AND.TE(I).LE.TE(I-1))THEN
         IPTS=(TE(I)-1)*NSR
         IF(TE(I).EQ.NS)IPTS=LTRACE
         IPTE=(TE(I-1)-1)*NSR
         IF(TE(I-1).EQ.NS)IPTE=LTRACE
         WRITE(6,524)IPTS,IPTE
         ERRKNT=ERRKNT+1
       ENDIF
       IF(TE(I)-TS(I)+1.LT.25.AND.TS(I).LT.NS)THEN
         IPTE=(TE(I)-1)*NSR
         IPTS=(TS(I)-1)*NSR
         WRITE(6,526)IPTS,IPTE
         ERRKNT=ERRKNT+1
       ENDIF
       IF(INTER.EQ.1)THEN
         IF(BTE(I).GT.NS)BTE(I)=NS
         IF(I.GT.1.AND.BREC(I).LE.BREC(I-1).AND.BTS(I).LT.BTE(I-1))THEN
           IPTS=(BTS(I)-1)*NSR
           IF(IPTS.LT.0)IPTS=0
           IPTE=(BTE(I-1)-1)*NSR
           IF(BTE(I-1).EQ.NS)IPTE=LTRACE
           WRITE(6,532)IPTS,IPTE
           ERRKNT=ERRKNT+1
         ENDIF
         IF(BTS(I).GE.BTE(I).AND.BTS(I).LT.NS)THEN
           IPTS=(BTS(I)-1)*NSR
           IPTE=(BTE(I)-1)*NSR
           IF(BTE(I).EQ.NS)IPTE=LTRACE
           WRITE(6,520)IPTE,IPTS
           ERRKNT=ERRKNT+1
         ENDIF
         IF(BTE(I)-BTS(I)+1.LT.25.AND.BTS(I).LT.NS)THEN
           IPTE=(BTE(I)-1)*NSR
            IF(BTE(I).EQ.NS)IPTE=LTRACE
           IPTS=(BTS(I)-1)*NSR
           WRITE(6,526)IPTS,IPTE
           ERRKNT=ERRKNT+1
         ENDIF
       IF(I.GT.1)THEN
         LL=I-1
         SLOTOP=FLOAT(BTE(LL)-TE(LL))/FLOAT(BREC(LL)-AREC(LL))
         SLOBOT=FLOAT(BTS(I)-TS(I))/FLOAT(BREC(I)-AREC(I))
         TEND1=FLOAT(LRTP-BREC(LL))*SLOTOP+FLOAT(BTE(LL))
         TEND2=FLOAT(LRTP-BREC(I))*SLOBOT+FLOAT(BTS(I))
         IF(TEND2.LT.(TEND1-1))THEN
          WRITE(6,536)LL,I
          ERRKNT=ERRKNT+1
         ENDIF
         TEND1=FLOAT(FRTP-AREC(LL))*SLOTOP+FLOAT(TE(LL))
         TEND2=FLOAT(FRTP-AREC(I))*SLOBOT+FLOAT(TS(I))
         IF(TEND2.LT.(TEND1-1))THEN
          WRITE(6,537)LL,I
          ERRKNT=ERRKNT+1
         ENDIF
       ENDIF
        ENDIF
       ENDIF
      IF(LTVAR.EQ.2)THEN
       IF(I.GT.1.AND.TS(I).LE.TS(I-1))THEN
         IPTS=(TS(I)-1)*NSR
         IF(TS(I).EQ.NS)IPTS=LTRACE
         IPTE=(TS(I-1)-1)*NSR
         IF(TS(I-1).EQ.NS)IPTE=LTRACE
         WRITE(6,521)IPTS,IPTE
         ERRKNT=ERRKNT+1
       ENDIF
       IF(I.GT.1.AND.BREC(I).LE.BREC(I-1).AND.BTS(I).LT.BTS(I-1).
     *     AND.INTER.EQ.1)THEN
         IPTS=(BTS(I)-1)*NSR
         IF(IPTS.LT.0)IPTS=0
         IPTE=(BTS(I-1)-1)*NSR
         IF(IPTE.LT.0)IPTE=0
         WRITE(6,534)IPTE,IPTS
         ERRKNT=ERRKNT+1
       ENDIF
       IF(I.GT.1.AND.INTER.EQ.1)THEN
         LL=I-1
         SLOTOP=FLOAT(BTS(LL)-TS(LL))/FLOAT(BREC(LL)-AREC(LL))
         SLOBOT=FLOAT(BTS(I)-TS(I))/FLOAT(BREC(I)-AREC(I))
         TEND1=FLOAT(LRTP-BREC(LL))*SLOTOP+FLOAT(BTS(LL))
         TEND2=FLOAT(LRTP-BREC(I))*SLOBOT+FLOAT(BTS(I))
         IF(TEND2.LT.(TEND1-1))THEN
          WRITE(6,536)LL,I
          ERRKNT=ERRKNT+1
         ENDIF
         TEND1=FLOAT(FRTP-AREC(LL))*SLOTOP+FLOAT(TS(LL))
         TEND2=FLOAT(FRTP-AREC(I))*SLOBOT+FLOAT(TS(I))
         IF(TEND2.LT.(TEND1-1))THEN
          WRITE(6,537)LL,I
          ERRKNT=ERRKNT+1
         ENDIF
       ENDIF
      ENDIF
  220 CONTINUE
      IF(IWERR.NE.0)THEN
         WRITE(6,525)
         ERRKNT=ERRKNT+1
      ENDIF
  520 FORMAT(T15,'** M0520 **  ERROR DETECTED BY SUBROUTINE GTIME.',
     */,T15,'THE GATED TIME VARIANT MODE REQUESTED AND',
     */,T15,'THE END TIME ',I5,' IS LESS THAN OR EQUAL TO THE START',
     *      ' TIME ',I5,'.',
     */,T15,'CORRECT THESE ENTRIES BEFORE RESUBMITTING YOUR JOB.')
  521 FORMAT(T15,'** M0521 **  ERROR DETECTED BY SUBROUTINE GTIME.',
     */,T15,'THE (PSEUDO) CONTINUOUSLY TIME VARIANT MODE REQUESTED AND',
     */,T15,'THE START TIME ',I5,' IS LESS THAN OR EQUAL TO THE',
     *      ' START TIME ',I5,'.',
     */,T15,'CORRECT THESE ENTRIES BEFORE RESUBMITTING YOUR JOB.')
  522 FORMAT(T15,'** M0522 **  ERROR DETECTED BY SUBROUTINE GTIME',
     */,T15,'THE GATED TIME VARIANT MODE REQUESTED AND',
     */,T15,'THE START TIME ',I5,' IS LESS THAN THE PREVIOUS END',
     *      ' TIME ',I5,'.',
     */,T15,'CORRECT THESE ENTRIES BEFORE RESUBMITTING YOUR JOB.')
  524 FORMAT(T15,'** M0524 **  ERROR DETECTED BY SUBROUTINE GTIME.',
     */,T15,'THE GATED TIME VARIANT MODE REQUESTED AND',
     */,T15,'THE END TIME ',I5,' IS LESS THAN THE PREVIOUS END TIME ',
     *      I5,'.',
     */,T15,'CORRECT THESE ENTRIES BEFORE RESUBMITTING YOUR JOB.')
  525 FORMAT(T15,'** M0525 **  ERROR DETECTED BY SUBROUTINE GTIME.',
     */,T15,'ONE OR MORE INVALID ENHANCEMENT FACTORS OF 1 HAVE BEEN ',
     *      'FOUND.',
     */,T15,'CORRECT THESE ENTRIES BEFORE RESUBMITTING YOUR JOB.')
  526 FORMAT(T15,'** M0526 **  ERROR DETECTED BY SUBROUTINE GTIME.',
     */,T15,'THE GATED TIME VARIANT MODE REQUESTED AND',
     */,T15,'THE GATE STARTING AT ',I5,' AND ENDING AT ',I5,' IS ',
     */,T15,'LESS THAN 25 SAMPLES LONG.',
     */,T15,'CORRECT THESE ENTRIES BEFORE RESUBMITTING YOUR JOB.')
  527 FORMAT(T15,'** M0527 **  ERROR DETECTED BY SUBROUTINE GTIME.',
     */,T15,'SPATIAL INTERPOLATION OF WINDOWS REQUESTED AND'
     */,T15,'THE RECORD NUMBER ',I5,' IS LESS THAN THE FIRST RECORD',
     */,T15,'TO PROCESS (',I5,').',
     */,T15,'CORRECT THESE ENTRIES BEFORE RESUBMITTING YOUR JOB.')
  528 FORMAT(T15,'** M0528 **  ERROR DETECTED BY SUBROUTINE GTIME.',
     */,T15,'SPATIAL INTERPOLATION OF WINDOWS REQUESTED AND'
     */,T15,'THE RECORD NUMBER ',I5,' IS GREATER THAN THE LAST RECORD',
     */,T15,'TO PROCESS (',I5,').',
     */,T15,'CORRECT THESE ENTRIES BEFORE RESUBMITTING YOUR JOB.')
  529 FORMAT(/,16X,'** M0529 ** ERROR DETECTED IN SUBROUTINE GTIME.',
     */,14X,'RECORD NUMBERS MUST BE IN INCREASING ORDER.  THE ENTRY',
     */,14X,'FOR THE LAST RECORD (',I5,') IS LESS THAN THE ENTRY FOR ',
     *'THE FIRST RECORD (',I5,').',
     */,14X,' CORRECT THESE ENTRIES BEFORE RESUBMITTING THIS JOB.')
  532 FORMAT(/,16X,'** M0532 ** ERROR DETECTED IN SUBROUTINE GTIME.',
     */,14X,'SPATIAL INTERPOLATION OVERLAP DETECTED.',
     */,14X,'THE START TIME ',I5,' IS LESS THAN THE PRECEDING END ',
     *'TIME ',I5,'.',
     */,14X,'RESPECIFY YOUR INTERPOLATION PARAMETERS TO PREVENT',
     *' OVERLAP.')
  534 FORMAT(/,16X,'** M0534 ** ERROR DETECTED IN SUBROUTINE GTIME.',
     */,14X,'SPATIAL INTERPOLATION OVERLAP DETECTED.',
     */,14X,'THE START TIME ',I5,' IS LESS THAN THE PRECEDING START ',
     *'TIME ',I5,'.',
     */,14X,'RESPECIFY YOUR INTERPOLATION PARAMETERS TO PREVENT',
     *' OVERLAP.')
  536 FORMAT(/,16X,'** M0536 ** ERROR DETECTED IN SUBROUTINE GTIME.',
     */,14X,'SLOPE PROJECTIONS INDICATE QUADRANGLES',I3,' AND',I3,
     */,14X,'WILL OVERLAP IN DIRECTION OF INCREASING RECORD NUMBERS',
     */,14X,'DURING INTERPOLATION.',
     */,14X,'RESPECIFY YOUR INTERPOLATION PARAMETERS TO PREVENT',
     *' OVERLAP.',
     */,14X,'SKETCHING THE INTERPOLATION QUADRANGLES IS RECOMMENDED.')
  537 FORMAT(/,16X,'** M0537 ** ERROR DETECTED IN SUBROUTINE GTIME.',
     */,14X,'SLOPE PROJECTIONS INDICATE QUADRANGLES',I3,' AND',I3,
     */,14X,'WILL OVERLAP IN DIRECTION OF DECREASING RECORD NUMBERS',
     */,14X,'DURING INTERPOLATION.',
     */,14X,'RESPECIFY YOUR INTERPOLATION PARAMETERS TO PREVENT',
     *' OVERLAP.',
     */,14X,'SKETCHING THE INTERPOLATION QUADRANGLES IS RECOMMENDED.')
  538 FORMAT(/,16X,'** M0538 ** ERROR DETECTED IN SUBROUTINE GTIME.',
     */,14X,'SLOPE PROJECTIONS INDICATE QUADRANGLE ',I3,' WILL',
     *' COLLAPSE IN DIRECTION ',
     */,14X,'OF INCREASING RECORD NUMBERS DURING INTERPOLATION.',
     */,14X,'RESPECIFY YOUR INTERPOLATION PARAMETERS TO PREVENT',
     *' COLLAPSE.',
     */,14X,'SKETCHING THE INTERPOLATION QUADRANGLES IS RECOMMENDED.')
  539 FORMAT(/,16X,'** M0539 ** ERROR DETECTED IN SUBROUTINE GTIME.',
     */,14X,'SLOPE PROJECTIONS INDICATE QUADRANGLE ',I3,' WILL',
     *' COLLAPSE IN DIRECTION ',
     */,14X,'OF DECREASING RECORD NUMBERS DURING INTERPOLATION.',
     */,14X,'RESPECIFY YOUR INTERPOLATION PARAMETERS TO PREVENT',
     *' COLLAPSE.',
     */,14X,'SKETCHING THE INTERPOLATION QUADRANGLES IS RECOMMENDED.')
C
      IF(ERRKNT.NE.0)IERROR=ERRKNT
      RETURN
      END
      SUBROUTINE GNTRC1(SUM,FDATA,IS,IE,RAMP,LTVAR)
      DIMENSION SUM(*),FDATA(*),RAMP(*)
      COMMON/NMDFF/NS,IFLIP,ITLEN,NSR
      DATA LRAMP/25/,LRAMP1/24/,IP/0/
      save lramp,lramp1,ip

      LEN=IE-IS+1
      IF(LEN.EQ.NS)THEN
         CALL VMOV(FDATA,1,SUM,1,NS)
         RETURN
      ENDIF
      IF(LTVAR.EQ.1)THEN
         IF(IP.EQ.0)THEN
         A=0.
         B=1./FLOAT(LRAMP1)
         CALL VRAMP(A,B,RAMP,1,LRAMP)
         IP=1
         ENDIF
         LOC1=IS-12
         LOC2=IS+12
         LOC3=IE-12
         LOC4=IE+12
         IF(IS.LE.13)THEN
            LCLR=LOC3
            CALL VCLR(SUM(1),1,LCLR)
         ELSE
            LCLR=LOC3-LOC2
            CALL VCLR(SUM(LOC2+1),1,LCLR)
            IF(LOC2.LE.NS)THEN
            CALL VRVRS(RAMP,1,LRAMP)
               CALL VMUL(SUM(LOC1),1,RAMP(1),1,SUM(LOC1),1,LRAMP)
            CALL VRVRS(RAMP,1,LRAMP)
               CALL VMUL(FDATA(LOC1),1,RAMP(1),1,FDATA(LOC1),1,LRAMP)
            ENDIF
         ENDIF
         LCLR=LOC1-1
         IF(LCLR.LT.0)LCLR=0
         IPNT=1
            CALL VCLR(FDATA(IPNT),1,LCLR)
         IF(IE.LT.NS-13)THEN
            IPNT=LOC4+1
            LCLR=NS-LOC4
            IF(LCLR.GT.NS)LCLR=NS
            IF(LCLR.LT.0)LCLR=0
            CALL VCLR(FDATA(IPNT),1,LCLR)
            CALL VMUL(SUM(LOC3),1,RAMP(1),1,SUM(LOC3),1,LRAMP)
            CALL VRVRS(RAMP,1,LRAMP)
            CALL VMUL(FDATA(LOC3),1,RAMP(1),1,FDATA(LOC3),1,LRAMP)
            CALL VRVRS(RAMP,1,LRAMP)
         ELSE
            CALL VCLR(SUM(LOC3+1),1,NS-LOC3)
         ENDIF
         CALL VADD(SUM,1,FDATA,1,SUM,1,NS)
      ENDIF
      IF(LTVAR.EQ.2)THEN
         IF(IS.EQ.IE)THEN
            CALL VMOV(FDATA,1,SUM,1,NS)
            RETURN
         ENDIF
         LCLR=NS-IE
         CALL VCLR(SUM(IE+1),1,LCLR)
         LCLR=IS-1
         IF(LCLR.LT.0)LCLR=0
         CALL VCLR(FDATA(1),1,LCLR)
         LRAMP=IE-IS+1
         LRAMP1=LRAMP-1
         A=0.
         B=1./FLOAT(LRAMP1)
         CALL VRAMP(A,B,RAMP,1,LRAMP)
         CALL VMUL(SUM(IE),-1,RAMP(1),1,SUM(IE),-1,LRAMP)
         CALL VMUL(FDATA(IS),1,RAMP(1),1,FDATA(IS),1,LRAMP)
         CALL VADD(SUM,1,FDATA,1,SUM,1,NS)
      ENDIF
      RETURN
      END
      subroutine gcmdln ( ntap, otap, cardin, cflag, verbos, LUCRD )
c     FORTRAN by M. A. Miller   4-14-89
c
c     this routine processes the command line arguments for use in
c     program DIPF on SUN .
c
c     include 'iounit.inc'
#include <f77/iounit.h>
      character ntap*100, otap*100, cardin*100
      logical     verbos, cflag, dflag
      integer copen, argis, iflag

      verbos = .false.

      verbos = (argis('-V') .gt. 0)
      if(verbos) then
        write(LERR,*)' verbos is true'
      else
        write(LERR,*)' verbos is false'
      endif

      cflag = .false.
      dflag = .false.

      call argstr ('-N',ntap,' ',' ')
      if(verbos) write(LERR,*)' ntap as read=',ntap
      call argstr ('-O',otap,' ',' ')
      if(verbos) write(LERR,*)' otap as read=',otap

          call argstr ('-D',cardin,' ',' ')
          if(verbos) write(LERR,*)' cardin as read=',cardin
          call noblnk(cardin,lc)

        if(cardin(1:1) .ne. ' ') then
          if(verbos) write(LERR,*)' open(unit=LUCRD, file=cardin) '
          open(unit=LUCRD, file=cardin, status='old',
     *         form='formatted',access='sequential')
          rewind (LUCRD)
        else
          if(verbos) write(LERR,*)' iflag=copen( -dipf.crd ,LUCRD) '
          iflag = copen('-dipf.crd',LUCRD)
          if(verbos) write(LERR,*) ' iflag=',iflag
        endif
        if(verbos) write(LERR,*)' LUCRD =',LUCRD
        if(verbos) then
          if(dflag) then
           write(LERR,*)' dflag is true'
          else
            write(LERR,*)' dflag is false'
          endif
        endif


      return
      end
      subroutine help
c     include 'iounit.inc'
#include <f77/iounit.h>
          write(LER,*)
     :'***************************************************************'
         write(LER,*)'PROGRAM dipf.......................dip filtering'
         write(LER,*)' '
         write(LER,*)
     :' -N [ntap]      (no default)      : Input data file name'
         write(LER,*)
     :' -O [otap]      (no default)      : Output data file name'
         write(LER,*)
     :' -D [cardin]    (no default)      : Card data file name'
         write(LER,*)
     :' if this parameter is not coded, then input is assumed'
         write(LER,*)
     :' to be from the command line cards designated as'
         write(LER,*)
     :'       -dipf.crd '
         write(LER,*)
     :' if this parameter is coded, and a filename follows which'
         write(LER,*)
     :' is not blank, input is assumed to be from that file'
         write(LER,*)
     :' -V [verbos]    (default=no)      : Verbose output '
       write(LER,*)
     :'Usage:  ',
     :' dipf -N[ntap] -O[otap] -D[cardin]  -V'
       write(LER,*)
     :'***************************************************************'
      return
      end
c     subroutine riclr (ipr)
c     integer ipr
c     return
c     end
c     subroutine riprnt (ir,ipr)
c     integer ir, ipr
c     return
c     end
      subroutine fptoi (i2,r4,ns,itt)
#ifndef CRAYSYSTEM
      INTEGER*2 i2(*)
#else
      INTEGER i2(*)
#endif
      integer ns, itt, i
      real r4(*)
      do 10 i = 1,ns
      i2(i) = ifix(r4(i))
   10 continue
      return
      end
      subroutine itofp (i2,r4,ns)
#ifndef CRAYSYSTEM
      INTEGER*2 i2(*)
#else
      INTEGER i2(*)
#endif
      integer ns, i, ival
      real r4(*)
      do 10 i = 1,ns
      ival = i2(i)
      r4(i) = float(ival)
   10 continue
      return
      end
      SUBROUTINE NEWCRD(CARD,NS,NSR,IPR)
      CHARACTER CARD1*80,CARD2*80,CARD*80,BLNK*10
      DATA BLNK/'          '/
      save blnk
c
       WRITE(IPR,80)
   80 FORMAT(/,14X,'** M1000 ** MESSAGE FROM PROGRAM DIPF.',
     */,14X,'YOU ARE USING AN OLD FORMAT FOR PARAMETER CARDS.',
     */,14X,'ALTHOUGH I WILL READ THE FORMAT CORRECTLY, YOU SHOULD',
     */,14X,'CHANGE TO THE NEW FORMAT IN ORDER TO UTILIZE THE FULL',
     */,14X,'CAPABILITIES (TIME- AND SPATIALLY-VARIANT FILTERING,',
     */,14X,' DIP ENHANCEMENT, AND GREATER TEMPORAL LENGTH).',
     */,14X,'THE NEW FORMAT FOR YOUR CURRENT (FIRST) PARAMETER CARD',
     */,14X,'WOULD LOOK LIKE THE FOLLOWING:')
      CARD1=CARD
      CARD1(6:15)=BLNK
      CARD1(16:18)=BLNK(1:3)
      CARD1(19:28)=BLNK
      CARD1(29:31)=BLNK(1:3)
      CARD1(57:57)=' '
      CARD1(67:69)='N00'
      WRITE(IPR,'(14X,A80)')CARD1
      DO 1 I=1,80,10
         J=I+9
         CARD2(I:J)=BLNK
    1 CONTINUE
      CARD2(1:5)='2DIPF'
      IST=0
      ITRLEN=NS*NSR
      WRITE(CARD2(6:10),'(I5)')IST
      WRITE(CARD2(11:15),'(I5)')ITRLEN
      CARD2(16:41)=CARD(6:31)
      CARD2(42:42)=CARD1(57:57)
      WRITE(IPR,'(14X,A80)')CARD2
      WRITE(IPR,'(A)')BLNK
      RETURN
      END
      SUBROUTINE SPLIT(NTPR,IWFLG,N1,STRTT,ENDT,AREC,BREC,
     *BSTRTT,BENDT,TEMP,TDATA,SUM,TENH,RAMP,
     *tri,RDATA,input,I2NPUT,
     *FRTP,LRTP,IFMT,IOFMT,FIN,FLTT,NSETS,IWBSMP,WBSAV,TRIRMP,
     *WGHT,XSUM,iearly,ISTAK,INTER,LRMP,*,*)
C ******************************************************************** C
C * SUBROUTINE TO PROCESS SPLIT SPREAD DATA                          * C
C *                                                                  * C
C *  A FULL RECORD OF DATA WILL BE READ, WRITING EACH TRACE OUT      * C
C *  TO DISK.  TRACE HEADERS WILL BE SAVED AND THEN EXAMINED TO      * C
C *  DETERMINE WHERE THE SPLIT OCCURS.  WHEN THE NUMBER OF TRACES    * C
C *  ON ANY SIDE OF THE SPLIT IS LESS THAN THE NUMBER OF CHANNELS    * C
C *  IN THE FILTER, A NEW FILTER WILL BE CONSTRUCTED TO FIT THE      * C
C *  IMMEDIATE NEED.  THE OLD FILTER IS SAVED TO DISK AND RESTORED   * C
C *  AS NECESSARY.  EACH SIDE OF SPREAD PROCESSED AS SEPARATE        * C
C *  RECORD.                                                         * C
C *                                                                  * C
C ******************************************************************** C
#include <f77/localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
      integer IALLWD
c -- upped the size of rdata per sam lilly's mod - 01/24/91 - jmw
c     parameter (IALLWD = 6000 + ITRWRD )
      parameter (IALLWD = 8192 + ITRWRD )
      REAL   RDATA(*),HDRS(itrwrd,47),WBSAV(*)
      REAL   TRIRMP(97),WGHT(10),TEMP(*),TDATA(*),SUM(*)
      REAL   DDMX(20),DDMI(20),DDNS(20),UDMX(20),UDMI(20),UDNS(20)
      REAL   TENH(*),RAMP(*),HOLD(iallwd),NRAMP(6000)
      real   tri(*)
C
      COMPLEX   FIN(*), FLTT(*), XSUM(*)
C
      integer frtp,ntrs,npts,iearly,lrtp,ltvar,inter
c - j.m.wade - 8/26/92 - added istak, inter, & lrmp to parm list
      integer istak,lrmp
      DIMENSION INPUT(*)
      integer iwbsmp(*)
      INTEGER   STRTT(20),ENDT(20)
      INTEGER   AREC(10),BREC(10),BSTRTT(10),BENDT(10)
#ifndef CRAYSYSTEM
      INTEGER*2 I2NPUT(12128),IHDRS,THDRS(128,512)
#else
      integer I2NPUT(6128),ihdrs,thdrs(128,512)
#endif
C
      LOGICAL*1     SIDE1,SIDE2,FOUND
C
      COMMON/NMDFF/NS,IFLIP,ITLEN,NSR
      COMMON/FLDFF/NPTS,NTRS,IHDRS(128,47)
      COMMON/PERIPH/LUI,LUO,LUD1,LUD2,IPR,LBYTE,NS4
      COMMON/SPRED1/DDMX,DDMI,DDNS,UDMX,UDMI,UDNS,NPTNTR,LTVAR
      COMMON/SPRED2/DELSRC(2,10),LZEROS(47),
     *              WVEL,WBBIAS,WBB2,NRAMP
      COMMON/SPRED3/IOKNT,NIT,KNT,IC,IEND,JKNT,IO
C
      EQUIVALENCE (HDRS(1,1),IHDRS(1,1))

      DATA IWRITE/1/,IREAD/2/,ICLOSE/3/,LPASS/0/
      DATA SIDE1/.TRUE./,SIDE2/.TRUE./
      DATA NCRD/0/
      DATA IFIN/0/,IFLTT/0/,IWBSAV/0/,ITDAT/0/,IXSUM/0/,ISAVE/0/
c
      save IWRITE,IREAD,ICLOSE,LPASS,SIDE1,SIDE2,NCRD
      save IFIN,IFLTT,IWBSAV,ITDAT,IXSUM,ISAVE
      save nwpb,ibytes,nunits
      save irec
c
C +---------------------------------------------------------------+
C |   IF THIS IS FIRST TIME IN, ALLOCATE DISK SPACE FOR A RECORD  |
C |   OF DATA AND FOR FILTERS (2 FILTERS, SINCE HALF SPREAD).     |
C +---------------------------------------------------------------+
      FOUND=.FALSE.
      IFRST=0
      IFLIP=0
      IZ=NTRS/2+1
      IZ1=IZ-1
      INIT=0
      IHCH=NTPR/2
c - j.m.wade - 8/26/92 - I think we really mean ntpr ....
c     IF(IHCH*2.NE.NTPR)IHCH=(NPTR-1)/2
      IF(IHCH*2.NE.NTPR)IHCH=(NTPR-1)/2
      itlenl=(itlen+2)*ISZBYT
      SIDE1=.TRUE.
      SIDE2=.TRUE.
      IF(LPASS.EQ.0)THEN
         NWPB= lbyte/iszbyt
         ibytes=lbyte
         NUNITS=1
         call daopen(ntpr+1,nunits,ibytes,lud1,nunits,iszbyt)
crider   CALL MOVE(0,INPUT,0,LBYTE)
         call vclr(input,1,nwpb)
         I2NPUT(125)=30000
         I2NPUT(107)=0
         I2NPUT(97)=0
         I2NPUT(119)=0
crider   CALL FILEAC(LUD1,INPUT,NTPR+1,IWRITE,1)
         call dawrte(ntpr+1,input,lud1)
      ENDIF
      IF(LPASS.EQ.1)THEN
******** CALL MOVE(1,INPUT,HOLD,LBYTE)
         call vmov(hold,1,input,1,NWPB)
         GO TO 8
      ENDIF
      LPASS=1
C +---------------------------------------------------------------+
C |  GO FIND DATA REQUESTED.  COPY TO OUTPUT IF RI LT FRTP        |
C +---------------------------------------------------------------+
    9 CONTINUE
      NIT=0
      CALL RTAPE(LUI,INPUT,NIT)
      IF(NIT.EQ.0)THEN
         WRITE(IPR,410)IREC
  410 FORMAT(/,14X,'END OF DATA SET FOUND AFTER RECORD ',I6,/)
         IF(.NOT.FOUND)THEN
           WRITE(IPR,303)FRTP
  303 FORMAT(/,14X,'** M0303 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'END OF FILE ENCOUNTERED ATTEMPTING TO FIND RECORD ',I5,'.',/,14X,
     *'DATA SET DOES NOT CONTAIN EXPECTED RECORDS.',/,14X,
     *'JOB ABORTED.')
           IC=100
           IEND=1
           RETURN 1
         ENDIF
         IF(IREC.LT.LRTP.AND.LRTP.LT.32767)THEN
            WRITE(IPR,303)LRTP
            IC=100
         ENDIF
         IEND=1
         RETURN 1
      ENDIF
    8 IREC=I2NPUT(106)
      IF(IREC.GE.FRTP.AND.IREC.LE.LRTP)GO TO 50
      IF(IREC.GT.LRTP.AND..NOT.FOUND)THEN
         WRITE(IPR,305)IREC,LRTP
  305 FORMAT(/,14X,'** M0305 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'FIRST RECORD FOUND ( ',I5,' ) IS GREATER THAN LAST RECORD TO',
     *' PROCESS ( ',I5,' ).',/,14X,
     *'DATA SET DOES NOT CONTAIN EXPECTED RECORDS.',/,14X,
     *'JOB ABORTED.')
         IC=100
         IEND=1
         RETURN 1
      ENDIF
      IF(I2NPUT(106).GT.LRTP)THEN
crider    CALL MOVE(1,HOLD,INPUT,LBYTE)
          call vmov(input,1,hold,1,NWPB)
          RETURN 2
      ENDIF
      if (i2nput(107) .ne. 0) CALL WRTARI(LUO,INPUT,NIT,NTPR,IPR)
      JKNT=JKNT+1
      GO TO 9
   50 CONTINUE
      IF(IREC.GT.FRTP.AND.IFRST.EQ.0.AND.FRTP.GT.-32767)THEN
         WRITE(IPR,304)IREC,FRTP
  304 FORMAT(/,14X,'** M0304 ** WARNING FROM DIPF.',/,14X,
     *'FIRST RECORD FOUND ( ',I5,' ) IS GREATER THAN REQUESTED',/,14X,
     *'FIRST RECORD TO PROCESS ( ',I6,' ).',/,14X,
     *'DATA SET DOES NOT CONTAIN EXPECTED RECORDS.',/,14X,
     *'PROCESSING WILL CONTINUE.')
      ENDIF
C +---------------------------------------------------------------+
C |    NOW READ THE FIRST RECORD, STORING ON DISK IN SAME FORMAT  |
C |    AS INPUT, SAVING TRACE HEADERS IN THDRS.                   |
C +---------------------------------------------------------------+
      IFRST=1
      FOUND=.TRUE.
      ITRC=1
      IREC=I2NPUT(106)
criderCALL FILEAC(LUD1,INPUT,ITRC,IWRITE,1)
      call dawrte(itrc,input,lud1)
criderCALL MOVE(1,THDRS(1,1),INPUT(1),256)
      call vmov(input,1,thdrs(1,1),1,itrwrd)
      DO 55 ITRC=2,NTPR
        NIT=0
        CALL RTAPE(LUI,INPUT,NIT)
        IF(NIT.EQ.0)THEN
          WRITE(IPR,411)IREC
  411 FORMAT('  END OF DATA SET FOUND AFTER RECORD ',I6)
          IF(IREC.LT.LRTP.AND.LRTP.LT.32767)THEN
            WRITE(IPR,306)LRTP
  306 FORMAT(/,14X,'** M0306 ** ERROR DETECTED IN MAIN PROGRAM.',/,14X,
     *'END OF FILE ENCOUNTERED BEFORE FINDING RECORD ',I5,/,14X,
     *'DATA SET DOES NOT CONTAIN EXPECTED RECORDS.',/,14X,
     *'JOB ABORTED.')
            IC=100
         ENDIF
         IF(IREC.LT.FRTP.AND.FRTP.GT.-32767)THEN
            WRITE(IPR,306)FRTP
            IC=100
         ENDIF
         RETURN 1
        ENDIF
crider  CALL FILEAC(LUD1,INPUT,ITRC,IWRITE,1)
        call dawrte(itrc,input,lud1)
crider  CALL MOVE(1,THDRS(1,ITRC),INPUT(1),256)
        call vmov(input,1,thdrs(1,itrc),1,itrwrd)
   55 CONTINUE
C +---------------------------------------------------------------+
C |    EXAMINE THE TRACE HEADERS TO FIND WHERE SPLIT OCCURS.      |
C +---------------------------------------------------------------+
C +---------------------------------------------------------------+
C |    FIRST FIND WHERE FIRST LIVE TRACE IS AND GET SIGN OF       |
C |    DISTANCE.  THEN GO FIND WHERE SIGN CHANGES FOR LIVE TRACE. |
C |    DETERMINE NUMBER OF LIVE TRACES IN EACH BANK OF TRACES.    |
C |    "R" FOR RIGHT AND "L" FOR LEFT ARE USED FOR COUNTER IDS    |
C |    AS IF LOOKING AT DATA PLOTTED RIGHT TO LEFT.               |
C +---------------------------------------------------------------+
      KNTRHT=0
      KNTLFT=0
      ITRC=1
      IDEADR=0
      IDEADL=0
      JSIGN=0
      KSIGN=0
      LSIGN=0
      DO 60 I=1,NTPR
      IF(THDRS(125,I).LT.30000)THEN
         IDIST=THDRS(119,I)
         JSIGN=ISIGN(1,IDIST)
         GO TO 65
      ENDIF
      IDEADR=IDEADR+1
      ITRC=ITRC+1
C +-----------------------------------------------------------------+
* | IDEADR COUNTS THE NUMBER OF DEAD TRACES TO WHERE FIRST LIVE     |
* | TRACE ENCOUNTERED.                                              |
* | ITRC POINTS TO THE NEXT TRACE TO BE PROCESSED.                  |
C +-----------------------------------------------------------------+
   60 CONTINUE
C +------------------------------------------------+
C | IF NO LIVE TRACES FOUND, WRITE THE DEAD RECORD |
C | AND RETURN FOR MORE DATA.                      |
C +------------------------------------------------+
      IF(ITRC.GE.NTPR)THEN
         DO 61 I=1,NTPR
crider   CALL MOVE(0,INPUT(65),0,KBYTE)
         call vclr(tri,1,ns)
crider   CALL MOVE(1,I2NPUT(1),THDRS(1,I),256)
         call vmov(thdrs(1,i),1,I2NPUT(1),1,itrwrd)
	 if (i2nput(107) .ne. 0) CALL WRTARI(LUO,INPUT,NIT,NTPR,IPR)
         JKNT=JKNT+1
   61    CONTINUE
         GO TO 9
      ENDIF
   65 CONTINUE
C +-----------------------------------------------------------------+
* | WHEN GET HERE NEED TO SEE IF FOUND A LIVE TRACE ON THE NEGATIVE |
* | DISTANCE SIDE OF THE SPREAD.  IF FOUND, JSIGN WILL BE -1. IF    |
* | NOT FOUND, ITRC WILL BE POINTING TO SECOND SIDE OF THE SPREAD   |
* | AND JSIGN WILL BE ZERO OR +1.                                   |
C +-----------------------------------------------------------------+
      IF(ITRC.GE.IHCH.AND.JSIGN.EQ.0)JSIGN=-1
C +-----------------------------------------------------------------+
* | SETTING JSIGN TO -1 LETS DEAD TRACES ON FIRST SIDE BE           |
* | IGNORED.                                                        |
* | NEXT LOOP PICKS UP AT NEXT TRACE AND COUNTS NUMBER OF TRACES    |
* | WITH SAME DISTANCE SIGN.                                        |
C +-----------------------------------------------------------------+
      DO 70 I=ITRC,NTPR
      KSIGN=JSIGN
      IF(THDRS(125,I).LT.30000)THEN
         IDIST=THDRS(119,I)
         KSIGN=ISIGN(1,IDIST)
         KNTRHT=KNTRHT+1
      ELSE
         IDEADR=IDEADR+1
      ENDIF
      IF(KSIGN.NE.JSIGN)THEN
         KNTRHT=KNTRHT-1
         GO TO 75
      ENDIF
   70 CONTINUE
   75 CONTINUE
      INLOCL=I
C +-----------------------------------------------------------------+
* | INLOCL DEFINES THE ENTRY LOCATION FOR THE LEFT SIDE OF THE      |
* | SPREAD.  IF ALL IS IN ORDER, THIS WILL BE AT 1/2 NUMBER OF      |
* | TRACES PER RECORD.  IF ALL IS NOT IN ORDER, IT MAY BE GREATER   |
* | THAN OR EQUAL TO NUMBER OF TRACES PER RECORD.                   |
C +-----------------------------------------------------------------+
c - changed the next line - j.m.wade  8-21-91
******     IF(INLOCL.GE.NTPR.AND.KSIGN.LT.0)KSIGN=1
c - j.m.wade - 8/26/92 - I think we really mean ideadr, deadr isn't set
c     if(kntrht+deadr.gt.ntpr.and.ksign.lt.0)ksign=1
      if(kntrht+ideadr.gt.ntpr.and.ksign.lt.0)ksign=1
C +-----------------------------------------------------------------+
* | IF DIDN'T FIND A CHANGE IN DISTANCE SIGN, MUST FORCE ONE.       |
C +-----------------------------------------------------------------+
c - changed the next line - j.m.wade  8-21-91
*******      IF(INLOCL.GE.NTPR)INLOCL=IHCH+1
c - j.m.wade - 8/26/92 - I think we really mean ideadr, deadr isn't set
c     if(kntrht+deadr.ge.ntpr)inlocl=ihch+1
      if(kntrht+ideadr.ge.ntpr)inlocl=ihch+1
C +-------------------------------------------------------------------+
* | NEXT LOOP LOOKS IN REVERSE DIRECTION FOR CHANGE IN DISTANCE SIGN  |
* | AND COUNTS NUMBER OF LIVE AND DEAD TRACES ON LEFT SIDE OF SPREAD. |
C +-------------------------------------------------------------------+
      DO 80 I=NTPR,1,-1
      LSIGN=KSIGN
      IF(THDRS(125,I).LT.30000)THEN
         IDIST=THDRS(119,I)
         LSIGN=ISIGN(1,IDIST)
         KNTLFT=KNTLFT+1
      ELSE
C        IF(I.GT.INLOCL)IDEADL=IDEADL+1
         IDEADL=IDEADL+1
      ENDIF
      IF(LSIGN.NE.KSIGN)THEN
         KNTLFT=KNTLFT-1
         GO TO 85
      ENDIF
   80 CONTINUE
   85 CONTINUE
      INLOCR=I
      IF(INLOCR.EQ.0)INLOCR=1
      ITOTL=KNTLFT+IDEADL
c - commented out the next line - j.m.wade  8-21-91
*     IF(IDEADL.EQ.KNTLFT)ITOTL=IDEADL
      ITOTR=KNTRHT+IDEADR
c - commented out the next line - j.m.wade  8-21-91
*     IF(IDEADR.EQ.KNTRHT)ITOTR=IDEADR
      NTODOR=ITOTR
      NTODOL=NTPR-NTODOR
      ITOTTR=ITOTR+ITOTL
*X    IF(ITOTTR.GT.NTPR)NTODOR=IHCH
*XX
C +-------------------------------------------------------------------+
* | IF THE TOTAL NUMBER TRACES COMPUTED IS GREATER THAN THE ACTUAL    |
* | NUMBER, THEN SOMETHING IS AMISS AND GENERALLY THERE ARE DEAD      |
* | TRACES AT THE SPLIT LOCATION.  IF THIS IS TRUE, THEN ATTEMPT TO   |
* | SET THE SMALLEST NUMBER OF TRACES TO BE PROCESSED AS THE "RIGHT"  |
* | SIDE AND THE LARGEST NUMBER AS THE "LEFT" SIDE.                   |
C +-------------------------------------------------------------------+
      IF(ITOTTR.GT.NTPR)THEN
         IF(ITOTR.GT.ITOTL)THEN
            ITOTR=NTPR-ITOTL
            NTODOR=ITOTR
            INLOCL=NTODOR+1
            NTODOL=ITOTL
         ELSE
            ITOTL=NTPR-ITOTR
            NTODOL=ITOTL
            NTODOR=NTPR-NTODOL
         ENDIF
      ENDIF
*XX
      IF(NTODOR.NE.0)THEN
         SIDE1=.TRUE.
      ELSE
         SIDE1=.FALSE.
      ENDIF
      IF(NTODOL.NE.0)THEN
         SIDE2=.TRUE.
      ELSE
         SIDE2=.FALSE.
      ENDIF
  695 CONTINUE
      IF((.NOT.SIDE1).AND.(.NOT.SIDE2))GO TO 9
      IF(SIDE1)THEN
         IFLIP=0
         KNT=0
         IO=0
         NMAX=NTODOR
         IBIAS=0
         ISIDE=1
         NTODO=NTODOR
         ITRC=1
         IF(NTODO.LE.NTRS)WRITE(IPR,412)IREC,NTODO,NTRS
  412 FORMAT(T15,'** M0412 **  WARNING FROM SPLIT-SPREAD PROCESSOR.',
     */,T14,'FOR RECORD ',I5,' THE NUMBER OF TRACES ON THE FIRST SIDE',
     *      ' OF THE SPREAD ( ',I4,' )',
     */,T15,'IS LESS THAN OR EQUAL TO THE NUMBER OF CHANNELS IN THE',
     *      ' FILTER ( ',I3,' ).',
     */,T15,'ZERO-VALUED TRACES WILL BE PADDED FOR PROCESSING.')
      ELSE
         KNT=0
         IO=0
         NMAX=NTPR
         IBIAS=NTODOR
         IFLIP=1
         ISIDE=NTRS+1
         NTODO=NTODOL
         ITRC=INLOCL
         IF(NTODO.LE.NTRS)WRITE(IPR,413)IREC,NTODO,NTRS
  413 FORMAT(T15,'** M0413 **  WARNING FROM SPLIT-SPREAD PROCESSOR.',
     */,T14,'FOR RECORD ',I5,' THE NUMBER OF TRACES ON THE LAST SIDE',
     *      ' OF THE SPREAD ( ',I4,' )',
     */,T15,'IS LESS THAN OR EQUAL TO THE NUMBER OF CHANNELS IN THE',
     *      ' FILTER ( ',I3,' ).',
     */,T15,'ZERO-VALUED TRACES WILL BE PADDED FOR PROCESSING.')
      ENDIF
C +------------------------------------------------------------+
C |                          TAPER IN                          |
C +------------------------------------------------------------+
C +--------------------------------------+
C |     Get first trace of this record   |
C +--------------------------------------+
criderCALL FILEAC(LUD1,INPUT,ITRC,IREAD,1)
      call daread(itrc,input,lud1)
      ITRC=ITRC+1
      KNT = KNT+1
      IO  = IO + 1
      IFIN2 = IFIN + (N1 * (IO - 1))
      IPNT=ITDAT+(IO-1)*NS
      IF (I2NPUT(125) .LT. 30000) THEN
         IF (IWFLG .EQ. 1) THEN
            DEPTH = I2NPUT(97)
            DIST  = I2NPUT(119)
            WBTIME = SQRT((2. * DEPTH) **2. + (DIST **2)) / WVEL
            IWBSMP(IO) = WBTIME / NSR + WBBIAS
            IF (IWBSMP(IO) .GE. NS) IWBSMP(IO) = NS - 1
            NWBSAV = IWBSMP(IO) + WBB2 + 1
            IF (NWBSAV .GT. NS) NWBSAV = NS
            IWB = IWBSAV + (NS * (IO - 1))
            IF (IFMT .EQ. 3) THEN
crider         CALL SCOPY (NWBSAV, RDATA(65), 1, WBSAV(IWB+1), 1)
               call vmov(tri(1),1,wbsav(iwb+1),1,nwbsav)
            ELSE
               CALL ITOFP (I2NPUT(129), WBSAV(IWB+1), NWBSAV)
            ENDIF
         ELSE
            IWBSMP(IO) = 0
         ENDIF
C
         IF (IEARLY .EQ. 0) THEN
            IF (IFMT .EQ. 1) THEN
               CALL IZEROS (I2NPUT(129+IWBSMP(IO)), NS-IWBSMP(IO),
     &                      LZEROS(IO))
            ELSE
*              CALL RZEROS ( RDATA(65+IWBSMP(IO)), NS-IWBSMP(IO),
               call rzeros ( tri(1+iwbsmp(io)),ns-iwbsmp(io),
     &                       LZEROS(IO) )
            ENDIF
         ENDIF
C
         IF (LZEROS(IO) .LT. NS-IWBSMP(IO)) THEN
crider      IF (IFMT .NE. 3) CALL ITOFP (I2NPUT(129), RDATA(65), NS)
            if (ifmt. ne. 3) call itofp (I2NPUT(129),tri(1),ns)
            IF (IWFLG .EQ. 1) THEN
               LZERO = IWBSMP(IO) - WBB2
               IF(LZERO.GT.NS)LZERO=NS
crider         CALL SCOPY (LZERO, 0.0, 0, RDATA(65), 1)
               call vclr(tri(1),1,lzero)
            ENDIF
C
crider      CALL SCOPY(NS,RDATA(65),1,TDATA(IPNT+1),1)
            call vmov(tri(1),1,tdata(ipnt+1),1,ns)
crider      CALL IAPR5 (RDATA(65), FIN(IFIN2+1))
            call iapr5(tri(1),fin(ifin2+1))
         ELSE
            I2NPUT(125) = 30000
crider      CALL SCOPY (ITLEN+2, 0.0, 0, FIN(IFIN2+1), 1)
            call vmov(0.0,0,fin(ifin2+1),1,itlen+2)
crider      CALL SCOPY (NS     , 0.0, 0, TDATA(IPNT+1),1)
            call vmov(0.0,0,tdata(ipnt+1),1,ns)
         ENDIF
      ELSE
crider   CALL SCOPY (NS, 0.0, 0, FIN(IFIN2+1), 1)
         call vmov(0.0,0,fin(ifin2+1),1,ns)
crider   CALL SCOPY (NS, 0.0, 0, TDATA(IPNT+1),1)
         call vmov(0.0,0,tdata(ipnt+1),1,ns)
      ENDIF
C
criderCALL SCOPY (64, RDATA, 1, HDRS(1,IO), 1)
      call vmov(input,1,hdrs(1,io),1,itrwrd)
      III = IO+1
      DO 10 I=III,NTRS
         IF(ITRC.GT.NMAX)ITRC=NTPR+1
crider   CALL FILEAC(LUD1,INPUT,ITRC,IREAD,1)
         call daread(itrc,input,lud1)
         ITRC=ITRC+1
         KNT  = KNT+1
         IFIN2 = IFIN + (N1 * (I - 1))
         IPNT  = ITDAT+ (I-1)*NS
         IF (I2NPUT(125) .LT. 30000) THEN
            IF (IWFLG .EQ. 1) THEN
               DEPTH = I2NPUT(97)
               DIST  = I2NPUT(119)
               WBTIME = SQRT((2. * DEPTH) **2. + (DIST **2)) / WVEL
               IWBSMP(I) = WBTIME / NSR + WBBIAS
               IF (IWBSMP(I) .GE. NS) IWBSMP(I) = NS - 1
               NWBSAV = IWBSMP(I) + WBB2 + 1
               IF (NWBSAV .GT. NS) NWBSAV = NS
               IWB = IWBSAV + (NS * (I - 1))
               IF (IFMT .EQ. 3) THEN
crider            CALL SCOPY (NWBSAV, RDATA(65), 1, WBSAV(IWB+1), 1)
                  call vmov(tri,1,wbsav(iwb+1),1,nwbsav)	
               ELSE
                  CALL ITOFP (I2NPUT(129), WBSAV(IWB+1), NWBSAV)
               ENDIF
            ELSE
               IWBSMP(I) = 0
            ENDIF
C
            IF ( IEARLY .EQ. 0 ) THEN
               IF (IFMT .EQ. 1) THEN
                  CALL IZEROS (I2NPUT(129+IWBSMP(I)), NS-IWBSMP(I),
     &                         LZEROS(I))
               ELSE
*                 CALL RZEROS (RDATA(65+IWBSMP(I)), NS-IWBSMP(I),
                  call rzeros (tri(1+iwbsmp(i)),ns-iwbsmp(i),
     &                         LZEROS(I))
               ENDIF
            ENDIF
C
            IF (LZEROS(I) .LT. NS-IWBSMP(I)) THEN
*              IF (IFMT .NE. 3)CALL ITOFP (I2NPUT(129), RDATA(65), NS)
               if(ifmt.ne.3)call itofp(i2nput(129),tri(1),ns)
               IF (IWFLG .EQ. 1) THEN
                  LZERO = IWBSMP(I) - WBB2
                  IF(LZERO.GT.NS)LZERO=NS
crider            CALL SCOPY (LZERO, 0.0, 0, RDATA(65), 1)
                  call vclr(tri,1,lzero)
               ENDIF
C
crider         CALL SCOPY(NS,RDATA(65),1,TDATA(IPNT+1),1)
               call vmov(tri,1,tdata(ipnt+1),1,ns)
crider         CALL IAPR5 (RDATA(65), FIN(IFIN2+1))
               call iapr5(tri(1),fin(ifin2+1))
            ELSE
                  I2NPUT(125) = 30000
crider         CALL SCOPY (ITLEN+2, 0.0, 0, FIN(IFIN2+1), 1)
               call vclr(fin(ifin2+1),1,itlen+2)

CRIDER          CALL SCOPY (NS,      0.0 ,0, TDATA(IPNT+1),1)
               call vclr(tdata(ipnt+1),1,ns)
            ENDIF
         ELSE
crider      CALL SCOPY (NS, 0.0 , 0, FIN(IFIN2+1), 1)
            call vclr(fin(ifin2+1),1,ns)
crider      CALL SCOPY (NS, 0.0,  0, TDATA(IPNT+1),1)
            call vclr(tdata(ipnt+1),1,ns)
         ENDIF
C
C --- SAVE THE TRACE HEADER
C
crider   CALL SCOPY (64, RDATA, 1, HDRS(1,I), 1)
         call vmov(input,1,hdrs(1,i),1,itrwrd)
   10 CONTINUE
C
C XXX CONVOLVE EACH TRACE WITH ITS RESPECTIVE FILTER TRACE
C
C +--------------------------------------+
C |  OUTPUT THE FIRST HALF OF THE TRACES |
C +--------------------------------------+
c -- added next 2 lines per crider for taper compensation -j.m.wade 12/05/90
      isw = 1
      nst = 2
      DO 18 IX=1,IZ
         IO  = IX
         IF (IHDRS(125,IO) .GE. 30000) THEN
crider      CALL SCOPY (NS, 0.0, 0, RDATA(65), 1)
            call vclr(tri,1,ns)
         ELSE
          CALL VCLR(SUM,1,NS)
          DO 2010 JF=1,NSETS
crider      CALL SCOPY (ITLEN+2, 0.0, 0, XSUM(IXSUM+1), 1)
            call vclr(xsum(ixsum+1),1,itlen+2)
            ISF  = IZ-IX+ISIDE
            IEZ  = IZ+IX-1
C
            IPNT=IFLTT+1+(JF-1)*NPTNTR
            IF(ISTAK.EQ.2)IPNT=IFLTT+1+2*(JF-1)*NPTNTR
            CALL EXCHN (FIN(IFIN+1), 1, FLTT(IPNT), ISF, IEZ,
     &                  XSUM(IXSUM+1), tri(1), NST, ISW)
*    &                  XSUM(IXSUM+1), RDATA(65))
C +---------------------------------------------------------------+
C |         PROCESS THE WEIGHTING FOR DIP ENHANCEMENT             |
C +---------------------------------------------------------------+
      IF(WGHT(JF).GT.0.0)THEN
         SCAL=WGHT(JF)-1.
*        CALL VSMUL(RDATA(65),1,SCAL,RDATA(65),1,NS)
         call vsmul(tri(1),1,scal,tri(1),1,ns)
      ENDIF
            IF(LTVAR.NE.0)THEN
              ISAV2 = ISAVE + (NS * (JF - 1))+1
crider        CALL SCOPY (NS, RDATA(65), 1, TEMP(ISAV2), 1)
              call vmov(tri,1,temp(isav2),1,ns)
            ENDIF
 2010     CONTINUE
      IF(LTVAR.NE.0)THEN
         IPNT=ITDAT+(IO-1)*NS
crider   CALL SCOPY(NS,TDATA(IPNT+1),1,RDATA(65),1)
         call vmov(tdata(ipnt+1),1,tri(1),1,ns)
crider   CALL VMOV(RDATA(65),1,SUM,1,NS)
         call vmov(tri,1,sum,1,ns)
crider   CALL VMOV(RDATA(65),1,TENH,1,NS)
         call vmov(tri,1,tenh,1,ns)
         DO 2015 JF=1,NSETS
              ISAV2 = ISAVE + (NS * (JF - 1))+1
crider        CALL SCOPY (NS, TEMP(ISAV2), 1, RDATA(65), 1)
              call vmov(temp(isav2),1,tri,1,ns)
         IF(LTVAR.EQ.1)THEN
           IS=STRTT(JF)
           IE=ENDT(JF)
         ELSE
           IE=STRTT(JF)
           IF(JF.GT.1)THEN
              IS=STRTT(JF-1)
           ELSE
              IS=IE
           ENDIF
            IF(NSETS.EQ.1)IS=IE
         ENDIF
         IF(INTER.EQ.1)THEN
            DELST=0.
            DELET=0.
            ICHK=IHDRS(106,IO)
C *-------------------------------------*
C |  THE CODE COMMENTED OUT BELOW WOULD |
C |  HOLD WINDOWS CONSTANT OUTSIDE AREC |
C |  AND BREC.                          |
C *-------------------------------------*
C           IF(ICHK.GE.AREC(JF))THEN
C              DREC=BREC(JF)-AREC(JF)
               DELRC=ICHK-AREC(JF)
C              IF(DELRC.GT.DREC)DELRC=DREC
               DELST=DELRC*DELSRC(1,JF)
               DELET=DELRC*DELSRC(2,JF)
C           ENDIF
            IS=IS+DELST
            IF(IS.GT.NS)IS=NS
            IF(IS.LE.0)IS=1
            IE=IE+DELET
            IF(IE.GT.NS)IE=NS
            IF(IE.LE.0)IE=1
         ENDIF
         IF((IE-IS+1).LE.12)GO TO 2015
         IF(WGHT(JF).GT.0.0)THEN
crider      CALL VADD(RDATA(65),1,TENH,1,RDATA(65),1,NS)
            CALL VADD(tri(1),1,TENH,1,TRI(1)   ,1,NS)
         ENDIF
crider   CALL GNTRC1(SUM,RDATA(65),IS,IE,NRAMP,LTVAR)
         CALL GNTRC1(SUM,tri(1)   ,IS,IE,NRAMP,LTVAR)
 2015   CONTINUE
crider  CALL VMOV(SUM,1,RDATA(65),1,NS)
        call vmov(sum,1,tri(1),1,ns)
        ELSE
         IF(WGHT(1).GT.0.0)THEN
            IPNT=ITDAT+(IO-1)*NS
crider      CALL VADD(RDATA(65),1,TDATA(IPNT+1),1,RDATA(65),1,NS)
            call vadd(tri(1),1,tdata(ipnt+1),1,tri(1),1,ns)
         ENDIF
      ENDIF
C +--------------------------------------------------------------------+
C | RESTORE DATA ABOVE WATER BOTTOM IF WATER BOTTOM TRACKING REQUESTED |
C +--------------------------------------------------------------------+
            IF (IWFLG .EQ. 1) THEN
               IWBSTR = IWBSMP(IO) - WBB2
               IWB = IWBSAV + (NS * (IO - 1))
crider         CALL SCOPY (IWBSTR, WBSAV(IWB+1), 1, RDATA(65), 1)
               call vmov(wbsav(iwb+1),1,tri,1,iwbstr)
C
               ILAST = LRMP
               IF ( IWBSTR+LRMP .GT. NS ) ILAST = NS - IWBSTR
               DO 20 I = 1, ILAST
                  RDATA(64+IWBSTR+I) =
     &               WBSAV(IWB+IWBSTR+I) * TRIRMP(I) +
     &               RDATA(64+IWBSTR+I) * (1 - TRIRMP(I))
   20          CONTINUE
            ENDIF
C +----------------------------------+
C | RESTORE EARLY MUTE IF REQUESTED  |
C | FIX THE DATA IF NECESSARY        |
C +----------------------------------+
            IF (IEARLY.EQ.0 .AND. LZEROS(IO).GT.0)
     &         CALL RSTORE (  tri(1+IWBSMP(IO)),IPR,LZEROS(IO))
crid &         CALL RSTORE (RDATA(65+IWBSMP(IO)),IPR,LZEROS(IO))
crider      IF (IOFMT.EQ.1) CALL FPTOI (I2NPUT(129),RDATA(65),NS,ITT)
            IF (IOFMT.EQ.1) CALL FPTOI (I2NPUT(129),tri(1)   ,NS,ITT)
         ENDIF
C +------------------------------+
C |   RESTORE THE TRACE HEADER   |
C +------------------------------+
crider   CALL SCOPY (64, HDRS(1,IO), 1, RDATA(1), 1)
         call vmov(hdrs(1,io),1,rdata(1),1,itrwrd)
C +------------------------------+
C |   OUTPUT THE SUMMED TRACE    |
C +------------------------------+
         if (i2nput(107) .ne. 0) CALL WRTARI (LUO,INPUT,LBYTE,NTPR,IPR)
         JKNT = JKNT + 1
c -- added next lines per crider for taper compensation -j.m.wade 12/05/90
         nst = nst + 2
   18 CONTINUE
C +------------------------------------------------------------+
C |                 MAIN PROCESSING LOOP                       |
C +------------------------------------------------------------+
c -- added next 2 lines per crider for taper compensation -j.m.wade 12/05/90
         isw = 0
         nst = 0
   40 CONTINUE
C
      IF(ITRC.GT.NMAX)ITRC=NTPR+1
criderCALL FILEAC(LUD1,INPUT,ITRC,IREAD,1)
      call daread(itrc,input,lud1)
      IF (ITRC.GE.NTPR+1)THEN
         IEND = 1
         GO TO 599
      ENDIF
      ITRC=ITRC+1
      KNT   = KNT+1
      IO    = IO+1
      IREPL = MOD(KNT,NTRS)
      IF (IREPL.EQ.0) IREPL=NTRS
      IOL   = MOD(IO,NTRS)
      IF (IOL.EQ.0) IOL=NTRS
      IFIN2 = IFIN + (N1 * (IREPL - 1))
      IPNT  = ITDAT+ (IREPL-1)*NS
      IF (I2NPUT(125) .LT. 30000) THEN
         IF (IWFLG .EQ. 1) THEN
            DEPTH = I2NPUT(97)
            DIST  = I2NPUT(119)
            WBTIME = SQRT((2. * DEPTH) **2. + (DIST **2)) / WVEL
            IWBSMP(IREPL) = WBTIME / NSR + WBBIAS
            IF (IWBSMP(IREPL) .GE. NS) IWBSMP(IREPL) = NS - 1
            NWBSAV = IWBSMP(IREPL) + WBB2 + 1
            IF (NWBSAV .GT. NS) NWBSAV = NS
            IWB = IWBSAV + (NS * (IREPL - 1))
            IF (IFMT .EQ. 3) THEN
crider         CALL SCOPY (NWBSAV, RDATA(65), 1, WBSAV(IWB+1), 1)
               call vmov(tri,1,wbsav(iwb+1),1,nwbsav)
            ELSE
               CALL ITOFP (I2NPUT(129), WBSAV(IWB+1), NWBSAV)
            ENDIF
         ELSE
            IWBSMP(IREPL) = 0
         ENDIF
         IF ( IEARLY .EQ. 0 ) THEN
            IF ( IFMT .EQ. 1 ) THEN
               CALL IZEROS ( I2NPUT(129+IWBSMP(IREPL)),
     &                       NS-IWBSMP(IREPL), LZEROS(IREPL) )
            ELSE
crider         CALL RZEROS ( RDATA(65+IWBSMP(IREPL)),
               call rzeros (tri(1+iwbsmp(irepl)),
     &                       NS-IWBSMP(IREPL), LZEROS(IREPL) )
            ENDIF
         ENDIF
C
         IF (LZEROS(IREPL) .LT. NS-IWBSMP(IREPL)) THEN
crider      IF (IFMT .NE. 3) CALL ITOFP (I2NPUT(129), RDATA(65), NS)
            IF (IFMT .NE. 3) CALL ITOFP (I2NPUT(129), tri(1)   , NS)
            IF (IWFLG .EQ. 1) THEN
               LZERO = IWBSMP(IREPL) - WBB2
               IF(LZERO.GT.NS)LZERO=NS
crider         CALL SCOPY (LZERO, 0.0, 0, RDATA(65), 1)
               call vclr(tri,1,lzero)
            ENDIF
C
crider      CALL SCOPY(NS,RDATA(65),1,TDATA(IPNT+1),1)
            call vmov(tri(1),1,tdata(ipnt+1),1,ns)
crider      CALL IAPR5 (RDATA(65), FIN(IFIN2+1))
            call iapr5(tri(1),fin(ifin2+1))
         ELSE
            I2NPUT(125) = 30000
crider      CALL SCOPY (ITLEN+2, 0.0, 0, FIN(IFIN2+1), 1)
crider      CALL SCOPY (NS     , 0.0, 0 ,TDATA(IPNT+1),1)
            call vclr(fin(ifin2+1),1,itlen+2)
            call vclr(tdata(ipnt+1),1,ns)
         ENDIF
      ELSE
crider   CALL SCOPY (NS, 0.0, 0, FIN(IFIN2+1), 1)
         call vclr(fin(ifin2+1),1,ns)
crider   CALL SCOPY(NS,0.0,0,TDATA(IPNT+1),1)
         call vclr(tdata(ipnt+1),1,ns)
      ENDIF
C +--------------------------+
C |   SAVE THE TRACE HEADER  |
C +--------------------------+
CriderCALL SCOPY (64, RDATA, 1, HDRS(1,IREPL), 1)
      call vmov(rdata,1,hdrs(1,irepl),1,itrwrd)
C +--------------------------+
C |   DO THE CONVOLUTION     |
C +--------------------------+
      ISTRT = IREPL+1
      IF (ISTRT.GT.NTRS) ISTRT=1
      IFLT = ISIDE
C
      IF (IHDRS(125,IOL) .GE. 30000) THEN
         call vclr(tri,1,ns)
crider   CALL SCOPY (NS, 0.0, 0, RDATA(65), 1)
      ELSE
         CALL VCLR(SUM,1,NS)
            DO 2020 JF=1,NSETS
crider      CALL SCOPY (ITLEN+2, 0.0, 0, XSUM(IXSUM+1), 1)
            call vclr(xsum(ixsum+1),1,itlen+2)
            IPNT=IFLTT+1+(JF-1)*NPTNTR
            IF(ISTAK.EQ.2)IPNT=IFLTT+1+2*(JF-1)*NPTNTR
            CALL EXCHN (FIN(IFIN+1), ISTRT, FLTT(IPNT), IFLT, NTRS,
     &                  xsum(ixsum+1), tri(1), NST, ISW)
*    &                  XSUM(IXSUM+1), RDATA(65))
C +---------------------------------------------------------------+
C |         PROCESS THE WEIGHTING FOR DIP ENHANCEMENT             |
C +---------------------------------------------------------------+
      IF(WGHT(JF).GT.0.0)THEN
         SCAL=WGHT(JF)-1.
*        CALL VSMUL(RDATA(65),1,SCAL,RDATA(65),1,NS)
         call vsmul(tri(1),1,scal,tri(1),1,ns)
      ENDIF
            IF(LTVAR.NE.0)THEN
              ISAV2 = ISAVE + (NS * (JF - 1))+1
CRIDER        CALL SCOPY (NS, RDATA(65), 1, TEMP(ISAV2), 1)
              call vmov(tri(1),1,temp(isav2),1,ns)
            ENDIF
 2020     CONTINUE
      IF(LTVAR.NE.0)THEN
         IPNT=ITDAT+(IOL-1)*NS
crider   CALL SCOPY(NS,TDATA(IPNT+1),1,RDATA(65),1)
         call vmov(tdata(ipnt+1),1,tri(1),1,ns)
crider   CALL VMOV(RDATA(65),1,SUM,1,NS)
         call vmov(tri(1),1,sum,1,ns)
crider   CALL VMOV(RDATA(65),1,TENH,1,NS)
         call vmov(tri(1),1,tenh,1,ns)
         DO 2025 JF=1,NSETS
              ISAV2 = ISAVE + (NS * (JF - 1))+1
crider        CALL SCOPY (NS, TEMP(ISAV2), 1, RDATA(65), 1)
              call vmov(temp(isav2),1,tri(1),1,ns)
         IF(LTVAR.EQ.1)THEN
           IS=STRTT(JF)
           IE=ENDT(JF)
         ELSE
           IE=STRTT(JF)
           IF(JF.GT.1)THEN
              IS=STRTT(JF-1)
           ELSE
              IS=IE
           ENDIF
            IF(NSETS.EQ.1)IS=IE
         ENDIF
         IF(INTER.EQ.1)THEN
            DELST=0.
            DELET=0.
            ICHK=IHDRS(106,IOL)
               DELRC=ICHK-AREC(JF)
               DELST=DELRC*DELSRC(1,JF)
               DELET=DELRC*DELSRC(2,JF)
            IS=IS+DELST
            IF(IS.GT.NS)IS=NS
            IF(IS.LE.0)IS=1
            IE=IE+DELET
            IF(IE.GT.NS)IE=NS
            IF(IE.LE.0)IE=1
         ENDIF
         IF((IE-IS+1).LE.12)GO TO 2025
         IF(WGHT(JF).GT.0.0)THEN
crider      CALL VADD(RDATA(65),1,TENH,1,RDATA(65),1,NS)
            call vadd(tri(1),1,tenh,1,tri(1),1,ns)
         ENDIF
crider   CALL GNTRC1(SUM,RDATA(65),IS,IE,NRAMP,LTVAR)
         call gntrc1(sum,tri(1),   is,ie,nramp,ltvar)
 2025   CONTINUE
*       CALL VMOV(SUM,1,RDATA(65),1,NS)
        call vmov(sum,1,tri(1),1,ns)
        ELSE
         IF(WGHT(1).GT.0.0)THEN
            IPNT=ITDAT+(IOL-1)*NS
*           CALL VADD(RDATA(65),1,TDATA(IPNT+1),1,RDATA(65),1,NS)
            call vadd(tri(1),1,tdata(ipnt+1),1,tri(1),1,ns)
         ENDIF
      ENDIF
C +--------------------------------------------------------------------+
C | RESTORE DATA ABOVE WATER BOTTOM IF WATER BOTTOM TRACKING REQUESTED |
C +--------------------------------------------------------------------+
         IF (IWFLG .EQ. 1) THEN
            IWBSTR = IWBSMP(IOL) - WBB2
            IWB = IWBSAV + (NS * (IOL - 1))
crider      CALL SCOPY (IWBSTR, WBSAV(IWB+1), 1, RDATA(65), 1)
            call vmov(wbsav(iwb+1),1,tri(1),1,iwbstr)
C
            ILAST = LRMP
            IF ( IWBSTR+LRMP .GT. NS ) ILAST = NS - IWBSTR
            DO 100 I = 1, ILAST
               RDATA(64+IWBSTR+I) =
     &            WBSAV(IWB+IWBSTR+I) * TRIRMP(I) +
     &            RDATA(64+IWBSTR+I) * (1 - TRIRMP(I))
  100       CONTINUE
         ENDIF
C +----------------------------------+
C | RESTORE EARLY MUTE IF REQUESTED  |
C | FIX THE DATA IF NECESSARY        |
C +----------------------------------+
         IF (IEARLY.EQ.0 .AND. LZEROS(IOL).GT.0)
     &      call rstore (tri(1+iwbsmp(iol)),ipr,lzeros(iol))
*    &      CALL RSTORE (RDATA(65+IWBSMP(IOL)),IPR,LZEROS(IOL))
*        IF (IOFMT.EQ.1) CALL FPTOI (I2NPUT(129),RDATA(65),NS,ITT)
         IF (IOFMT.EQ.1) CALL FPTOI (I2NPUT(129),tri(1)   ,NS,ITT)
      ENDIF
C +------------------------------+
C |   RESTORE THE TRACE HEADER   |
C +------------------------------+
CriderCALL SCOPY (64, HDRS(1,IOL), 1, RDATA(1), 1)
      call vmov(hdrs(1,iol),1,rdata(1),1,itrwrd)
C +--------------------+
C |  OUTPUT THE TRACE  |
C +--------------------+
      if (i2nput(107) .ne. 0) CALL WRTARI (LUO,INPUT,LBYTE,NTPR,IPR)
      JKNT = JKNT + 1
      GO TO 40
C +------------------------------------------------------------+
C |                          TAPER OUT                         |
C +------------------------------------------------------------+
  599 CONTINUE
c -- added next 2 lines per crider for taper compensation -j.m.wade 12/05/90
      isw = -1
      nst = 1
      NDO = NTRS - 1
      DO 610 I=1,IZ1
         IO  = IO+1
         IOL = MOD(IO,NTRS)
         IF (IOL.EQ.0) IOL=NTRS
         IF (IHDRS(125,IOL) .GE. 30000) THEN
crider      CALL SCOPY (NS, 0.0 , 0, RDATA(65), 1)
            call vclr(tri(1),1,ns)
            NDO = NDO - 1
         ELSE
C
            JTRC = IOL-IZ1
            IF (JTRC.LE.0) JTRC = IOL+IZ
            JTRC = MOD(JTRC,NTRS)
            IF (JTRC.EQ.0) JTRC=NTRS
C
            IFLT = ISIDE
C
            CALL VCLR(SUM,1,NS)
            DO 2030 JF=1,NSETS
crider      CALL SCOPY (ITLEN+2, 0.0, 0, XSUM(IXSUM+1), 1)
            call vclr(xsum(ixsum+1),1,itlen+2)
            IPNT=IFLTT+1+(JF-1)*NPTNTR
            IF(ISTAK.EQ.2)IPNT=IFLTT+1+2*(JF-1)*NPTNTR
            CALL EXCHN (FIN(IFIN+1), JTRC, FLTT(IPNT), IFLT,
     &                  NDO, XSUM(IXSUM+1), tri(1), NST, ISW   )
crid &                  NDO, XSUM(IXSUM+1), RDATA(65))
C +---------------------------------------------------------------+
C |         PROCESS THE WEIGHTING FOR DIP ENHANCEMENT             |
C +---------------------------------------------------------------+
      IF(WGHT(JF).GT.0.0)THEN
         SCAL=WGHT(JF)-1.
*        CALL VSMUL(RDATA(65),1,SCAL,RDATA(65),1,NS)
         call vsmul(tri(1),1,scal,tri(1),1,ns)
      ENDIF
            IF(LTVAR.NE.0)THEN
              ISAV2 = ISAVE + (NS * (JF - 1))+1
crider        CALL SCOPY (NS, RDATA(65), 1, TEMP(ISAV2), 1)
              call vmov(tri(1),1,temp(isav2),1,ns)
            ENDIF
 2030     CONTINUE
      IF(LTVAR.NE.0)THEN
         IPNT=ITDAT+(IOL-1)*NS
crider   CALL SCOPY(NS,TDATA(IPNT+1),1,RDATA(65),1)
         call vmov(tdata(ipnt+1),1,tri(1),1,ns)
         CALL VMOV(TRI(1),1,SUM,1,NS)
CRIDER   CALL VMOV(RDATA(65),1,SUM,1,NS)
         CALL VMOV(TRI(1),1,TENH,1,NS)
CRIDER   CALL VMOV(RDATA(65),1,TENH,1,NS)
         DO 2035 JF=1,NSETS
              ISAV2 = ISAVE + (NS * (JF - 1))+1
crider        CALL SCOPY (NS, TEMP(ISAV2), 1, RDATA(65), 1)
              call vmov(temp(isav2),1,tri(1),1,ns)
         IF(LTVAR.EQ.1)THEN
           IS=STRTT(JF)
           IE=ENDT(JF)
         ELSE
           IE=STRTT(JF)
           IF(JF.GT.1)THEN
              IS=STRTT(JF-1)
           ELSE
              IS=IE
           ENDIF
            IF(NSETS.EQ.1)IS=IE
         ENDIF
         IF(INTER.EQ.1)THEN
            DELST=0.
            DELET=0.
            ICHK=IHDRS(106,IOL)
               DELRC=ICHK-AREC(JF)
               DELST=DELRC*DELSRC(1,JF)
               DELET=DELRC*DELSRC(2,JF)
            IS=IS+DELST
            IF(IS.GT.NS)IS=NS
            IF(IS.LE.0)IS=1
            IE=IE+DELET
            IF(IE.GT.NS)IE=NS
            IF(IE.LE.0)IE=1
         ENDIF
         IF(WGHT(JF).GT.0.0)THEN
*           CALL VADD(RDATA(65),1,TENH,1,RDATA(65),1,NS)
            call vadd(tri(1),1,tenh,1,tri(1),1,ns)
         ENDIF
*        CALL GNTRC1(SUM,RDATA(65),IS,IE,NRAMP,LTVAR)
         call gntrc1(sum,tri(1),is,ie,nramp,ltvar)
 2035   CONTINUE
*        CALL VMOV(SUM,1,RDATA(65),1,NS)
         call vmov(sum,1,tri(1),1,ns)
        ELSE
         IF(WGHT(1).GT.0.0)THEN
            IPNT=ITDAT+(IOL-1)*NS
*           CALL VADD(RDATA(65),1,TDATA(IPNT+1),1,RDATA(65),1,NS)
            call vadd(tri(1),1,tdata(ipnt+1),1,tri(1),1,ns)
         ENDIF
      ENDIF
C
            NDO = NDO-1
C +--------------------------------------------------------------------+
C | RESTORE DATA ABOVE WATER BOTTOM IF WATER BOTTOM TRACKING REQUESTED |
C +--------------------------------------------------------------------+
            IF (IWFLG .EQ. 1) THEN
               IWBSTR = IWBSMP(IOL) - WBB2
               IWB = IWBSAV + (NS * (IOL - 1))
crider         CALL SCOPY (IWBSTR, WBSAV(IWB+1), 1, RDATA(65), 1)
               call vmov(wbsav(iwb+1),1,tri(1),1,iwbstr)
C
               ILAST = LRMP
               IF ( IWBSTR+LRMP .GT. NS ) ILAST = NS - IWBSTR
               DO 200 J = 1, ILAST
                  RDATA(64+IWBSTR+J) =
     &               WBSAV(IWB+IWBSTR+J) * TRIRMP(J) +
     &               RDATA(64+IWBSTR+J) * (1 - TRIRMP(J))
  200          CONTINUE
            ENDIF
C +----------------------------------+
C | RESTORE EARLY MUTE IF REQUESTED  |
C | FIX THE DATA IF NECESSARY        |
C +----------------------------------+
            IF (IEARLY.EQ.0 .AND. LZEROS(IOL).GT.0)
     &         call rstore(tri(1+iwbsmp(iol)), ipr,lzeros(iol))
*    &         CALL RSTORE (RDATA(65+IWBSMP(IOL)),IPR,LZEROS(IOL))
crider      IF (IOFMT.EQ.1) CALL FPTOI (I2NPUT(129),RDATA(65),NS,ITT)
            IF (IOFMT.EQ.1) CALL FPTOI (I2NPUT(129),tri(1)   ,NS,ITT)
         ENDIF 
C +------------------------------+
C |   RESTORE THE TRACE HEADER   |
C +------------------------------+
crider   CALL SCOPY (64, HDRS(1,IOL), 1, RDATA(1), 1)
         call vmov(hdrs(1,iol),1,rdata(1),1,itrwrd)
C +--------------------+
C |  OUTPUT THE TRACE  |
C +--------------------+
         if (i2nput(107) .ne. 0) CALL WRTARI (LUO,INPUT,LBYTE,NTPR,IPR)
         JKNT = JKNT + 1
c -- added next line per crider for taper compensation -j.m.wade 12/05/90
         nst = nst + 1
  610 CONTINUE
C
C +-----------------------------+
C |   CHECK FOR RECORD BOUNDARY |
C +-----------------------------+
C
      IF(SIDE1)THEN
         SIDE1=.FALSE.
         GO TO 695
      ENDIF
      IF(SIDE2)THEN
         SIDE2=.FALSE.
         GO TO 695
      ENDIF
      END
      subroutine daopen(ntrs,ntrks,nbytes,lud,nunits,iszbyt)
#include <f77/iounit.h>
      real array(*)
      real work
c     common / diskio / wkaddr
      pointer(wkaddr, work(1))
      logical heap
      integer nsamps
      integer errcod, abort
      data abort / 0 /
      save abort
      data heap / .true. /
      SAVE nsamps,heap
      save wkaddr
      nsamps = nbytes/iszbyt

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      call galloc(wkaddr, ntrs*ntrks*nbytes, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
        write(LERR,*)' DIPF: unable to allocate memory in DAOPEN',
     *              ', use scratch disk'
        open(lud,form='UNFORMATTED',access='DIRECT', recl=nbytes,
     *     status = 'SCRATCH',iostat=ios)
        if (ios .ne. 0)
     *    write(LERR,*)' DIPF: Unable to allocate scratch disk in ',
     *              'DAOPEN recl = ',nbytes,', iostat = ',ios
      endif
      return
*
      entry daread(irec,array,lud)
      if ( heap ) then
        iloca=(irec-1)*nsamps+1
        call vmov(work(iloca),1,array(1),1,nsamps)
      else
        read(lud,rec=irec)(array(i),i=1,nsamps)
      endif
      return
*
      entry dawrte(irec,array,lud)
      if ( heap ) then
        iloca=(irec-1)*nsamps+1
        call vmov(array(1),1,work(iloca),1,nsamps)
      else
        write(lud,rec=irec)(array(i),i=1,nsamps)
      endif
      return
*
      entry daclos(lud)
      if ( heap ) then
        call gfree(wkaddr)
      else
        close(lud, status = 'DELETE')
      endif
      return
*
      end
      subroutine lgetln(luns,tap,flg,defval)
c-----
c     associate logical unit numbers with input and output
c
c     luin  - I*4 unit number for file
c     tap  - C*120     name of input file
c     flg   - C*1 flag for file permission,e.g.,'r' or 'w'
c     defval- I*4 default luns if tap = ' '
c-----
#include <f77/localsys.h>
#include <f77/iounit.h>
      integer*4 luns
      character tap*(*)
      character flg*(*)
      integer*4 defval
            if ( tap .ne. ' ' ) then
                  call lbopen ( luns, tap, flg )
            else
                  luns=defval
            endif
      return
      end
