C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine arrange ( nlive, ndead, ntrc, ngrp, itrce_size, idist, 
     1     dx, xmod_size, xmod, itrce, idead, model, isht, igrp, idi, 
     2     ili, split, ifmt_StaCor,l_StaCor, ln_StaCor, ntrm, ntro,
     3     ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd, nopad,
     4     ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc, fix,
     5     ifmt_RecInd,l_RecInd, ln_RecInd,
     6     ifmt_DphInd,l_DphInd, ln_DphInd,
     6     ifmt_LinInd,l_LinInd, ln_LinInd,
     7     ifmt_RecNum,l_RecNum, ln_RecNum,
     8     itr_size, itr, trhead_plus_tr_size, irec, jdist, interp )

      implicit none

#include <save_defs.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nlive, ndead, ntrc, ngrp, itrce_size, xmod_size
      integer ntrm, ntro, itr_size, trhead_plus_tr_size, irec
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd
      integer ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc
      integer ifmt_RecInd,l_RecInd, ln_RecInd
      integer ifmt_DphInd,l_DphInd, ln_DphInd
      integer ifmt_LinInd,l_LinInd, ln_LinInd
      integer ifmt_RecNum,l_RecNum, ln_RecNum

      integer idist(ntrc)
      integer itrce(itrce_size)
      integer idead(itrce_size)
      integer isht(ntrc)
      integer igrp(ntrc)
      integer idi(ntrc)
      integer ili(ntrc)
      integer itr(itr_size)
      integer jdist(ntrm)

      real dx
      real xmod(xmod_size)

      logical model, split, nopad, fix, interp

c declare local variables

      integer j, locmin, mismin, mislst, jx, kx, miscur, loc
      integer missdx, minloc, jnlst, joff, il, id, ic
      integer istrc, idtrc, i, ii

      integer jndx(SZLNHD)
      integer jnlx(SZLNHD)
      integer kdist(SZLNHD)
      integer ldist(SZLNHD)
      integer jsht(SZLNHD)
      integer jgrp(SZLNHD)
      integer jdi(SZLNHD)
      integer jli(SZLNHD)

      real xmin, discur, xloc

      SAVE

c policeman

      if ( ntrm .gt. SZLNHD ) then
         write(LERR,*) ' '
         write(LERR,*) 'Array overflow in arrange.F '
         write(LERR,*) 'Get USP staff to add yet more'
         write(LERR,*) 'dynamic memory allocation to'
         write(LERR,*) 'this routine.'
         write(LERR,*) 'FATAL'
         write(LER,*) 'DISORT: '
         write(LER,*) ' Array overflow in arrange.F '
         write(LER,*) ' Get USP staff to add yet more'
         write(LER,*) ' dynamic memory allocation to'
         write(LER,*) ' this routine.'
         write(LER,*) 'FATAL'
         stop
      endif
      
c initialize variables

      do  j = nlive+1, ntrm
         idist(j) = -999999
      enddo

      do  j = 1, ntrm
         jnlx(j)   =  0
         jndx(j)   =  0
         jdist(j)  = -999999
         kdist(j)  = -999999
         ldist(j)  = -999999
         jsht(j)   =  0
         jgrp(j)   =  0
         jdi(j)    =  0
         jli(j)    =  0
      enddo

c-----------------------------------
c  find position of first (min) input trace within model
c  the input trace distances have been ordered from most
c  neg. to most pos.
c-----------------------------------

      call minmgv (xmod, 1, xmin, locmin, ngrp)

      if (.not. split) then
         locmin = locmin - 1
      endif

c-----------------------------------
c  find position of input traces within model
c  starting from initial model location
c  of the min input trc distance
c-----------------------------------

      mismin = 999999
      mislst = 0
      jx     = 0
      kx     = 0

      DO  j = 1, nlive

         discur = idist(j)
    
         xloc   = discur / dx
         if (fix) then
            miscur  = ifix (xloc) + loc
         else
            miscur  = nint (xloc) + loc
         endif
         if (miscur .le. mismin) mismin = miscur
         if (miscur .eq. mislst) then
            jx = jx + 1
            kx = kx + 1
            missdx   = miscur + kx
            jnlx (j) = locmin + missdx
         else
            jx       = 0
            jnlx (j) = locmin + miscur + kx
            mislst   = miscur
         endif

      ENDDO

c-----
c  if we retain the original # traces/rec on output (nopad) then we must
c  adjust the starting pointer into the model array to be 1 (even if the
c  first distance of the input spread is gt 1).
c-----
      if (nopad) then
         minloc = jnlx (1) - 1
         do  j = 1, nlive
             jnlx (j) = jnlx (j) - minloc
         enddo
      endif

      do  j = 1, nlive
         ldist (j) = xmod(jnlx(j))
      enddo

      if (nlive .lt. 2) go to 17
      
c----
c   if the pointer runs off the end of the model spread find the adjustment
c   that gets it back
c----
c      do  j = 1, nlive

c 
c holy shit batman, ishft is not typed above and is not assigned or used
c anywhere in this routine except here.  God only knows what this was 
c originally meant to do.  At this point if you are lucky ishft=0 and
c nothing happens.  If ishft happens to contain something non-zero
c then I suspect this routine will eventually abort with a segmentation
c violation.  I am going to comment this section out as at best it is 
c a waste of time, at worst it will crash this routine....PGAG
c

c         jnlx (j) = jnlx (j) + ishft
c      enddo

      jnlst = jnlx (nlive)

c hmmm... jnfst is never used for anything so I am commenting it out for now
c ....PGAG?

c      jnfst = jnlx (1)

      if (jnlst .gt. ngrp) then

         joff = jnlst - ngrp

c again, joff could be larger than jnlx(1) in which case jnlx(1) will
c become negative and following the logic below, no data will ever be output
c from this routine.....


         do  j = 1, nlive
            jnlx (j) = jnlx (j) - joff
         enddo

      endif

 17   continue

      il = 1
      id = 0
      ic = 0

      DO  20  j = 1, ntro

         if (j .eq. jnlx(il)) then

            ic = ic + 1
            jndx(ic) = il
            kdist(j) = idist(il)
            jdist(j) = ldist(il)
            jsht (j) = isht (il)
            jgrp (j) = igrp (il)
            jdi  (j) = idi  (il)
            jli  (j) = ili  (il)
            il = il + 1

         else

            ic = ic + 1
            id = id + 1
            jndx(ic) = nlive + id
            kdist(j) = -999999

         endif

 20   CONTINUE

      il = il - 1

      do  30  j = 1, ntro

         istrc = (jndx(j)-1) * trhead_plus_tr_size
         idtrc = (j-1)       * trhead_plus_tr_size

         do  29  i = 1, trhead_plus_tr_size
            itr(i) = itrce(istrc+i)
 29      continue


         if (interp) then
            call savew2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1           jdist(j), TRACEHEADER)
         else
            call savew2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1           kdist(j), TRACEHEADER)
         endif

         call savew2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1        jsht(j), TRACEHEADER)
         call savew2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1        jgrp(j), TRACEHEADER)
         call savew2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1        jdi(j), TRACEHEADER)
         call savew2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1        jli(j), TRACEHEADER)
         call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1        irec, TRACEHEADER)
         if (jdist(j) .eq. -999999) then
            call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           30000, TRACEHEADER)
            call savew2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1           0, TRACEHEADER)
         endif

         do  ii = 1, trhead_plus_tr_size
            idead(idtrc+ii) = itr(ii)
         enddo

         idist (j) = kdist (j)

 30   continue

      return
      end
