C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE DIstance SORT traces, record-by-record
C
C**********************************************************************C
C
C DISORT reads each seismic record, sorts the trace ordering according
C to either ascending or descending order, then outputs the record
C
C SUBROUTINE CALLS: RTAPE, HLH, SAVE, SORT
C
C**********************************************************************C
c
c Changes:
c
c October 16, 2001 : added dynamic memory allocation to support very large
c                    input records , installed implicit none, general cleanup
c Garossino
C
C     DECLARE VARIABLES
C

      implicit none

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>

c declare standard USP variables

      integer  nsamp, nsi, ntrc, nrec, iform
      integer  luin , lbytes, nbytes, luout, lbyout
      integer  ntrco, jj, kk
      integer  argis, jerr

      real UnitSc

      character name * 6, ntap * 256, otap * 256

      logical verbos
      
c variables used in dynamic memory allocation

      integer itr, itr0, itr_size
      integer itrce, idead, itrce_size, itrce_size_bytes
      integer xmod_size, array_size 
      integer iz
      integer trhead_plus_tr_size, ipos
      integer idist, isht, igrp, idi, ili, jndx, jdist, isize
      integer iwork1, iwork2, iwork3
      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, errcd7
      integer errcd8, errcd9, errcd10, errcd11, errcd12, errcd13
      integer errcd14, errcd15, errcd16, errcd17, errcd18, errcd19
      integer errcd20, errcd21, errcd22
      integer abort

      real array
      real xmod
      real work1, work2
      real tabl1, tabl2, zz

      pointer ( mem_itr, itr(2) )
      pointer ( mem_itr0, itr0(2) )
      pointer ( mem_xmod, xmod(2) )
      pointer ( mem_iz, iz(2) )
      pointer ( mem_array, array(2) )
      pointer ( mem_itrce, itrce(2) )
      pointer ( mem_idead, idead(2) )
      pointer ( mem_idist, idist(2) )
      pointer ( mem_isht, isht(2) )
      pointer ( mem_igrp, igrp(2) )
      pointer ( mem_idi, idi(2) )
      pointer ( mem_ili, ili(2) )
      pointer ( mem_jndx, jndx(2) )
      pointer ( mem_jdist, jdist(2) )
      pointer ( mem_iwork1, iwork1(2) )
      pointer ( mem_iwork2, iwork2(2) )
      pointer ( mem_iwork3, iwork3(2) )
      pointer ( mem_work1, work1(2) )
      pointer ( mem_work2, work2(2) )
      pointer ( mem_ipos, ipos(2) )
      pointer ( mem_tabl1, tabl1(2) )
      pointer ( mem_tabl2, tabl2(2) )
      pointer ( mem_zz, zz(2) )

c declare local variables

      integer ntr, ntrm, ngrpi, j, ngrp2, ngrp, il, id, iflag
      integer i, irec, nlive, ndead, istrc, ic, idtrc, ittrc, jt
      integer irr, ip 
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum,TrcNum
      integer ifmt_RecNum,l_RecNum,ln_RecNum,RecNum
      integer ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc
      integer ifmt_RecInd,l_RecInd,ln_RecInd
      integer ifmt_DphInd,l_DphInd,ln_DphInd
      integer ifmt_LinInd,l_LinInd,ln_LinInd
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn,DstSgn
      integer ifmt_DstUsg,l_DstUsg,ln_DstUsg
      integer ifmt_StaCor,l_StaCor,ln_StaCor,StaCor
      integer ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd

      real dis, dmin, dmax, offfar, offx, x, dx

      character hdrwrd * 6

      logical reverse, pass, nopad, split, model, back
      logical bin, interp, dead, neg, fix

c initialize variables
 
      DATA NAME/'DISORT'/
      DATA LUIN/ 1 /
      data LBYTES / 0 /
      data NBYTES / 0 /
      data back/.false./
      data abort/0/

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0.or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C

#include <f77/open.h>

C**********************************************************************C
C     read command line parameters
C**********************************************************************C

      call cmdln ( ntap, otap, ntr, dmin, dmax, pass, reverse, split, 
     :     offfar, dx, ngrpi, model, nopad, verbos, bin, interp, dead, 
     :     neg, hdrwrd, fix )

C**********************************************************************C
C     get logical data units, get header values, update line header
C**********************************************************************C

      call getln( luin, ntap, 'r', 0)
      call getln( luout, otap, 'w', 1)

C**********************************************************************C
C     initial dynamic allocation of ITR to allow for line header 
c     interaction
C**********************************************************************C

      itr_size = SZLNHD * SZSMPD
      errcd1 = 0
      call galloc ( mem_itr, itr_size, errcd1, abort )
      if (errcd1 .ne. 0) then
         write(LERR,*) 'ERROR: Unable to allocate workspace '
         write(LERR,*) '       ',itr_size,' bytes requested '
         write(LERR,*) 'FATAL'
         write(LER,*) ' '
         write(LER,*) 'DISORT:'
         write(LER,*) ' Unable to allocate workspace '
         write(LER,*) '  ',itr_size,' bytes requested '
         write(LER,*) 'FATAL'
         write(LER,*) ' '
         goto 999
      else
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itr_size,' bytes requested '
      endif

      call vclr ( itr, 1, SZLNHD )

C**********************************************************************C
C     read input line header
C**********************************************************************C

      CALL RTAPE ( LUIN, ITR, LBYTES )
      if(lbytes .eq. 0) then
         write(LERR,*)'DISORT: no header read on unit ',luin
         write(LERR,*)'ntap =  ',ntap
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'DISORT:'
         write(LER,*)' no header read on unit ',luin
         write(LER,*)' ntap =  ',ntap
         write(LER,*)'FATAL'
         write(LER,*)' '
         goto 999
      endif

C**********************************************************************C
C     echo processing history to printout
C**********************************************************************C

      CALL HLHprt ( ITR , LBYTES, NAME, 6, LERR )

C**********************************************************************C
C     capture global parameters
C**********************************************************************C

      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

C**********************************************************************C
c     create pointers to trace header entries to be used in disort
C**********************************************************************C
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)

c-----------------------
c  model trace distances

      offx = offfar + dx

      IF ( model ) THEN

c in this case we are modeling the spread, the dmin and dmax as set
c here, the dx is required on the command line or you would not
c have gotten this far as policeman in cmdln[] would have already
c stopped the program.

         dmin =  99999.
         dmax = -99999.

C**********************************************************************C
C     allocate and initialize memory for xmod[], we need to make xmod_size
c     a little bigger than required so that ngrp2 gets calculated in the 
c     if logic below
C**********************************************************************C

         if ( split ) then
            xmod_size = nint ( offx / dx ) * 2 + 1
            ngrp2 = nint ( offx / dx )
         else
            xmod_size = nint ( offx / dx ) + 1
            ngrp2 = nint ( offx / dx )
         endif

         errcd2 = 0
         errcd3 = 0
         call galloc ( mem_xmod, xmod_size * SZSMPD, errcd2, abort )
         call galloc ( mem_iz, xmod_size * SZSMPD, errcd3, abort )

         if (errcd2 .ne. 0 .or. 
     :       errcd3 .ne. 0 ) then
            write(LERR,*) 'ERROR: Unable to allocate workspace '
            write(LERR,*) '  ',2*xmod_size*SZSMPD,' bytes requested '
            write(LERR,*) 'FATAL'
            write(LER,*) ' '
            write(LER,*) 'DISORT:'
            write(LER,*) ' Unable to allocate workspace '
            write(LER,*) '  ',2*xmod_size*SZSMPD,' bytes requested '
            write(LER,*) 'FATAL'
            write(LER,*) ' '
            goto 999
         else
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 2*xmod_size*SZSMPD,' bytes '
         endif

         call vclr ( xmod, 1, xmod_size )
         call vclr ( iz, 1, xmod_size )


         x = 0.
         if ( split ) then
            do j = 1, ngrp2
               x = x + dx
               xmod( ngrp2+1 + j ) = +x
               xmod( ngrp2+1 - j ) = -x
            enddo
            xmod( ngrp2+1 ) = 0.
            ngrp = 2 * ngrp2 + 1
         else
            do j = 1, ngrp2
               x = x + dx
               xmod (j+1) = x
            enddo
            xmod( 1 ) = 0.
            ngrp = ngrp2 + 1
         endif

         if ( .not. split .and. neg ) then
            call vsmul (xmod, 1, -1., xmod, 1, ngrp)
         endif

         call rsort (xmod , iz, ngrp)

         if ( xmod(1) .le. xmod(2) ) then
             back = .false.
         else
             back = .true.
         endif

         write(LERR,*)'Model group interval= ',dx,
     1        '  Number grps= ',ngrp
         do  92 j = 1, ngrp
            write(LERR,*)'Trace ',j,'  model distance= ',xmod(j)
 92      continue
         write(LERR,*)' '
          
         dx = abs (dx)

         if (nopad) then
            ntr = ntrc
         else
            ntr = ngrp
         endif

         ntrco = ntr

      ELSE

         ngrp = ntrc

         if(nopad) then
            if(ntr .le. 0) ntr = ntrc
         else
            ntr = ntrc
         endif

         if (dead) ntr = ntrc
         ntrco = ntrc

      ENDIF

C**********************************************************************C
c update output line header with modified entries for number of traces
c per record and number of samples per trace
C**********************************************************************C

      call savew( itr, 'NumTrc', ntr   , LINHED)
      call savew( itr, 'NumSmp', nsamp , LINHED)

C**********************************************************************C
c update historical line header with current command line
C**********************************************************************C

      call savhlh( itr, lbytes, lbyout)

C**********************************************************************C
c write output line header
C**********************************************************************C

      call wrtape(luout,itr,lbyout)

C**********************************************************************C
C     print out key header values to printout file
C**********************************************************************C

      write(LERR,*)
      write(LERR,*)' Values read from input data set line header'
      write(LERR,*)
      write(LERR,*) ' # of Samples/Trace =  ', nsamp
      write(LERR,*) ' Sample Interval    =  ', nsi  
      write(LERR,*) ' Traces per Record  =  ', ntrc 
      write(LERR,*) ' Output traces/rec  =  ', ntr
      write(LERR,*) ' Records per Line   =  ', nrec 
      write(LERR,*) ' Format of Data     =  ', iform
      write(LERR,*) ' Minimum distance   =  ', dmin
      write(LERR,*) ' Maximum distance   =  ', dmax
      write(LERR,*) ' Doing sorting on hdr word = ',hdrwrd
      
      if(pass)write(LERR,*)' Pass  dmin < dist < dmax'
      if(dead)write(LERR,*)' Rejected dists are marked as dead'
      if(.not.pass)write(LERR,*)' Reject  dmin < dist < dmax'
      if(reverse) then
         write(LERR,*)' Reverse distance order'
      else
         write(LERR,*)' Ascending distance order'
      endif
      if(nopad) then
         write(LERR,*)' Do Not Pad Output Records With Null Traces'
      else
         write(LERR,*)' Pad Output Records With Null Traces'
      endif
      if(model) then
         write(LERR,*)'Will model trace distances and output traces'
         write(LERR,*)'in their proper distance slots'
         write(LERR,*)'Far offset will be ',offfar
         write(LERR,*)'Groups interval will be ', dx
         if (fix) then
            write(LERR,*)'Regridding done to nearest integer'
         else
            write(LERR,*)'Regridding done to integer granularity'
         endif
         if (split) then
            write(LERR,*)'Split Spread assumed'
         else
            write(LERR,*)'Single Ender Spread assumed'
            if (neg)
     1           write(LERR,*)'single ender has negative distances'
         endif
      endif

C**********************************************************************C
C     dynamic memory allocation
C**********************************************************************C

      itr_size = ITRWRD + nsamp
      errcd1 = 0
      call grealloc ( mem_itr, itr_size * SZSMPD, errcd1, abort )

      if (errcd1 .ne. 0) then
         write(LERR,*) 'ERROR: Unable to allocate workspace '
         write(LERR,*) '       ',itr_size,' bytes requested '
         write(LERR,*) '       FATAL'
         write(LER,*) 'DISORT: '
         write(LER,*) ' Unable to allocate workspace '
         write(LER,*) ' ',itr_size,' bytes requested '
         write(LER,*) 'FATAL'
         goto 999
      else
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itr_size,' bytes'
      endif

      call move (0, itr, 0, itr_size*SZSMPD )

      errcd1 = 0
      call galloc ( mem_itr0, itr_size * SZSMPD, errcd1, abort )

      if (errcd1 .ne. 0) then
         write(LERR,*) 'ERROR: Unable to allocate workspace '
         write(LERR,*) '       ',itr_size,' bytes requested '
         write(LERR,*) '       FATAL'
         write(LER,*) 'DISORT: '
         write(LER,*) ' Unable to allocate workspace '
         write(LER,*) ' ',itr_size,' bytes requested '
         write(LER,*) 'FATAL'
         goto 999
      else
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itr_size,' bytes'
      endif

      call move (0, itr0, 0, itr_size*SZSMPD )

      ntrm = max (ntrc, ngrp)
      
      if (model) then
         array_size = ntrm * nsamp
         errcd4 = 0
         call galloc (mem_array, array_size*SZSMPD, errcd4, abort)
         if (errcd4 .ne. 0) then
            write(LERR,*) 'ERROR: Unable to allocate workspace '
            write(LERR,*) '       ',array_size,' bytes requested '
            write(LERR,*) '       FATAL'
            write(LER,*) 'DISORT: '
            write(LER,*) ' Unable to allocate workspace '
            write(LER,*) ' ',array_size,' bytes requested '
            write(LER,*) 'FATAL'
            goto 999
         else
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) array_size,' bytes'
         endif

         call vclr ( array, 1, array_size )

c hmmm  better do a lot of checking about the size of this array, the old code
c is fairly vague.  Seems to allocate more than enough but I am not sure about
c the dependancy on interp

c         if (interp) call vclr (array, 1, ntrm*nsamp)

      endif

      itrce_size = ntrm * (ITRWRD + nsamp)
      errcd5 = 0
      errcd6 = 0
      call galloc (mem_itrce, itrce_size*SZSMPD, errcd5, abort)
      call galloc (mem_idead, itrce_size*SZSMPD, errcd6, abort)

      if ( errcd5 .ne. 0 .or. 
     :     errcd6 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itrce_size*SZSMPD,'  bytes'
         write(LERR,*) itrce_size*SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)'DISORT:'
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*) itrce_size*SZSMPD,'  bytes'
         write(LER,*) itrce_size*SZSMPD,'  bytes'
         write(LER,*)'FATAL'
         goto 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itrce_size*SZSMPD,'  bytes'
         write(LERR,*) itrce_size*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

      isize = ntrc
      errcd7 = 0
      errcd8 = 0
      errcd9 = 0
      errcd10 = 0
      errcd11 = 0
      errcd12 = 0
      errcd13 = 0
      errcd14 = 0
      call galloc ( mem_idist, isize * SZSMPD, errcd7, abort )
      call galloc ( mem_isht, isize * SZSMPD, errcd8, abort )
      call galloc ( mem_igrp, isize * SZSMPD, errcd9, abort )
      call galloc ( mem_idi, isize * SZSMPD, errcd10, abort )
      call galloc ( mem_ili, isize * SZSMPD, errcd11, abort )
      call galloc ( mem_jndx, isize * SZSMPD, errcd12, abort )
      call galloc ( mem_jdist, ntrm * SZSMPD, errcd13, abort )
      call galloc ( mem_iwork1, isize * SZSMPD, errcd14, abort )
      call galloc ( mem_iwork2, isize * SZSMPD, errcd15, abort )
      call galloc ( mem_iwork3, isize * SZSMPD, errcd22, abort )

      if ( errcd7 .ne. 0 .or. 
     :     errcd8 .ne. 0 .or. 
     :     errcd9 .ne. 0 .or. 
     :     errcd10 .ne. 0 .or. 
     :     errcd11 .ne. 0 .or. 
     :     errcd12 .ne. 0 .or. 
     :     errcd13 .ne. 0 .or. 
     :     errcd14 .ne. 0 .or. 
     :     errcd15 .ne. 0 .or. 
     :     errcd22 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 9 * isize * SZSMPD,'  bytes'
         write(LERR,*) ntrm * SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)'DISORT:'
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*) 9 * isize * SZSMPD,'  bytes'
         write(LER,*) ntrm * SZSMPD,'  bytes'
         write(LER,*)'FATAL'
         goto 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 9 * isize * SZSMPD,'  bytes'
         write(LERR,*) ntrm * SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

      call move ( 0, idist, 0, isize*SZSMPD )
      call move ( 0, isht, 0, isize*SZSMPD )
      call move ( 0, igrp, 0, isize*SZSMPD )
      call move ( 0, idi, 0, isize*SZSMPD )
      call move ( 0, ili, 0, isize*SZSMPD )
      call move ( 0, jndx, 0, isize*SZSMPD )
      call move ( 0, iwork1, 0, isize*SZSMPD )
      call move ( 0, iwork2, 0, isize*SZSMPD )
      call move ( 0, iwork3, 0, isize*SZSMPD )
      call move ( 0, jdist, 0, ntrm*SZSMPD )

      errcd16 = 0
      errcd17 = 0
      call galloc ( mem_work1, nsamp*SZSMPD, errcd16, abort )
      call galloc ( mem_work2, nsamp*SZSMPD, errcd17, abort )
      
      if ( errcd16 .ne. 0 .or. 
     :     errcd17 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2 * nsamp * SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)'DISORT:'
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*) 2 * nsamp * SZSMPD,'  bytes'
         write(LER,*)'FATAL'
         goto 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2 * nsamp * SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

      call move ( 0, work1, 0, nsamp*SZSMPD )
      call move ( 0, work2, 0, nsamp*SZSMPD )

      errcd18 = 0
      errcd19 = 0
      errcd20 = 0
      errcd21 = 0
      call galloc ( mem_tabl1, ntr*SZSMPD, errcd18, abort )
      call galloc ( mem_tabl2, ntr*SZSMPD, errcd19, abort )
      call galloc ( mem_zz, 4*ntr*SZSMPD, errcd20, abort )
      call galloc ( mem_ipos, ntr*SZSMPD, errcd21, abort )
      
      if ( errcd18 .ne. 0 .or. 
     :     errcd19 .ne. 0 .or. 
     :     errcd20 .ne. 0 .or. 
     :     errcd21 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 7 * ntr * SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)'DISORT:'
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*) 7 * ntr * SZSMPD,'  bytes'
         write(LER,*)'FATAL'
         goto 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 7 * ntr * SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

      call move ( 0, tabl1, 0, ntr*SZSMPD )
      call move ( 0, tabl2, 0, ntr*SZSMPD )
      call move ( 0, zz, 0, 4*ntr*SZSMPD )
      call move ( 0, ipos, 0, ntr*SZSMPD )

C**********************************************************************C
C
C     read record, sort on distances, limit distances, then output
C
C**********************************************************************C
 
      trhead_plus_tr_size = ITRWRD + nsamp

C**********************************************************************C
c unlike vclr(), move() expects the itrce_size entry to be in bytes, 
c not words.

      itrce_size_bytes = itrce_size * SZSMPD
C**********************************************************************C

      DO 100 JJ = 1, NREC

         il = 0
         id = 0
         iflag = 1

         call move (0, idead, 0, itrce_size_bytes)
         call move (0, itrce, 0, itrce_size_bytes)

         DO 99 KK = 1, NTRC

            nbytes=0
            CALL RTAPE  ( LUIN , itr, NBYTES )
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input:'
               write(LERR,*)'rec= ',jj,' trace= ',kk
               go to 999
            endif

            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           StaCor , TRACEHEADER)

            IF ( StaCor .eq. 30000) THEN

C**********************************************************************C
c  put dead trcs into array idead[], headers and all
C**********************************************************************C

               call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              32767, TRACEHEADER)
               id = id + 1
               istrc = (id-1) * trhead_plus_tr_size
               do i = 1, trhead_plus_tr_size
                  idead(istrc+i) = itr(i)
               enddo

            ELSE

C**********************************************************************C
c  put live traces into array itrce[], headers and all
C**********************************************************************C

               il = il + 1

               call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1              irec, TRACEHEADER)
               call saver2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1              idist(il), TRACEHEADER)
               call saver2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1              isht(il), TRACEHEADER)
               call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1              igrp(il), TRACEHEADER)
               call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1              idi (il), TRACEHEADER)
               call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1              ili (il), TRACEHEADER)

               istrc = (il - 1) * trhead_plus_tr_size

               do i = 1, trhead_plus_tr_size
                  itrce(istrc+i) = itr(i)
               enddo

            ENDIF


C**********************************************************************C
c  put distances into array and store original trace indices into array
c  & store static values in original order
c  because we put 32767 in the distance word of dead traces they end
c  up on the right side of the spread
C**********************************************************************C

            jndx(kk)  = kk
 
 99      CONTINUE

         nlive = il
         ndead = id

         if (nlive+ndead .ne. ntrc) then
            write(LERR,*)'Number live traces + dead traces= ',
     1           nlive+ndead
            write(LERR,*)'does not equal # traces/gather= ',ntrc
            write(LERR,*)'FATAL HEART ATTACK for disort at'
            write(LERR,*)'record ',jj,'  trace ',kk
            go to 999
         endif

C**********************************************************************C
c  sort live traces by dist
c  move dead traces into 
c  right side of array
C**********************************************************************C

         ic = 0
         do  64  j = il+1, ntrc

            ic = ic + 1
            istrc =  (j-1) * trhead_plus_tr_size
            idtrc = (ic-1) * trhead_plus_tr_size
            
            do  63  i = 1, trhead_plus_tr_size
               itrce(istrc+i) = idead(idtrc+i)
 63         continue
 64      continue


C**********************************************************************C
c sort on distances
c of live traces
C**********************************************************************C

         call sort ( isize, idist, jndx, iwork2, iwork3, nlive, back )

         call reorder ( isize, isht, jndx, iwork2, nlive )
         call reorder ( isize, igrp, jndx, iwork2, nlive )
         call reorder ( isize, idi , jndx, iwork2, nlive )
         call reorder ( isize, ili , jndx, iwork2, nlive )

C**********************************************************************C
c stuff sorted live trcs
c into temp storeage
C**********************************************************************C

         do  66  j = 1, nlive

            istrc = (jndx(j) - 1) * trhead_plus_tr_size
            ittrc =       (j - 1) * trhead_plus_tr_size

            do  65  i = 1, trhead_plus_tr_size
               idead(ittrc+i) = itrce(istrc+i)
 65         continue

 66      continue

C**********************************************************************C
c copy sorted live traces
c back into primary store
C**********************************************************************C

         do  j = 1, nlive

            istrc = (j - 1) * trhead_plus_tr_size

            do    i = 1, trhead_plus_tr_size
               itrce(istrc+i) = idead(istrc+i)
            enddo
         enddo


C**********************************************************************C
c put traces into proper
c locations in gather
C**********************************************************************C

         IF (model) THEN

C**********************************************************************C
c            take care of duplicate
c            trc dists (result maybe
c            of too coarse binning
c            before?)
C**********************************************************************C

            call dupdst ( nlive, nsamp, ntrc, ntr, itrce_size, idist, 
     1           itrce, idead, trhead_plus_tr_size, work1, work2, 
     :           iwork1 )

            call arrange ( nlive, ndead, ntrc, ngrp, itrce_size, idist,
     1           dx, xmod_size, xmod,itrce, idead, model, isht, igrp, 
     2           idi, ili, split, ifmt_StaCor,l_StaCor, ln_StaCor, 
     3           ntrm, ntr, ifmt_hdrwrd, l_hdrwrd, ln_hdrwrd, nopad,
     4           ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc, fix,
     5           ifmt_RecInd,l_RecInd, ln_RecInd,
     6           ifmt_DphInd,l_DphInd, ln_DphInd,
     6           ifmt_LinInd,l_LinInd, ln_LinInd,
     7           ifmt_RecNum,l_RecNum, ln_RecNum,
     8           itr_size, itr, trhead_plus_tr_size, irec, jdist,interp)

C**********************************************************************C
c bin & interpolate rearranged
c traces onto model distances
C**********************************************************************C

            if (interp)
     :           call binner ( nlive, nsamp, ntrc, ngrp, 
     :           itrce_size, idist, xmod, itrce, idead, tabl1, 
     :           tabl2, zz, iz, array, iflag, verbos, ntrm, ntr,
     :           work1, work2, jdist, dx, JJ, trhead_plus_tr_size, irec, 
     :           itr_size, itr, xmod_size, ipos )

         ELSE
 
            do  j = 1, nlive
 
               istrc = (j - 1) * trhead_plus_tr_size
 
               do    i = 1, trhead_plus_tr_size
                  idead(istrc+i) = itrce(istrc+i)
               enddo
            enddo


         ENDIF

         ic = 0

         DO 199 KK = 1, ntrco

C**********************************************************************C
c  put traces into output vector in ascending distance order
c  and output within range of distances
C**********************************************************************C

            jt = kk
            if ( reverse ) jt = ntrc-kk+1
            dis = idist(jt)

            IF ( pass ) then

               if ( dead ) then

                  if ( dis .ge. dmin .and. dis .le. dmax ) then
    
                     ic = ic + 1

                     if (ic .gt. ntr) go to 100

                     istrc = (jt-1) * trhead_plus_tr_size

                     do  i=1,trhead_plus_tr_size
                        itr(i) = idead(istrc+i)
                     enddo

                     if(verbos) then
                        call saver2(itr,ifmt_DstSgn,l_DstSgn, 
     1                       ln_DstSgn, DstSgn, TRACEHEADER)
                        call saver2(itr,ifmt_TrcNum,l_TrcNum, 
     1                       ln_TrcNum, TrcNum, TRACEHEADER)
                        write(LERR,*)'writing trace ',TrcNum,
     &                       ' record ',irec,
     &                       ' dist= ',DstSgn
                     endif
 
                     itr (ITHWP1) = 0
                     call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irr  , TRACEHEADER)
                     if (irr .eq. 0) then
                        call savew2(itr,ifmt_RecNum,l_RecNum, 
     1                       ln_RecNum,irec , TRACEHEADER)
                        call savew2(itr,ifmt_StaCor,l_StaCor, 
     1                       ln_StaCor,30000, TRACEHEADER)
                     endif
                     call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    ic, TRACEHEADER)
                     call wrtape(luout,itr,nbytes)

                  else

                     ic = ic + 1

                     if (ic .gt. ntr) go to 100

                     istrc = (jt-1) * trhead_plus_tr_size

                     do  i=1,trhead_plus_tr_size
                        itr(i) = idead(istrc+i)
                     enddo

                     call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irr  , TRACEHEADER)
                     if (irr .eq. 0) then
                        call savew2(itr,ifmt_RecNum,l_RecNum,
     1                       ln_RecNum, irec , TRACEHEADER)
                     endif
                     call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    ic , TRACEHEADER)
                     call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    30000 , TRACEHEADER)
                     call wrtape(luout,itr,nbytes)

                  endif

               else


                  if ( dis .ge. dmin .and. dis .le. dmax ) then
     
                     ic = ic + 1          
                     if (ic .gt. ntr) go to 100
                     istrc = (jt-1) * trhead_plus_tr_size
                     do  i=1,trhead_plus_tr_size
                        itr(i) = idead(istrc+i)
                     enddo
                     if(verbos) then
                        call saver2(itr,ifmt_DstSgn,l_DstSgn, 
     1                       ln_DstSgn, DstSgn , TRACEHEADER)
                        write(LERR,*)'writing trace ',itr(l_TrcNum),
     &                       ' record ',irec,
     &                       ' dist= ',DstSgn
                     endif
                     
                     itr (ITHWP1) = 0
                     call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irr  , TRACEHEADER)
                     if (irr .eq. 0) then
                        call savew2(itr,ifmt_RecNum,l_RecNum, 
     1                       ln_RecNum, irec , TRACEHEADER)
                        call savew2(itr,ifmt_StaCor,l_StaCor, 
     1                       ln_StaCor, 30000, TRACEHEADER)
                     endif
                     call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    ic, TRACEHEADER)
                     call wrtape(luout,itr,nbytes)
                  endif

               endif

            ELSEIF( .not. pass) then

               if ( dead ) then

                  if(dis .le. dmin .or. dis .ge. dmax) then
 
                     ic = ic + 1
                     if (ic .gt. ntr) go to 100
                     istrc = (jt-1) * trhead_plus_tr_size
                     do  i=1,trhead_plus_tr_size
                        itr(i) = idead(istrc+i)
                     enddo
                     if(verbos) then
                        call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     1                       DstSgn , TRACEHEADER)
                        call saver2(itr,ifmt_TrcNum,l_TrcNum, 
     1                       ln_TrcNum, TrcNum, TRACEHEADER)
                        call saver2(itr,ifmt_RecNum,l_RecNum, 
     1                       ln_RecNum, RecNum, TRACEHEADER)
                        write(LERR,*)'writing trace ',TrcNum,
     &                       ' record ',RecNum,
     &                       ' dist= ',DstSgn
                     endif
 
C**********************************************************************C
c interesting, I wonder why we set the first value of the output time
c series to be zero here
C**********************************************************************C

                     itr (ITHWP1) = 0

                     call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irr  , TRACEHEADER)
                     if (irr .eq. 0) then
                        call savew2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,
     1                       irec , TRACEHEADER)
                        call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,
     1                       30000, TRACEHEADER)
                     endif
                     call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    ic        , TRACEHEADER)
                     call wrtape(luout,itr,nbytes)

                  else

                     ic = ic + 1

                     if (ic .gt. ntr) go to 100

                     istrc = (jt-1) * trhead_plus_tr_size

                     do  i=1,trhead_plus_tr_size
                        itr(i) = idead(istrc+i)
                     enddo

                     call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irr  , TRACEHEADER)
                     if (irr .eq. 0) then
                        call savew2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,
     1                       irec , TRACEHEADER)
                     endif
                     call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    ic        , TRACEHEADER)
                     call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    30000 , TRACEHEADER)
                     call wrtape(luout,itr,nbytes)
                  endif
                  
               else
                  
                  if(dis .le. dmin .or. dis .ge. dmax) then
                     
                     ic = ic + 1          

                     if (ic .gt. ntr) go to 100

                     istrc = (jt-1) * trhead_plus_tr_size

                     do  i=1,trhead_plus_tr_size
                        itr(i) = idead(istrc+i)
                     enddo

                     if(verbos) then
                        call saver2(itr,ifmt_DstSgn,l_DstSgn, 
     1                       ln_DstSgn, DstSgn , TRACEHEADER)
                        call saver2(itr,ifmt_TrcNum,l_TrcNum, 
     1                       ln_TrcNum, TrcNum, TRACEHEADER)
                        call saver2(itr,ifmt_RecNum,l_RecNum, 
     1                       ln_RecNum, RecNum, TRACEHEADER)
                        write(LERR,*)'writing trace ',TrcNum,
     &                       ' record ',RecNum,
     &                       ' dist= ',DstSgn
                     endif
                     
                     itr (ITHWP1) = 0
                     call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irr  , TRACEHEADER)
                     if (irr .eq. 0) then
                        call savew2(itr,ifmt_RecNum,l_RecNum, 
     1                       ln_RecNum, irec , TRACEHEADER)
                        call savew2(itr,ifmt_StaCor,l_StaCor, 
     1                       ln_StaCor, 30000, TRACEHEADER)
                     endif
                     call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    ic        , TRACEHEADER)
                     call wrtape(luout,itr,nbytes)
                  endif
                  
               endif
               
            ENDIF
            
 199     CONTINUE

         IF ( dead ) go to 100

         if( nopad ) then

            if(ic .ne. ntr) then

               write(LERR,*)'WARNNG from disort rec ',irec,':'
               write(LERR,*)'Wrong number of traces/rec on command line'
               write(LERR,*)'Actual number output is  ',ic,ntr
               write(LERR,*)'Padding record out to ',ntr,' traces'

               do 71  ip = ic+1, ntr
                  jt = ip
                  if(reverse) jt = ntr-ip+1
                  call savew2(itr0,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                 irec      , TRACEHEADER)
                  call savew2(itr0,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                 ip        , TRACEHEADER)
                  call savew2(itr0,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                 iabs(idist(jt)), TRACEHEADER)
                  if (interp) then
                     call savew2(itr0,ifmt_DstSgn,l_DstSgn,
     1                    ln_DstSgn,jdist(jt) , TRACEHEADER)
                  else
                     call savew2(itr0,ifmt_DstSgn,l_DstSgn,
     1                    ln_DstSgn,idist(jt) , TRACEHEADER)
                  endif
                  call savew2(itr0,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                 30000     , TRACEHEADER)
                  
                  itr0 (ITHWP1) = 0
                  call wrtape(luout,itr0,nbytes)
 71            continue
            endif

         else

            do 69  ip = ic+1, ntrc

               jt = ip
               if(reverse) jt = ntrc-ip+1
               call savew2(itr0,ifmt_RecNum,l_RecNum, ln_RecNum,
     1              irec      , TRACEHEADER)
               call savew2(itr0,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1              ip        , TRACEHEADER)
               call savew2(itr0,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1              iabs(idist(jt)), TRACEHEADER)
               if (interp) then
                  call savew2(itr0,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                 jdist(jt) , TRACEHEADER)
               else
                  call savew2(itr0,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                 idist(jt) , TRACEHEADER)
               endif
               call savew2(itr0,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              30000     , TRACEHEADER)
               
C**********************************************************************C
c here we are again, setting the first value of the output dead trace
c time series to be zero, I wonder why, also in the original code this
c array was and I*2 array so only 2 bytes would be set to zero instead 
c of the 4 bytes now being set.  Better take a close look at the output
c and make sure there is nothing funky going on at the first sample.
C**********************************************************************C

               itr0 (ITHWP1) = 0
               call wrtape(luout,itr0,nbytes)
 69         continue
         endif

 100  CONTINUE

      write(LERR,*)'Normal Termination '
      write(LER,*)'disort: Normal Termination'

      call lbclos(luin)
      call lbclos(luout)

      stop

 999  continue

      write(LERR,*)'Abnormal Termination '
      write(LER,*)'disort: Abnormal Termination'

      call lbclos(luin)
      call lbclos(luout)

      stop
      END

C**********************************************************************C
c start of subroutines
C**********************************************************************C


      subroutine sort( isize, ix, key, iy, ley, no, back )

C**********************************************************************C
c     This provides a sort of items
c     x(i) is the array to be sorted
c     key(i) is the pointer array
c     no is the number of points to be sorted
c     After the sort x(i) will be ordered from least to
c           greatest
c     key(1) will point to the position in the original array
c     with the least value
C**********************************************************************C

      implicit none

c declare variables passed from calling routine

      integer no, isize
      integer ix(isize), key(isize), iy(isize), ley(isize)

      logical   back

c declare local variables

      integer i, mo, ko, jo, j

      real temp, kemp


      do 1 i=1,no
    1 key(i)=i
      mo=no
    2 if(mo-15)21,21,23
   21 if(mo-1)29,29,22
   22 mo=2*(mo/4)+1
      goto 24
   23 mo=2*(mo/8)+1
   24 ko=no-mo
      jo=1
   25 i=jo
   26 if(ix(i)-ix(i+mo))28,28,27
   27 temp=ix(i)
      ix(i)=ix(i+mo)
      ix(i+mo)=temp
      kemp=key(i)
      key(i)=key(i+mo)
      key(i+mo)=kemp
      i=i-mo
      if(i-1)28,26,26
   28 jo=jo+1
      if(jo-ko)25,25,2
   29 continue

      if (back) then
         do 100 j = 1, no
            iy (no-j+1) = ix(j)
            ley(no-j+1) = key(j)
100      continue
         do 101 j = 1, no
            ix(j) = iy(j)
            key(j) = ley(j)
101      continue
         return
      else
         return
      endif

      end

C**********************************************************************C
c  online help
C**********************************************************************C

      subroutine help
#include <f77/iounit.h>

      
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for DISORT: sort traces'
        write(LER,*)'       record-by-record according to distances'
        write(LER,*)'       bin trace distances, or sort each record'
        write(LER,*)'       according to specified header word'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-hw[hdrwrd]-- key trace header word (DstSgn)'
        write(LER,*)'              Must be distance if binning option'
        write(LER,*)'-ntr[ntr]  -- output traces/rec if dmin or dmax is'
        write(LER,*)'              given on command line'
        write(LER,*)'-dmax[dmax]-- maximum distance'
        write(LER,*)'-dmin[dmin]-- minimum distance'
        write(LER,*)' '
        write(LER,*)'-xn[offfar]-- gather spread model far offset'
        write(LER,*)'-xd[dx]    -- gather spread model group interval'
        write(LER,*)'-M         -- model spread & put dead traces in'
        write(LER,*)'-neg       -- input dists are all neg (single end)'
        write(LER,*)'              proper horizontal positions'
        write(LER,*)'-fix       -- regridding based on integer else,'
        write(LER,*)'              regridding based on nearest integer'
        write(LER,*)'-S         -- split spread, else single ender'
        write(LER,*)'-I         -- interpolate trcs onto model offsets'
        write(LER,*)'              (after first putting dead trcs in'
        write(LER,*)'              correct horizontal location)'
        write(LER,*)' '
        write(LER,*)'-P         -- if present, pass dists between dmin'
        write(LER,*)'              dmax, else reject betw dmin-dmax'
        write(LER,*)'-D         -- rejected dists are marked dead but'
        write(LER,*)'              kept in the output record'
        write(LER,*)'-R         -- distances are descending order'
        write(LER,*)'-F         -- dead traces put on positive end of'
        write(LER,*)'              spread; otherwise on neg end'
        write(LER,*)'-X         -- do not pad output recs with null trac
     1es'
        write(LER,*)'              Bin option: do not expand to model sp
     1read'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' disort -N[] -O[] [ [ -I -M -S -neg -fix  ]'
        write(LER,*)'        -R -D -P -F -X -V] -dmax[] -dmin[]'
        write(LER,*)'        -ntr[] -xd[] -xn[] -hw[]'
        write(LER,*)' '
      return
      end

C**********************************************************************C
C command line subroutine
C**********************************************************************C

      subroutine cmdln( ntap, otap, ntr, dmin, dmax, pass, reverse, 
     :     split, offfar, dx, ndx, model, nopad, verbos, bin, interp, 
     :     dead, neg, hdrwrd, fix )

C**********************************************************************C
c     get command arguments
c
c     ntap  - C*256  input file name
c     otap  - C*256  output file name
c     ntr   - I      output traces/rec
c    dmin   - R      min distance to stack
c    dmax   - R      max distance to stack
c  offfar   - R      near offset for spread model
c     dx    - R      group interval
c    ndx    - I      Number groups
c    pass   - L      pass range of distances
c   nopad   - L      do not pad output records
c   split   - L      split spread
c   model   - L      model spread
c   reverse - L      reverse order of distances
c    verbos - L      verbose output or not
C**********************************************************************C
      
      implicit none

#include <f77/iounit.h>

c declare variables passed by calling routine

      integer    ntr, ndx

      real       dmin, dmax, offfar, dx

      character  ntap*(*), otap*(*), hdrwrd*6

      logical    pass, reverse, split, model, nopad, verbos
      logical    bin, interp, dead, neg, fix

c declare local variables

      integer argis

c parse command line

      bin     = ( argis('-B') .gt. 0)

      call argr4 ('-dmax',dmax, 99999., 99999.)
      call argr4 ('-dmin',dmin,-99999.,-99999.)
      dead    = ( argis('-D') .gt. 0)

      call argi4('-gn',ndx,0,0)

      call argstr ('-hw',hdrwrd,'DstSgn','DstSgn') 

      interp  = ( argis('-I') .gt. 0)
      
      model   = ( argis('-M') .gt. 0)

      fix     = ( argis('-fix') .gt. 0)
      neg     = ( argis('-neg') .gt. 0)
      call argi4('-ntr',ntr,0,0)
      call argstr('-N',ntap,' ',' ')
 
      call argstr('-O',otap,' ',' ') 

      pass    = ( argis('-P') .gt. 0)

      reverse = ( argis('-R') .gt. 0)

      split   = ( argis('-S') .gt. 0)

      call argr4('-xd',dx,0.,0.)
      call argr4('-xn',offfar,0.,0.)

      verbos  = ( argis('-V') .gt. 0)

      nopad   = ( argis('-X') .gt. 0)

c policemen

      if ( interp .and. .not. model ) model = .true.

      if ( dx .eq. 0. .and. model ) then
         write(LERR,*)'Must include group interval for model'
         write(LERR,*)'spead and/or interp options.'
         write(LERR,*)'Include'
         write(LERR,*)'            -M [ -I ] -xn[] -xd[]'
         write(LERR,*)'on cms line & rerun'
         write(LER,*)' '
         write(LER,*)'DISORT:'
         write(LER,*)' Must include group interval for model'
         write(LER,*)' spead and/or interp options.'
         write(LER,*)' Include'
         write(LER,*)'            -M [ -I ] -xn[] -xd[]'
         write(LER,*)' on cms line & rerun'
         write(LER,*)'FATAL'
         stop
      endif

      if (dx .eq. 0. .and. interp) then
         write(LERR,*)'Must include group interval for interp'
         write(LERR,*)'Include'
         write(LERR,*)'            -M -I -xn[] -xd[]'
         write(LERR,*)'on cms line & rerun'
         write(LER,*)' '
         write(LER,*)'DISORT:'
         write(LER,*)' Must include group interval for interp'
         write(LER,*)' Include'
         write(LER,*)'            -M -I -xn[] -xd[]'
         write(LER,*)' on cms line & rerun'
         write(LER,*)'FATAL'
         stop
      endif

      if ( model ) then
         dmin = -99999.
         dmax = +99999.
      endif
         
      if ( dmax .eq. 99999. .and. 
     :     dmin .eq. -99999.) then
         ntr = -1
         if(.not. pass) then
            dmin =  99999.
            dmax = -99999.
         endif
      endif

      if ( dmax .ne. 99999. .or. 
     :     dmin .ne. -99999.) then
         if ( ntr .eq. 0 .AND. .not. dead ) then
            write(LERR,*)'For range limiting, output traces/rec must
     1 be given'
            write(LERR,*)'Put this value on command line; rerun'
            write(LER,*)' '
            write(LER,*)'DISORT:'
            write(LERR,*)' For range limiting, output traces/rec must
     1 be given'
            write(LERR,*)' Put this value on command line; rerun'
            write(LER,*)'FATAL'
            stop
         endif
      endif
         
      return
      end

C**********************************************************************C
c reorder subroutine
C**********************************************************************C

      subroutine reorder ( isize, inout, jndx, iwork2, nlive )

      implicit none

c declare variables passed from calling routine

      integer isize, nlive

      integer inout(isize), jndx(isize), iwork2(isize)

c declare local variables

      integer i

      do  i = 1, nlive
         iwork2(i) = inout( jndx(i) )
      enddo

      do i = 1, nlive
         inout(i) = iwork2(i)
      enddo

      return
      end
