C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  scale
C
C**********************************************************************C
C
C SCALE READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C applies a single scale factor to the data & writes the results to otap
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes
      integer     argis
      REAL        xtr(SZSMPM),xtrace(SZSMPM)
      CHARACTER   NAME * 5, ntap * 256, otap * 256
#include <f77/pid.h>
      logical     verbos,query,lessth,npp
 
c     EQUIVALENCE ( ITR(129), xtr (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'SCALE'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      data verbos/.false./, query/.false./, lessth/.false./

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?') .gt. 0)
      if( query ) then
            call help()
            stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,dist,amp,
     1           lessth,verbos,bias,beta,npp)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      lbytes = 0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
          write(LERR,*)'SCALE: no header read on dsn ',ntap
          write(LERR,*)'check existence of this file & rerun'
          stop
      endif
      CALL HLH    ( ITR , LBYTES, NAME, 4              )
#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-------------------------
c check input parameters
c-------------------------
      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      jtrc=ned-nst+1
      nrecc=nred-nrst+1
      ist=ist/nsi
      iend=iend/nsi
      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp
      nsampo=iend-ist+1

c----------------------------
c  adjust line header
c----------------------------
      obytes = SZTRHD + SZSMPD * nsampo
      call savhlh( itr, lbytes, lbyout)
      call wrtape(luout,itr,lbyout)

c------------------------------
c  printout program parameters
c------------------------------
c     if(verbos) then
         write(LERR,*)
         write(LERR,*)' Values read from input data set line header'
         write(LERR,*)
         write(LERR,*) ' # of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval    =  ', nsi  
         write(LERR,*) ' Traces per Record  =  ', ntrc 
         write(LERR,*) ' Records per Line   =  ', nrec
         write(LERR,*) ' Output records     =  ', nrecc
         write(LERR,*) ' Format of Data     =  ', iform
         write(LERR,*) ' Output # samples   =  ',nsampo
         write(LERR,*) ' Scale factor       =  ',amp
         write(LERR,*) ' Exponent           =  ',beta
         write(LERR,*) ' Bias               =  ',bias
         write(LERR,*) ' No Polarity Pres.  =  ',npp
         write(LERR,*) ' dist               =  ',dist
         write(LERR,*) ' Scale less than dist? ', lessth
         write(LERR,*) ' Number output bytes=  ',obytes
c     endif
 
 
C**********************************************************************C
C     READ TRACE, SCALE, WRITE OUTPUT
C**********************************************************************C
 
c-----------------------
c  skip records
c-----------------------
      call recskp(1,nrst-1,luin,ntrc,itr)

      DO 100  JJ = NRST, NRED

c------------------------
c  skip traces
c------------------------
            call trcskp(jj,1,nst-1,luin,ntrc,itr)

           DO 99 KK = NST, NED

               nbytes = 0
               CALL RTAPE  ( LUIN , ITR, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif
               call vmov (itr(ITHWP1), 1, xtr, 1, nsamp)
               call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istatic, TRACEHEADER)

              if(verbos) then
                 write(LERR,*)' Record=  ',jj,'  Trace=  ',kk
              endif

c---------------------------------
c  scale only if not a dead trace
c---------------------------------
              IF(istatic .ne. 30000) THEN
                    call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          idis   , TRACEHEADER)
                    xdist = idis
                    call vmov(xtr(ist),1,xtrace,1,nsampo)

c----------------------------
c scale traces less than DIST
c----------------------------
                    if(lessth) then
                        if(xdist .le. dist) then
c----------------------------
c no polarity preserved case
c----------------------------
                          if( npp ) then
                            do 800 ip = 1,nsampo
                              xtr(ip)=
     1                        ((xtrace(ip)**beta) * amp) + bias
800                         continue
                          else
c----------------------------
c polarity preserved case
c----------------------------
                            rone = 1.0
                            do 801 ip = 1,nsampo
                              val = abs(xtrace(ip))
                              xtr(ip)=
     1                        (((val**beta) * amp) + bias)
     1                        * sign(rone,xtrace(ip))
801                         continue
                          endif
                        endif
c
c--------------------------------
c scale traces greater than DIST
c--------------------------------
                    else
                        if(xdist .ge. dist) then
c----------------------------
c no polarity preserved case
c----------------------------
                          if( npp ) then
                            do 802 ip = 1,nsampo
                              xtr(ip)=
     1                        ((xtrace(ip)**beta) * amp) + bias
802                         continue
                          else
c----------------------------
c polarity preserved case
c----------------------------
                            rone = 1.0
                            do 803 ip = 1,nsampo
                              val = abs(xtrace(ip))
                              xtr(ip)=
     1                        (((val**beta) * amp) + bias)
     1                        * sign(rone,xtrace(ip))
803                         continue
                          endif
                        endif
                    endif

              ENDIF

c---------------
c  write output
c---------------
              call vmov  (xtr, 1, itr(ITHWP1), 1, nsampo)
              call wrtape(luout,itr,obytes)
   99      CONTINUE

c---------------------------------
c  skip to end of current record
c---------------------------------
           call trcskp(jj,ned+1,ntrc,luin,ntrc,itr)

  100 CONTINUE
  999 continue
       call lbclos(luin)
       call lbclos(luout)
      END

c--------------------------
c  online help section
c--------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for SCALE: scale data'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-amp[amp]  -- multiplying value'
        write(LER,*)'-exp[beta] -- exponent value'
        write(LER,*)'-bias[bias]-- scaling amplitude'
        write(LER,*)'-d[dist]   -- do scaling on part of spread (all)'
        write(LER,*)'-s[ist]    -- start time (ms)        (first samp)'
        write(LER,*)'-e[iend]   -- end time (ms)           (last samp)'
        write(LER,*)'-ns[nstr]  -- start trace number          (first)'
        write(LER,*)'-ne[netr]  -- end trace number             (last)'
        write(LER,*)'-rs[nrst]  -- start record                (first)'
        write(LER,*)'-re[nred]  -- end record                   (last)'
        write(LER,*)'-NPP       -- no polarity preserved'
        write(LER,*)'-L         -- do scaling for dists less than dist'
        write(LER,*)'              if not scale greater than dist'
        write(LER,*)'              (default is scale for all dists)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        scale -N[] -O[] -amp[] -s[] -e[] -ns[] '
        write(LER,*)'               -d[] -ne[] -rs[] -re[] -L -V'
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c     iend  - I      end sample
c      ns   - I      start trace
c      ne   - I      stop end trace
c      rs   - I      start record
c      re   - I      stop end record
c    dist   - R      key distance
c    amp    - R      scaling amplitude
c    lessth - L      do scaling on dists .le. dist
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,ist,iend,ns,ne,irs,ire,dist,amp,
     1                 lessth,verbos,bias,beta,npp)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    ist,iend,ns,ne,irs,ire, argis
      real       amp, dist
      logical    lessth, verbos, npp

           call argstr('-N',ntap,' ',' ') 
           call argstr('-O',otap,' ',' ') 
           call argr4('-amp',amp,1.,1.)
           call argr4('-bias',bias,0.,0.)
           call argr4('-exp',beta,1.,1.)
           call argr4('-d',dist,-9999999.,-9999999.)
           call argi4('-s',ist,1,1)
           call argi4('-e',iend,0,0)
           call argi4('-ns',ns,0,0)
           call argi4('-ne',ne,0,0)
           call argi4('-rs',irs,1,1)
           call argi4('-re',ire,0,0)
           npp = (argis('-NPP') .gt. 0)
           lessth = (argis('-L') .gt. 0)
           verbos = (argis('-V') .gt. 0)
      
      return
      end
