/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*ARGSUSED*/		/* this comment line is for Saber-C */
/*		This routine is for centering the action button
		at the bottom of the form. It usually gets called
		more than once since we are triggering on the 
		expose event, but then again, better safe than
		sorry.
*/
#include <stdio.h>
#include <eventnames.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include "dskutil_defs.h"
#include "dskutil_glob.h"

void c_label(parent,child,event)
Widget parent,child;
XEvent *event;		/* unused */
{
	Dimension width,button_width;
	int button_x,cur_offset;
	Boolean mode_not_selected();

	if (debug_mode >= 2) fprintf(stderr,"-> c_label <-\n");

        if (mode != 0) {

	if (debug_mode >= 2 ) fprintf(stderr,"get width of child = %d\n",child);

	XtVaGetValues(child,
			XmNwidth,		&width,
			XmNleftOffset,		&cur_offset,
			NULL);

	button_width = width;
	if (debug_mode >= 2 ) fprintf(stderr,"width of button = %d\n",width);

	XtVaGetValues(parent,
			XmNwidth,		&width,
			NULL);

	button_x = (int) (width - button_width) / 2;
	if (debug_mode >= 2) fprintf(stderr,"width of parent = %d\n",width);
	if (debug_mode >= 2) fprintf(stderr,"current offset = %d\n",cur_offset);
	if (debug_mode >= 2) fprintf(stderr,"computed x value = %d\n",button_x);
	if (cur_offset == button_x) return;

	XFlush(XtDisplay(child));

	XtVaSetValues(child,
			XmNleftOffset,		button_x,
			NULL);
	XtManageChild(child);
	}

}
