/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <localsys.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/SelectioB.h>
#include <Xm/FileSB.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>

#include "HelpObject.h"
#include "search_menu.h"
#include "dskutil_glob.h"

Widget *search_widget;

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void set_search_options(widget,client_data,call_data)
  Widget widget;
  XtPointer client_data,call_data;
{
  int i,j,num_search_items;
  void pop_the_dialog();
  void sort_list();

  if (debug_mode >= 2) fprintf(stderr,"-> set_search_options <-\n");
  num_search_items = sizeof(search_item) / sizeof(option_list_item);
  if (num_search_items > 10) {
	fprintf(stderr,"we got problems; num_search_items = %d\n",
  		num_search_items);
	exit(100);
	}

  *find_options = '\0';
 
  for (i=0; i<num_search_items; i++) {
    switch (search_item[i].value) {
      case 2:				/* files greater than %n bytes */
        search_item[i].text = (XtPointer ) XmTextGetString(search_widget[i]);
        if (strlen(search_item[i].text) != 0) {
	  for (j=0; j < (int) strlen(search_item[i].text); j++) {
	    if ( ! isdigit(*((char *)search_item[i].text+j))) {
		post_message(TRUE,widget,
			"Invalid lower size limit; Reenter",
			XmDIALOG_ERROR,
			TRUE,"OK",NULL,NULL,
			FALSE,NULL,NULL,NULL,
			FALSE,NULL,NULL,NULL);
			return;
	       }
	    }
	  strcat(find_options,"-size +");
	  strcat(find_options,search_item[i].text);
	  strcat(find_options,"c ");
	  }
	break;
      case 3:				/* files less than %n bytes */
        search_item[i].text = (XtPointer ) XmTextGetString(search_widget[i]);
        if (strlen(search_item[i].text) != 0) {
	  for (j=0; j < (int) strlen(search_item[i].text); j++) {
	    if ( ! isdigit(*((char *)search_item[i].text+j))) {
		post_message(TRUE,widget,
			"Invalid upper size limit; Reenter",
			XmDIALOG_ERROR,
			TRUE,"OK",NULL,NULL,
			FALSE,NULL,NULL,NULL,
			FALSE,NULL,NULL,NULL);
			return;
	       }
	    }
	  strcat(find_options,"-size -");
	  strcat(find_options,search_item[i].text);
	  strcat(find_options,"c ");
	  }
	break;
      case 4:				/* files older than %n days */
        search_item[i].text = (XtPointer ) XmTextGetString(search_widget[i]);
        if (strlen(search_item[i].text) != 0) {
	  for (j=0; j < (int) strlen(search_item[i].text); j++) {
	    if ( ! isdigit(*((char *)search_item[i].text+j))) {
		post_message(TRUE,widget,
			"Invalid lower age limit; Reenter",
			XmDIALOG_ERROR,
			TRUE,"OK",NULL,NULL,
			FALSE,NULL,NULL,NULL,
			FALSE,NULL,NULL,NULL);
			return;
	       }
	    }
	  strcat(find_options,"-xtime +");
	  strcat(find_options,search_item[i].text);
	  strcat(find_options," ");
	  }
	break;
      case 5:				/* files newer than %n days */
        search_item[i].text = (XtPointer ) XmTextGetString(search_widget[i]);
        if (strlen(search_item[i].text) != 0) {
	  for (j=0; j < (int) strlen(search_item[i].text); j++) {
	    if ( ! isdigit(*((char *)search_item[i].text+j))) {
		post_message(TRUE,widget,
			"Invalid upper age limit; Reenter",
			XmDIALOG_ERROR,
			TRUE,"OK",NULL,NULL,
			FALSE,NULL,NULL,NULL,
			FALSE,NULL,NULL,NULL);
			return;
	       }
	    }
	  strcat(find_options,"-xtime -");
	  strcat(find_options,search_item[i].text);
	  strcat(find_options," ");
	  }
	break;
      case 1:				/* search subdirectories ? */
        search_item[i].state = XmToggleButtonGetState(search_widget[i]);
	if ( !search_item[i].state ) 
	  strcat(find_options,"\\( -type f -o -type d -prune \\) ! -type d ");
	break;
      }
    }

  if ((Boolean) client_data) sort_list((Widget)widget,NULL,NULL);
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void cancel_search_options(widget,client_data,call_data)
  Widget widget;
  XtPointer client_data,call_data;
{
  int i,num_search_items;

  if (debug_mode >= 2) fprintf(stderr,"-> cancel_all_options <-\n");

  num_search_items = sizeof(search_item) / sizeof(option_list_item);

  for (i=1; i<num_search_items; i++)
    XmTextSetString(search_widget[i], search_item[i].text);
  
  XmToggleButtonSetState(search_widget[0],
	search_item[0].state,False);

  XtUnmanageChild((Widget) client_data);
  return;
}

Widget search_menu(popup)
     Widget popup;
{
	Widget dialog,option_form,label_widget;
	Widget search_rc;
	Widget dialog_heading,search_heading,subdir_heading;
	Widget option_heading;
	Widget separator;
	Widget button_form,ok,apply,set,cancel,help;
	Widget above_widget;
	int i;
	XmString item_label;
	XmString *labels;
	int num_search_items;
	void pop_the_dialog(),dismiss_dialog();
	void sort_list();
	void rev_button_label(),tree();

  if (debug_mode >= 2) fprintf(stderr,"-> display_menu <-\n");
	dialog = XmCreateFormDialog(popup,"Display_Shell",NULL,0);
	item_label = XmStringCreateLtoR("Display Options",
		XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(dialog,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		popup,
			XmNautoUnmanage,	FALSE,
			XmNdefaultPosition,	TRUE,
			XmNhorizontalSpacing,	10,
			XmNdialogTitle,		item_label,
			NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("Search Options",
		XmSTRING_DEFAULT_CHARSET);
	dialog_heading = XtVaCreateManagedWidget("search_heading",
		xmLabelWidgetClass,dialog,
			XmNlabelString,item_label,
			XmNrightAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
	XmStringFree(item_label);

	option_form = XtVaCreateManagedWidget("search_form",
		xmFormWidgetClass,dialog,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,dialog_heading,
			NULL);

	item_label = XmStringCreateLtoR("Find files:",
		XmSTRING_DEFAULT_CHARSET);
	option_heading = XtVaCreateManagedWidget("option_heading",
		xmLabelWidgetClass,option_form,
			XmNlabelString,item_label,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
	XmStringFree(item_label);
	above_widget = option_heading;

/*
	search_rc = XtVaCreateManagedWidget("searchrc",
		xmRowColumnWidgetClass,option_form,
			XmNpacking,XmPACK_TIGHT,
			XmNorientation,XmVERTICAL,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,option_heading,
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			XmNleftOffset,40,
			XmNrightAttachment,XmATTACH_FORM,
			XmNmarginWidth,0,
			NULL);
*/

	num_search_items = sizeof(search_item) / sizeof(option_list_item);
	search_widget = (Widget *) malloc(num_search_items * sizeof(Widget));
	for (i=1; i<num_search_items; i++) {
	  search_widget[i] = XtVaCreateManagedWidget(search_item[i].name,
		xmTextWidgetClass,option_form,
	  		XmNvalue,(char *)search_item[i].text,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 10,
			XmNleftAttachment, XmATTACH_NONE,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget,	above_widget,
			NULL);
	  item_label = XmStringCreateLtoR(search_item[i].label,
		XmSTRING_DEFAULT_CHARSET);
	  label_widget = XtVaCreateManagedWidget(search_item[i].name,
		xmLabelWidgetClass,option_form,
	  		XmNlabelString, item_label,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 10,
			XmNrightAttachment, XmATTACH_WIDGET,
			XmNrightWidget, search_widget[i],
			XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget, search_widget[i],
			XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget, search_widget[i],
			XmNalignment, XmALIGNMENT_END,
			NULL);
	  XmStringFree(item_label);
	  above_widget = search_widget[i];
	  }

	labels = (XmString *) XtMalloc(2*sizeof(XmString));
	labels[0] = XmStringCreateLtoR("Yes",XmSTRING_DEFAULT_CHARSET);
	labels[1] = XmStringCreateLtoR("No",XmSTRING_DEFAULT_CHARSET);

	search_widget[0] = XtVaCreateManagedWidget("subdir",
		xmToggleButtonWidgetClass,option_form,
/*
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,search_rc,
*/
			XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget, above_widget,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget,	above_widget,
			XmNrightAttachment,XmATTACH_NONE,
			NULL);

	XtAddCallback(search_widget[0],
		XmNvalueChangedCallback, rev_button_label,
			labels);

	if (XmToggleButtonGetState(search_widget[0])) {
	  XtVaSetValues(search_widget[0],XmNlabelString,labels[0],NULL);
	  }
	else {
	  XtVaSetValues(search_widget[0],XmNlabelString,labels[1],NULL);
	  }

	item_label = XmStringCreateLtoR("Search subdirectories:",
		XmSTRING_DEFAULT_CHARSET);
	subdir_heading = XtVaCreateManagedWidget("subdir_heading",
		xmLabelWidgetClass,option_form,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget, above_widget,
			XmNrightAttachment,XmATTACH_WIDGET,
			XmNrightWidget, search_widget[0],
			XmNleftAttachment,XmATTACH_FORM,
			XmNlabelString,item_label,
			XmNalignment, XmALIGNMENT_END,
			NULL);
	XmStringFree(item_label);

	separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass,dialog,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,option_form,
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);


	button_form = XtVaCreateManagedWidget("search_form",
		xmFormWidgetClass,dialog,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,separator,
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);

	ok = XtVaCreateManagedWidget("OK",
		xmPushButtonWidgetClass,button_form,
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,5,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,19,
			XmNbottomOffset,10,
			NULL);
	XtAddCallback(ok, XmNactivateCallback, set_search_options,
		(XtPointer) TRUE);
	XtAddCallback(ok, XmNactivateCallback, dismiss_dialog,
		(XtPointer) dialog);
/*
	XtAddCallback(apply, XmNactivateCallback, sort_list,
		(XtPointer) NULL);
*/

	apply = XtVaCreateManagedWidget("Apply",
		xmPushButtonWidgetClass,button_form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNtopOffset,0,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,24,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,38,
			NULL);

	XtAddCallback(apply, XmNactivateCallback, set_search_options,
		(XtPointer) TRUE);

	set = XtVaCreateManagedWidget("Set",
		xmPushButtonWidgetClass,button_form,
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,43,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,57,
			XmNbottomOffset,10,
			NULL);

	XtAddCallback(set, XmNactivateCallback, set_search_options,
		(XtPointer) FALSE);

	XtAddCallback(set, XmNactivateCallback, dismiss_dialog,
		(XtPointer) dialog);

	cancel = XtVaCreateManagedWidget("Cancel",
		xmPushButtonWidgetClass,button_form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNtopOffset,0,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,62,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,76,
			NULL);

	XtAddCallback(cancel, XmNactivateCallback, cancel_search_options,
		(XtPointer) dialog);

	help = XtVaCreateManagedWidget("Help",
		xmPushButtonWidgetClass,button_form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNtopOffset,0,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,81,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,95,
			NULL);

	XtAddCallback(help, XmNactivateCallback, (XtCallbackProc) XuHelper,
		(XtPointer) "Search_Dsc.help");

	XtAddCallback(popup, XmNactivateCallback, pop_the_dialog,
		(XtPointer) dialog);

	XtAddCallback(popup, XmNhelpCallback, (XtCallbackProc) XuHelper,
		(XtPointer) "Search_Dsc.help");

	if (debug_mode >= 1) tree(dialog,0);
	return(dialog);
}
