/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
#include <stdio.h>
#include <localsys.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>

#include "HelpObject.h"
#include "dskutil_defs.h"
#include "dskutil_glob.h"
#include "tape_menu.h"
 
void enter_tar_device(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	callback_info *tar_info = (callback_info *) client_data;
  if (debug_mode >= 2) fprintf(stderr,"-> enter_tar_device <-\n");
	XtCallCallbacks(*(tar_info->widgets+APPLY_BUTTON),XmNactivateCallback,
		(XtPointer)client_data);
}

void tar_device_menu(trigger,parmfile,menu_format)
Widget trigger;
tape_parameters *parmfile;
int menu_format;
{
	Arg args[20];
	int nargs;
	Widget options_form;
	Widget tar_device_input; 
	Widget dialog;
	Widget machine_label,machine_input;
	Widget transfer_blksz_label,transfer_blksz_input;
	Widget device_blksz_label,device_blksz_input;
	Widget label,rm_query,rm_toggle,full_path_toggle,full_path_query;
	Widget transfer_blksz_option,transfer_blksz_pd;
	Widget block_option_label,kilo_option_label,words_option_label;
	Widget device_blksz_option,device_blksz_pd;
	Widget device_blksz_history,transfer_blksz_history;
	Widget separator;
	Widget apply,cancel,help;
	Dimension width,left_max_width = 0;
	XmString item_label;
	String machine_name,blocksize,orig_tar_device;
	callback_info *info;
	void pop_the_dialog(),write_tape();
	void set_archival_opts(),cancel_archival_changes();
	void chg_toggle_label(),check_dsn(),set_dialog_focus();
	void tree();

  if (debug_mode >= 2) fprintf(stderr,"-> tar_device_menu <-\n");
	info = (callback_info *) malloc(sizeof(callback_info));
	(parmfile+menu_format)->menu_info = info;

	info->menu_format = menu_format;
	info->widgets = (Widget *) calloc(MENU_WIDGET_MAX,sizeof(Widget));

	nargs = 0;
	XtSetArg(Xarg[nargs], XmNallowShellResize, FALSE);	nargs++;
	dialog = XmCreateFormDialog(
		trigger,menu_dialog_name[menu_format],Xarg,nargs);
	item_label = XmStringCreateLtoR(tape_dialog_label[menu_format],
		XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(dialog,
			XmNdialogTitle,		item_label,
			XmNverticalSpacing,	10,
			XmNautoUnmanage,	FALSE,
			XmNmappedWhenManaged,	TRUE,
			XmNresizable,		TRUE,
			NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("OK", XmSTRING_DEFAULT_CHARSET);
	apply = XtVaCreateManagedWidget("apply",
		xmPushButtonWidgetClass, dialog,
			XmNlabelString,item_label,
			XmNtopAttachment,XmATTACH_NONE,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,10,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,30,
			XmNbottomAttachment,XmATTACH_FORM,
			NULL);
	XmStringFree(item_label);

	cancel = XtVaCreateManagedWidget("Cancel",
		xmPushButtonWidgetClass, dialog,
			XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,apply,
			XmNtopOffset,0,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,40,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,60,
			XmNbottomAttachment,XmATTACH_FORM,
			NULL);

	help = XtVaCreateManagedWidget("Help",
		xmPushButtonWidgetClass, dialog,
			XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,apply,
			XmNtopOffset,0,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,70,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,90,
			XmNbottomAttachment,XmATTACH_FORM,
			NULL);

	separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, dialog,
			XmNtopAttachment,XmATTACH_NONE,
			XmNbottomAttachment,XmATTACH_WIDGET,
			XmNbottomWidget,apply,
			XmNbottomOffset, 0,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);

	item_label = XmStringCreateLtoR(tape_dialog_label[menu_format],
		XmSTRING_DEFAULT_CHARSET);
	options_form = XtVaCreateManagedWidget("tar_options",
		xmFormWidgetClass,dialog,
			XmNdialogTitle,		item_label,
/*
			XmNverticalSpacing,	15,
*/
			XmNresizable,TRUE,
			XmNresizePolicy, XmRESIZE_GROW,
			XmNtopAttachment,XmATTACH_FORM,
			XmNbottomAttachment,XmATTACH_WIDGET,
			XmNbottomWidget, separator,
			NULL);
	XmStringFree(item_label);

	if (menu_format == TAR_REMOTE_DEVICE) {
	  machine_input = XtVaCreateManagedWidget("machine",
		xmTextWidgetClass,options_form,
			XmNautoShowCursorPosition,TRUE,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	(Position) 50,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNresizeWidth,TRUE,
			NULL);

	  item_label = XmStringCreateLtoR("machine name or address",
		XmSTRING_DEFAULT_CHARSET);
	  machine_label = XtVaCreateManagedWidget("machine_label",
		xmLabelWidgetClass, options_form, 
			XmNtopAttachment,	XmATTACH_FORM,
			XmNlabelString,		item_label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	(Position) 50,
			XmNbottomAttachment, 	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	machine_input,
			XmNbottomOffset,	0,
			XmNalignment,		XmALIGNMENT_END,
			NULL);
	  XmStringFree(item_label);

	  machine_name = XmTextGetString(machine_input);
	  (parmfile+menu_format)->machine_name = machine_name;

	  if (strlen(machine_name) != 0) {
	    XtVaSetValues(machine_input,
	  	XmNcolumns,	(short)strlen(machine_name)+25,
	  	XmNcursorPosition, (XmTextPosition) strlen(machine_name),
		NULL);
	    }

	  XtVaGetValues(machine_label,XmNwidth,&width,NULL);
	  if (width > left_max_width) left_max_width = width;

	  transfer_blksz_input = XtVaCreateManagedWidget("transfer_blksz_input",
		xmTextWidgetClass,options_form,
			XmNautoShowCursorPosition,TRUE,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		machine_input,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	(Position) 50,
			XmNrightAttachment,	XmATTACH_NONE,
			XmNresizeWidth,		TRUE,
			NULL);

	  transfer_blksz_pd = XmCreatePulldownMenu(options_form, 
		"transfer_blksz_pd", NULL, 0);

	  item_label = XmStringCreateLtoR("", XmSTRING_DEFAULT_CHARSET);
	  nargs = 0;
	  XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_WIDGET); nargs++;
	  XtSetArg(args[nargs],	XmNleftWidget, transfer_blksz_input); nargs++;
	  XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_WIDGET); nargs++;
	  XtSetArg(args[nargs],	XmNtopWidget, machine_input); nargs++;
	  XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_NONE); nargs++;
	  XtSetArg(args[nargs],	XmNsubMenuId, transfer_blksz_pd); nargs++;
	  XtSetArg(args[nargs],	XmNlabelString,	item_label);	nargs++;
	  XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	  XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;

	  transfer_blksz_option = XmCreateOptionMenu(options_form,
			"transfer_blksz_option", args, nargs);
	  XmStringFree(item_label);

	  item_label = XmStringCreateLtoR("blocks", XmSTRING_DEFAULT_CHARSET);
	  block_option_label = XtVaCreateManagedWidget("blocks_label",
		xmPushButtonWidgetClass, transfer_blksz_pd, 
			XmNlabelString,		item_label,
			XmNuserData,		"b",
			NULL);
	  XmStringFree(item_label);
	  transfer_blksz_history = block_option_label;

	  item_label = XmStringCreateLtoR("kilobytes",
		XmSTRING_DEFAULT_CHARSET);
	  kilo_option_label = XtVaCreateManagedWidget("kilobytes_label",
		xmPushButtonWidgetClass, transfer_blksz_pd, 
			XmNlabelString,		item_label,
			XmNuserData,		"k",
			XmNsensitive,		FALSE,
			NULL);
	  XmStringFree(item_label);

	  item_label = XmStringCreateLtoR("words", XmSTRING_DEFAULT_CHARSET);
	  words_option_label = XtVaCreateManagedWidget("words_label",
		xmPushButtonWidgetClass, transfer_blksz_pd, 
			XmNlabelString,		item_label,
			XmNuserData,		"w",
			XmNsensitive,		FALSE,
			NULL);
	  XmStringFree(item_label);

	  XtManageChild(transfer_blksz_option);

	  item_label = XmStringCreateLtoR("transfer blocking size",
		XmSTRING_DEFAULT_CHARSET);
	  transfer_blksz_label = XtVaCreateManagedWidget("transfer_blksz_label",
		xmLabelWidgetClass, options_form, 
			XmNlabelString,		item_label,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		machine_label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	(Position) 50,
			XmNbottomAttachment, 	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	transfer_blksz_input,
			XmNbottomOffset,	0,
			XmNalignment,		XmALIGNMENT_END,
			NULL);
	  XmStringFree(item_label);

	  blocksize = XmTextGetString(transfer_blksz_input);
	  (parmfile+menu_format)->transfer_blocksize = blocksize;

	  if (strlen(blocksize) != 0) {
	    XtVaSetValues(transfer_blksz_input,
	  	XmNcolumns,		(short) strlen(blocksize)+25,
	  	XmNcursorPosition,	(XmTextPosition) strlen(blocksize),
		NULL);
	    }
	  XtVaGetValues(transfer_blksz_label,XmNwidth,&width,NULL);
	  if (width > left_max_width) left_max_width = width;
	  }

	tar_device_input = XtVaCreateManagedWidget("dsn",
		xmTextWidgetClass,options_form,
			XmNautoShowCursorPosition,TRUE,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,(Position) 50,
			XmNrightAttachment,XmATTACH_FORM,
			XmNresizeWidth,TRUE,
			NULL);
/*
 * this was rigged so a carriage return in the text widget would trigger it
 *
	XtAddCallback(tar_device_input, XmNactivateCallback, enter_tar_device,
		(XtPointer) info);
*/

	if (menu_format == TAR_REMOTE_DEVICE)
	  XtVaSetValues(tar_device_input,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,transfer_blksz_input,
			NULL);
	else {
	  machine_input = NULL;
	  transfer_blksz_input = NULL;
	  transfer_blksz_option = NULL;
	  XtVaSetValues(tar_device_input,
			XmNtopAttachment,XmATTACH_FORM,
			NULL);
	  }

	orig_tar_device = XmTextGetString(tar_device_input);

	if (strlen(orig_tar_device) == 0) {
	  if (menu_format == TAR_ARCHIVAL_FILE) {
/*
 *	if we're creating a tar file, preload the text widget with the
 *	name of the current directory.
 */
	    XtVaSetValues(tar_device_input,
	    	XmNcursorPosition, (XmTextPosition) strlen(current_dir),
	    	XmNcolumns,(short)(strlen(current_dir)+10),
	    	XmNvalue,(char *) current_dir,
		NULL);
/* kluge */
	    XmTextSetInsertionPosition(tar_device_input,strlen(current_dir));
	    }
	  }
	else {
	    XtVaSetValues(tar_device_input,
		XmNcursorPosition, (XmTextPosition) strlen(orig_tar_device),
		XmNcolumns,(short) strlen(orig_tar_device),
		NULL);
	  }
	XtFree(orig_tar_device);

	(parmfile+menu_format)->dataset_name =
		XmTextGetString(tar_device_input);

	if (menu_format != TAR_ARCHIVAL_FILE) {
	  device_blksz_input = XtVaCreateManagedWidget("device_blksz_input",
		xmTextWidgetClass,options_form,
			XmNautoShowCursorPosition,TRUE,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		tar_device_input,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	(Position) 50,
			XmNrightAttachment,	XmATTACH_NONE,
			XmNresizeWidth,TRUE,
			NULL);

	  blocksize = XmTextGetString(device_blksz_input);
	  (parmfile+menu_format)->device_blocksize = blocksize;

	  if (strlen(blocksize) != 0) {
	    XtVaSetValues(device_blksz_input,
	  	XmNcolumns,		(short)strlen(blocksize)+25,
	  	XmNcursorPosition, (XmTextPosition) strlen(blocksize),
		NULL);
	    }
	  device_blksz_pd = XmCreatePulldownMenu(options_form, 
		"device_blksz_pd", NULL, 0);

	  item_label = XmStringCreateLtoR("", XmSTRING_DEFAULT_CHARSET);
	  nargs = 0;
	  XtSetArg(args[nargs],	XmNleftAttachment, XmATTACH_WIDGET); nargs++;
	  XtSetArg(args[nargs],	XmNleftWidget, device_blksz_input); nargs++;
	  XtSetArg(args[nargs],	XmNtopAttachment, XmATTACH_WIDGET); nargs++;
	  XtSetArg(args[nargs],	XmNtopWidget, tar_device_input); nargs++;
	  XtSetArg(args[nargs],	XmNbottomAttachment, XmATTACH_NONE); nargs++;
	  XtSetArg(args[nargs],	XmNsubMenuId, device_blksz_pd); nargs++;
	  XtSetArg(args[nargs],	XmNlabelString,	item_label);	nargs++;
	  XtSetArg(args[nargs],	XmNmarginHeight,	0);	nargs++;
	  XtSetArg(args[nargs],	XmNmarginWidth,		0);	nargs++;

	  device_blksz_option = XmCreateOptionMenu(options_form,
			"device_blksz_option", args, nargs);
	  XmStringFree(item_label);

	  item_label = XmStringCreateLtoR("blocks", XmSTRING_DEFAULT_CHARSET);
	  block_option_label = XtVaCreateManagedWidget("blocks_label",
		xmPushButtonWidgetClass, device_blksz_pd, 
			XmNlabelString,		item_label,
			XmNuserData,		"b",
			NULL);
	  XmStringFree(item_label);
	  device_blksz_history = block_option_label;

	  item_label = XmStringCreateLtoR("kilobytes",
		XmSTRING_DEFAULT_CHARSET);
	  kilo_option_label = XtVaCreateManagedWidget("kilobytes_label",
		xmPushButtonWidgetClass, device_blksz_pd, 
			XmNlabelString,		item_label,
			XmNuserData,		"k",
			NULL);
	  XmStringFree(item_label);

	  item_label = XmStringCreateLtoR("words", XmSTRING_DEFAULT_CHARSET);
	  words_option_label = XtVaCreateManagedWidget("words_label",
		xmPushButtonWidgetClass, device_blksz_pd, 
			XmNlabelString,		item_label,
			XmNuserData,		"w",
			NULL);
	  XmStringFree(item_label);

	  if (menu_format != TAR_REMOTE_DEVICE) {
	    XtVaSetValues(kilo_option_label,
			XmNsensitive,	FALSE,
			NULL);
	    XtVaSetValues(words_option_label,
			XmNsensitive,	FALSE,
			NULL);
	    }

	  XtManageChild(device_blksz_option);
	  }
	else {
	  device_blksz_input = NULL;
	  device_blksz_option = NULL;
	  }

	full_path_toggle = XtVaCreateManagedWidget("full_path_toggle",
		xmToggleButtonWidgetClass,options_form,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,(Position) 50,
			XmNrightAttachment,XmATTACH_FORM,
			XmNalignment,XmALIGNMENT_BEGINNING,
			NULL);
	XtAddCallback(full_path_toggle, XmNvalueChangedCallback,
		chg_toggle_label, path_labels);

	if (menu_format == TAR_ARCHIVAL_FILE)
		XtVaSetValues(full_path_toggle,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,tar_device_input,
			NULL);
	else
		XtVaSetValues(full_path_toggle,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,device_blksz_input,
			NULL);

	(parmfile+menu_format)->full_path_names =
		XmToggleButtonGetState(full_path_toggle);

	rm_toggle = XtVaCreateManagedWidget("rm_toggle",
		xmToggleButtonWidgetClass,options_form,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,full_path_toggle,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,(Position) 50,
			XmNrightAttachment,XmATTACH_FORM,
			XmNalignment,XmALIGNMENT_BEGINNING,
			NULL);
	XtAddCallback(rm_toggle, XmNvalueChangedCallback,
		chg_toggle_label, bool_label);

	if (menu_format == TAR_REMOTE_DEVICE) {
		XmToggleButtonSetState(rm_toggle,FALSE,FALSE);
		XtVaSetValues(rm_toggle, XmNsensitive, FALSE, NULL);
		}

	(parmfile+menu_format)->remove_archive_files =
		XmToggleButtonGetState(rm_toggle);

	if ( menu_format == TAR_ARCHIVAL_FILE ) {
	  item_label = XmStringCreateLtoR("file name",
		XmSTRING_DEFAULT_CHARSET);
	  }
	else if ( menu_format == TAR_ARCHIVAL_TAPE ) {
	  item_label = XmStringCreateLtoR("device name (blank for default)",
		XmSTRING_DEFAULT_CHARSET);
	  }
	else if ( menu_format == TAR_REMOTE_DEVICE ) {
	  item_label = XmStringCreateLtoR("device or file (no default)",
		XmSTRING_DEFAULT_CHARSET);
	  }

	label = XtVaCreateManagedWidget("tar_label",
		xmLabelWidgetClass, options_form,
			XmNlabelString,item_label,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,(Position) 50,
			XmNleftAttachment,XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,tar_device_input,
			XmNbottomOffset,	0,
			XmNalignment,XmALIGNMENT_END,
			NULL);
	XtVaGetValues(label,XmNwidth,&width,NULL);
	if (width > left_max_width) left_max_width = width;
	XmStringFree(item_label);

	if (menu_format == TAR_REMOTE_DEVICE)
	  XtVaSetValues(label,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,transfer_blksz_label,
			NULL);
	else
	  XtVaSetValues(label,
			XmNtopAttachment,XmATTACH_FORM,
			NULL);

	if (menu_format != TAR_ARCHIVAL_FILE) {
	  item_label = XmStringCreateLtoR("device blocking size",
		XmSTRING_DEFAULT_CHARSET);
	  device_blksz_label = XtVaCreateManagedWidget("device_blksz_label",
		xmLabelWidgetClass, options_form, 
			XmNlabelString,		item_label,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	(Position) 50,
			XmNbottomAttachment, 	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	device_blksz_input,
			XmNbottomOffset,	0,
			XmNalignment,		XmALIGNMENT_END,
			NULL);
	  XtVaGetValues(device_blksz_label,XmNwidth,&width,NULL);
	  if (width > left_max_width) left_max_width = width;
	  XmStringFree(item_label);
	  }

/*
	if (menu_format == TAR_ARCHIVAL_FILE) {
	  XtVaSetValues( device_blksz_label,
			XmNsensitive,	FALSE,
			NULL);
	  XtVaSetValues( device_blksz_input,
			XmNsensitive,	FALSE,
			NULL);
	  XtVaSetValues( device_blksz_option,
			XmNsensitive,	FALSE,
			NULL);
	  }
*/

	item_label = XmStringCreateLtoR("Path name for archival",
		XmSTRING_DEFAULT_CHARSET);
	full_path_query = XtVaCreateManagedWidget("full_path_query",
		xmLabelWidgetClass,options_form,
			XmNlabelString,item_label,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,(Position) 50,
			XmNleftAttachment,XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,full_path_toggle,
			XmNbottomOffset, 0,
			XmNalignment,XmALIGNMENT_END,
			NULL);
	XtVaGetValues(full_path_query,XmNwidth,&width,NULL);
	if (width > left_max_width) left_max_width = width;
	XmStringFree(item_label);

	if (menu_format != TAR_ARCHIVAL_FILE)
		XtVaSetValues( full_path_query,
			XmNtopWidget,device_blksz_label,
			NULL);
	else
		XtVaSetValues( full_path_query,
			XmNtopWidget,label,
			NULL);
	
	item_label = XmStringCreateLtoR("Remove files after archive?",
		XmSTRING_DEFAULT_CHARSET);
	rm_query = XtVaCreateManagedWidget("rm_query",
		xmLabelWidgetClass, options_form,
			XmNlabelString,item_label,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,full_path_toggle,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,(Position) 50,
			XmNleftAttachment,XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,rm_toggle,
			XmNbottomOffset,	0,
			XmNalignment,XmALIGNMENT_END,
			NULL);
	XtVaGetValues(rm_query,XmNwidth,&width,NULL);
	if (width > left_max_width) left_max_width = width;
	XmStringFree(item_label);

	if (menu_format == TAR_REMOTE_DEVICE) {
		XtVaSetValues(rm_query, XmNsensitive, FALSE, NULL);
		}

	XtManageChild(options_form);

/* set the initial label on the toggle button */

	XtVaSetValues(full_path_toggle, XmNlabelString,
	  path_labels[(parmfile+menu_format)->full_path_names], NULL);
	XtVaSetValues(rm_toggle, XmNlabelString,
	  bool_label[(parmfile+menu_format)->remove_archive_files], NULL);

	/* set positions based on proportional lengths of widgets */

	if (menu_format == TAR_REMOTE_DEVICE) {
	  XtVaSetValues(machine_label,
/* this didn't work on the Cray XMP; we'll set width instead
				XmNrightAttachment,XmATTACH_OPPOSITE_FORM,
				XmNrightOffset, -left_max_width,
*/
				XmNrightAttachment,XmATTACH_NONE,
				XmNleftAttachment, XmATTACH_FORM,
				XmNwidth, 	left_max_width,
				NULL);
	  XtVaSetValues(machine_input,
				XmNleftAttachment,XmATTACH_FORM,
				XmNleftOffset, left_max_width,
				NULL);

	  XtVaSetValues(transfer_blksz_label,
/* this didn't work on the Cray XMP; we'll set width instead
				XmNrightAttachment,XmATTACH_OPPOSITE_FORM,
				XmNrightOffset, -left_max_width,
*/
				XmNrightAttachment,XmATTACH_NONE,
				XmNleftAttachment, XmATTACH_FORM,
				XmNwidth, 	left_max_width,
				NULL);
	  XtVaSetValues(transfer_blksz_input,
				XmNleftAttachment,XmATTACH_FORM,
				XmNleftOffset, left_max_width,
				NULL);
	  }
	XtVaSetValues(label,
/* this didn't work on the Cray XMP; we'll set width instead
				XmNrightAttachment,XmATTACH_OPPOSITE_FORM,
				XmNrightOffset, -left_max_width,
*/
				XmNrightAttachment,XmATTACH_NONE,
				XmNleftAttachment, XmATTACH_FORM,
				XmNwidth, 	left_max_width,
				NULL);
	if ( menu_format != TAR_ARCHIVAL_FILE) {
	  XtVaSetValues(device_blksz_label,
/* this didn't work on the Cray XMP; we'll set width instead
				XmNrightAttachment,XmATTACH_OPPOSITE_FORM,
				XmNrightOffset, -left_max_width,
*/
				XmNrightAttachment,XmATTACH_NONE,
				XmNleftAttachment, XmATTACH_FORM,
				XmNwidth, 	left_max_width,
				NULL);
	  XtVaSetValues(device_blksz_input,
				XmNleftAttachment,XmATTACH_FORM,
				XmNleftOffset, left_max_width,
				NULL);
	  }
	XtVaSetValues(full_path_query,
/* this didn't work on the Cray XMP; we'll set width instead
				XmNrightAttachment,XmATTACH_OPPOSITE_FORM,
				XmNrightOffset, -left_max_width,
*/
				XmNrightAttachment,XmATTACH_NONE,
				XmNleftAttachment, XmATTACH_FORM,
				XmNwidth, 	left_max_width,
				NULL);
	XtVaSetValues(rm_query,
/* this didn't work on the Cray XMP; we'll set width instead
				XmNrightAttachment,XmATTACH_OPPOSITE_FORM,
				XmNrightOffset, -left_max_width,
*/
				XmNrightAttachment,XmATTACH_NONE,
				XmNleftAttachment, XmATTACH_FORM,
				XmNwidth, 	left_max_width,
				NULL);


	XtVaSetValues(tar_device_input,
				XmNleftAttachment,XmATTACH_FORM,
				XmNleftOffset, left_max_width,
				NULL);
	XtVaSetValues(full_path_toggle,
				XmNleftAttachment,XmATTACH_FORM,
				XmNleftOffset, left_max_width,
				NULL);
	XtVaSetValues(rm_toggle,
				XmNleftAttachment,XmATTACH_FORM,
				XmNleftOffset, left_max_width,
				NULL);

	*(info->widgets+TRIGGER_WIDGET)   = trigger;
	*(info->widgets+DIALOG_WIDGET)	  = dialog;
	*(info->widgets+MACHINE_NAME)	  = machine_input;
	*(info->widgets+TRANSFER_BLOCKSIZE) = transfer_blksz_input;
	*(info->widgets+TRANSFER_BLOCKSIZE_OPTION) = transfer_blksz_option;
	*(info->widgets+TRANSFER_BLOCKSIZE_HISTORY) = transfer_blksz_history;
	*(info->widgets+DATASET_TEXT)     = tar_device_input;
	*(info->widgets+DEVICE_BLOCKSIZE) = device_blksz_input;
	*(info->widgets+DEVICE_BLOCKSIZE_OPTION) = device_blksz_option;
	*(info->widgets+DEVICE_BLOCKSIZE_HISTORY) = device_blksz_history;
	*(info->widgets+FULL_PATH_TOGGLE) = full_path_toggle;
	*(info->widgets+REMOVAL_TOGGLE)	  = rm_toggle;
	*(info->widgets+APPLY_BUTTON)	  = apply;
	*(info->widgets+CANCEL_BUTTON)	  = cancel;

	XtAddCallback(apply, XmNactivateCallback, set_archival_opts,
		(XtPointer) (parmfile+menu_format));

	XtAddCallback(apply, XmNactivateCallback, check_dsn,
		(XtPointer) (parmfile+menu_format));

	XtAddCallback(cancel, XmNactivateCallback, cancel_archival_changes,
		(XtPointer) (parmfile+menu_format));

	XtAddCallback(help, XmNactivateCallback, XuHelper,
		(XtPointer) (parmfile+menu_format)->help_file);

	XtAddCallback(trigger, XmNactivateCallback, pop_the_dialog,
		(XtPointer) dialog);

	XtAddCallback(trigger, XmNhelpCallback, XuHelper,
		(XtPointer) (parmfile+menu_format)->help_file);

	if (menu_format == TAR_REMOTE_DEVICE)
	  XtAddCallback(dialog, XmNmapCallback, set_dialog_focus,
		(XtPointer) machine_input);
	else
	  XtAddCallback(dialog, XmNmapCallback, set_dialog_focus,
		(XtPointer) tar_device_input);

        if (debug_mode >= 1) tree(dialog,0);
}
