/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include "dskutil_defs.h"
#include "dskutil_glob.h"
#include "tape_menu.h"

/*
void write_tape(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
*/

void write_tape(archive_info)
tape_parameters *archive_info;
{
	char *msg;
	char *cray_tape_msg = "Create cray format dataset: "; 
	char *ibm_tape_msg = "Create ibm format dataset: "; 
	char *tar_file_msg = "Create tar file: "; 
	char *tar_tape_msg = "Create tar file on ";
	char *default_dev_msg = "default device";
	callback_info *menu_info = (callback_info *) archive_info->menu_info;
	XmString label,button_label;
	void c_label();

  if (debug_mode >= 2) fprintf(stderr,"-> write_tape <-\n");
/*	mode = ARCHIVAL; */
	archival_mode = menu_info->menu_format;
	switch (archival_mode) {
	  case IBM_ARCHIVAL_TAPE:
		label = XmStringCreate("USP dataset to be written to tape:",
			XmSTRING_DEFAULT_CHARSET);
		msg = (char *) XtMalloc(strlen(archive_info->dataset_name) +
			strlen(ibm_tape_msg) + 1);
		strcpy(msg,ibm_tape_msg);
		strcat(msg,archive_info->dataset_name);
		button_label = XmStringCreate(msg,XmSTRING_DEFAULT_CHARSET);
		break;
	  case CRAY_ARCHIVAL_TAPE:
		label = XmStringCreate("Files to be archived:",
			XmSTRING_DEFAULT_CHARSET);
		msg = (char *) XtMalloc(strlen(archive_info->dataset_name) +
			strlen(cray_tape_msg) + 1);
		strcpy(msg,cray_tape_msg);
		strcat(msg,archive_info->dataset_name);
		button_label = XmStringCreate(msg,XmSTRING_DEFAULT_CHARSET);
		break;
	  case TAR_ARCHIVAL_FILE:
		label = XmStringCreate("Files to be archived:",
			XmSTRING_DEFAULT_CHARSET);
		msg = (char *) XtMalloc(strlen(archive_info->dataset_name) +
			strlen(tar_file_msg) + 1);
		strcpy(msg,tar_file_msg);
		strcat(msg,archive_info->dataset_name);
		button_label = XmStringCreate(msg,
			XmSTRING_DEFAULT_CHARSET);
		break;
	  case TAR_ARCHIVAL_TAPE:
		label = XmStringCreate("Files to be archived:",
			XmSTRING_DEFAULT_CHARSET);
		if (strlen(archive_info->dataset_name) != 0) {
		  msg = (char *) XtMalloc(strlen(archive_info->dataset_name) +
			strlen(tar_tape_msg) + 1);
		  strcpy(msg,tar_tape_msg);
		  strcat(msg,archive_info->dataset_name);
		  }
		else {
		  msg = (char *) XtMalloc(strlen(default_dev_msg) +
			strlen(tar_tape_msg) + 1);
		  strcpy(msg,tar_tape_msg);
		  strcat(msg,default_dev_msg);
		  }
		button_label = XmStringCreate(msg,XmSTRING_DEFAULT_CHARSET);
		break;
	  case TAR_REMOTE_DEVICE:
		label = XmStringCreate("Files to be archived:",
			XmSTRING_DEFAULT_CHARSET);
		msg = (char *) XtMalloc(strlen(archive_info->machine_name) +
			strlen(archive_info->dataset_name) +
			strlen(tar_tape_msg) + 3);
		strcpy(msg,tar_tape_msg);
		strcat(msg,archive_info->machine_name);
		strcat(msg,":");
		strcat(msg,archive_info->dataset_name);
		button_label = XmStringCreate(msg,
			XmSTRING_DEFAULT_CHARSET);
		break;
	  }
	XtFree(msg);
        XtVaSetValues(list2_label,XmNlabelString,label,NULL);
	XmStringFree(label);

/*	XtUnmanageChild(apply_but); */

	XtVaSetValues(apply_but,
        		XmNsensitive,dsn_verified,
			XmNlabelString,button_label,
			XmNmappedWhenManaged,TRUE,
			NULL);
	XmStringFree(button_label);

/* we shouldn't need to call this explicitly - but we do!!
*/
	c_label(XtParent(apply_but),apply_but,NULL);

  if (debug_mode >= 2) fprintf(stderr,"manage the apply button\n");
/*	XtManageChild(apply_but); */
}

