C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, nsi, ntrc, nrec, iform, nsamp, irs, ire, 
     :        ns, ne, start, end, otap, ntrco, nreco, nsampo, NumCoefs, 
     :        remove, nsampR, ntrcR, peak, verbos )

#include <f77/iounit.h>

c declare variables passed from main

      integer ntrc, nrec, iform, nsamp, irs, ire, ns, ne, start, end
      integer ntrco, nreco, nsampo, NumCoefs, nsampR, ntrcR

      character ntap*(*), otap*(*)

      logical remove, peak, verbos

c local variables

      integer lentap, leotap

c initialize variables

      lentap = lenth(ntap)
      leotap = lenth(otap)

      write(LERR,*)' '
      write(LERR,*)' Command Line Input'
      write(LERR,*)' '
      if (lentap .gt. 0) then
        write(LERR,*)' Input dataset name : ',ntap(1:lentap)
      else
        write(LERR,*)' Input dataset      : stdin'
      endif
      if (leotap .gt. 0) then
        write(LERR,*)' Output dataset name : ',otap(1:leotap)
      else
        write(LERR,*)' Output dataset      : stdout'
      endif
      write(LERR,*)' Start record : ', irs
      write(LERR,*)' End record : ', ire
      write(LERR,*)' Start trace : ', ns
      write(LERR,*)' End trace : ', ne
      write(LERR,*)' Start time : ', start * nsi - nsi
      write(LERR,*)' End time : ', end * nsi - nsi
      if(peak) then
         write(LERR,*)' Wavelet Peak Centered at each level'
      else
         write(LERR,*)' Wavelet Support Centered at each level'
      endif 
      if ( NumCoefs .eq. 4 ) then
         write(LERR,*)' Wavelet Used :  Daubechies 4 '
      elseif ( NumCoefs .eq. 12 ) then
         write(LERR,*)' Wavelet Used :  Daubechies 12 '
      elseif ( NumCoefs .eq. 14 ) then
         write(LERR,*)' Wavelet Used :  Battle_Lemarie order 1'
      elseif ( NumCoefs .eq. 20 ) then
         write(LERR,*)' Wavelet Used :  Daubechies 20 '
      elseif ( NumCoefs .eq. 24 ) then
         write(LERR,*)' Wavelet Used :  Battle_Lemarie order 3'
      elseif ( NumCoefs .eq. 29 ) then
         write(LERR,*)' Wavelet Used :  Battle_Lemarie order 5'
      elseif ( NumCoefs .eq. 39 ) then
         write(LERR,*)' Wavelet Used :  Meyer'
      else
         write(LERR,*)' Wavelet Requested : ', NumCoefs, ' invalid'
      endif

      if ( remove ) then
         write(LERR,*)' Inverse Transform Applied'
      else
         write(LERR,*)' Forward Transform Applied'
      endif  
      
      write(LERR,*)' '
      write(LERR,*)' Input Data Parameters  '
      write(LERR,*)
      write(LERR,*) ' # of Samples/Trace =  ', nsamp
      write(LERR,*) ' Sample Interval    =  ', nsi  
      write(LERR,*) ' Traces per Record  =  ', ntrc 
      write(LERR,*) ' Records per Line   =  ', nrec 
      write(LERR,*) ' Format of Data     =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Output Data Parameters  '
      write(LERR,*)
      if ( .not. remove ) then
         write(LERR,*) ' # of Samples/Trace =  ', nsampo
      else
         write(LERR,*) ' # of Samples/Trace =  ', nsampR
      endif
      write(LERR,*) ' Sample Interval    =  ', nsi  
      if ( .not. remove ) then
         write(LERR,*) ' Traces per Record  =  ', ntrco 
      else
         write(LERR,*) ' Traces per Record  =  ', ntrcR 
      endif
      write(LERR,*) ' Records per Line   =  ', nreco 
      write(LERR,*) ' Format of Data     =  ', iform

      if ( verbos ) write(LERR,*)' Verbose printout requested'

      return
      end

