C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getmx(f,fc,r,rf,fcrf,
     1                 mx,my,mz,dx,dy,dz,power,lerr,
     2                 notchx,notchy,notchz)
c
      complex f(-mz:+mz,-mx:+mx,-my:+my,-mz:+mz,-mx:+mx,-my:+my)
      complex fc(-mz:+mz,-mx:+mx,-my:+my,-mz:+mz,-mx:+mx,-my:+my)
      complex rf(-mz:+mz,-mx:+mx,-my:+my,-mz:+mz,-mx:+mx,-my:+my)
      real    r(-mz:+mz,-mx:+mx,-my:+my)
      real    fcrf(-mz:+mz,-mx:+mx,-my:+my)
      complex ci
      parameter (ci=(0.,1.))
      parameter (pi=3.1415926)
      logical notchx,notchy,notchz
c_________________________________________________________________
c     calculate wavenumber increments.
c_________________________________________________________________
      zlen=(2*mz+1)*dz    
      if(zlen .gt. 0.) then
         dkz=2.*pi/zlen
      else
         dkz=1.
      endif
      xlen=(2*mx+1)*dx
      if(xlen .gt. 0.) then
         dkx=2.*pi/xlen
      else
         dkx=1.
      endif
      ylen=(2*my+1)*dy
      if(ylen .gt. 0.) then
         dky=2.*pi/ylen
      else
         dky=1.
      endif
      n=(2*mz+1)*(2*mx+1)*(2*my+1)
      write(lerr,*) 'normalization. n = ',n
      anorm=1./n
c_________________________________________________________________
c     calculate the forward fourier transform matrix, f, an
c     the inverse fourier transform matrix, fc=conjg(f).
c_________________________________________________________________
      do 26000 iy=-my,+my           
       y=iy*dy
       do 25000 ix=-mx,+mx           
        x=ix*dx
        do 24000 iz=-mz,+mz           
         z=iz*dz
         do 23000 ky=-my,+my       
          aky=ky*dky        
          do 22000 kx=-mx,+mx           
           akx=kx*dkx        
           do 21000 kz=-mz,+mz       
            akz=kz*dkz
            arg=akz*z+akx*x+aky*y
            f(kz,kx,ky,iz,ix,iy)=exp(-ci*arg)
            fc(kz,kx,ky,iz,ix,iy)=
     1                 anorm*conjg(f(kz,kx,ky,iz,ix,iy))
21000      continue
22000     continue
23000    continue
24000   continue
25000  continue
26000 continue
c_________________________________________________________________
c     calculate the wavenumber spectrum amplification filter, r:
c     r is a diagonal matrix.
c_________________________________________________________________
      do 33000 ky=-my,+my          
       aky=ky*dky        
       aky2=aky**2
       do 32000 kx=-mx,+mx           
       akx=kx*dkx        
        akx=kx*dkx
        akx2=akx**2
        do 31000 kz=-mz,+mz
         akz=kz*dkz
         akz2=akz**2
         ak=sqrt(akx2+aky2+akz2)
         r(kz,kx,ky)=ak**power
         if(notchx) then 
            if(kx .eq. 0) then 
               r(kz,kx,ky)=0.
            endif
         endif
         if(notchy) then 
            if(ky .eq. 0) then 
               r(kz,kx,ky)=0.
            endif
         endif
         if(notchz) then 
            if(kz .eq. 0) then 
               r(kz,kx,ky)=0.
            endif
         endif
         write(0,*) 'kx,ky,kz,r ',kx,ky,kz,r(kz,kx,ky)
31000   continue
32000  continue
33000 continue
c_________________________________________________________________
c     calculate matrix product rf=r*f, where r is a diagonal matrix.
c     kz,kx,ky are wavenumber indices.
c     lz,lx,ly are wavenumber indices.dd
c     iz,ix,iy are spatial indices on outer loop.
c     inner most loop is degenerate. we only want the result at the
c     center of the 3D analysis window.
c_________________________________________________________________
      do 63000 iy=-my,+my
       do 62000 ix=-mx,+mx
        do 61000 iz=-mz,+mz
         fcrf(iz,ix,iy)=0.
         do 43000 ky=-my,+my      
          do 42000 kx=-mx,+mx
           do 41000 kz=-mz,+mz      
            rf(kz,kx,ky,iz,ix,iy)=r(kz,kx,ky)*f(kz,kx,ky,iz,ix,iy)
41000      continue
42000     continue
43000    continue
c_________________________________________________________________
c        calculate matrix product fcrf=fc*rf             
c        since we are designing a running window operator, we only
c        need to perform this for index (0,0,0).
c_________________________________________________________________
         do 53000 ky=-my,+my     
          do 52000 kx=-mx,+mx
           do 51000 kz=-mz,+mz  
            fcrf(iz,ix,iy)=fcrf(iz,ix,iy)
     1            +real(fc(kz,kx,ky,0,0,0)*rf(kz,kx,ky,iz,ix,iy))
51000      continue
52000     continue
53000    continue
61000   continue
62000  continue
63000 continue

      return
      end


