C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DATOUT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      DATOUT  (LUPRT,LUOTAP,ITRWRD,NBYTES,MXHBUF,ITRH,IX,MXNSPT,RX,   *
C               NSPT,NTRACE,IREC,Z,DATMAX)                             *
C  ARGUMENTS:                                                          *
C      LUPRT   INTEGER    ??IOU*                -                      *
C      LUOTAP  INTEGER    ??IOU*                -                      *
C      ITRWRD  INTEGER    ??IOU*                -                      *
C      NBYTES  INTEGER    ??IOU*                -                      *
C      MXHBUF  INTEGER    ??IOU*                -                      *
C      ITRH    INTEGER*2  ??IOU*  (MXHBUF)      -                      *
C      IX      INTEGER*2  ??IOU*  (ITRWRD)      -                      *
C      MXNSPT  INTEGER    ??IOU*                -                      *
C      RX      REAL       ??IOU*  (MXNSPT)      -                      *
C      NSPT    INTEGER    ??IOU*                -                      *
C      NTRACE  INTEGER    ??IOU*                -                      *
C      IREC    INTEGER    ??IOU*                -                      *
C      Z       REAL       ??IOU*  (NSPT,NTRACE) -                      *
C      DATMAX  REAL       ??IOU*                -                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV   -                                                        *
C      SAVEW  -                                                        *
C      WRTAPE -                                                        *
C      MAXMGV -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUPRT  ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       datout                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      write buffer z to output device.                                *
c                                                                      *
c  entry points:                                                       *
c      datout  (luprt,luotap,itrwrd,nbytes,mxhbuf,itrh,ix,mxnspt,rx,   *
c               nspt,ntrace,irec,z,datmax)                             *
c  arguments:                                                          *
c      luprt   integer    ??iou*                  -                    *
c      luotap  integer    ??iou*                  -                    *
c      itrwrd  integer    ??iou*                -                      *
c      nbytes  integer    ??iou*                -                      *
c      mxhbuf  integer    ??iou*                  -                    *
c      itrh    integer*2  ??iou*  (mxhbuf)      -                      *
c      ix      integer*2  ??iou*  (129)         -                      *
c      mxnspt  integer    ??iou*                  -                    *
c      rx      real       ??iou*  (mxnspt)        -                    *
c      nspt    integer    ??iou*                  -                    *
c      ntrace  integer    ??iou*                  -                    *
c      irec    integer    ??iou*                  -                    *
c      z       real       ??iou*  (nspt,ntrace)   -                    *
c      datmax  real     ??iou*                  -                      *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 88/03/30  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      vmov   -                                                        *
c      savew  -                                                        *
c      wrtape -                                                        *
c      maxmgv -                                                        *
c  intrinsic functions called:  none                                   *
c  files:                                                              *
c      luprt  ( output sequential ) -                                  *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      use with main program eign5b.                                   *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      modified from e5aout fortcray for use with eign5b.              *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/25  *
c      optimized, as by corvin on e5aout.                              *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/07  *
c      change to find maximum absolute value of output, rather than    *
c      maximum value.                                                  *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/29  *
c      replace call move with qtc call vmov.  uses new trace header    *
c      (ix) and trace data (rx) equivalencing:  ix(120) = rx(1).       *
c      use savew to store record number and trace number in trace      *
c      header.  itrwrd added to call list.  this is a system dependent *
c      variable which is equal to the number of full words in the      *
c      trace header for that system (i.e., 128 for cray2, or 64 for    *
c      ibm or sun).                                                    *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:      1 detected                               *
c      integer*                                                        *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine datout (luprt , luotap, itrwrd, nbytes, mxhbuf, itrh  ,
     *                   ix    , mxnspt, rx    , nspt  , ntrace, irec  ,
     *                   z     , datmax)
      integer*2 ix(itrwrd), itrh(mxhbuf)
      real rx(mxnspt), z(nspt,ntrace)
c
c     itrwrd is the number of full words in the trace header.
c     nbytes is the number of bytes in the trace header and trace data
c        combined.
c
c
c     write z to tape
c        note:  qtc mathadvantage routine vmov is used to move integer
c               array into another integer array.  tested on the sun
c               and cray-2 systems, 88/3/29.
c
      do 200 it = 1, ntrace
         itmin1 = it - 1
c
c        move trace header from buffer.  itrwrd is the number of
c        full words in the trace header (system dependent).
c
c>>      call move (1, ix, itrh((itmin1*itrwrd)+1), itbyte)
         call vmov (itrh((itmin1*itrwrd)+1), 1, ix, 1, itrwrd)
c        ix(106) = irec
c        ix(107) = it
         call savew (ix, 'RecNum', irec, 1)
         call savew (ix, 'TrcNum', it  , 1)
c
c        move data from buffer to output array
c
c>>      call move (1, rx(itrwrd), z(1,it), mbytes)
         call vmov (z(1,it), 1, rx(1), 1, nspt)
         call wrtape (luotap, ix, nbytes)
  200 continue
c
c     determine maximum output data value
c
      call maxmgv ( z, 1, datmax, lc, nspt*ntrace)
      write (luprt,4000) datmax
 4000 format(5x,'DATOUT:  maximum absolute data value = ',1pe11.4)
      return
      end
