C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       NORMLZ                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      NORMLZ  (MBLSIZ,EGNVEC)                                         *
C  ARGUMENTS:                                                          *
C      MBLSIZ  INTEGER  ??IOU*                  -                      *
C      EGNVEC  REAL     ??IOU*  (MBLSIZ,MBLSIZ) -                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SQRT    GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       normlz                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      normalize eigenvectors for program eign.  assumes these are     *
c      real eigenvectors.                                              *
c                                                                      *
c  entry points:                                                       *
c      normlz  (mblsiz,egnvec)                                         *
c  arguments:                                                          *
c      mblsiz  integer  ??iou*                  -                      *
c      egnvec  real     ??iou*  (mblsiz,mblsiz) -                      *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 87/08/25  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:  none                                              *
c  intrinsic functions called:                                         *
c      sqrt    generic -                                               *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      given eigenvectors in array egnvec, normalize the elements      *
c      of the eigenvector.                                             *
c      use with main program eign5b.                                   *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      modified from e5anrm for use with eign5b.                       *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/25  *
c      optimized, as by corvin for e5anrm.                             *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine normlz (mblsiz, egnvec)
      real egnvec(mblsiz,mblsiz), zn
c     common /timer/ clocks     , ops
c     real           clocks(100), ops(100)
c
c     normalize eigenvectors
c
c     call secon1 (v300b, w300b)
      do 300 i = 1, mblsiz
         zn = 0.0
c        call secon1 (v100b, w100b)
         do 100 j = 1, mblsiz
            zn = zn + egnvec(j,i)**2
  100    continue
c        call secon1 (v100e, w100e)
c        clocks(6) = clocks(6) + v100e - v100b
         zn = 1./sqrt(zn)
c        call secon1 (v200b, w200b)
         do 200 j = 1, mblsiz
            egnvec(j,i) = egnvec(j,i)*zn
  200    continue
c        call secon1 (v200e, w200e)
c        clocks(7) = clocks(7) + v200e - v200b
  300 continue
c     call secon1 (v300e, w300e)
c     clocks(8) = clocks(8) + v300e - v300b
c     ops   (6) = ops   (6) + 2*mblsiz*mblsiz
c     ops   (7) = ops   (7) +   mblsiz*mblsiz
c     ops   (8) = ops   (6) + ops(7)
      return
      end
